/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.DebugTracer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DirectorySizeChecker {
    public static boolean checker(final String string, final int n, final int n2, final FileFilter fileFilter) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                File file = CommonUtil.getAbsoluteFile(string);
                if (!file.exists() || !file.isDirectory()) {
                    return;
                }
                File[] fileArray = file.listFiles();
                double d = 0.0;
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].isFile()) continue;
                    d += (double)fileArray[i].length();
                }
                if ((double)n > (d /= 1048576.0)) {
                    return;
                }
                File[] fileArray2 = file.listFiles(fileFilter);
                if (0 == fileArray2.length) {
                    return;
                }
                int n3 = n2;
                DirectorySizeChecker.sortOnModifiedTime(fileArray2);
                int n22 = 0;
                n22 = n3 > fileArray2.length ? fileArray2.length : n3;
                for (int i = 0; i < n22; ++i) {
                    if (!fileArray2[i].exists()) continue;
                    System.out.println("Delete trace file: " + fileArray2[i].getName());
                    fileArray2[i].delete();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        return true;
    }

    private static void sortOnModifiedTime(File[] fileArray) {
        Comparator<File> comparator = new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return (int)(file.lastModified() - file2.lastModified());
            }
        };
        Arrays.sort(fileArray, comparator);
    }

    private static boolean checkAndRemoveZipFiles(final File file) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                FilenameFilter filenameFilter = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.endsWith("_iview.zip");
                    }
                };
                File[] fileArray = file.listFiles(filenameFilter);
                if (DebugTracer.getMaxNoOfZipFiles() > fileArray.length) {
                    return;
                }
                DirectorySizeChecker.sortOnModifiedTime(fileArray);
                int n = Math.min(fileArray.length, DebugTracer.getTotalNoOfZipFileToRemove());
                DirectorySizeChecker.sortOnModifiedTime(fileArray);
                for (int i = 0; i < n; ++i) {
                    if (!fileArray[i].exists()) continue;
                    System.out.println("Deleted zip file: " + fileArray[i].getName());
                    fileArray[i].delete();
                }
            }
        });
        thread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void archiveOldTraceFiles(String string, ArrayList arrayList, File file) {
        System.out.println("zip file will be created in: file " + file.getName() + File.separator + string);
        byte[] byArray = new byte[1024];
        ZipOutputStream zipOutputStream = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ZipEntry zipEntry = null;
        File[] fileArray = null;
        try {
            void var13_26;
            fileOutputStream = new FileOutputStream(new File(file, string));
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
            File[] fileArray2 = null;
            int n = 0;
            int n2 = arrayList.size();
            fileArray = new File[n2];
            boolean i = false;
            while (var13_26 < n2) {
                fileArray2 = (File[])arrayList.get((int)var13_26);
                fileInputStream = new FileInputStream(fileArray2.getAbsoluteFile());
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                zipEntry = new ZipEntry(fileArray2.getName());
                zipOutputStream.putNextEntry(zipEntry);
                n = bufferedInputStream.read(byArray);
                while (n > 0) {
                    zipOutputStream.write(byArray, 0, n);
                    n = bufferedInputStream.read(byArray);
                }
                fileInputStream.close();
                bufferedInputStream.close();
                zipOutputStream.closeEntry();
                fileArray[var13_26] = fileArray2;
                ++var13_26;
            }
        }
        catch (IOException iOException) {
            DebugTracer.trace("The zip file is not created.");
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {
                    DebugTracer.trace(iOException);
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    DebugTracer.trace(iOException);
                }
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    DebugTracer.trace(iOException);
                }
            }
            for (void var13_28 : fileArray) {
                var13_28.getAbsoluteFile().delete();
            }
        }
    }

    protected static boolean zipFileAndDleteZipFie(final String string, final File file) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                FilenameFilter filenameFilter = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        boolean bl = string.startsWith(string) && false == string.endsWith(".zip");
                        return bl;
                    }
                };
                File[] fileArray = file.listFiles(filenameFilter);
                int n = DebugTracer.getTotalNoOfFileToZip();
                if (n > fileArray.length) {
                    return;
                }
                DirectorySizeChecker.sortOnModifiedTime(fileArray);
                ArrayList<File> arrayList = new ArrayList<File>();
                for (File file2 : fileArray) {
                    if (file2.isFile() && file2.renameTo(file2)) {
                        arrayList.add(file2);
                    }
                    if (arrayList.size() >= n) break;
                }
                if (n > arrayList.size()) {
                    return;
                }
                File[] fileArray2 = arrayList.toArray(new File[arrayList.size()]);
                ArrayList<File> arrayList2 = new ArrayList<File>(n);
                for (int i = 0; i < n; ++i) {
                    arrayList2.add(fileArray2[i]);
                }
                StringBuffer stringBuffer = new StringBuffer(fileArray2[n - 1].getName());
                int n2 = stringBuffer.lastIndexOf(".");
                if (n2 > -1) {
                    stringBuffer = new StringBuffer(stringBuffer.substring(0, n2));
                }
                stringBuffer.append("_iview.zip");
                if (DebugTracer.getTotalNoOfZipFileToRemove() > 0) {
                    DirectorySizeChecker.checkAndRemoveZipFiles(file);
                }
                DirectorySizeChecker.archiveOldTraceFiles(stringBuffer.toString(), arrayList2, file);
            }
        });
        thread.setName("CreateZipThread");
        thread.start();
        return true;
    }
}

