/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.DirectorySizeChecker;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.iview.util.log.IviewRollingFileAppender;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.WriterAppender;

public class DebugTracer {
    private static Logger logger = IviewLogger.getLogger(DebugTracer.class, "IVIEW");
    private static PatternLayout layout = new PatternLayout("[%t%x]%d{M-d-yyyy HH:mm:ss} | %-5p | %c{1} | %M | %m  %n");
    private static PatternLayout debugTracerlayout = new PatternLayout("%m");
    private static final int TWELVE_HOURS = 12;
    private static String fileAppenderName = null;
    private static StringWriter strWriter = new StringWriter();
    private static PrintWriter printWriter = new PrintWriter(strWriter);
    public static boolean PerformanceTest = "true".equalsIgnoreCase(System.getProperty("PerformanceTest"));
    public static final String DEBUG_LEVEL_PARAM_NAME = "-debuglevel";
    public static final String SHOW_TRACE_PARAM_NAME = "-showtrace";
    public static final String TRACE_FILE_PARAM_NAME = "-tracefile";
    public static final String ENABLE_DEBUG_PARAM_NAME = "-enabledebug";
    static final String DEFAULT_TRACE_FILE_DIR = "tracefile";
    private static String traceLogDirName = null;
    public static final int DETAIL_TRACE = 0;
    public static final int DEBUG_TRACE = 1;
    public static final int WARNING_TRACE = 2;
    public static final int SOFTWARE_ERROR = 3;
    public static final int EXCEPTION = 4;
    protected static String outputFileName = null;
    private static String firstTraceFileName;
    protected static int traceLogLevel;
    protected static boolean dispLogOnScreen;
    protected static boolean enableDebug;
    protected static OutputStream currentOutputStream;
    public static final int TWO_POWER_TEN = 1024;
    private static final long MAX_FILE_CAPABILITY = 0x500000L;
    private static long maxFileSize;
    private static final int ONE_MEGA_BYTE = 0x100000;
    private static final int MAX_FILE_NUMBER = 20;
    private static final String LINE_SEPARATOR;
    private static GregorianCalendar gregorianCalendar;
    private static String clientStartTime;
    private static final int DEFAULTMAXFOLDERSIZE = 500;
    private static int maxFolderSize;
    private static final int DEFAULTNUMOFFILESTOREMOVE = 20;
    private static int noOfFileToBeRemoved;
    private static boolean isDTFileToBeRemoved;
    private static boolean isIndependentModule;
    private static boolean isUseLogger;
    private static boolean isConsoleEnabled;
    private static boolean isFileEnabled;
    private static Priority priority;
    private static boolean setConsole;
    private static boolean setTraceFile;
    private static boolean fileAppenderSet;
    private static boolean consoleAppenderSet;
    public static boolean isInitCalled;
    private static int totalNoOfFileToZip;
    private static int maxNoOfZipFiles;
    private static int totalNoOfZipFileToRemove;
    private static boolean isZippingEnabled;
    private static int loggerMaxFileSize;
    private static Logger debugLogger;

    private static void init() {
        isInitCalled = true;
        Object object = ReflectionUtilities.callStaticMethod("com.swimap.iview.commstyle.commini.CommStyleManager", "getInstance", null, null);
        if (null == object) {
            return;
        }
        Object object2 = ReflectionUtilities.callTheMethod(object, "getCommonStyleFile", new Class[]{String.class}, new Object[]{"conf/mainfrm/debugtracerfileconf"});
        if (object2 != null) {
            Object object3 = ReflectionUtilities.callTheMethod(object2, "getAreaDescContainer", new Class[]{Integer.TYPE}, new Object[]{0});
            Object object4 = ReflectionUtilities.callTheMethod(object3, "getDescContainer", new Class[]{String.class}, new Object[]{"debugTracerFileDelete"});
            String string = DebugTracer.getDescParaValue(object4, "isDTFileToBeRemoved");
            isDTFileToBeRemoved = "true".equalsIgnoreCase(string);
            try {
                maxFolderSize = Integer.parseInt(DebugTracer.getDescParaValue(object4, "maxSize"));
            }
            catch (NumberFormatException numberFormatException) {
                debugLogger.trace((Object)numberFormatException);
                maxFolderSize = 500;
            }
            try {
                noOfFileToBeRemoved = Integer.parseInt(DebugTracer.getDescParaValue(object4, "totalNoOfFileToRemove"));
            }
            catch (NumberFormatException numberFormatException) {
                debugLogger.trace((Object)numberFormatException);
                noOfFileToBeRemoved = 20;
            }
            try {
                DebugTracer.setTotalNoOfFileToZip(Integer.parseInt(DebugTracer.getDescParaValue(object4, "totalNoOfFileToZip")));
            }
            catch (NumberFormatException numberFormatException) {
                debugLogger.trace((Object)("zipAfterNoOfFile is invalid " + numberFormatException));
            }
            try {
                DebugTracer.setMaxNoOfZipFiles(Integer.parseInt(DebugTracer.getDescParaValue(object4, "maxNoOfZipFiles")));
            }
            catch (NumberFormatException numberFormatException) {
                debugLogger.trace((Object)("maxNoOfZipFile is invalid  " + numberFormatException));
            }
            try {
                DebugTracer.setTotalNoOfZipFileToRemove(Integer.parseInt(DebugTracer.getDescParaValue(object4, "totalNoOfZipFileToRemove")));
            }
            catch (NumberFormatException numberFormatException) {
                debugLogger.trace((Object)("totalNoOfZipFileToRemove is invalid  " + numberFormatException));
            }
            String string2 = DebugTracer.getDescParaValue(object4, "maxFileSize");
            int n = 0;
            if (loggerMaxFileSize <= 0) {
                if (null == string2 || !DebugTracer.isNumber(string2)) {
                    debugLogger.trace((Object)("Invalid file size, default size 5MB will be used " + string2));
                    n = 5;
                } else {
                    n = Integer.parseInt(string2);
                }
            }
            DebugTracer.updateMaxFileSize(n);
        }
    }

    private static String getDescParaValue(Object object, String string) {
        return (String)ReflectionUtilities.callTheMethod(object, "getParasItemValue", new Class[]{String.class}, new Object[]{string});
    }

    private static void validateZip() {
        if (totalNoOfFileToZip > 0 && maxNoOfZipFiles > 0 && totalNoOfZipFileToRemove >= 0) {
            isZippingEnabled = true;
            isDTFileToBeRemoved = false;
        }
    }

    public static void setMaxNoOfZipFiles(int n) {
        maxNoOfZipFiles = n;
    }

    public static void setTotalNoOfFileToZip(int n) {
        totalNoOfFileToZip = n;
    }

    public static void setTotalNoOfZipFileToRemove(int n) {
        totalNoOfZipFileToRemove = n;
    }

    public static int getTotalNoOfZipFileToRemove() {
        return totalNoOfZipFileToRemove;
    }

    public static int getTotalNoOfFileToZip() {
        return totalNoOfFileToZip;
    }

    public static int getMaxNoOfZipFiles() {
        return maxNoOfZipFiles;
    }

    private static boolean isNumber(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) <= '9' && string.charAt(i) >= '0') continue;
            return false;
        }
        return true;
    }

    private static void updateMaxFileSize(int n) {
        Appender appender = logger.getAppender("fileappender");
        if (null == appender) {
            appender = logger.getAppender("file");
        }
        if (n > 0 && appender instanceof RollingFileAppender) {
            debugLogger.trace((Object)("File size got modified, new file size in MB -> " + n));
            maxFileSize = n * 0x100000;
            ((RollingFileAppender)appender).setMaximumFileSize(maxFileSize);
        }
    }

    public static void logActionCost(String string, long l) {
        if (PerformanceTest) {
            StringBuffer stringBuffer = new StringBuffer("*****Peformance Test*****:Time of ");
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(l);
            stringBuffer.append(System.getProperty("line.separator"));
        }
    }

    public static void redirectOutputStream(OutputStream outputStream) {
    }

    private static StringBuffer appendLevel(int n, StringBuffer stringBuffer) {
        if (n == 3) {
            stringBuffer.append(" | ERROR | ");
        } else if (n == 2) {
            stringBuffer.append(" | WARNING | ");
        } else if (n == 4) {
            stringBuffer.append(" | EXCEPTION | ");
        } else if (n == 0) {
            stringBuffer.append(" | DETAIL | ");
        } else if (n == 1) {
            stringBuffer.append(" | DEBUG | ");
        } else {
            stringBuffer.append(" |  | ");
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToTrace(StringBuffer stringBuffer) {
        Logger logger;
        WriterAppender writerAppender;
        WriterAppender writerAppender2 = null;
        WriterAppender writerAppender3 = null;
        Layout layout = null;
        Layout layout2 = null;
        Enumeration enumeration = DebugTracer.logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            writerAppender = (WriterAppender)enumeration.nextElement();
            if (writerAppender instanceof ConsoleAppender) {
                writerAppender3 = writerAppender;
                layout2 = writerAppender3.getLayout();
            }
            if (!(writerAppender instanceof FileAppender)) continue;
            writerAppender2 = writerAppender;
            layout = writerAppender2.getLayout();
        }
        writerAppender = DebugTracer.logger.getAppender("fileappender");
        Appender appender = DebugTracer.logger.getAppender("console");
        if (!isUseLogger && null != writerAppender) {
            writerAppender.setLayout((Layout)debugTracerlayout);
        }
        if ((!isUseLogger && null != appender || setConsole) && null != appender) {
            appender.setLayout((Layout)debugTracerlayout);
        }
        Logger logger2 = logger = Logger.getRootLogger();
        synchronized (logger2) {
            if (null != writerAppender2) {
                writerAppender2.setLayout((Layout)debugTracerlayout);
            }
            if (null != writerAppender3) {
                writerAppender3.setLayout((Layout)debugTracerlayout);
            }
            if (setConsole) {
                DebugTracer.logger.removeAppender(fileAppenderName);
                DebugTracer.logger.removeAppender("fileappender");
            }
            DebugTracer.logger.log(DebugTracer.class.getName(), priority, (Object)stringBuffer, null);
            if (null != writerAppender2) {
                writerAppender2.setLayout(layout);
            }
            if (null != writerAppender3) {
                writerAppender3.setLayout(layout2);
            }
            if (!isUseLogger && null != writerAppender) {
                writerAppender.setLayout((Layout)DebugTracer.layout);
            }
            if (!isUseLogger && null != appender || setConsole) {
                appender.setLayout((Layout)DebugTracer.layout);
            }
        }
    }

    public static synchronized void trace(int n, String string, String string2, String string3) {
        if (!enableDebug || traceLogLevel == 4) {
            return;
        }
        if (n >= traceLogLevel) {
            StringBuffer stringBuffer = new StringBuffer(16);
            DebugTracer.constructPrefix(stringBuffer);
            DebugTracer.appendLevel(n, stringBuffer);
            stringBuffer.append(null == string ? " " : string);
            stringBuffer.append(" | ");
            stringBuffer.append(null == string2 ? " " : string2);
            stringBuffer.append(" | ");
            stringBuffer.append(null == string3 ? " " : string3);
            stringBuffer.append(LINE_SEPARATOR);
            if (null != outputFileName && setTraceFile) {
                DebugTracer.setFileAppenderAndDeleteFiles();
            }
            if (setConsole && !consoleAppenderSet) {
                DebugTracer.setConsoleAppender();
            }
            if (null != priority) {
                DebugTracer.writeToTrace(stringBuffer);
            }
        }
    }

    private static void setConsoleAppender() {
        PatternLayout patternLayout = new PatternLayout("[%t%x]%d{M-d-yyyy HH:mm:ss} | %-5p | %c{1} | %M | %m  %n");
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)patternLayout);
        consoleAppender.setName("console");
        logger.addAppender((Appender)consoleAppender);
        consoleAppenderSet = true;
        System.out.println("Tracing will be written into: System.out");
    }

    private static void setFileAppender() {
        DebugTracer.removeConsoleAppender();
        PatternLayout patternLayout = new PatternLayout("[%t%x]%d{M-d-yyyy HH:mm:ss} | %-5p | %c{1} | %M | %m  %n");
        IviewRollingFileAppender iviewRollingFileAppender = new IviewRollingFileAppender();
        iviewRollingFileAppender.setLayout((Layout)patternLayout);
        iviewRollingFileAppender.setName("fileappender");
        iviewRollingFileAppender.setFile(outputFileName);
        iviewRollingFileAppender.setMaximumFileSize(maxFileSize);
        iviewRollingFileAppender.setMaxBackupIndex(20);
        iviewRollingFileAppender.activateOptions();
        logger.addAppender((Appender)iviewRollingFileAppender);
        fileAppenderSet = true;
    }

    private static synchronized StringBuffer constructPrefix(StringBuffer stringBuffer) {
        stringBuffer.append('[');
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append(']');
        gregorianCalendar.setTimeInMillis(System.currentTimeMillis());
        stringBuffer.append(gregorianCalendar.get(2) + 1);
        stringBuffer.append('-');
        stringBuffer.append(gregorianCalendar.get(5));
        stringBuffer.append('-');
        stringBuffer.append(gregorianCalendar.get(1));
        stringBuffer.append(' ');
        int n = gregorianCalendar.get(11);
        if (String.valueOf(n).length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        stringBuffer.append(':');
        int n2 = gregorianCalendar.get(12);
        if (String.valueOf(n2).length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        stringBuffer.append(':');
        int n3 = gregorianCalendar.get(13);
        if (String.valueOf(n3).length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        return stringBuffer;
    }

    public static void traceDetail(String string) {
        if (null != priority) {
            if (logger.getLevel().isGreaterOrEqual((Priority)Level.TRACE)) {
                return;
            }
            DebugTracer.trace(0, "", "", string);
        }
    }

    public static void trace(String string) {
        if (null != priority && Level.DEBUG.isGreaterOrEqual((Priority)logger.getLevel())) {
            DebugTracer.trace(1, "", "", string);
        }
    }

    public static void traceWarning(String string) {
        if (null != priority && Level.WARN.isGreaterOrEqual((Priority)logger.getLevel())) {
            DebugTracer.trace(2, "", "", string);
        }
    }

    public static void traceError(String string) {
        if (null != priority && Level.ERROR.isGreaterOrEqual((Priority)logger.getLevel())) {
            DebugTracer.trace(3, "", "", string);
        }
    }

    public static void trace(Throwable throwable) {
        if (!enableDebug) {
            return;
        }
        if (null != outputFileName && setTraceFile) {
            DebugTracer.setFileAppenderAndDeleteFiles();
        }
        if (setConsole && !consoleAppenderSet) {
            DebugTracer.setConsoleAppender();
        }
        if (null != throwable) {
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            DebugTracer.trace(4, "", "", "Exception trace in DebugTracer " + throwable.toString());
            DebugTracer.trace(4, "", "", strWriter.toString());
            strWriter.getBuffer().setLength(0);
        }
    }

    public static void trace(Exception exception) {
        DebugTracer.trace((Throwable)exception);
    }

    public static int getTraceLogLevel() {
        return traceLogLevel;
    }

    public static void setTraceLogLevel(int n) {
        if (n != 0 && n != 1 && n != 3 && n != 2 && n != 4) {
            throw new IllegalArgumentException("Trace log level should be value of DEBUG_TRACE,WARNING_TRACE or SOFTWARE_ERROR.");
        }
        traceLogLevel = n;
        if (!isUseLogger || !IviewLogger.isLog4jExists()) {
            if (traceLogLevel == 3 || traceLogLevel == 4) {
                priority = Level.ERROR;
                logger.setLevel(Level.ERROR);
            } else if (traceLogLevel == 2) {
                priority = Level.WARN;
                logger.setLevel(Level.WARN);
            } else if (traceLogLevel == 1) {
                priority = Level.DEBUG;
                logger.setLevel(Level.DEBUG);
            } else {
                priority = Level.ALL;
                logger.setLevel(Level.ALL);
            }
        }
    }

    public static boolean isEnableDebug() {
        return enableDebug;
    }

    public static void setEnableDebug(boolean bl) {
        DebugTracer.getLoggerAppender();
        if (enableDebug && bl || !enableDebug && !bl) {
            return;
        }
        enableDebug = bl;
        try {
            DebugTracer.setDisplayMode(dispLogOnScreen);
        }
        catch (Exception exception) {
            System.out.println("Failed to set the debug log properties: " + exception.toString());
        }
    }

    public static boolean isDisplayMode() {
        return dispLogOnScreen;
    }

    private static void removeConsoleAppender() {
        Appender appender = logger.getAppender("console");
        if (null != appender) {
            logger.removeAppender(appender);
        }
        consoleAppenderSet = false;
    }

    public static synchronized void setDisplayMode(boolean bl) throws FileNotFoundException {
        setConsole = false;
        setTraceFile = false;
        dispLogOnScreen = bl;
        if (!enableDebug) {
            return;
        }
        if (!dispLogOnScreen && isUseLogger && null == outputFileName && !consoleAppenderSet) {
            DebugTracer.setConsoleAppender();
        }
        if (!dispLogOnScreen && !isUseLogger || !IviewLogger.isLog4jExists()) {
            setTraceFile = true;
            if (logger.getLevel() == null) {
                priority = Level.ALL;
                logger.setLevel(Level.ALL);
            }
            if (null != outputFileName) {
                DebugTracer.setFileAppenderAndDeleteFiles();
            } else if (!consoleAppenderSet && null == outputFileName) {
                DebugTracer.setConsoleAppender();
            }
        } else if (dispLogOnScreen) {
            setConsole = true;
            if (logger.getLevel() == null) {
                priority = Level.ALL;
                logger.setLevel(Level.ALL);
            }
            if (!consoleAppenderSet) {
                DebugTracer.setConsoleAppender();
            }
        }
    }

    private static String toTimeString(GregorianCalendar gregorianCalendar) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        StringBuffer stringBuffer = new StringBuffer(16);
        n = gregorianCalendar.get(10);
        if (gregorianCalendar.get(9) == 1) {
            n += 12;
        }
        n2 = gregorianCalendar.get(12);
        n3 = gregorianCalendar.get(13);
        n4 = gregorianCalendar.get(14);
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        stringBuffer.append("#");
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        stringBuffer.append("#");
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        stringBuffer.append("#");
        if (n4 < 10) {
            stringBuffer.append("00");
        } else if (n4 < 100) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n4);
        return stringBuffer.toString();
    }

    public static String createTimeString(GregorianCalendar gregorianCalendar) {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(CommonUtil.toYearString(gregorianCalendar));
        stringBuffer.append("-");
        stringBuffer.append(CommonUtil.toMonthString(gregorianCalendar));
        stringBuffer.append("-");
        stringBuffer.append(CommonUtil.toDateString(gregorianCalendar));
        stringBuffer.append("_");
        stringBuffer.append(DebugTracer.toTimeString(gregorianCalendar));
        return stringBuffer.toString();
    }

    public static String getTraceLogFolderName() {
        return traceLogDirName;
    }

    public static String addFolderToFile(String string) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer(16);
        boolean bl2 = bl = System.getProperty("os.name").indexOf("Windows") != -1;
        if (null != string && (string.indexOf(File.separator) != -1 || bl && string.indexOf(47) != -1)) {
            stringBuffer.append(string);
            File file = CommonUtil.getAbsoluteFile(stringBuffer.toString()).getParentFile();
            if (!file.exists()) {
                file.mkdirs();
            }
        } else {
            File file = CommonUtil.getAbsoluteFile(DEFAULT_TRACE_FILE_DIR);
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory()) {
                stringBuffer.delete(0, stringBuffer.capacity());
                stringBuffer.append(DEFAULT_TRACE_FILE_DIR);
                stringBuffer.append(File.separator);
                stringBuffer.append(string);
            } else {
                stringBuffer.delete(0, stringBuffer.capacity());
                stringBuffer.append(string);
            }
        }
        firstTraceFileName = DebugTracer.trimFileExtension(stringBuffer.toString());
        return stringBuffer.toString();
    }

    private static String trimFileExtension(String string) {
        int n = string.lastIndexOf(46);
        int n2 = Math.max(string.lastIndexOf(47), string.lastIndexOf(File.separator));
        if (n > -1 && n2 < n) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static void setFileAppenderAndDeleteFiles() {
        DebugTracer.checkAndDeleteFiles();
        if (!fileAppenderSet) {
            DebugTracer.setFileAppender();
        }
    }

    private static void changeDebugTracer(String string) {
        if (null != outputFileName && setTraceFile) {
            DebugTracer.setFileAppenderAndDeleteFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void changeLogFile(String string) {
        DebugTracer.removeConsoleAppender();
        DebugTracer.checkAndDeleteFiles();
        String string2 = System.getProperty("user.dir") + System.getProperty("file.separator") + "log4j.properties";
        if (!new File(string2).exists()) {
            if (!fileAppenderSet) {
                DebugTracer.setFileAppender();
            }
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            Properties properties = new Properties();
            fileInputStream = new FileInputStream(string2);
            properties.load(fileInputStream);
            Enumeration<?> enumeration = properties.propertyNames();
            String string3 = "log4j.appender." + fileAppenderName + ".File";
            String string4 = properties.getProperty(string3);
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                if (string5.startsWith("log4j.logger")) {
                    properties.remove(string5);
                    continue;
                }
                if (!string5.equals(string3) || null == string4) continue;
                bl = true;
            }
            if (!bl) {
                properties.setProperty("log4j.appender." + fileAppenderName + ".File", string);
                PropertyConfigurator.configure((Properties)properties);
            }
        }
        catch (Exception exception) {
            DebugTracer.trace(exception);
            BasicConfigurator.configure();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                DebugTracer.trace(exception);
            }
        }
    }

    public static synchronized void setOutputFileName(String string) throws IOException {
        boolean bl;
        outputFileName = DebugTracer.addFolderToFile(string);
        boolean bl2 = bl = System.getProperty("os.name").indexOf("Windows") != -1;
        if (string.indexOf(File.separator) != -1 || bl && string.indexOf("/") != -1) {
            if (isUseLogger && !setConsole) {
                DebugTracer.changeLogFile(string);
            } else if (DebugTracer.isEnableDebug() && !isUseLogger && !setConsole) {
                DebugTracer.changeDebugTracer(string);
            }
            File file = CommonUtil.getAbsoluteFile(string).getParentFile();
            traceLogDirName = file.getAbsolutePath();
        } else if (isUseLogger && !setConsole) {
            DebugTracer.changeLogFile(string);
        } else if (DebugTracer.isEnableDebug() && !isUseLogger && !setConsole) {
            DebugTracer.changeDebugTracer(string);
        }
    }

    public static synchronized void cleanup() {
    }

    public static synchronized void assertTrue(boolean bl) {
        if (!enableDebug) {
            return;
        }
        if (!bl) {
            DebugTracer.trace(1, "DebugTracer", "assertTrue", "ASSERTION FAILED");
        }
    }

    public static synchronized void assertTrue(boolean bl, String string) {
        if (!enableDebug) {
            return;
        }
        if (!bl) {
            DebugTracer.trace(1, "DebugTracer", "assertTrue", "ASSERTION FAILED: " + string);
        }
    }

    private static void getLoggerAppender() {
        logger = Logger.getRootLogger();
        Enumeration enumeration = logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            WriterAppender writerAppender = (WriterAppender)enumeration.nextElement();
            if (writerAppender instanceof ConsoleAppender) {
                isConsoleEnabled = true;
                isUseLogger = true;
                priority = logger.getLevel();
                DebugTracer.setLevel();
            }
            if (!(writerAppender instanceof FileAppender)) continue;
            FileAppender fileAppender = (FileAppender)writerAppender;
            RollingFileAppender rollingFileAppender = (RollingFileAppender)writerAppender;
            loggerMaxFileSize = (int)rollingFileAppender.getMaximumFileSize();
            fileAppenderName = fileAppender.getName();
            isFileEnabled = true;
            isUseLogger = true;
            priority = logger.getLevel();
            DebugTracer.setLevel();
            outputFileName = fileAppender.getFile();
        }
    }

    public static void identifyDebugParam(String[] stringArray) {
        DebugTracer.getLoggerAppender();
        if (!isConsoleEnabled && !isFileEnabled && null == stringArray) {
            return;
        }
        if (!isUseLogger || !IviewLogger.isLog4jExists()) {
            int n = stringArray.length;
            String string = null;
            Vector<String> vector = new Vector<String>(5);
            String string2 = null;
            for (int i = 0; i < n && null != (string2 = stringArray[i]); ++i) {
                if (string2.startsWith("-")) {
                    DebugTracer.processSetting(string, vector);
                    string = string2;
                    vector.clear();
                } else {
                    vector.add(string2);
                }
                if (i != n - 1) continue;
                DebugTracer.processSetting(string, vector);
            }
        }
        if (!isIndependentModule) {
            DebugTracer.init();
            if (null != outputFileName && !consoleAppenderSet) {
                DebugTracer.checkAndDeleteFiles();
            }
        }
    }

    private static void setLevel() {
        if (priority == Level.ERROR) {
            traceLogLevel = 3;
            enableDebug = true;
        } else if (priority == Level.WARN) {
            traceLogLevel = 2;
            enableDebug = true;
        } else if (priority == Level.DEBUG || priority == Level.TRACE) {
            traceLogLevel = 1;
            enableDebug = true;
        } else if (priority == Level.INFO || priority == Level.ALL) {
            traceLogLevel = 0;
            enableDebug = true;
        } else if (priority == Level.OFF || priority == Level.FATAL) {
            enableDebug = false;
        }
    }

    private static void processSetting(String string, Vector vector) {
        if (null == string) {
            return;
        }
        if (null == vector) {
            System.out.println("Unidentified input : " + string);
            return;
        }
        if (vector.size() <= 0) {
            System.out.println("The Value of " + string + "must be setted");
        }
        if (DEBUG_LEVEL_PARAM_NAME.equalsIgnoreCase(string)) {
            String string2 = vector.firstElement().toString();
            if (null != string2) {
                try {
                    DebugTracer.setTraceLogLevel(Integer.parseInt(string2));
                }
                catch (Exception exception) {
                    System.out.println("The input of " + string + " is error. " + "Unidentified value : " + string2);
                }
            } else {
                System.out.println("The Value of " + string + " must be set");
            }
        } else if (SHOW_TRACE_PARAM_NAME.equalsIgnoreCase(string)) {
            String string3 = vector.firstElement().toString();
            if (null != string3) {
                try {
                    boolean bl = Boolean.valueOf(string3);
                    DebugTracer.setDisplayMode(bl);
                }
                catch (Exception exception) {
                    System.out.println("The input of " + string + " is error. " + "Unidentified value : " + string3);
                }
            } else {
                System.out.println("The Value of " + string + " must be setted");
            }
        } else if (TRACE_FILE_PARAM_NAME.equalsIgnoreCase(string)) {
            String string4 = vector.firstElement().toString();
            if (null != string4) {
                try {
                    DebugTracer.setOutputFileName(string4);
                }
                catch (Exception exception) {
                    DebugTracer.trace(exception.toString());
                    System.out.println("The input of " + string + " is error. " + "Unidentified value : " + string4);
                }
            } else {
                System.out.println("The Value of " + string + " must be setted");
            }
        } else if (ENABLE_DEBUG_PARAM_NAME.equalsIgnoreCase(string)) {
            String string5 = vector.firstElement().toString();
            if (null != string5) {
                if ("true".equalsIgnoreCase(string5)) {
                    DebugTracer.setEnableDebug(true);
                } else {
                    DebugTracer.setEnableDebug(false);
                }
            } else {
                System.out.println("The Value of " + string + " must be set.");
            }
        }
    }

    public static String forTest(String string) {
        outputFileName = string;
        return outputFileName;
    }

    public static void resetCalendar() {
        debugLogger.trace((Object)"reset Calendar");
    }

    public static String getClientStartTime() {
        return clientStartTime;
    }

    public static void checkAndDeleteFiles() {
        DebugTracer.validateZip();
        File file = CommonUtil.getAbsoluteFile(outputFileName);
        if (isDTFileToBeRemoved && DebugTracer.getFolderSize(file) >= (double)maxFolderSize) {
            DebugTracer.checkAndRemoveFiles(file);
        }
        if (!isDTFileToBeRemoved && isZippingEnabled) {
            DebugTracer.makeZipFiles();
        }
    }

    public static void makeLogFileZip() {
        DebugTracer.validateZip();
        if (!isDTFileToBeRemoved && isZippingEnabled) {
            DebugTracer.makeZipFiles();
        }
    }

    private static synchronized double getFolderSize(File file) {
        double d = 0.0;
        File file2 = file.getParentFile();
        double d2 = 0.0;
        if (file2.exists() && file2.isDirectory()) {
            File[] fileArray = file2.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile()) continue;
                d2 += (double)fileArray[i].length();
            }
        }
        d = d2 / 1048576.0;
        return d;
    }

    public static synchronized void checkAndRemoveFiles(File file) {
        String string = null;
        int n = file.getName().lastIndexOf(".");
        if (n != -1) {
            string = file.getName().substring(n + 1);
        }
        final String string2 = string;
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return null != string2 && file.isFile() && file.getName().endsWith(string2);
            }
        };
        DirectorySizeChecker.checker(file.getParent(), maxFolderSize, noOfFileToBeRemoved, fileFilter);
    }

    public static void checkFileNumber(String string, int n) {
        int n2;
        int n3;
        String string2 = null;
        String string3 = null;
        int n4 = string.indexOf(".");
        string3 = n4 != -1 ? string.substring(0, n4) : string;
        n4 = string3.lastIndexOf(47);
        if (n4 != -1) {
            string3 = string3.substring(n4 + 1);
        }
        if ((n3 = (n2 = DebugTracer.getExitFileNumber(string, string3)) - n) >= 0) {
            String string4 = DebugTracer.getMinFileNumber(string, string3);
            int n5 = Integer.parseInt(string4);
            if (n5 == 0) {
                string2 = string;
                DebugTracer.deleteTrace(string, string3, 0, true);
            } else {
                string2 = DebugTracer.getDeleteFileName(string, n5);
                DebugTracer.deleteTrace(string, string2, n5, false);
            }
        }
    }

    public static void deleteTrace(String string, String string2, final int n, final boolean bl) {
        final String string3 = string2;
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                int n2 = DebugTracer.getFileNumber(file.getName());
                boolean bl2 = false;
                bl2 = !bl && file.isFile() && file.getName().contains(string3) || bl && file.isFile() && file.getName().contains(string3) && !file.getName().contains(string3 + "@") || bl && file.isFile() && file.getName().trim().endsWith("@");
                if (n2 > -1 && n2 != n) {
                    bl2 = false;
                }
                return bl2;
            }
        };
        File file = CommonUtil.getAbsoluteFile(string);
        File file2 = file.getParentFile();
        File[] fileArray = null;
        if (file2.exists() && file2.isDirectory()) {
            fileArray = file2.listFiles(fileFilter);
        }
        if (null != fileArray) {
            for (File file3 : fileArray) {
                file3.delete();
            }
        }
    }

    private static int getFileNumber(String string) {
        int n = string.indexOf("@");
        int n2 = string.indexOf(".");
        String string2 = "";
        if (n > 0 && n2 > 0) {
            string2 = string.substring(n + 1, n2);
        }
        boolean bl = false;
        for (char c : string2.toCharArray()) {
            if (!Character.isDigit(c)) {
                bl = false;
                break;
            }
            bl = true;
        }
        int n3 = -1;
        if (bl) {
            n3 = Integer.parseInt(string2);
        }
        return n3;
    }

    private static int getExitFileNumber(String string, final String string2) {
        File file = CommonUtil.getAbsoluteFile(string);
        File file2 = file.getParentFile();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().indexOf(string2) == 0 && !file.getName().endsWith(".zip");
            }
        };
        if (file2.exists() && file2.isDirectory()) {
            return file2.listFiles(fileFilter).length;
        }
        return 0;
    }

    public static String createFileName(String string, int n) {
        String string2 = null;
        String string3 = null;
        if (string != null) {
            int n2 = string.lastIndexOf(".");
            if (n2 != -1) {
                string2 = string.substring(n2 + 1);
                int n3 = string.indexOf("@");
                string3 = n3 != -1 ? string.substring(0, n3) : string.substring(0, n2);
            }
            string3 = string3 + "@" + n;
            if (string2 != null) {
                string3 = string3 + '.' + string2;
            }
        }
        return string3;
    }

    public static String getDeleteFileName(String string, int n) {
        int n2;
        int n3;
        String string2 = null;
        if (string != null) {
            n3 = string.lastIndexOf(".");
            if (n3 != -1) {
                n2 = string.indexOf("@");
                string2 = n2 != -1 ? string.substring(0, n2) : string.substring(0, n3);
            }
            string2 = string2 + "@" + n;
        }
        if (null != string2) {
            n3 = string2.lastIndexOf("/");
            string2 = n3 > (n2 = string2.lastIndexOf("\\\\")) ? string2.substring(n3 + 1) : string2.substring(n2 + 1);
        }
        return string2;
    }

    private static String getMinFileNumber(String string, final String string2) {
        File file = CommonUtil.getAbsoluteFile(string);
        File file2 = file.getParentFile();
        File[] fileArray = null;
        Vector<String> vector = new Vector<String>(10);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().indexOf(string2) == 0 && !file.getName().endsWith(".zip");
            }
        };
        fileArray = file2.exists() && file2.isDirectory() ? file2.listFiles(fileFilter) : new File[]{};
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            string3 = fileArray[i].getName();
            int n = string3.lastIndexOf(".");
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
            if ((n = string3.lastIndexOf("@")) != -1) {
                string4 = string3.substring(0, n);
                if (!string4.equals(string2)) continue;
                string3 = string3.substring(n + 1);
                string3 = DebugTracer.checkFileValidity(string3);
            } else {
                string3 = "0";
            }
            if (null == string3 || string3.equals("")) continue;
            vector.add(string3);
        }
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    int n = Integer.parseInt(object.toString());
                    int n2 = Integer.parseInt(object2.toString());
                    if (n < n2) {
                        return -1;
                    }
                    if (n > n2) {
                        return 1;
                    }
                    return 0;
                }
                catch (NumberFormatException numberFormatException) {
                    return -1;
                }
            }
        });
        return vector.get(0).toString();
    }

    public static String checkFileValidity(String string) {
        if (null != string) {
            String[] stringArray = string.split("[^0-9]");
            if (stringArray.length >= 1) {
                return stringArray[0];
            }
            return "";
        }
        return "";
    }

    private static void makeZipFiles() {
        if (null == outputFileName) {
            return;
        }
        File file = CommonUtil.getAbsoluteFile(outputFileName).getParentFile();
        if (!file.exists() || !file.isDirectory() || null == firstTraceFileName) {
            return;
        }
        if (firstTraceFileName.lastIndexOf(47) > -1) {
            firstTraceFileName = firstTraceFileName.substring(firstTraceFileName.lastIndexOf(47) + 1);
        } else if (firstTraceFileName.lastIndexOf(File.separator) > -1) {
            firstTraceFileName = firstTraceFileName.substring(firstTraceFileName.lastIndexOf(File.separator) + 1);
        }
        if (firstTraceFileName.length() <= 0) {
            return;
        }
        DirectorySizeChecker.zipFileAndDleteZipFie(firstTraceFileName, file);
    }

    public static void setDTFileToBeRemoved(boolean bl) {
        isDTFileToBeRemoved = bl;
    }

    public static void setMaxFolderSize(int n) {
        maxFolderSize = n;
    }

    public static void setNoOfFileToBeRemoved(int n) {
        noOfFileToBeRemoved = n;
    }

    public static void setIsIndependent(boolean bl) {
        isIndependentModule = bl;
    }

    public static String getOutputFileName() {
        return outputFileName;
    }

    public static void setMaxFileSize(int n) {
        DebugTracer.updateMaxFileSize(n);
    }

    public static int getMaxFileSize() {
        return (int)maxFileSize / 0x100000;
    }

    static void setTraceLevel(int n) {
        if (n != 0 && n != 1 && n != 3 && n != 2 && n != 4) {
            throw new IllegalArgumentException("Trace log level should be value of DEBUG_TRACE,WARNING_TRACE or SOFTWARE_ERROR.");
        }
        traceLogLevel = n;
        if (traceLogLevel == 3 || traceLogLevel == 4) {
            priority = Level.ERROR;
            logger.setLevel(Level.ERROR);
        } else if (traceLogLevel == 2) {
            priority = Level.WARN;
            logger.setLevel(Level.WARN);
        } else if (traceLogLevel == 1) {
            priority = Level.DEBUG;
            logger.setLevel(Level.DEBUG);
        } else {
            priority = Level.ALL;
            logger.setLevel(Level.ALL);
        }
    }

    static {
        traceLogLevel = 1;
        dispLogOnScreen = true;
        enableDebug = false;
        currentOutputStream = null;
        maxFileSize = 0x500000L;
        LINE_SEPARATOR = System.getProperty("line.separator");
        gregorianCalendar = new GregorianCalendar();
        clientStartTime = DebugTracer.createTimeString(new GregorianCalendar());
        maxFolderSize = 500;
        noOfFileToBeRemoved = 20;
        isDTFileToBeRemoved = false;
        isIndependentModule = false;
        isUseLogger = false;
        isConsoleEnabled = false;
        isFileEnabled = false;
        priority = null;
        setConsole = false;
        setTraceFile = false;
        fileAppenderSet = false;
        consoleAppenderSet = false;
        isInitCalled = false;
        totalNoOfFileToZip = -1;
        maxNoOfZipFiles = -1;
        totalNoOfZipFileToRemove = -1;
        isZippingEnabled = false;
        loggerMaxFileSize = 0;
        debugLogger = logger;
    }
}

