/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public final class DebugTraceConfigurationDialog
extends JDialog {
    private static Logger logger = IviewLogger.getLogger(DebugTraceConfigurationDialog.class, "IVIEW");
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private static DebugTraceConfigurationDialog instance = null;
    private JLabel logLevelLabel = new JLabel();
    private final String[] levels = new String[]{res.getString("Detail"), res.getString("Debug"), res.getString("Warning"), res.getString("ErrorOrException")};
    private JComboBox logLevelCombo = new JComboBox<String>(this.levels);
    private JButton apply = new JButton();
    private JButton cancelButton = new JButton();
    private JCheckBox enableDebug = new JCheckBox();
    private int oldTraceLevel = DebugTracer.getTraceLogLevel();
    private boolean oldTraceEnable = DebugTracer.isEnableDebug();
    private static final int BUTTON_PREFERRED_WIDTH = 100;
    private static final int BUTTON_PREFERRED_HEIGHT = 21;

    public static DebugTraceConfigurationDialog getInstance(JFrame jFrame) {
        if (null == instance) {
            instance = new DebugTraceConfigurationDialog(jFrame);
        }
        return instance;
    }

    private DebugTraceConfigurationDialog(JFrame jFrame) {
        super(jFrame, res.getString("Dialog_Title"), true);
        this.jbInit();
        this.initActionListener();
    }

    private void jbInit() {
        this.logLevelLabel.setName("Log_Level");
        this.logLevelLabel.setText(res.getString("Log_Level"));
        this.logLevelLabel.setBounds(new Rectangle(10, 10, 75, 27));
        this.logLevelLabel.setDisplayedMnemonic('L');
        this.logLevelLabel.setLabelFor(this.logLevelCombo);
        this.logLevelCombo.setAlignmentX(0.0f);
        this.logLevelCombo.setMinimumSize(new Dimension(4, 21));
        this.logLevelCombo.setPreferredSize(new Dimension(63, 21));
        this.logLevelCombo.setBounds(new Rectangle(91, 13, 242, 21));
        this.logLevelCombo.setName("LogLevel_Combo");
        this.logLevelCombo.setSelectedIndex(this.oldTraceLevel);
        if (!this.oldTraceEnable) {
            this.logLevelCombo.setEnabled(false);
        }
        this.enableDebug.setName("Enable_Logging");
        this.enableDebug.setText(res.getString("Enable_Logging"));
        this.enableDebug.setBounds(new Rectangle(10, 79, 157, 25));
        this.enableDebug.setMnemonic('E');
        this.enableDebug.setSelected(this.oldTraceEnable);
        this.apply.setMaximumSize(new Dimension(100, 21));
        this.apply.setMinimumSize(new Dimension(100, 21));
        this.apply.setPreferredSize(new Dimension(100, 21));
        this.apply.setMargin(new Insets(2, 1, 2, 1));
        this.apply.setText(res.getString("OK_Button"));
        this.apply.setBounds(new Rectangle(350, 13, 100, 21));
        this.apply.setEnabled(false);
        this.apply.setMnemonic('O');
        this.apply.setName("Apply_Button");
        this.cancelButton.setBounds(new Rectangle(350, 46, 100, 21));
        this.cancelButton.setMaximumSize(new Dimension(100, 21));
        this.cancelButton.setMinimumSize(new Dimension(100, 21));
        this.cancelButton.setPreferredSize(new Dimension(100, 21));
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText(res.getString("Cancel_Button"));
        this.cancelButton.setName("Cancel_Button");
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)this.logLevelCombo, null);
        this.getContentPane().add((Component)this.apply, null);
        this.getContentPane().add((Component)this.logLevelLabel, null);
        this.getContentPane().add((Component)this.enableDebug, null);
        this.getContentPane().add((Component)this.cancelButton, null);
        this.setSize(new Dimension(468, 150));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        HelpManager.getInstance().enableHelpKey(this.getRootPane(), "iVIEW.Debug.DebugTraceConfigurationDialog");
        ScreenToolKit.setDefaultButtons(this.apply, this.cancelButton);
        ScreenToolKit.setPreferredSizeofButtons(new JButton[]{this.apply, this.cancelButton}, 21);
        ScreenToolKit.centerLocateToScreen(this);
    }

    private void initActionListener() {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DebugTraceConfigurationDialog.this.removeAll();
                DebugTraceConfigurationDialog.this.dispose();
                instance = null;
            }
        });
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.trace((Object)("DebugTrace configuration modified for thecurrent session, Level=" + DebugTraceConfigurationDialog.this.logLevelCombo.getSelectedIndex() + " Debug Enable = " + DebugTraceConfigurationDialog.this.enableDebug.isSelected()));
                DebugTracer.setTraceLevel(DebugTraceConfigurationDialog.this.logLevelCombo.getSelectedIndex());
                DebugTracer.setEnableDebug(DebugTraceConfigurationDialog.this.enableDebug.isSelected());
                DebugTraceConfigurationDialog.this.dispose();
                instance = null;
            }
        });
        this.enableDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!DebugTraceConfigurationDialog.this.enableDebug.isSelected()) {
                    DebugTraceConfigurationDialog.this.logLevelCombo.setEnabled(false);
                } else {
                    DebugTraceConfigurationDialog.this.logLevelCombo.setEnabled(true);
                }
                DebugTraceConfigurationDialog.this.enableApplyButton();
            }
        });
        this.logLevelCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DebugTraceConfigurationDialog.this.enableApplyButton();
            }
        });
    }

    private void enableApplyButton() {
        if (this.logLevelCombo.getSelectedIndex() == this.oldTraceLevel && this.enableDebug.isSelected() == this.oldTraceEnable) {
            this.apply.setEnabled(false);
        } else {
            this.apply.setEnabled(true);
        }
    }
}

