/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.util.log.IviewLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class CommonUtil {
    private static IviewLogger logger = IviewLogger.getLogger(CommonUtil.class, "IVIEW");
    private static ResourceBundle res = null;
    private static final int SIXTY_SEC = 59;
    private static final int SIXTY_MIN = 59;
    private static final int TWENTY_FOUR_HOURS = 23;
    private static final int THIRTY_ONE_DAYS = 31;
    private static final int TWELVE_MONTHS = 12;
    public static final int SYSTEM_START_YEAR = 1990;
    public static final byte HAS_YF = 0;
    public static final byte HAS_YMF = 1;
    public static final byte HAS_YMDF = 2;
    public static final byte HAS_YMDTF = 3;
    public static final byte HAS_TF = 4;
    public static final String DEFAULT_PATH = "iview.filechooser.defaultpath";
    private static final byte RANDOM_HOUR = 13;
    public static final boolean IS_MENUTOOL = null != System.getProperty("MenuTool") && "true".equals(System.getProperty("MenuTool"));
    static StringBuffer timeBuf = new StringBuffer(16);
    static StringBuffer yearBuf = new StringBuffer(16);
    static StringBuffer monthBuf = new StringBuffer(16);
    static StringBuffer dateBuf = new StringBuffer(16);
    static StringBuffer convertBuf = new StringBuffer(16);

    public static final boolean validateDate(int n, int n2, int n3) {
        GregorianCalendar gregorianCalendar = null;
        if (n < 0 || n2 < 0 || n3 < 0 || n2 > 12 || n3 > 31) {
            return false;
        }
        gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, 13, 0, 0);
        return gregorianCalendar.get(1) == n && gregorianCalendar.get(2) == n2 - 1 && gregorianCalendar.get(5) == n3;
    }

    public static final boolean validateDate(String string, String string2, String string3) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        try {
            n = Integer.parseInt(string.trim());
            n2 = Integer.parseInt(string2.trim());
            n3 = Integer.parseInt(string3.trim());
        }
        catch (Exception exception) {
            return false;
        }
        return CommonUtil.validateDate(n, n2, n3);
    }

    public static final boolean validateTime(int n, int n2, int n3) {
        return n >= 0 && n2 >= 0 && n3 >= 0 && n <= 23 && n2 <= 59 && n3 <= 59;
    }

    public static final boolean validateTime(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(string.trim());
            n2 = Integer.parseInt(string2.trim());
            n3 = Integer.parseInt(string3.trim());
        }
        catch (Exception exception) {
            return false;
        }
        return CommonUtil.validateTime(n, n2, n3);
    }

    public static final String toTimeString(Calendar calendar) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        n = calendar.get(10);
        if (calendar.get(9) == 1) {
            n += 12;
        }
        n2 = calendar.get(12);
        n3 = calendar.get(13);
        if (timeBuf.capacity() > 0) {
            timeBuf.delete(0, timeBuf.capacity() - 1);
        }
        if (n < 10) {
            timeBuf.append("0");
        }
        timeBuf.append(n);
        timeBuf.append(":");
        if (n2 < 10) {
            timeBuf.append("0");
        }
        timeBuf.append(n2);
        timeBuf.append(":");
        if (n3 < 10) {
            timeBuf.append("0");
        }
        timeBuf.append(n3);
        return timeBuf.toString();
    }

    public static final String toYearString(Calendar calendar) {
        int n = calendar.get(1);
        if (yearBuf.capacity() > 0) {
            yearBuf.delete(0, yearBuf.capacity() - 1);
        }
        yearBuf.append(n);
        while (yearBuf.length() < 4) {
            yearBuf.insert(0, "0");
        }
        return yearBuf.toString();
    }

    public static final String toMonthString(Calendar calendar) {
        int n = calendar.get(2) + 1;
        if (monthBuf.capacity() > 0) {
            monthBuf.delete(0, monthBuf.capacity() - 1);
        }
        monthBuf.append(n);
        if (monthBuf.length() == 1) {
            monthBuf.insert(0, "0");
        }
        return monthBuf.toString();
    }

    public static final String toDateString(Calendar calendar) {
        int n = calendar.get(5);
        if (dateBuf.capacity() > 0) {
            dateBuf.delete(0, dateBuf.capacity() - 1);
        }
        dateBuf.append(n);
        if (dateBuf.length() == 1) {
            dateBuf.insert(0, "0");
        }
        return dateBuf.toString();
    }

    public static synchronized byte[] calendarToBytes(Calendar calendar) {
        byte[] byArray = new byte[6];
        int n = calendar.get(1) - 1990;
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(10);
        if (calendar.get(9) == 1) {
            n4 += 12;
        }
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        byArray[0] = (byte)n;
        byArray[1] = (byte)n2;
        byArray[2] = (byte)n3;
        byArray[3] = (byte)n4;
        byArray[4] = (byte)n5;
        byArray[5] = (byte)n6;
        return byArray;
    }

    public static synchronized String convertCalendarToStr(Calendar calendar, byte by) {
        if (calendar == null) {
            return null;
        }
        String string = CommonUtil.toMonthString(calendar);
        String string2 = CommonUtil.toDateString(calendar);
        String string3 = CommonUtil.toTimeString(calendar);
        if (convertBuf.capacity() > 0) {
            convertBuf.delete(0, convertBuf.capacity() - 1);
        }
        convertBuf.append(CommonUtil.toYearString(calendar));
        switch (by) {
            case 0: {
                return convertBuf.toString();
            }
            case 1: {
                return convertBuf.append("-").append(string).toString();
            }
            case 2: {
                return convertBuf.append("-").append(string).append("-").append(string2).toString();
            }
            case 3: {
                return convertBuf.append("-").append(string).append("-").append(string2).append(" ").append(string3).toString();
            }
            case 4: {
                return string3;
            }
        }
        return null;
    }

    public static String convertStrToISO_8859_1(String string) {
        String string2 = string;
        try {
            string2 = new String(string.getBytes(), "ISO-8859-1");
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return string2;
    }

    public static String convertStrAsISO_8859_1(String string) {
        String string2 = string;
        try {
            string2 = new String(string.getBytes("ISO-8859-1"));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return string2;
    }

    public static String convertStrForSend(String string) {
        return CommonUtil.convertStrToISO_8859_1(string);
    }

    public static String convertStrForReceive(String string) {
        return CommonUtil.convertStrAsISO_8859_1(string);
    }

    public static final long start() {
        return System.currentTimeMillis();
    }

    public static final long end(long l) {
        long l2 = System.currentTimeMillis() - l;
        logger.trace("Cost time : " + l2 + "  (ms)");
        return l2;
    }

    public static String getDefaultSavePath() {
        String string = System.getProperty(DEFAULT_PATH);
        if (string == null || string.length() == 0) {
            logger.debug("defaultPath is null");
            return "";
        }
        File file = new File(string);
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeStrToFile(String string, String string2) {
        boolean bl = true;
        File file = CommonUtil.getAbsoluteFile(string);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new BufferedWriter(new FileWriter(file)));
            bufferedWriter.write(string2);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            bl = false;
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                    bufferedWriter = null;
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStrFromFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        File file = CommonUtil.getAbsoluteFile(string);
        if (!file.exists()) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            while (null != string2) {
                stringBuffer.append(string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                    bufferedReader = null;
                }
                catch (IOException iOException) {
                    logger.trace(iOException.getMessage(), iOException);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String getResString(ResourceBundle resourceBundle, String string) {
        String string2 = "";
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return null;
        }
        return string2;
    }

    public static File getAbsoluteFile(String string) {
        File file = new File(string);
        return file.getAbsoluteFile();
    }

    public static String getAbsolutePath(String string) {
        File file = new File(string);
        return file.getAbsolutePath();
    }

    public static void checkDirectory(String string) {
        File file = CommonUtil.getAbsoluteFile(string);
        String string2 = file.getParent();
        File file2 = CommonUtil.getAbsoluteFile(string2);
        boolean bl = file2.mkdirs();
        logger.debug("Parent:" + string2 + ", result:" + bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readAndPrintErrMsg(InputStream inputStream, IviewLogger iviewLogger) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        try {
            String string;
            while ((string = lineNumberReader.readLine()) != null) {
                iviewLogger.error(string);
            }
        }
        catch (IOException iOException) {
            iviewLogger.trace(iOException.getMessage(), iOException);
        }
        finally {
            try {
                lineNumberReader.close();
                lineNumberReader = null;
                inputStreamReader.close();
                inputStreamReader = null;
            }
            catch (IOException iOException) {
                iviewLogger.trace(iOException.getMessage(), iOException);
            }
        }
    }

    public static File getParentDirectory(String string) {
        File file = new File(string);
        if (null != file && file.exists()) {
            return file.getParentFile();
        }
        return null;
    }

    public static int getUTFStringGBKLength(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        String string2 = System.getProperty("file.encoding");
        if (null != string2 && "utf-8".equals(System.getProperty("file.encoding").toLowerCase())) {
            int n = 0;
            String string3 = string.replaceAll("[^\u4e00-\u9fa5\u3000-\u303f\uff00-\uffef\ufe31-\ufe5e\u2014-\u2027]", "");
            String string4 = string.replaceAll("[\u4e00-\u9fa5\u3000-\u303f\uff00-\uffef\ufe31-\ufe5e\u2014-\u2027]", "");
            n = string4.getBytes().length + string3.length() * 2;
            return n;
        }
        return string.getBytes().length;
    }

    public static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            File file2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                file2 = new File(file, stringArray[i]);
                if (CommonUtil.deleteDir(file2)) continue;
                logger.trace("File deletion might have failed : " + file2.getAbsolutePath());
                return false;
            }
        }
        return file.delete();
    }

    public static boolean isStartupClassLoaded() {
        ClassLoader classLoader = CommonUtil.class.getClassLoader();
        try {
            classLoader.loadClass("com.swimap.startup.StartupClassLoader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.trace("Startup class loader jar not present in class path");
            return false;
        }
        return true;
    }

    public static boolean isCurrentUserDir(String string) {
        boolean bl = false;
        String string2 = System.getProperty("user.dir");
        if (null != string && null != string2) {
            File file = new File(string2);
            String string3 = file.getAbsolutePath();
            if ((string3 = string3.replace('\\', '/')).endsWith("/")) {
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
            } else if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string3.equals(string)) {
                bl = true;
            }
        }
        return bl;
    }

    public static String getCurrentUserDir() {
        String string = null;
        String string2 = System.getProperty("user.dir");
        if (null != string2) {
            File file = new File(string2);
            String string3 = file.getAbsolutePath();
            string = string3.replace('\\', '/');
            logger.trace("Sreialize the resource client path " + string);
        }
        return string;
    }

    public static boolean executeCommand(String string) {
        return CommonUtil.executeCommand(string, true);
    }

    public static boolean executeCommand(String string, boolean bl) {
        try {
            final Process process = CommonUtil.getProcess(string.trim());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        CommonUtil.readAndPrintErrMsg(process.getInputStream(), logger);
                        CommonUtil.readAndPrintErrMsg(process.getErrorStream(), logger);
                    }
                    catch (Exception exception) {
                        logger.trace(exception);
                    }
                }
            };
            Thread thread = new Thread(runnable, "Command Test Reader");
            thread.start();
        }
        catch (Exception exception) {
            if (null == res) {
                res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
            }
            String string2 = null;
            string2 = string.trim().length() == 0 ? exception.getMessage() : ResourceUtil.getRangeString(res.getString("Error_Msg"), string.trim());
            if (bl) {
                DetailMessageDlg detailMessageDlg = new DetailMessageDlg(FrameworkUtilities.getMainFrame(), res.getString("Warning"), (Object)res.getString("command_error"), 2, 0, string2);
                detailMessageDlg.pack();
                detailMessageDlg.show();
            }
            logger.trace("Unable to execute command" + exception);
            return false;
        }
        return true;
    }

    private static Process getProcess(String string) throws IOException {
        File file = CommonUtil.getParentDirectory(string);
        logger.trace("Parent directory for executable link " + string + " is " + file);
        Process process = null;
        if (null != file) {
            String[] stringArray = new String[]{string};
            process = Runtime.getRuntime().exec(stringArray, null, file);
        } else {
            process = Runtime.getRuntime().exec(string);
        }
        return process;
    }

    public static void hideShowTooltip() {
        final ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (SwingUtilities.isEventDispatchThread()) {
            toolTipManager.setEnabled(false);
            toolTipManager.setEnabled(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    toolTipManager.setEnabled(false);
                    toolTipManager.setEnabled(true);
                }
            });
        }
    }

    public static void hidePopupMenu(final JPopupMenu jPopupMenu) {
        if (jPopupMenu != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                jPopupMenu.setVisible(false);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jPopupMenu.setVisible(false);
                    }
                });
            }
        }
    }
}

