/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.util.IconCloseListener;
import com.swimap.iview.util.adapter.ResourceMngHelper;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class CloseIcon
extends JComponent
implements Icon {
    private static IviewLogger logger = IviewLogger.getLogger(CloseIcon.class, "IVIEW");
    static ResourceBundle res = ResourceMngHelper.getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private final Color COLOR_MOUSE_HOVER = new Color(255, 153, 0);
    private final Color COLOR_MOUSE_PRESSED = new Color(153, 102, 0);
    private final Color COLOR_MOUSE_NORMAL = new Color(94, 94, 94);
    private static final String ICON_STATUS_HOVER = "hover";
    private static final String ICON_STATUS_PRESSED = "pressed";
    private static final String ICON_STATUS_NORMAL = "normal";
    private String iconStatus;
    private static final int ICON_HEIGHT = 8;
    private static final int ICON_WIDTH = 8;
    private int bound_x = 0;
    private int bound_y = 0;
    private JComponent parent = null;
    private boolean enabled = true;
    private MouseListener mouseListener = null;
    private MouseMotionListener mouseMotionListener = null;
    private EventListenerList listeners = new EventListenerList();
    private static final String DEFAULTTOOLTIP = res == null ? "Close" : res.getString("CloseIcon_ToolTip");
    private String parentToolTip = null;
    private PropertyChangeListener tooltipListener = null;
    private boolean pressed = false;

    public CloseIcon(JComponent jComponent) {
        this.parent = jComponent;
        this.iconStatus = ICON_STATUS_NORMAL;
        this.parentToolTip = jComponent.getToolTipText();
        this.setName("CloseIcon");
        if (this.parentToolTip == null) {
            this.setParentToolTip(DEFAULTTOOLTIP);
        }
        jComponent.addMouseListener(this.getMouseListener());
        jComponent.addMouseMotionListener(this.getMouseMotionListener());
        jComponent.addPropertyChangeListener(this.getTooltipListener());
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        if (!bl) {
            this.parent.removeMouseListener(this.mouseListener);
            this.parent.removeMouseMotionListener(this.mouseMotionListener);
            this.parent.removePropertyChangeListener(this.tooltipListener);
        } else {
            this.parent.addMouseListener(this.mouseListener);
            this.parent.addMouseMotionListener(this.mouseMotionListener);
            this.parent.addPropertyChangeListener(this.tooltipListener);
        }
    }

    private MouseMotionListener getMouseMotionListener() {
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if (CloseIcon.this.isCloseIcon(mouseEvent)) {
                        CloseIcon.this.setIconStatus(CloseIcon.ICON_STATUS_HOVER);
                        CloseIcon.this.setToolTip(CloseIcon.this.getIconToolTip());
                    } else {
                        CloseIcon.this.setIconStatus(CloseIcon.ICON_STATUS_NORMAL);
                        CloseIcon.this.setToolTip(CloseIcon.this.getParentToolTip());
                    }
                }
            };
        }
        return this.mouseMotionListener;
    }

    protected String getIconToolTip() {
        return DEFAULTTOOLTIP;
    }

    private MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (CloseIcon.this.isCloseIcon(mouseEvent)) {
                        if (CloseIcon.this.pressed) {
                            CloseIcon.this.setIconStatus(CloseIcon.ICON_STATUS_PRESSED);
                        } else if (mouseEvent.getModifiers() == 0) {
                            CloseIcon.this.setIconStatus(CloseIcon.ICON_STATUS_HOVER);
                        }
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    CloseIcon.this.setIconStatus(CloseIcon.ICON_STATUS_NORMAL);
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (CloseIcon.this.isCloseIcon(mouseEvent) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        CloseIcon.this.pressed = true;
                        CloseIcon.this.setIconStatus(CloseIcon.ICON_STATUS_PRESSED);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        if (CloseIcon.this.pressed && CloseIcon.this.isCloseIcon(mouseEvent)) {
                            CloseIcon.this.setIconStatus(CloseIcon.ICON_STATUS_NORMAL);
                            CloseIcon.this.processCloseEvent();
                        }
                        CloseIcon.this.pressed = false;
                    }
                }
            };
        }
        return this.mouseListener;
    }

    public void setMousePressed(boolean bl) {
        this.pressed = bl;
    }

    private PropertyChangeListener getTooltipListener() {
        if (this.tooltipListener == null) {
            this.tooltipListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("ToolTipText") && !DEFAULTTOOLTIP.equals(propertyChangeEvent.getNewValue())) {
                        CloseIcon.this.parentToolTip = (String)propertyChangeEvent.getNewValue();
                    }
                }
            };
        }
        return this.tooltipListener;
    }

    protected String getParentToolTip() {
        return this.parentToolTip;
    }

    protected void setParentToolTip(String string) {
        String string2 = this.parent.getToolTipText();
        if (string == null ? string2 == null : ResourceUtil.areEquals(string, string2)) {
            return;
        }
        this.parent.setToolTipText(string);
    }

    private synchronized void setToolTip(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setParentToolTip(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CloseIcon.this.setParentToolTip(string);
                }
            });
        }
    }

    private synchronized void setIconStatus(String string) {
        if (this.iconStatus == null || !this.iconStatus.equals(string)) {
            this.iconStatus = string;
            this.parent.repaint();
        }
    }

    public void addIconCloseListener(IconCloseListener iconCloseListener) {
        this.listeners.add(IconCloseListener.class, iconCloseListener);
    }

    public void removeIconCloseListener(IconCloseListener iconCloseListener) {
        this.listeners.remove(IconCloseListener.class, iconCloseListener);
    }

    private void processCloseEvent() {
        EventListener[] eventListenerArray = this.listeners.getListeners(IconCloseListener.class);
        IconCloseListener iconCloseListener = null;
        for (int i = 0; i < eventListenerArray.length; ++i) {
            try {
                iconCloseListener = (IconCloseListener)eventListenerArray[i];
                iconCloseListener.close();
                continue;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.bound_x, this.bound_y, 8, 8);
    }

    public boolean isCloseIcon(MouseEvent mouseEvent) {
        Rectangle rectangle = this.getMouseBounds();
        return rectangle.contains(mouseEvent.getPoint());
    }

    protected Rectangle getMouseBounds() {
        return new Rectangle(this.bound_x, 0, this.parent.getWidth() - this.bound_x, this.parent.getHeight());
    }

    @Override
    public int getIconHeight() {
        return 8;
    }

    @Override
    public int getIconWidth() {
        return 8;
    }

    @Override
    public void repaint() {
        if (this.parent != null) {
            this.paintIcon(this.parent, this.parent.getGraphics(), this.bound_x, this.bound_y);
        }
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (graphics == null) {
            throw new IllegalArgumentException("Graphics is null.");
        }
        this.bound_x = n;
        this.bound_y = n2;
        if (this.enabled) {
            if (ICON_STATUS_NORMAL.equals(this.iconStatus)) {
                graphics.setColor(this.COLOR_MOUSE_NORMAL);
            }
            if (ICON_STATUS_HOVER.equals(this.iconStatus)) {
                graphics.setColor(this.COLOR_MOUSE_HOVER);
            }
            if (ICON_STATUS_PRESSED.equals(this.iconStatus)) {
                graphics.setColor(this.COLOR_MOUSE_PRESSED);
            }
        } else {
            graphics.setColor(this.COLOR_MOUSE_NORMAL.brighter().brighter());
        }
        graphics.drawLine(n, n2, n + 8, n2 + 8);
        graphics.drawLine(n, n2 + 8, n + 8, n2);
        graphics.drawLine(n + 1, n2, n + 8, n2 + 8 - 1);
        graphics.drawLine(n, n2 + 8 - 1, n - 1 + 8, n2);
        graphics.drawLine(n, n2 + 1, n + 8 - 1, n2 + 8);
        graphics.drawLine(n + 1, n2 + 8, n + 8, n2 + 1);
    }
}

