/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util;

import com.swimap.iview.util.XYLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class BevelPanel
extends JComponent
implements Serializable {
    public static final int FLAT = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    protected int bevlIneer = 1;
    protected int bevlOuter = 0;
    protected boolean soft = false;
    protected Insets margins = new Insets(0, 0, 0, 0);
    protected String textureName = null;
    private Border border = null;
    private final int MINIMUMSIZE = 10;

    public BevelPanel() {
        this.setLayout(new XYLayout());
        this.setBackground(UIManager.getColor("Panel.background"));
        this.setForeground(UIManager.getColor("Panel.foreground"));
        this.setFont(UIManager.getFont("Panel.font"));
        this.setOpaque(true);
        this.resetEdges();
    }

    public BevelPanel(int n, int n2) {
        this.setLayout(new XYLayout());
        this.setBackground(SystemColor.control);
        this.setOpaque(true);
        if (n >= 0 && n <= 2) {
            this.bevlIneer = n;
        }
        if (n2 >= 0 && n2 <= 2) {
            this.bevlOuter = n2;
        }
        this.resetEdges();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        super.setBackground(UIManager.getColor("Panel.background"));
        super.setForeground(UIManager.getColor("Panel.foreground"));
        this.setFont(UIManager.getFont("Panel.font"));
    }

    public void setBevelInner(int n) {
        if (n >= 0 && n <= 2 && n != this.bevlIneer) {
            this.bevlIneer = n;
            this.resetEdges();
        }
    }

    public int getBevelInner() {
        return this.bevlIneer;
    }

    public void setBevelOuter(int n) {
        if ((n == 0 || n == 1 || n == 2) && n != this.bevlOuter) {
            this.bevlOuter = n;
            this.resetEdges();
        }
    }

    public int getBevelOuter() {
        return this.bevlOuter;
    }

    public void setSoft(boolean bl) {
        if (this.soft != bl) {
            this.soft = bl;
            this.resetEdges();
        }
    }

    public boolean isSoft() {
        return this.soft;
    }

    public void setMargins(Insets insets) {
        if (this.margins.equals(insets)) {
            return;
        }
        this.margins = insets == null ? new Insets(0, 0, 0, 0) : insets;
        this.invalidate();
        this.repaint();
    }

    public Insets getMargins() {
        return this.margins;
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        Insets insets2 = new Insets(0, 0, 0, 0);
        return new Insets(insets.top + insets2.top + this.margins.top, insets.left + insets2.left + this.margins.left, insets.bottom + insets2.bottom + this.margins.bottom, insets.right + insets2.right + this.margins.right);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width <= 10) {
            dimension.width = 100;
        }
        if (dimension.height <= 10) {
            dimension.height = 100;
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        if (null != this.border) {
            this.border.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
        }
    }

    protected void resetEdges() {
        if (this.bevlIneer == 0 && this.bevlOuter == 0) {
            this.border = null;
        } else {
            int n = 0;
            switch (this.bevlIneer) {
                case 1: {
                    n |= 0x400;
                    break;
                }
                case 2: {
                    n |= 0x800;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            switch (this.bevlOuter) {
                case 1: {
                    n |= 0x100;
                    break;
                }
                case 2: {
                    n |= 0x200;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            this.border = BorderFactory.createBevelBorder(1);
        }
        this.invalidate();
        this.repaint();
    }
}

