/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.wizard;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.wizard.IWizardStyleInterface;
import com.swimap.iview.templates.wizard.WizardStyleInformation;
import com.swimap.iview.templates.wizard.WizardStyleInformationManager;
import com.swimap.iview.templates.wizard.xml.IViewWizard;
import com.swimap.iview.templates.wizard.xml.StepIcon;
import com.swimap.iview.templates.wizard.xml.WizardInfoPanel;
import com.swimap.iview.templates.wizard.xml.WizardStepInformation;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;

public class WizardXMLFileReader {
    private static IviewLogger logger = IviewLogger.getLogger(WizardXMLFileReader.class, "IVIEW");
    private static final int DEFAULT_LEFTPANEL_WIDTH = 100;
    private static final int DEFAULT_LEFTPANEL_HEIGHT = 300;
    private boolean validity = false;
    public WizardStyleInformationManager theWizardStyleInformationManager = null;
    public WizardStyleInformation theWizardStyleInformation = null;

    public boolean readXMLFile(String string) throws IOException {
        try {
            String string2 = CommonUtil.getAbsolutePath(string);
            File file = new File(string2);
            URL uRL = file.toURL();
            IViewWizard iViewWizard = IViewWizard.unmarshal(uRL);
            this.validity = iViewWizard.isValid();
            if (this.validity) {
                int n;
                WizardStepInformation[] wizardStepInformationArray = iViewWizard.getWizardStepInformation();
                String[] stringArray = new String[wizardStepInformationArray.length];
                for (n = 0; n < wizardStepInformationArray.length; ++n) {
                    stringArray[Integer.parseInt((String)wizardStepInformationArray[n].getStepNumber()) - 1] = wizardStepInformationArray[n].getStepUi();
                }
                for (n = 0; n < stringArray.length; ++n) {
                    if (stringArray[n] != null) continue;
                    throw new NullPointerException("Step #" + (n + 1) + " is null");
                }
                this.theWizardStyleInformation = new WizardStyleInformation();
                this.theWizardStyleInformation.setSteps(stringArray);
                this.readLeftInfoPanel(iViewWizard);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.validity = false;
            logger.error("Number Format Exception while reading style information object: " + numberFormatException);
        }
        catch (Exception exception) {
            this.validity = false;
            logger.error("Exception while reading style information object: " + exception);
        }
        return this.validity;
    }

    private void readLeftInfoPanel(IViewWizard iViewWizard) {
        WizardInfoPanel wizardInfoPanel = iViewWizard.getWizardInfoPanel();
        if (null == wizardInfoPanel) {
            return;
        }
        boolean bl = "true".equalsIgnoreCase(wizardInfoPanel.getStepListVisible());
        this.theWizardStyleInformation.setShowStepList(bl);
        String string = wizardInfoPanel.getBgImage();
        ImageIcon imageIcon = this.readImageIcon(string);
        this.theWizardStyleInformation.setLeftPanelImage(imageIcon);
        this.setSizeOfLeftPanel(wizardInfoPanel);
        this.readIconInfo(wizardInfoPanel);
    }

    private void setSizeOfLeftPanel(WizardInfoPanel wizardInfoPanel) {
        String string = wizardInfoPanel.getDimension().getWidth();
        String string2 = wizardInfoPanel.getDimension().getHeight();
        int n = 100;
        int n2 = 300;
        try {
            n = Integer.parseInt(string);
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 100;
            n2 = 300;
        }
        this.theWizardStyleInformation.setLeftPanelDimension(new Dimension(n, n2));
    }

    private void readIconInfo(WizardInfoPanel wizardInfoPanel) {
        StepIcon stepIcon = wizardInfoPanel.getStepIcon();
        String string = stepIcon.getCurrent();
        this.theWizardStyleInformation.setCurrentStepIcon(this.readImageIcon(string));
        string = stepIcon.getFinished();
        this.theWizardStyleInformation.setFinishedStepIcon(this.readImageIcon(string));
        string = stepIcon.getRemaining();
        this.theWizardStyleInformation.setRemainingStepIcon(this.readImageIcon(string));
    }

    private ImageIcon readImageIcon(String string) {
        if (null == string || string.trim().length() == 0) {
            return null;
        }
        ImageIcon imageIcon = null;
        File file = CommonUtil.getAbsoluteFile(string);
        if (null == file || !file.exists()) {
            ClassLoader classLoader = WizardXMLFileReader.class.getClassLoader();
            URL uRL = classLoader.getResource(string);
            if (null != uRL) {
                Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                imageIcon = new ImageIcon(image);
            }
        } else {
            imageIcon = new ImageIcon(CommonUtil.getAbsolutePath(string));
        }
        if (null == imageIcon) {
            imageIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect(string);
        }
        return imageIcon;
    }

    public boolean isInformationValid() {
        return this.validity;
    }

    public boolean saveInformation(IWizardStyleInterface iWizardStyleInterface) {
        boolean bl = iWizardStyleInterface != null & this.theWizardStyleInformation != null;
        if (bl) {
            try {
                iWizardStyleInterface.saveInformation(this.theWizardStyleInformation);
            }
            catch (Exception exception) {
                bl = false;
                logger.error("Exception while saving style information object:" + exception);
            }
        }
        return bl;
    }
}

