/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.wizard;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.wizard.AbstractWizardPanel;
import com.swimap.iview.templates.wizard.IWizardInterface;
import com.swimap.iview.templates.wizard.IWizardInterfaceEx;
import com.swimap.iview.templates.wizard.IWizardStyleInterface;
import com.swimap.iview.templates.wizard.StepList;
import com.swimap.iview.templates.wizard.WizardStyleInformation;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;

public class WizardTemplate
extends JDialog {
    private static final long serialVersionUID = -4972242702124007236L;
    private static IviewLogger logger = IviewLogger.getLogger(WizardTemplate.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/wizard/Res");
    private JButton nextButton = null;
    private JButton previousButton = null;
    private JButton finishButton = null;
    private JButton cancelButton = null;
    private JButton helpButton = null;
    public WizardStyleInformation theWizardStyleInformation = null;
    private static final double BOLD_EXTRA_WIDTH = 0.332;
    private IWizardInterface currentStep = null;
    private final int ARRAY_CAPACITY = 5;
    private ArrayList<IWizardInterface> previousSteps = new ArrayList(5);
    private JPanel stepPanel = null;
    private JPanel leftPanel = null;
    private StepList stepList = null;
    private Object userObject = null;
    private JPanel panelButtons = null;
    private static final int MINIMUMWIDTH = 466;

    public WizardTemplate(JDialog jDialog) {
        super(jDialog);
        this.initializeDialogComponents();
        this.layoutComponents();
        this.addListeners();
    }

    public WizardTemplate(JFrame jFrame) {
        super(jFrame);
        this.initializeDialogComponents();
        this.layoutComponents();
        this.addListeners();
    }

    public WizardTemplate(JDialog jDialog, WizardStyleInformation wizardStyleInformation) throws Exception {
        this(jDialog);
        this.setInformation(wizardStyleInformation);
    }

    public WizardTemplate(JFrame jFrame, WizardStyleInformation wizardStyleInformation) throws Exception {
        this(jFrame);
        this.setInformation(wizardStyleInformation);
    }

    public WizardTemplate(JDialog jDialog, IWizardStyleInterface iWizardStyleInterface) throws ClassNotFoundException, IOException {
        this(jDialog);
        this.setInformation(iWizardStyleInterface);
    }

    public WizardTemplate(JFrame jFrame, IWizardStyleInterface iWizardStyleInterface) throws ClassNotFoundException, IOException {
        this(jFrame);
        this.setInformation(iWizardStyleInterface);
    }

    private void initializeDialogComponents() {
        this.stepPanel = new JPanel(new BorderLayout());
        this.stepPanel.setName("WizardTemplate_stepPanel");
        Dimension dimension = new Dimension(80, 21);
        this.nextButton = new JButton();
        this.nextButton.setPreferredSize(dimension);
        this.nextButton.setMaximumSize(dimension);
        this.nextButton.setMinimumSize(dimension);
        Insets insets = this.nextButton.getInsets();
        this.nextButton.setMargin(new Insets(insets.top, insets.left - 8, insets.bottom, insets.right - 8));
        this.previousButton = new JButton();
        this.previousButton.setPreferredSize(dimension);
        this.previousButton.setMaximumSize(dimension);
        this.previousButton.setMinimumSize(dimension);
        Insets insets2 = this.previousButton.getInsets();
        this.previousButton.setMargin(new Insets(insets2.top, insets2.left - 8, insets2.bottom, insets2.right - 8));
        this.finishButton = new JButton();
        this.finishButton.setPreferredSize(dimension);
        this.finishButton.setMaximumSize(dimension);
        this.finishButton.setMinimumSize(dimension);
        this.cancelButton = new JButton();
        this.cancelButton.setPreferredSize(dimension);
        this.cancelButton.setMaximumSize(dimension);
        this.cancelButton.setMinimumSize(dimension);
        this.helpButton = new JButton();
        this.helpButton.setPreferredSize(dimension);
        this.helpButton.setMaximumSize(dimension);
        this.helpButton.setMinimumSize(dimension);
        this.nextButton.setText(res.getString("Next"));
        this.nextButton.setName("WizardTemplate_nextButton");
        this.previousButton.setText(res.getString("Previous"));
        this.previousButton.setName("WizardTemplate_previousButton");
        this.finishButton.setText(res.getString("Finish"));
        this.finishButton.setName("WizardTemplate_finishButton");
        this.cancelButton.setText(res.getString("Cancel"));
        this.cancelButton.setName("WizardTemplate_cancelButton");
        this.helpButton.setText(res.getString("Help"));
        this.helpButton.setName("WizardTemplate_helpButton");
        this.setDefaultCloseOperation(0);
        this.nextButton.setMnemonic('N');
        this.previousButton.setMnemonic('P');
        this.finishButton.setMnemonic('F');
        this.cancelButton.setMnemonic('C');
        this.helpButton.setMnemonic('H');
    }

    private void layoutComponents() {
        this.panelButtons = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 12, 12, 0), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 0, 12, 12), 30, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 10, 12, 10), 0, 0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 0, 12, 0), 0, 0);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 4, 12, 0), 0, 0);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 4, 12, 0), 0, 0);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 12, 12, 0), 0, 0);
        this.panelButtons.add((Component)this.helpButton, gridBagConstraints);
        this.panelButtons.add(Box.createHorizontalGlue(), gridBagConstraints2);
        this.panelButtons.add((Component)this.cancelButton, gridBagConstraints3);
        this.panelButtons.add((Component)this.previousButton, gridBagConstraints4);
        this.panelButtons.add((Component)this.nextButton, gridBagConstraints5);
        this.panelButtons.add((Component)this.finishButton, gridBagConstraints6);
        this.panelButtons.add((Component)new JLabel(), gridBagConstraints7);
        this.leftPanel = new JPanel(new GridBagLayout());
        this.leftPanel.setName("WizardTemplate_leftpanel");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.stepPanel, "Center");
        this.getContentPane().add((Component)this.leftPanel, "West");
        this.getContentPane().add((Component)this.panelButtons, "South");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (WizardTemplate.this.getWidth() < 466) {
                    WizardTemplate.this.setSize(466, WizardTemplate.this.getHeight());
                }
            }
        });
        this.pack();
    }

    public void addCancelAtEnd() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 10, 12, 0), 0, 0);
        this.panelButtons.remove(this.cancelButton);
        this.panelButtons.add((Component)this.cancelButton, gridBagConstraints);
    }

    private void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WizardTemplate.this.cancelClicked();
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WizardTemplate.this.nextClicked();
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WizardTemplate.this.previousClicked();
            }
        });
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WizardTemplate.this.finishClicked();
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WizardTemplate.this.cancelClicked();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WizardTemplate.this.cancelClicked();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WizardTemplate.this.helpClicked();
            }
        });
    }

    public WizardStyleInformation getInformation() {
        return this.theWizardStyleInformation;
    }

    public void setInformation(WizardStyleInformation wizardStyleInformation) throws Exception {
        if (wizardStyleInformation == null) {
            logger.error("Wizard style information object is null");
            throw new NullPointerException("Wizard style information object is null");
        }
        this.theWizardStyleInformation = wizardStyleInformation;
        IWizardInterface[] iWizardInterfaceArray = this.theWizardStyleInformation.getSteps();
        for (int i = 0; i < iWizardInterfaceArray.length; ++i) {
            iWizardInterfaceArray[i].setParent(this);
        }
        if (wizardStyleInformation.isShowStepList() || null != wizardStyleInformation.getLeftPanelImage()) {
            this.addLeftPanel(wizardStyleInformation);
        }
        this.setCurrentStep(this.theWizardStyleInformation.getStepInformation(0));
    }

    private void addLeftPanel(WizardStyleInformation wizardStyleInformation) {
        Serializable serializable;
        Accessible accessible;
        Dimension dimension = this.theWizardStyleInformation.getLeftPanelDimension();
        this.leftPanel.setPreferredSize(dimension);
        if (this.theWizardStyleInformation.isShowStepList()) {
            accessible = this.createLeftPanel(wizardStyleInformation, dimension);
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).gridx = 0;
            ((GridBagConstraints)serializable).gridy = 0;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagConstraints)serializable).weighty = 1.0;
            ((GridBagConstraints)serializable).insets = new Insets(12, 12, 0, 0);
            ((GridBagConstraints)serializable).fill = 1;
            ((GridBagConstraints)serializable).anchor = 18;
            this.leftPanel.add((Component)((Object)accessible), serializable);
        }
        accessible = this.theWizardStyleInformation.getLeftPanelImage();
        serializable = null;
        if (null != accessible) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            serializable = new JLabel((Icon)((Object)accessible));
            ((Component)serializable).setName("WizardTemplate_LeftPanel_BGImage");
            ((JLabel)serializable).setVerticalAlignment(1);
            ((JLabel)serializable).setHorizontalAlignment(10);
            this.leftPanel.add((Component)serializable, gridBagConstraints);
        }
    }

    private JPanel createLeftPanel(WizardStyleInformation wizardStyleInformation, Dimension dimension) {
        String string = this.theWizardStyleInformation.getLeftPanelTitle();
        JLabel jLabel = null;
        if (null != string) {
            jLabel = this.createTitleLabel(dimension, string);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName("WizardTemplate_LeftPanel_StepListPanel");
        jPanel.setOpaque(false);
        jPanel.setBorder(new OnePxBevelBorder(1));
        this.createStepList(wizardStyleInformation);
        if (null != jLabel) {
            jPanel.add((Component)jLabel, "North");
        }
        JScrollPane jScrollPane = this.getScrollPanelForStepList();
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JLabel createTitleLabel(Dimension dimension, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setOpaque(false);
        jLabel.setPreferredSize(new Dimension(dimension.width, 60));
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        Font font = UIManager.getFont("Label.font");
        jLabel.setFont(new Font(font.getFontName(), 1, 18));
        return jLabel;
    }

    private JScrollPane getScrollPanelForStepList() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(7, 20));
        jPanel.setOpaque(false);
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)this.stepList, "Center");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setName("WizardTemplate_steplist_scrollPane");
        jScrollPane.setBorder(null);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.getHorizontalScrollBar().setOpaque(false);
        jScrollPane.getVerticalScrollBar().setOpaque(false);
        return jScrollPane;
    }

    private void createStepList(WizardStyleInformation wizardStyleInformation) {
        Object[] objectArray = null;
        try {
            objectArray = wizardStyleInformation.getSteps();
        }
        catch (Exception exception) {
            logger.trace("not able to read steps.", exception);
        }
        this.stepList = new StepList(objectArray, wizardStyleInformation);
        this.stepList.setOpaque(false);
        this.stepList.setFocusable(false);
        this.stepList.setName("WizardTemplate_steplist");
        int n = 0;
        if (null != objectArray) {
            n = objectArray.length;
        }
        this.stepList.setVisibleRowCount(n);
        this.stepList.setFixedCellHeight(30);
        this.stepList.setFixedCellWidth((int)Math.round(this.getStepListWidth(this.stepList, (IWizardInterface[])objectArray)));
    }

    private double getStepListWidth(StepList stepList, IWizardInterface[] iWizardInterfaceArray) {
        String string = null;
        int n = 0;
        int n2 = 0;
        for (IWizardInterface iWizardInterface : iWizardInterfaceArray) {
            string = iWizardInterface.toString();
            n = string.length();
            if (n2 >= n) continue;
            n2 = n;
        }
        double d = stepList.getMaximumSize().getWidth() + (double)n2 * 0.332;
        if (!ResourceMng.getInstance().getLocaleString().equals("en_US")) {
            d += (double)stepList.getListIcon(0).getIconWidth();
        }
        return d;
    }

    public void setInformation(IWizardStyleInterface iWizardStyleInterface) throws ClassNotFoundException, IOException {
        try {
            this.setInformation(iWizardStyleInterface.loadInformation());
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Error while loading persisted object: " + nullPointerException);
            throw nullPointerException;
        }
        catch (ClassCastException classCastException) {
            logger.error("Error while loading persisted object: " + classCastException);
            throw classCastException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("Error while loading persisted object: " + classNotFoundException);
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            logger.error("Error while loading persisted object: " + iOException);
            throw iOException;
        }
        catch (SecurityException securityException) {
            logger.error("Error while loading persisted object: " + securityException);
            throw securityException;
        }
        catch (Exception exception) {
            logger.error("Error while loading persisted object: " + exception);
        }
    }

    public void nextClicked() {
        if (this.currentStep.isUserEntryValid()) {
            Object object = this.currentStep.getInformation();
            this.previousSteps.add(this.currentStep);
            int n = this.currentStep.getNextStepNumber();
            IWizardInterface iWizardInterface = this.theWizardStyleInformation.getStepInformation(n - 1);
            this.setCurrentStep(iWizardInterface);
            this.currentStep.setInformation(object);
        }
    }

    public void previousClicked() {
        int n = this.previousSteps.size();
        if (n >= 1) {
            IWizardInterface iWizardInterface = this.previousSteps.remove(n - 1);
            this.setCurrentStep(iWizardInterface);
        }
    }

    public void finishClicked() {
        if (this.currentStep.isUserEntryValid()) {
            this.currentStep.finishAction();
            this.dispose();
        }
    }

    public void cancelClicked() {
        int n;
        if (this.currentStep != null && this.currentStep instanceof IWizardInterfaceEx) {
            ((IWizardInterfaceEx)this.currentStep).preCancelAction();
        }
        if ((n = OptionPane.showConfirmDialog((Component)this, (Object)res.getString("Are_you_sure_you_want"), res.getString("Confirmation"), 0, 3)) == 0) {
            if (this.currentStep != null) {
                this.currentStep.cancelAction();
            }
            this.dispose();
        } else if (this.currentStep != null && this.currentStep instanceof IWizardInterfaceEx) {
            ((IWizardInterfaceEx)this.currentStep).notCancelAction();
        }
    }

    public void helpClicked() {
        this.currentStep.displayHelp();
    }

    final int getStepNumber(IWizardInterface iWizardInterface) {
        int n = this.theWizardStyleInformation.indexOfStep(iWizardInterface);
        return -1 == n ? 1 : n + 1;
    }

    public void setNextEnabled(boolean bl) {
        this.nextButton.setEnabled(bl);
    }

    public void setCancelEnabled(boolean bl) {
        this.cancelButton.setEnabled(bl);
    }

    public void setFinishEnabled(boolean bl) {
        this.finishButton.setEnabled(bl);
    }

    public void setPreviousEnabled(boolean bl) {
        this.previousButton.setEnabled(bl);
    }

    public void setHelpEnabled(boolean bl) {
        this.helpButton.setEnabled(bl);
    }

    private void setCurrentStep(IWizardInterface iWizardInterface) {
        this.currentStep = iWizardInterface;
        this.stepPanel.removeAll();
        this.stepPanel.add((Component)this.currentStep.getDisplayPanel(), "Center");
        this.setButtonStatus();
        if (this.theWizardStyleInformation.isShowStepList()) {
            int n = this.theWizardStyleInformation.indexOfStep(this.currentStep);
            this.stepList.setSelectedIndex(n);
            this.stepList.scrollRectToVisible(this.stepList.getCellBounds(n, n));
        }
        this.stepPanel.updateUI();
    }

    public void setButtonStatus() {
        this.setFinishEnabled(this.currentStep.isFinishAllowed());
        this.setPreviousEnabled(this.currentStep.isPreviousAllowed());
        this.setNextEnabled(this.currentStep.isNextAllowed());
        if (this.currentStep instanceof AbstractWizardPanel) {
            AbstractWizardPanel abstractWizardPanel = (AbstractWizardPanel)this.currentStep;
            this.helpButton.setVisible(abstractWizardPanel.isHelpVisible());
            this.nextButton.setVisible(abstractWizardPanel.isNextVisible());
            this.finishButton.setVisible(abstractWizardPanel.isFinishVisible());
            this.cancelButton.setEnabled(abstractWizardPanel.isCancelAllowed());
            this.setHelpEnabled(abstractWizardPanel.isHelpAllowed());
            this.cancelButton.setVisible(abstractWizardPanel.isCancelVisible());
            this.previousButton.setVisible(abstractWizardPanel.isPreviousVisible());
        }
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    private class OnePxBevelBorder
    extends BevelBorder {
        OnePxBevelBorder(int n) {
            super(n);
        }

        @Override
        protected void paintLoweredBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n4;
            int n6 = n3;
            graphics.translate(n, n2);
            graphics.setColor(this.getShadowInnerColor(component));
            graphics.drawLine(0, 0, 0, n5 - 1);
            graphics.drawLine(1, 0, n6 - 1, 0);
            graphics.setColor(this.getHighlightOuterColor(component));
            graphics.drawLine(1, n5 - 1, n6 - 1, n5 - 1);
            graphics.drawLine(n6 - 1, 1, n6 - 1, n5 - 1);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }
    }
}

