/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.wizard;

import com.swimap.iview.templates.wizard.IWizardInterface;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class WizardStyleInformation
implements Serializable {
    private static final long serialVersionUID = 3460636431643004386L;
    private static IviewLogger logger = IviewLogger.getLogger(WizardStyleInformation.class, "IVIEW");
    private transient IWizardInterface[] steps = null;
    private String[] stepNames = null;
    private Dimension leftPanelDimension = null;
    private Icon currentStepIcon = null;
    private Icon finishedStepIcon = null;
    private Icon remainingStepIcon = null;
    private ImageIcon leftPanelImage = null;
    private boolean showStepList = false;
    private String leftPanelTitle = null;

    public void setSteps(String[] stringArray) throws Exception {
        this.stepNames = stringArray;
        this.instantiateSteps();
    }

    private void instantiateSteps() throws Exception {
        this.steps = new IWizardInterface[this.stepNames.length];
        try {
            for (int i = 0; i < this.steps.length; ++i) {
                this.steps[i] = (IWizardInterface)ReflectionUtilities.instantiateTheClass(this.stepNames[i]);
            }
        }
        catch (ClassCastException classCastException) {
            logger.error("Error in the wizard step class name mentioned in the XML file. It is not an instance of IWizardInterface\n" + classCastException.getMessage(), classCastException);
            this.steps = null;
            throw classCastException;
        }
        catch (Exception exception) {
            logger.error("Error in the wizard steps mentioned in the XML file. Exception encountered is\n" + exception.getMessage(), exception);
            this.steps = null;
            throw exception;
        }
    }

    public int getNumberOfSteps() throws Exception {
        return this.getSteps().length;
    }

    public IWizardInterface[] getSteps() throws Exception {
        if (this.steps == null) {
            try {
                this.instantiateSteps();
            }
            catch (Exception exception) {
                logger.error("Error in style information. Cannot instantiate the wizard steps. Exception encountered is\n" + exception.getMessage(), exception);
                this.steps = null;
                throw exception;
            }
        }
        return this.steps;
    }

    public IWizardInterface getStepInformation(int n) {
        if (this.steps != null && n >= 0 && n < this.steps.length) {
            return this.steps[n];
        }
        return null;
    }

    int indexOfStep(IWizardInterface iWizardInterface) {
        int n = -1;
        for (int i = 0; i < this.steps.length; ++i) {
            if (null == iWizardInterface || this.steps[i] != iWizardInterface) continue;
            n = i;
            break;
        }
        return n;
    }

    public void setLeftPanelDimension(Dimension dimension) {
        this.leftPanelDimension = dimension;
    }

    public Dimension getLeftPanelDimension() {
        return this.leftPanelDimension;
    }

    public void setCurrentStepIcon(Icon icon) {
        this.currentStepIcon = icon;
    }

    public Icon getCurrentStepIcon() {
        return this.currentStepIcon;
    }

    public void setFinishedStepIcon(Icon icon) {
        this.finishedStepIcon = icon;
    }

    public Icon getFinishedStepIcon() {
        return this.finishedStepIcon;
    }

    public void setRemainingStepIcon(Icon icon) {
        this.remainingStepIcon = icon;
    }

    public Icon getRemainingStepIcon() {
        return this.remainingStepIcon;
    }

    public void setLeftPanelImage(ImageIcon imageIcon) {
        this.leftPanelImage = imageIcon;
    }

    public ImageIcon getLeftPanelImage() {
        return this.leftPanelImage;
    }

    public boolean isShowStepList() {
        return this.showStepList;
    }

    public void setShowStepList(boolean bl) {
        this.showStepList = bl;
    }

    public void setLeftPanelTitle(String string) {
        this.leftPanelTitle = string;
    }

    public String getLeftPanelTitle() {
        return this.leftPanelTitle;
    }
}

