/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils.timer;

import com.swimap.iview.templates.utils.timer.IViewTaskQueue;
import com.swimap.iview.templates.utils.timer.IviewTimerTask;
import com.swimap.iview.templates.utils.timer.Timekeeper;
import com.swimap.iview.templates.utils.timer.TimerThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class IviewUtilTimer {
    private final IViewTaskQueue taskQueue = new IViewTaskQueue();
    private TimerThread timerThread = new TimerThread(this.taskQueue);
    private Timekeeper timekeeper = Timekeeper.getInstance();
    private static ExecutorService threadPool = null;

    public IviewUtilTimer() {
        this.timerThread.start();
    }

    public IviewUtilTimer(boolean bl) {
        this.timerThread.setDaemon(bl);
        this.timerThread.start();
    }

    public IviewUtilTimer(int n) {
        if (null == threadPool) {
            threadPool = Executors.newFixedThreadPool(n);
        }
        threadPool.execute(this.timerThread);
    }

    public void schedule(IviewTimerTask iviewTimerTask, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(iviewTimerTask, this.timekeeper.getStandardTime() + l, 0L);
    }

    public void schedule(IviewTimerTask iviewTimerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay " + l);
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period " + l2);
        }
        this.sched(iviewTimerTask, this.timekeeper.getStandardTime() + l, -l2);
    }

    public void scheduleAtFixedRate(IviewTimerTask iviewTimerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(iviewTimerTask, this.timekeeper.getStandardTime() + l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(IviewTimerTask iviewTimerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        IViewTaskQueue iViewTaskQueue = this.taskQueue;
        synchronized (iViewTaskQueue) {
            if (!this.timerThread.newTasksMayBeScheduled) {
                throw new IllegalStateException("Timer already cancelled.");
            }
            Object object = iviewTimerTask.timerTaskLock;
            synchronized (object) {
                if (iviewTimerTask.taskState != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                iviewTimerTask.nextExecTime = l;
                iviewTimerTask.period = l2;
                iviewTimerTask.taskState = 1;
            }
            this.taskQueue.add(iviewTimerTask);
            if (this.taskQueue.getMin() == iviewTimerTask) {
                this.taskQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        IViewTaskQueue iViewTaskQueue = this.taskQueue;
        synchronized (iViewTaskQueue) {
            this.timerThread.newTasksMayBeScheduled = false;
            this.taskQueue.clear();
            this.taskQueue.notify();
        }
    }
}

