/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils.timer;

import com.swimap.iview.templates.utils.timer.IviewTimerTask;
import com.swimap.iview.templates.utils.timer.IviewUtilTimer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;

public class IviewSwingTimer {
    private ActionListener listener = null;
    private IviewTimerTask swingTask = null;
    private int initialDelay = 0;
    private IviewUtilTimer timer = null;
    private int delay = 0;

    public IviewSwingTimer(int n, ActionListener actionListener) {
        this.listener = actionListener;
        this.initialDelay = n;
        this.delay = n;
    }

    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        if (this.listener != null) {
            this.swingTask = new IviewTimerTask(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (IviewSwingTimer.this.listener != null) {
                                IviewSwingTimer.this.listener.actionPerformed(new ActionEvent(IviewSwingTimer.this, 0, null, System.currentTimeMillis(), 0));
                            }
                        }
                    });
                }
            };
            this.timer = new IviewUtilTimer();
            this.timer.schedule(this.swingTask, this.initialDelay, this.delay);
        }
    }

    public synchronized void startLockTimer() {
        if (this.isRunning()) {
            return;
        }
        if (this.listener != null) {
            this.swingTask = new IviewTimerTask(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (IviewSwingTimer.this.listener != null) {
                                IviewSwingTimer.this.listener.actionPerformed(new ActionEvent(IviewSwingTimer.this, 0, null, System.currentTimeMillis(), 0));
                            }
                        }
                    });
                }
            };
            this.timer = new IviewUtilTimer(3);
            this.timer.schedule(this.swingTask, this.initialDelay, this.delay);
        }
    }

    public synchronized void stop() {
        if (this.swingTask != null) {
            this.swingTask.cancel();
            this.swingTask = null;
        }
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void restartLockTimer() {
        this.stop();
        this.startLockTimer();
    }

    public boolean isRunning() {
        return this.swingTask != null && this.swingTask.taskState == 1;
    }

    public void setInitialDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid initial delay: " + n);
        }
        this.initialDelay = n;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid delay: " + n);
        }
        this.delay = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public void cancel() {
        this.stop();
        this.listener = null;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

