/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils.timer;

import com.swimap.iview.templates.utils.timer.IviewTimerTask;

final class IViewTaskQueue {
    private static final int DEFAULT_SIZE = 128;
    private IviewTimerTask[] taskQueue = new IviewTimerTask[128];
    private int size = 0;

    IViewTaskQueue() {
    }

    final void add(IviewTimerTask iviewTimerTask) {
        ++this.size;
        if (this.size == this.taskQueue.length) {
            IviewTimerTask[] iviewTimerTaskArray = new IviewTimerTask[2 * this.taskQueue.length];
            System.arraycopy(this.taskQueue, 0, iviewTimerTaskArray, 0, this.size);
            this.taskQueue = iviewTimerTaskArray;
        }
        this.taskQueue[this.size] = iviewTimerTask;
        this.fixUp(this.size);
    }

    final IviewTimerTask getMin() {
        return this.taskQueue[1];
    }

    final void removeMin() {
        this.taskQueue[1] = this.taskQueue[this.size];
        this.taskQueue[this.size] = null;
        --this.size;
        this.fixDown(1);
    }

    final void rescheduleMin(long l) {
        this.taskQueue[1].nextExecTime = l;
        this.fixDown(1);
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final void clear() {
        for (int i = 1; i <= this.size; ++i) {
            this.taskQueue[i] = null;
        }
        this.size = 0;
    }

    private void fixUp(int n) {
        while (n > 1) {
            int n2 = n >> 1;
            if (this.taskQueue[n2].nextExecTime <= this.taskQueue[n].nextExecTime) break;
            IviewTimerTask iviewTimerTask = this.taskQueue[n2];
            this.taskQueue[n2] = this.taskQueue[n];
            this.taskQueue[n] = iviewTimerTask;
            n = n2;
        }
    }

    private void fixDown(int n) {
        int n2 = 0;
        while ((n2 = n << 1) <= this.size) {
            if (n2 < this.size && this.taskQueue[n2].nextExecTime > this.taskQueue[n2 + 1].nextExecTime) {
                ++n2;
            }
            if (this.taskQueue[n].nextExecTime <= this.taskQueue[n2].nextExecTime) break;
            IviewTimerTask iviewTimerTask = this.taskQueue[n2];
            this.taskQueue[n2] = this.taskQueue[n];
            this.taskQueue[n] = iviewTimerTask;
            n = n2;
        }
    }
}

