/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public final class UndoRedoManager {
    private JTextComponent component = null;
    private UndoManager manager = new UndoManager();
    public static final KeyStroke DEFAULT_UNDO_KEY = KeyStroke.getKeyStroke("ctrl Z");
    public static final KeyStroke DEFAULT_REDO_KEY = KeyStroke.getKeyStroke("ctrl Y");
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();

    public UndoRedoManager(Document document) {
        this.initlize(document, -1);
    }

    public UndoRedoManager(Document document, int n) {
        this.initlize(document, n);
    }

    public UndoRedoManager(JTextComponent jTextComponent) {
        this(jTextComponent, -1, true);
    }

    public UndoRedoManager(JTextComponent jTextComponent, int n, boolean bl) {
        if (jTextComponent == null) {
            throw new IllegalArgumentException("JTextComponent can't be null");
        }
        this.initlize(jTextComponent.getDocument(), n);
        this.component = jTextComponent;
        if (bl) {
            this.setRedoHotKey(DEFAULT_REDO_KEY);
            this.setUndoHotKey(DEFAULT_UNDO_KEY);
        }
    }

    private void initlize(Document document, int n) {
        if (document == null) {
            throw new IllegalArgumentException("Document can't be null");
        }
        document.addUndoableEditListener(new UndoableEditImplement());
        if (n > 0) {
            this.manager.setLimit(n);
        }
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public void setRedoHotKey(KeyStroke keyStroke) {
        if (this.component == null) {
            throw new IllegalStateException("JTextComponent is null, must use 'new UndoRedoManager(JTextComponent, ...,...)' to create instance.");
        }
        this.component.getInputMap().put(keyStroke, keyStroke);
        this.component.getActionMap().put(keyStroke, this.redoAction);
    }

    public void setUndoHotKey(KeyStroke keyStroke) {
        if (this.component == null) {
            throw new IllegalStateException("JTextComponent is null, must use 'new UndoRedoManager(JTextComponent, ...,...)' to create instance.");
        }
        this.component.getInputMap().put(keyStroke, keyStroke);
        this.component.getActionMap().put(keyStroke, this.undoAction);
    }

    public void removeHotKey(KeyStroke keyStroke) {
        if (this.component == null) {
            throw new IllegalStateException("JTextComponent is null, must use 'new UndoRedoManager(JTextComponent, ...,...)' to create instance.");
        }
        this.component.getInputMap().remove(keyStroke);
        this.component.getActionMap().remove(keyStroke);
    }

    public void setLimit(int n) {
        this.manager.setLimit(n);
    }

    public int getLimit() {
        return this.manager.getLimit();
    }

    public void undo() {
        this.undoAction.undo();
    }

    public void redo() {
        this.redoAction.redo();
    }

    public boolean canUndo() {
        return this.manager.canUndo();
    }

    public boolean canRedo() {
        return this.manager.canRedo();
    }

    public void discardAllEdits() {
        this.manager.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    private final class UndoableEditImplement
    implements UndoableEditListener {
        private UndoableEditImplement() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            UndoRedoManager.this.manager.addEdit(undoableEditEvent.getEdit());
            UndoRedoManager.this.undoAction.update();
            UndoRedoManager.this.redoAction.update();
        }
    }

    private final class RedoAction
    extends AbstractAction {
        public RedoAction() {
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.redo();
        }

        public void redo() {
            UndoRedoManager.this.manager.redo();
            UndoRedoManager.this.undoAction.update();
            this.update();
        }

        public void update() {
            if (UndoRedoManager.this.manager.canRedo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private final class UndoAction
    extends AbstractAction {
        public UndoAction() {
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.undo();
        }

        public void undo() {
            UndoRedoManager.this.manager.undo();
            UndoRedoManager.this.redoAction.update();
            this.update();
        }

        public void update() {
            if (UndoRedoManager.this.manager.canUndo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

