/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils;

import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.utils.SwingWorker;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class UITask<T>
implements InvocationHandler,
Callable<T> {
    private static IviewLogger logger = IviewLogger.getLogger(UITask.class, "IVIEW");
    private static final int DIALOG_MIN_WIDTH = 350;
    private static final String FLUSH_EVENT_METHOD = "flushPendingEvents";
    private static final String SUN_TOOLKIT_CLASS = "sun.awt.SunToolkit";
    private static final String PUMP_EVENTS_METHOD = "pumpEvents";
    private static final String AWT_EDT_CLASS = "java.awt.EventDispatchThread";
    private static final String AWT_CONDITIONAL_CLASS = "java.awt.Conditional";
    private static final int SHOW_PROGRESS_DELAY = 2000;
    private static final long MOUSE_EVENT_TIMEOUT = 2000L;
    private static Class conditionalClass;
    private static Method pumpEventsMethod;
    private static Class<?> sunToolkitClass;
    private static Method flushEventMethod;
    private static String defaultMessage;
    private static String cancelText;
    private static ImageIcon cartoonIcon;
    private SwingWorker<T, Void> worker;
    private ArrayList<Component> glassList = new ArrayList(2);
    private Timer timer = null;
    private JDialog dialog = null;
    private JLabel message = null;
    private JProgressBar progress = null;
    private Callable<T> callable = null;
    private String title = null;
    private String messageText = defaultMessage;
    private int progressValue = -1;
    private JFrame mainFrame = FrameworkUtilities.getMainFrame();
    private List<AWTEvent> sequencedEventList = new ArrayList<AWTEvent>(10);
    private static Class sequencedEventClass;
    private static Method getFirstMethod;
    private MouseEvent mouseEvent = null;
    private boolean isDispatchDblClick = false;
    private Action cancelAction = new AbstractAction(cancelText){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UITask.this.cancel();
        }
    };
    private boolean processMouseEvent = false;
    private static Stack<MouseEvent> mouseEventStack;

    public static void setDefaultMessage(String string) {
        defaultMessage = string;
    }

    public static void setCancelText(String string) {
        cancelText = string;
    }

    public UITask() {
        this.callable = this;
        this.cancelAction.setEnabled(false);
    }

    public UITask(Callable<T> callable) {
        this.callable = callable;
        this.cancelAction.setEnabled(false);
    }

    public void setCancelable(final boolean bl) {
        this.invokeUI(new Runnable(){

            @Override
            public void run() {
                UITask.this.cancelAction.setEnabled(bl);
            }
        });
    }

    public void setTitle(final String string) {
        this.invokeUI(new Runnable(){

            @Override
            public void run() {
                UITask.this.title = string;
                if (UITask.this.dialog != null) {
                    UITask.this.dialog.setTitle(string);
                }
            }
        });
    }

    public void setMessage(final String string) {
        this.invokeUI(new Runnable(){

            @Override
            public void run() {
                UITask.this.messageText = string;
                if (UITask.this.message != null) {
                    UITask.this.message.setText(string);
                }
            }
        });
    }

    public void setProgress(final int n) {
        this.invokeUI(new Runnable(){

            @Override
            public void run() {
                UITask.this.progressValue = n;
                if (UITask.this.progress != null) {
                    if (n < 0) {
                        UITask.this.progress.setIndeterminate(true);
                    } else {
                        UITask.this.progress.setIndeterminate(false);
                        UITask.this.progress.setValue(n);
                    }
                }
            }
        });
    }

    protected void invokeUI(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public T call() throws Exception {
        return null;
    }

    public T execute() throws Exception {
        if (!SwingUtilities.isEventDispatchThread()) {
            return this.callable.call();
        }
        try {
            Iterator<AWTEvent> iterator;
            this.worker = new SwingWorker<T, Void>(){

                @Override
                protected T doInBackground() throws Exception {
                    logger.trace("Processing the callable by worker thread : " + this.hashCode());
                    return UITask.this.callable.call();
                }
            };
            logger.trace("UITask:" + this.hashCode() + " about to start worker thread : " + this.worker.hashCode());
            this.worker.execute();
            this.timer = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UITask.this.startWaitCursor();
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
            this.sequencedEventList.clear();
            this.pumpEvents();
            if (!this.sequencedEventList.isEmpty()) {
                for (AWTEvent serializable : this.sequencedEventList) {
                    this.getEventQueue().postEvent(serializable);
                }
            }
            if (!Thread.currentThread().isInterrupted()) {
                iterator = this.worker.get();
                return (T)iterator;
            }
            iterator = null;
            return (T)iterator;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw executionException;
        }
        finally {
            this.stopWaitCursor();
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            if (this.dialog != null) {
                this.dialog.dispose();
                this.dialog = null;
            }
        }
    }

    public T executeSilently(boolean bl) {
        this.isDispatchDblClick = bl;
        return this.executeSilently();
    }

    public T executeSilently() {
        try {
            return this.execute();
        }
        catch (Exception exception) {
            logger.trace("Exception caught in UITask : " + exception.getMessage(), exception);
            return null;
        }
    }

    public boolean isCancelled() {
        if (this.worker != null) {
            return this.worker.isCancelled();
        }
        return false;
    }

    private void showProgress() {
        Window window = this.getCurrentOwner();
        this.dialog = window instanceof Dialog ? new JDialog((Dialog)window) : (window instanceof Frame ? new JDialog((Frame)window) : new JDialog());
        if (null == this.title) {
            this.dialog.setTitle("Progress...");
        } else {
            this.dialog.setTitle(this.title);
        }
        this.dialog.setModal(false);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(cartoonIcon);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(jLabel);
        this.message = new JLabel(this.messageText);
        jPanel.add(this.message);
        this.dialog.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.progress = new JProgressBar(0, 100);
        this.setProgress(this.progressValue);
        jPanel2.add((Component)this.progress, "Center");
        this.dialog.getContentPane().add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(this.cancelAction);
        jButton.setPreferredSize(new Dimension(80, 20));
        jButton.setMinimumSize(new Dimension(80, 20));
        jButton.setMaximumSize(new Dimension(80, 20));
        jPanel3.add(jButton);
        this.dialog.getContentPane().add((Component)jPanel3, "South");
        this.dialog.setCursor(Cursor.getPredefinedCursor(3));
        jButton.setCursor(Cursor.getDefaultCursor());
        this.dialog.setResizable(false);
        this.dialog.pack();
        Dimension dimension = this.dialog.getPreferredSize();
        if (dimension.width < 350) {
            dimension.width = 350;
            this.dialog.setSize(dimension);
        }
        this.dialog.setLocationRelativeTo(window);
    }

    private Window getCurrentOwner() {
        Window[] windowArray;
        for (Window window : windowArray = UITask.getWindows()) {
            if (!window.isActive()) continue;
            return window;
        }
        return Frame.getFrames()[0];
    }

    private void cancel() {
        this.worker.cancel(true);
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private void startWaitCursor() {
        Window[] windowArray;
        logger.trace("UITask : startWaitCursor " + this.hashCode() + "--Start to set the cursor to busy state ");
        if (this.mainFrame != null) {
            ((MDIFrame)this.mainFrame).setCursorState(3);
        }
        for (Window window : windowArray = UITask.getWindows()) {
            if (!(window instanceof RootPaneContainer) || window instanceof JDialog) continue;
            Component component = ((RootPaneContainer)((Object)window)).getGlassPane();
            component.setCursor(Cursor.getPredefinedCursor(3));
            component.setVisible(true);
            this.glassList.add(component);
        }
        logger.trace("UITask : startWaitCursor " + this.hashCode() + "--End of set the cursor to busy state ");
    }

    private void stopWaitCursor() {
        logger.trace("UITask:" + this.hashCode() + "--Stopping the cursor busy state ");
        if (this.mainFrame != null) {
            ((MDIFrame)this.mainFrame).setCursorState(0);
        }
        for (Component component : this.glassList) {
            component.setCursor(Cursor.getDefaultCursor());
            component.setVisible(false);
        }
        this.glassList.clear();
        logger.trace("UITask:" + this.hashCode() + "--Stopped the cursor busy state ");
    }

    private void pumpEvents() {
        block2: {
            try {
                Object object = Proxy.newProxyInstance(conditionalClass.getClassLoader(), new Class[]{conditionalClass}, (InvocationHandler)this);
                pumpEventsMethod.invoke((Object)Thread.currentThread(), object);
                this.invokeStoredEvents();
            }
            catch (Throwable throwable) {
                logger.trace(throwable.getMessage(), throwable);
                if (this.worker.isDone()) break block2;
                this.pumpEvents();
            }
        }
    }

    private void invokeStoredEvents() {
        if (this.processMouseEvent && mouseEventStack.size() > 0) {
            final MouseEvent mouseEvent = (MouseEvent)mouseEventStack.firstElement();
            int n = mouseEventStack.size();
            mouseEventStack.clear();
            if (System.currentTimeMillis() - mouseEvent.getWhen() < 2000L) {
                logger.trace("Dispatching mouse event =" + mouseEvent + " Stack size was = " + n);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((Component)mouseEvent.getSource()).dispatchEvent(mouseEvent);
                    }
                });
            } else {
                logger.trace("Mouse event dropped since dispatching is delayed more!");
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UITask.this.isDispatchDblClick && UITask.this.mouseEvent != null && UITask.this.mouseEvent.getSource() instanceof Frame) {
                    ((Component)UITask.this.mouseEvent.getSource()).dispatchEvent(UITask.this.mouseEvent);
                    UITask.this.mouseEvent = null;
                }
            }
        });
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Exception {
        while (!this.worker.isDone() && !Thread.currentThread().isInterrupted()) {
            Object object2;
            AWTEvent aWTEvent = this.waitForEvent();
            if (aWTEvent == null) {
                return false;
            }
            if (aWTEvent instanceof InvocationEvent && "iview_terminal_event".equals(object2 = ((InvocationEvent)aWTEvent).paramString())) {
                this.getNextEvent();
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aWTEvent);
                logger.trace("Re-posted lock event!..." + (String)object2);
                continue;
            }
            if (this.acceptEvent(aWTEvent)) {
                return true;
            }
            if (this.getNextEvent() == null) {
                return false;
            }
            if (aWTEvent instanceof MouseEvent) {
                object2 = (MouseEvent)aWTEvent;
                if (aWTEvent.getID() == 501) {
                    mouseEventStack.push((MouseEvent)object2);
                } else if (aWTEvent.getID() == 502) {
                    if (mouseEventStack.empty()) {
                        this.processMouseEvent = true;
                        mouseEventStack.push((MouseEvent)object2);
                    } else {
                        MouseEvent mouseEvent = mouseEventStack.peek();
                        if (mouseEvent.getID() == 501) {
                            mouseEventStack.pop();
                        } else {
                            logger.trace("Two successive mouse released events!");
                        }
                    }
                }
            }
            if (!this.isDispatchDblClick || aWTEvent.getID() != 500 || ((MouseEvent)(object2 = (MouseEvent)aWTEvent)).getClickCount() != 2) continue;
            this.mouseEvent = object2;
        }
        return false;
    }

    private boolean acceptEvent(AWTEvent aWTEvent) {
        Object object;
        if (sequencedEventClass.isInstance(aWTEvent)) {
            try {
                object = getFirstMethod.invoke((Object)aWTEvent, null);
                if (object != aWTEvent) {
                    this.sequencedEventList.add(aWTEvent);
                    return false;
                }
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        if (aWTEvent.getID() == 401 && aWTEvent instanceof KeyEvent && ((KeyEvent)(object = (KeyEvent)aWTEvent)).getKeyCode() == 3 && ((InputEvent)object).isControlDown()) {
            this.cancel();
            return true;
        }
        if (this.dialog != null && !this.dialog.isActive()) {
            this.dialog.requestFocus();
        }
        if (this.dialog != null && aWTEvent.getSource() == this.dialog) {
            return true;
        }
        return !(aWTEvent instanceof InputEvent);
    }

    private EventQueue getEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    private AWTEvent getNextEvent() {
        try {
            return this.getEventQueue().getNextEvent();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AWTEvent waitForEvent() {
        EventQueue eventQueue = this.getEventQueue();
        this.flushPendingEvents();
        EventQueue eventQueue2 = eventQueue;
        synchronized (eventQueue2) {
            AWTEvent aWTEvent = this.peekEvent(eventQueue);
            while (null == aWTEvent) {
                try {
                    eventQueue.wait();
                    aWTEvent = this.peekEvent(eventQueue);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return aWTEvent;
        }
    }

    private AWTEvent peekEvent(EventQueue eventQueue) {
        return eventQueue.peekEvent();
    }

    private void flushPendingEvents() {
        try {
            flushEventMethod.invoke(sunToolkitClass, new Object[0]);
        }
        catch (Exception exception) {
            logger.error("Exception ", exception);
        }
    }

    private static Window[] getWindows() {
        ArrayList<Window> arrayList = new ArrayList<Window>(2);
        Frame[] frameArray = Frame.getFrames();
        for (Frame frame : frameArray) {
            UITask.addWindow(frame, arrayList);
        }
        Window[] windowArray = new Window[arrayList.size()];
        arrayList.toArray(windowArray);
        return windowArray;
    }

    private static void addWindow(Window window, List<Window> list) {
        Window[] windowArray;
        list.add(window);
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            UITask.addWindow(window2, list);
        }
    }

    public void disposeDialog() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    static {
        defaultMessage = "Please wait...";
        cancelText = "Cancel";
        cartoonIcon = new ImageIcon(UITask.class.getResource("loadingprogress.gif"));
        sequencedEventClass = null;
        getFirstMethod = null;
        mouseEventStack = new Stack();
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            conditionalClass = classLoader.loadClass(AWT_CONDITIONAL_CLASS);
            Class<?> clazz = classLoader.loadClass(AWT_EDT_CLASS);
            pumpEventsMethod = clazz.getDeclaredMethod(PUMP_EVENTS_METHOD, conditionalClass);
            pumpEventsMethod.setAccessible(true);
            sunToolkitClass = classLoader.loadClass(SUN_TOOLKIT_CLASS);
            flushEventMethod = sunToolkitClass.getMethod(FLUSH_EVENT_METHOD, new Class[0]);
            sequencedEventClass = classLoader.loadClass("java.awt.SequencedEvent");
            getFirstMethod = sequencedEventClass.getDeclaredMethod("getFirst", new Class[0]);
            getFirstMethod.setAccessible(true);
        }
        catch (Exception exception) {
            logger.error("Exception ", exception);
            Main.instance().exit();
        }
    }
}

