/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;

public class TextAreaCellRenderer
extends JTextArea
implements TableCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private boolean bSameRowHeight = false;
    private static final String PROP_TABLE_ROW_HEIGHT = "_table_row_height_";
    private static final int DEFAULT_HEIGHT = 22;
    private static final String MAX_WIDTH_STRING = "\u2014";
    private FontMetrics fontMetrics = null;
    private int rowHeight = 0;
    private boolean showToolTip = false;
    private Color unselectedForeground = null;
    private Color unselectedBackground = null;

    public TextAreaCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        String string = System.getProperty("java.version");
        if (string.indexOf("1.5") != -1 || string.indexOf("1.4") != -1) {
            this.getDocument().putProperty("i18n", Boolean.TRUE);
        }
    }

    public void setShowToolTip(boolean bl) {
        this.showToolTip = bl;
    }

    public void setSameRowHeight(boolean bl) {
        this.bSameRowHeight = bl;
    }

    public boolean isSameRowHeight() {
        return this.bSameRowHeight;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.invalidate();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color;
        Insets insets;
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            super.setBackground(jTable.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
        }
        this.setFont(jTable.getFont());
        if (bl2) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        if (this.showToolTip) {
            if (object == null || object.toString().length() == 0) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(object.toString());
            }
        }
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        if (null == object) {
            object = "";
        }
        String string = object.toString();
        string = string.replaceAll("\r", "");
        this.setValue(string);
        if (this.fontMetrics == null) {
            this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(jTable.getFont());
            this.rowHeight = this.fontMetrics.getHeight();
        }
        int n3 = jTable.getColumnModel().getColumn(n2).getWidth() - 3;
        Insets insets2 = insets = this.getBorder() != null ? this.getBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
        if (n3 > 0) {
            n3 = n3 - insets.left - insets.right - 1;
        }
        int n4 = this.getPreferredHeight(object == null ? "" : object.toString(), n3) + insets.top + insets.bottom + 1;
        HashMap<RowColumn, Integer> hashMap = (HashMap<RowColumn, Integer>)jTable.getClientProperty(PROP_TABLE_ROW_HEIGHT);
        if (hashMap == null) {
            hashMap = new HashMap<RowColumn, Integer>(10);
            jTable.putClientProperty(PROP_TABLE_ROW_HEIGHT, hashMap);
        }
        hashMap.put(new RowColumn(n, n2), n4);
        int n5 = jTable.getRowHeight(n);
        int n6 = 22;
        for (int i = jTable.getColumnCount() - 1; i >= 0; --i) {
            Object v = hashMap.get(new RowColumn(n, i));
            if (v == null) continue;
            n6 = Math.max(n6, (Integer)v);
        }
        if (n6 != n5) {
            if (this.bSameRowHeight) {
                jTable.setRowHeight(n6);
            } else {
                jTable.setRowHeight(n, n6);
            }
        }
        boolean bl3 = (color = this.getBackground()) != null && color.equals(jTable.getBackground()) && jTable.isOpaque();
        this.setOpaque(!bl3);
        return this;
    }

    private int getPreferredHeight(String string, int n) {
        int n2 = 0;
        String string2 = null;
        double d = 0.0;
        string = string.replaceAll("\r", "");
        int n3 = 0;
        while (string.indexOf("\n\n") != -1) {
            string = string.replaceFirst("\n\n", "\n");
            ++n3;
        }
        if (string.startsWith("\n")) {
            ++n3;
        }
        if (string.endsWith("\n")) {
            ++n3;
        }
        int n4 = this.fontMetrics.stringWidth(MAX_WIDTH_STRING);
        boolean bl = false;
        int n5 = 0;
        if (n < n4) {
            n = n4;
            bl = true;
        }
        n5 = n4 <= 0 ? 1 : n / n4;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (stringTokenizer.countTokens() > 1) {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                n2 = this.fontMetrics.stringWidth(string2);
                while (n2 > n && string2.length() > 1) {
                    int n6;
                    int n7;
                    int n8 = string2.length() > n5 ? n5 : 0;
                    int n9 = 0;
                    boolean bl2 = false;
                    for (n7 = this.fontMetrics.stringWidth(string2.substring(0, n8 + n9)); n7 > n && n8 + n9 > 1; n7 -= this.fontMetrics.charWidth(string2.charAt(n8 + --n9))) {
                        bl2 = true;
                    }
                    if (!bl2) {
                        n9 = 0;
                        while (n7 < n) {
                            n7 += this.fontMetrics.charWidth(string2.charAt(n8 + n9));
                            ++n9;
                        }
                    }
                    if (n7 > n && n8 + n9 > 1) {
                        n7 -= this.fontMetrics.charWidth(string2.charAt(n8 + --n9));
                    }
                    ++n3;
                    if (string2.charAt(n8 + n9) != ' ' && (n6 = string2.substring(0, n8 + n9).lastIndexOf(" ")) != -1) {
                        n2 -= this.fontMetrics.stringWidth(string2.substring(0, n6 + 1));
                        string2 = string2.substring(n6 + 1);
                        continue;
                    }
                    string2 = string2.substring(n8 + n9);
                    n2 -= n7;
                }
                if (string2.length() <= 0) continue;
                ++n3;
            }
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!bl) {
                    n2 = this.fontMetrics.stringWidth(string2);
                    String[] stringArray = string2.split(" ");
                    int n10 = 0;
                    if (n2 - 3 > n) {
                        int n11;
                        if (stringArray.length > 1) {
                            if (n % n4 != 0) {
                                n11 = n / n4;
                                n = n11 * n4;
                            }
                            while (n10 < stringArray.length) {
                                n11 = this.fontMetrics.stringWidth(stringArray[n10]);
                                double d2 = (double)n11 / (double)n;
                                d += d2;
                                ++n10;
                            }
                            d += (double)(--n10 * n4 / n);
                            n3 += (int)Math.ceil(d += 1.0);
                            continue;
                        }
                        d = (double)n2 / (double)n;
                        n3 += (int)Math.ceil(d);
                        n11 = string2.matches("^[\u0000-\u0080]+$") ? 1 : 0;
                        if (0 != n11) continue;
                        ++n3;
                        continue;
                    }
                    d = (double)n2 / (double)n;
                    n3 += (int)Math.round(d);
                    continue;
                }
                n3 += string2.length();
            }
        }
        return (n3 > 0 ? n3 : 1) * this.rowHeight;
    }

    protected void setValue(Object object) {
        Document document = this.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).putProperty("i18n", Boolean.TRUE);
        }
        this.setText(object == null ? "" : object.toString());
    }

    private class RowColumn {
        private int row = -1;
        private int column = -1;

        public RowColumn(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        public int hashCode() {
            return this.row * this.column;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RowColumn)) {
                return false;
            }
            RowColumn rowColumn = (RowColumn)object;
            return this.row == rowColumn.row && this.column == rowColumn.column;
        }
    }
}

