/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils;

import com.swimap.iview.util.log.IviewLogger;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;

public abstract class SwingWorker<T, V>
implements Runnable {
    private static IviewLogger logger = IviewLogger.getLogger(SwingWorker.class, "IVIEW");
    private volatile StateValue stateValue;
    private final FutureTask<T> futureTask;

    public SwingWorker() {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                SwingWorker.this.setState(StateValue.STARTED);
                return SwingWorker.this.doInBackground();
            }
        };
        this.futureTask = new FutureTask<T>(callable){

            @Override
            protected void done() {
                SwingWorker.this.doneEDT();
            }
        };
        this.stateValue = StateValue.PENDING;
    }

    protected abstract T doInBackground() throws Exception;

    @Override
    public final void run() {
        this.futureTask.run();
    }

    protected void process(List<V> list) {
    }

    protected void done() {
    }

    public final void execute() {
        SwingWorker.getWorkersExecutorService().execute(this);
    }

    public final boolean cancel(boolean bl) {
        return this.futureTask.cancel(bl);
    }

    public final boolean isCancelled() {
        return this.futureTask.isCancelled();
    }

    public final boolean isDone() {
        if (this.futureTask.isDone()) {
            return true;
        }
        return this.stateValue.equals((Object)StateValue.DONE);
    }

    public final T get() throws InterruptedException, ExecutionException {
        return this.futureTask.get();
    }

    public final T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.futureTask.get(l, timeUnit);
    }

    public final StateValue getState() {
        return this.isDone() ? StateValue.DONE : this.stateValue;
    }

    private void setState(StateValue stateValue) {
        this.stateValue = stateValue;
    }

    private void doneEDT() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingWorker.this.setState(StateValue.DONE);
                SwingWorker.this.done();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static synchronized ExecutorService getWorkersExecutorService() {
        AppContext appContext = AppContext.getAppContext();
        Object object = appContext.get(SwingWorker.class);
        if (null == object) {
            ThreadFactory threadFactory = new ThreadFactory(){
                final ThreadFactory defFactory = Executors.defaultThreadFactory();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = this.defFactory.newThread(runnable);
                    thread.setName("IView SwingWorker-" + thread.getName());
                    return thread;
                }
            };
            object = new ThreadPoolExecutor(0, 10, 1L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory){
                private final ReentrantLock PAUSE_LOCK = new ReentrantLock();
                private final Condition unpaused = this.PAUSE_LOCK.newCondition();
                private boolean isPaused = false;
                private final ReentrantLock EXECUTE_LOCK = new ReentrantLock();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(Runnable runnable) {
                    this.EXECUTE_LOCK.lock();
                    try {
                        this.PAUSE_LOCK.lock();
                        try {
                            this.isPaused = true;
                        }
                        finally {
                            this.PAUSE_LOCK.unlock();
                        }
                        this.setCorePoolSize(10);
                        super.execute(runnable);
                        this.setCorePoolSize(0);
                        this.PAUSE_LOCK.lock();
                        try {
                            this.isPaused = false;
                            this.unpaused.signalAll();
                        }
                        finally {
                            this.PAUSE_LOCK.unlock();
                        }
                    }
                    finally {
                        this.EXECUTE_LOCK.unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void afterExecute(Runnable runnable, Throwable throwable) {
                    super.afterExecute(runnable, throwable);
                    this.PAUSE_LOCK.lock();
                    try {
                        while (this.isPaused) {
                            this.unpaused.await();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        logger.trace(interruptedException.getMessage(), interruptedException);
                    }
                    finally {
                        this.PAUSE_LOCK.unlock();
                    }
                }
            };
            appContext.put(SwingWorker.class, object);
        }
        return (ExecutorService)object;
    }

    public static enum StateValue {
        PENDING,
        STARTED,
        DONE;

    }
}

