/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

public class SingleColorFilter
extends RGBImageFilter {
    private Color oldColor = null;
    private Color renderColor = null;
    private int colorOffset = 10;
    private float lightOffset = 0.6f;

    public SingleColorFilter(Color color, Color color2) {
        this.oldColor = color;
        this.renderColor = color2;
    }

    public SingleColorFilter(Color color, Color color2, int n, float f) {
        this.oldColor = color;
        this.renderColor = color2;
        this.colorOffset = n;
        this.lightOffset = f;
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        Color color = new Color(n3);
        if (this.oldColor != null && this.renderColor != null) {
            if (this.match(this.oldColor, color)) {
                return this.renderColor.getRGB();
            }
            if (!this.match(color, Color.WHITE) && !this.match(color, Color.BLACK)) {
                float[] fArray = Color.RGBtoHSB(this.renderColor.getRed(), this.renderColor.getGreen(), this.renderColor.getBlue(), null);
                fArray[2] = fArray[2] * this.lightOffset;
                if ((double)fArray[2] < 0.0) {
                    fArray[2] = 0.0f;
                }
                int n4 = Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]);
                return n4;
            }
        }
        return n3;
    }

    private boolean match(Color color, Color color2) {
        return Math.abs(color.getRed() - color2.getRed()) <= this.colorOffset && Math.abs(color.getGreen() - color2.getGreen()) <= this.colorOffset && Math.abs(color.getBlue() - color2.getBlue()) <= this.colorOffset;
    }
}

