/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class ScrollPopupMenu
extends JPopupMenu {
    private Rectangle screenBounds = null;
    private Insets screenInsets = null;
    private JPopupMenu mainPopup = null;
    private boolean isLongPopupMenu = false;
    private LinkedList topList = new LinkedList();
    private LinkedList downList = new LinkedList();
    private int x = 0;
    private int y = 0;
    private int preferredWidth = 0;

    public ScrollPopupMenu() {
    }

    public ScrollPopupMenu(String string) {
        super(string);
        super.setName("ScrollPopupMenu");
    }

    @Override
    public void show(Component component, int n, int n2) {
        this.show(component, n, n2, null);
    }

    public void show(Component component, int n, int n2, Component component2) {
        this.x = n;
        this.y = n2;
        this.preferredWidth = this.getPreferredSize().width;
        if (!this.isLongPopupMenu(this, new Point(n, n2))) {
            super.show(component, n, n2);
        } else {
            this.showLongPopupMenu(component, n, n2);
        }
    }

    protected void showLongPopupMenu(Component component, int n, int n2) {
        if (this.mainPopup == null) {
            this.mainPopup = new JPopupMenu();
            PopupMenuListener[] popupMenuListenerArray = this.getPopupMenuListeners();
            for (int i = 0; i < popupMenuListenerArray.length; ++i) {
                this.mainPopup.addPopupMenuListener(popupMenuListenerArray[i]);
            }
            this.mainPopup.setName("ScrollPopupMenu_mainPopup");
            Component[] componentArray = this.getComponents();
            int n3 = 0;
            Dimension dimension = null;
            for (int i = 0; i < componentArray.length; ++i) {
                dimension = componentArray[i].getPreferredSize();
                if (this.screenBounds.y + this.screenBounds.height - this.screenInsets.bottom - this.screenInsets.top > (n3 += dimension.height)) {
                    this.mainPopup.add(componentArray[i]);
                    continue;
                }
                this.downList.addLast(componentArray[i]);
            }
            Component component2 = this.mainPopup.getComponent(this.mainPopup.getComponentCount() - 1);
            this.mainPopup.remove(component2);
            this.downList.addFirst(component2);
            Component component3 = this.mainPopup.getComponent(this.mainPopup.getComponentCount() - 1);
            this.mainPopup.remove(component3);
            this.downList.addFirst(component3);
            ScrollMenuItem scrollMenuItem = new ScrollMenuItem(0);
            scrollMenuItem.setEnabled(false);
            ScrollMenuItem scrollMenuItem2 = new ScrollMenuItem(1);
            this.mainPopup.insert(scrollMenuItem, 0);
            this.mainPopup.add(scrollMenuItem2);
        } else if (this.mainPopup != null && !this.topList.isEmpty()) {
            while (!this.topList.isEmpty()) {
                this.mainPopup.insert((Component)this.topList.getLast(), 1);
                this.topList.removeLast();
                Component component4 = this.mainPopup.getComponent(this.mainPopup.getComponentCount() - 2);
                while (component4 instanceof JSeparator) {
                    this.mainPopup.remove(component4);
                    this.downList.addFirst(component4);
                    component4 = this.mainPopup.getComponent(this.mainPopup.getComponentCount() - 2);
                }
                this.mainPopup.remove(component4);
                this.downList.addFirst(component4);
            }
            this.mainPopup.getComponent(0).setEnabled(false);
            this.mainPopup.getComponent(this.mainPopup.getComponentCount() - 1).setEnabled(true);
        }
        this.mainPopup.show(component, n, n2);
    }

    private boolean isLongPopupMenu(Component component, Point point) {
        SwingUtilities.convertPointToScreen(point, component);
        int n = point.x;
        int n2 = point.y;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration2;
            if (graphicsDeviceArray[i].getType() != 0 || !(graphicsConfiguration2 = graphicsDeviceArray[i].getDefaultConfiguration()).getBounds().contains(n, n2)) continue;
            graphicsConfiguration = graphicsConfiguration2;
            break;
        }
        if (graphicsConfiguration == null && this.getInvoker() != null) {
            graphicsConfiguration = this.getInvoker().getGraphicsConfiguration();
        }
        if (graphicsConfiguration != null) {
            this.screenInsets = toolkit.getScreenInsets(graphicsConfiguration);
            this.screenBounds = graphicsConfiguration.getBounds();
        } else {
            this.screenInsets = new Insets(0, 0, 0, 0);
            this.screenBounds = new Rectangle(toolkit.getScreenSize());
        }
        this.screenInsets = new Insets(this.screenInsets.top + 5, this.screenInsets.left, this.screenInsets.bottom + 5, this.screenInsets.right);
        this.isLongPopupMenu = this.screenBounds.y + this.screenBounds.height - this.screenInsets.bottom - this.screenInsets.top <= this.getPreferredSize().height;
        return this.isLongPopupMenu;
    }

    protected void upScrollMenu() {
        if (this.topList.isEmpty()) {
            this.mainPopup.getComponent(0).setEnabled(false);
        } else {
            this.mainPopup.getComponent(this.mainPopup.getComponentCount() - 1).setEnabled(true);
            Component component = this.mainPopup.getComponent(this.mainPopup.getComponentCount() - 2);
            if (component instanceof JSeparator) {
                this.mainPopup.remove(component);
                this.downList.addFirst(component);
            } else {
                this.mainPopup.remove(component);
                this.downList.addFirst(component);
                Component component2 = (Component)this.topList.getLast();
                if (component2 instanceof JSeparator) {
                    this.mainPopup.insert(component2, 1);
                    this.topList.removeLast();
                    this.mainPopup.insert(component, this.mainPopup.getComponentCount() - 1);
                    this.downList.remove(component);
                } else {
                    this.mainPopup.insert(component2, 1);
                    this.topList.removeLast();
                }
            }
            if (this.topList.isEmpty()) {
                this.mainPopup.getComponent(0).setEnabled(false);
            }
        }
        if (!((ScrollMenuItem)this.mainPopup.getComponent((int)0)).enabled) {
            // empty if block
        }
    }

    protected void downScrollMenu() {
        if (!this.downList.isEmpty()) {
            this.mainPopup.getComponent(0).setEnabled(true);
            Component component = this.mainPopup.getComponent(1);
            if (component instanceof JSeparator) {
                this.mainPopup.remove(component);
                this.topList.addLast(component);
            } else {
                this.mainPopup.remove(component);
                this.topList.addLast(component);
                Component component2 = (Component)this.downList.getFirst();
                if (component2 instanceof JSeparator) {
                    this.mainPopup.insert(component2, this.mainPopup.getComponentCount() - 1);
                    this.downList.removeFirst();
                    this.mainPopup.insert(component, 1);
                    this.topList.remove(component);
                } else {
                    this.mainPopup.insert(component2, this.mainPopup.getComponentCount() - 1);
                    this.downList.removeFirst();
                }
            }
            if (this.downList.isEmpty()) {
                this.mainPopup.getComponent(this.mainPopup.getComponentCount() - 1).setEnabled(false);
            }
        }
        if (!((ScrollMenuItem)this.mainPopup.getComponent((int)(this.mainPopup.getComponentCount() - 1))).enabled) {
            // empty if block
        }
    }

    private class DownScrollMenuAction
    extends AbstractAction {
        private DownScrollMenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScrollPopupMenu.this.downScrollMenu();
            ScrollPopupMenu.this.mainPopup.updateUI();
        }
    }

    private class UpScrollMenuAction
    extends AbstractAction {
        private UpScrollMenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScrollPopupMenu.this.upScrollMenu();
            ScrollPopupMenu.this.mainPopup.updateUI();
        }
    }

    private class ScrollMenuItem
    extends JMenuItem {
        static final int UP_SCROLL = 0;
        static final int DOWN_SCROLL = 1;
        private BufferedImage drawingImage = null;
        private Color stateColor = Color.black;
        private int direction = 0;
        boolean enabled = true;
        private Dimension size = null;

        ScrollMenuItem(int n) {
            this.direction = n;
            this.setUI(new BasicMenuItemUI(){

                @Override
                protected void doClick(MenuSelectionManager menuSelectionManager) {
                    ScrollMenuItem.this.doClick(0);
                    ScrollMenuItem.this.setArmed(true);
                }
            });
            this.init();
        }

        @Override
        public void setEnabled(boolean bl) {
            this.enabled = bl;
            this.stateColor = !bl ? Color.gray : Color.black;
            this.draw();
            this.repaint();
        }

        private void init() {
            int n = ScrollPopupMenu.this.mainPopup.getComponentCount();
            Dimension dimension = null;
            for (int i = 0; i < n; ++i) {
                if (!(ScrollPopupMenu.this.mainPopup.getComponent(i) instanceof JMenuItem)) continue;
                this.size = ScrollPopupMenu.this.mainPopup.getComponent(i).getPreferredSize();
                dimension = new Dimension(this.size.width, this.size.height - 7);
                this.setPreferredSize(dimension);
            }
            if (this.direction == 0) {
                this.setAction(new UpScrollMenuAction());
            } else {
                this.setAction(new DownScrollMenuAction());
            }
            this.setPreferredSize(new Dimension(ScrollPopupMenu.this.preferredWidth, this.getPreferredSize().height));
            this.draw();
        }

        private void draw() {
            int n = ScrollPopupMenu.this.preferredWidth / 2 - 3;
            int n2 = 3;
            this.drawingImage = new BufferedImage(ScrollPopupMenu.this.preferredWidth, this.getPreferredSize().height, 2);
            Graphics2D graphics2D = this.drawingImage.createGraphics();
            graphics2D.setPaint(this.stateColor);
            int[] nArray = null;
            int[] nArray2 = null;
            if (this.direction == 1) {
                nArray = new int[]{n, n + 10, n + 5};
                nArray2 = new int[]{n2, n2, n2 + 5};
            } else {
                nArray = new int[]{n + 5, n, n + 10};
                nArray2 = new int[]{n2, n2 + 5, n2 + 5};
            }
            graphics2D.fillPolygon(nArray, nArray2, 3);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.drawImage(this.drawingImage, 0, 0, null);
        }
    }
}

