/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils;

import com.swimap.iview.util.adapter.LineWrapper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JToolTip;
import javax.swing.UIManager;

public class MultiRowToolTip
extends JToolTip {
    private static final int WIDTH_DELTA = 6;
    private static final int HEIGHT_DELTA = 4;
    private static final int HEAD_DELTA = 15;
    private int maxWidth;
    private FontMetrics stringMeasure;
    private Vector tokens;
    private int maxLine;

    public MultiRowToolTip() {
        this.maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
        this.stringMeasure = null;
        this.tokens = new Vector(10);
        this.maxLine = Integer.MAX_VALUE;
        Font font = (Font)UIManager.get("ToolTip.font");
        this.setFont(font);
    }

    @Override
    public void setTipText(String string) {
        int n;
        super.setTipText(string);
        if (string == null || string.length() == 0) {
            return;
        }
        this.tokens.clear();
        string = LineWrapper.getLineWrapString(string, this.maxWidth, this.getFont(), true);
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator"));
        int n2 = stringTokenizer.countTokens();
        for (n = 0; n < n2; ++n) {
            if (this.tokens.size() >= this.maxLine) {
                String string2 = (String)this.tokens.lastElement() + stringTokenizer.nextToken();
                string2 = LineWrapper.getAbbreviatoryString(string2, this.maxWidth, this.getFont());
                this.tokens.removeElementAt(this.maxLine - 1);
                this.tokens.add(string2);
                break;
            }
            this.tokens.add(stringTokenizer.nextToken());
        }
        n = this.stringMeasure.getHeight() * this.tokens.size();
        int n3 = 0;
        int n4 = this.tokens.size();
        for (int i = 0; i < n4; ++i) {
            if (n3 >= this.stringMeasure.stringWidth((String)this.tokens.get(i))) continue;
            n3 = this.stringMeasure.stringWidth((String)this.tokens.get(i));
        }
        Dimension dimension = new Dimension(n3 + 6, n + 4);
        this.setPreferredSize(dimension);
    }

    public Vector separateString(String string) {
        Vector<String> vector = new Vector<String>(10);
        int n = this.stringMeasure.stringWidth(string);
        if (n <= this.maxWidth) {
            vector.add(string);
        } else {
            char[] cArray = string.toCharArray();
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n2 + ++n3 > cArray.length) {
                    vector.add(new String(cArray, n2, n3 - 1));
                    break;
                }
                if (this.stringMeasure.charsWidth(cArray, n2, n3) <= this.maxWidth) continue;
                String string2 = new String(cArray, n2, n3 - 1);
                vector.add(string2);
                n2 = n2 + n3 - 1;
                n3 = 0;
            }
        }
        return vector;
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            super.setFont(font);
            BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
            Graphics graphics = ((Image)bufferedImage).getGraphics();
            this.stringMeasure = graphics.getFontMetrics(font);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.tokens.size() == 0) {
            return;
        }
        Color color = this.getBackground();
        graphics.setColor(color);
        graphics.fill3DRect(0, 0, this.getWidth(), this.getHeight(), true);
        Color color2 = this.getForeground();
        graphics.setColor(color2);
        int n = this.getHeight() / this.tokens.size();
        int n2 = this.tokens.size();
        for (int i = 0; i < n2; ++i) {
            graphics.setColor(this.getTextColor(i + 1, (String)this.tokens.get(i)));
            graphics.drawString((String)this.tokens.get(i), 3, i * n + 15);
        }
    }

    protected Color getTextColor(int n, String string) {
        return this.getForeground();
    }

    public void setMaxLineNumber(int n) {
        if (n > 0) {
            this.maxLine = n;
        }
    }

    public int getMaxLineNumber() {
        return this.maxLine;
    }
}

