/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class MouseClickActions
implements MouseListener {
    private static IviewLogger logger = IviewLogger.getLogger(MouseClickActions.class, "IVIEW");
    Component sourceTemplate = null;
    Object singleClickObject = null;
    Object doubleClickObject = null;
    Object rightClickObject = null;
    String singleClickAction = null;
    String doubleClickAction = null;
    String rightClickAction = null;

    public void setSource(Component component) {
        this.sourceTemplate = component;
    }

    public Component getSource() {
        return this.sourceTemplate;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = null;
        String string = null;
        if ((mouseEvent.getModifiers() & 4) != 0) {
            object = this.rightClickObject;
            string = this.rightClickAction;
        } else if (mouseEvent.getClickCount() > 1) {
            object = this.doubleClickObject;
            string = this.doubleClickAction;
        } else {
            object = this.singleClickObject;
            string = this.singleClickAction;
        }
        if (object != null && string != null && !"".equals(string.trim())) {
            Object[] objectArray = new Object[]{mouseEvent, this.sourceTemplate};
            try {
                ReflectionUtilities.callTheMethod(object, string, objectArray);
            }
            catch (Exception exception) {
                logger.warn(exception.getMessage());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public MouseClickActions() {
        this(null, null, null);
    }

    public MouseClickActions(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.handleSingleClickAction(stringArray);
        this.handleDoubleClickAction(stringArray, stringArray2);
        this.handleRightClickAction(stringArray, stringArray2, stringArray3);
    }

    private void handleSingleClickAction(String[] stringArray) {
        if (null == stringArray || stringArray.length < 2) {
            return;
        }
        try {
            if (!"".equals(stringArray[0]) && !"".equals(stringArray[1])) {
                this.singleClickObject = ReflectionUtilities.instantiateTheClass(stringArray[0]);
            }
        }
        catch (Exception exception) {
            this.singleClickObject = null;
            logger.warn("Exception while instantiating the singleClickObject. Please check the class name. The class name should be be given with the complete path (eg. java.util.Vector)\nThe Exception message received is:\n" + exception.getMessage());
        }
        this.singleClickAction = stringArray[1];
    }

    private void handleDoubleClickAction(String[] stringArray, String[] stringArray2) {
        if (null == stringArray2 || stringArray2.length < 2) {
            return;
        }
        try {
            if (!"".equals(stringArray2[0]) && !"".equals(stringArray2[1])) {
                this.doubleClickObject = this.singleClickObject != null && ResourceUtil.areEquals(stringArray[0], stringArray2[0]) ? this.singleClickObject : ReflectionUtilities.instantiateTheClass(stringArray2[0]);
            }
        }
        catch (Exception exception) {
            this.doubleClickObject = null;
            logger.warn("Exception while instantiating the doubleClickObject. Please check the class name. The class name should be be given with the complete path (eg. java.util.Vector)\nThe Exception message received is:\n" + exception.getMessage());
        }
        this.doubleClickAction = stringArray2[1];
    }

    private void handleRightClickAction(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        if (null == stringArray3 || stringArray3.length < 2) {
            return;
        }
        try {
            if (!"".equals(stringArray3[0]) && !"".equals(stringArray3[1])) {
                this.rightClickObject = this.singleClickObject != null && ResourceUtil.areEquals(stringArray[0], stringArray3[0]) ? this.singleClickObject : (this.doubleClickObject != null && ResourceUtil.areEquals(stringArray2[0], stringArray3[0]) ? this.doubleClickObject : ReflectionUtilities.instantiateTheClass(stringArray3[0]));
            }
        }
        catch (Exception exception) {
            this.rightClickObject = null;
            logger.warn("Exception while instantiating the rightClickObject. Please check the class name. The class name should be be given with the complete path (eg. java.util.Vector)\nThe Exception message received is:\n" + exception.getMessage());
        }
        this.rightClickAction = stringArray3[1];
    }
}

