/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboPopup;

public class JTooltipComboBox
extends JComboBox {
    private JList comboList = null;

    public JTooltipComboBox() {
        this.initTooltip();
    }

    public JTooltipComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.initTooltip();
    }

    public JTooltipComboBox(Object[] objectArray) {
        super(objectArray);
        this.initTooltip();
    }

    public JTooltipComboBox(Vector vector) {
        super(vector);
        this.initTooltip();
    }

    private void initTooltip() {
        Accessible accessible = this.getUI().getAccessibleChild(this, 0);
        if (accessible instanceof BasicComboPopup) {
            BasicComboPopup basicComboPopup = (BasicComboPopup)accessible;
            this.comboList = basicComboPopup.getList();
            ToolTipManager.sharedInstance().registerComponent(this.comboList);
            this.comboList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    JList jList = (JList)listSelectionEvent.getSource();
                    Object e = jList.getSelectedValue();
                    if (null != e) {
                        jList.setToolTipText(e.toString());
                    }
                }
            });
            basicComboPopup = null;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                JTooltipComboBox.this.this_mouseEntered(mouseEvent);
            }
        });
        this.setName("JTooltipComboBox");
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        if (this.comboList != null) {
            this.comboList.setName(string + "combolist");
        }
    }

    void this_mouseEntered(MouseEvent mouseEvent) {
        this.setToolTipText((String)this.getItemAt(this.getSelectedIndex()));
    }
}

