/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;

public final class FileUtil {
    private static IviewLogger logger = IviewLogger.getLogger(FileUtil.class, "IVIEW");
    private static final int FILE_NOT_FOUND = 0;
    private static final int FILE_BEING_USED = 1;
    private static final int FILE_RIGHT = 2;
    private static final int DIR_NOT_FOUND = 3;
    public static final String lineSeparator = System.getProperty("line.separator");

    public static void openFiles(String[] stringArray, boolean bl, Window window) {
        String string = null;
        string = bl ? "cmd /c " : "/bin/bash ";
        File[] fileArray = FileUtil.writeToTemp(stringArray, bl, window, false);
        FileUtil.startProcess(stringArray, bl, string, fileArray, window);
    }

    public static void openFolder(String string, boolean bl, Window window) {
        File[] fileArray;
        String[] stringArray = new String[]{string};
        String string2 = null;
        string2 = bl ? "cmd /c " : "/bin/bash ";
        if (bl && !(fileArray = new File(string)).exists()) {
            FileUtil.showOpenError(new File[]{fileArray}, 1, window, 3);
            return;
        }
        fileArray = FileUtil.writeToTemp(stringArray, bl, window, true);
        FileUtil.startProcess(stringArray, bl, string2, fileArray, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startProcess(String[] stringArray, boolean bl, String string, File[] fileArray, Window window) {
        Process process = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        for (int i = fileArray.length - 1; i >= 0; --i) {
            if (null == fileArray[i]) continue;
            try {
                Runtime runtime = Runtime.getRuntime();
                String string2 = fileArray[i].getCanonicalPath();
                if (bl) {
                    Object object;
                    fileInputStream = new FileInputStream(fileArray[i]);
                    inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                    bufferedReader = new BufferedReader(inputStreamReader);
                    String string3 = bufferedReader.readLine();
                    String string4 = null;
                    while (null != (string4 = bufferedReader.readLine())) {
                        string3 = string3 + string4;
                    }
                    String[] stringArray2 = new String[]{string3};
                    HashMap<Object, String> hashMap = new HashMap<Object, String>(1);
                    hashMap.putAll(System.getenv());
                    String[] stringArray3 = new String[stringArray2.length + 2];
                    stringArray3[0] = "cmd";
                    stringArray3[1] = "/C";
                    for (int j = 0; j < stringArray2.length; ++j) {
                        object = "JENV_" + j;
                        stringArray3[j + 2] = "%" + (String)object + "%";
                        hashMap.put(object, stringArray2[j]);
                    }
                    stringArray2 = stringArray3;
                    ProcessBuilder processBuilder = new ProcessBuilder(stringArray2);
                    object = processBuilder.environment();
                    object.putAll(hashMap);
                    process = processBuilder.start();
                } else {
                    process = runtime.exec(string + string2);
                }
            }
            catch (IOException iOException) {
                logger.trace("Failed to execute the temp file :" + bl + iOException);
                FileUtil.showOpenError(fileArray, stringArray.length, window, 2);
                break;
            }
            finally {
                try {
                    if (null != bufferedReader) {
                        bufferedReader.close();
                    }
                    if (null != fileInputStream) {
                        fileInputStream.close();
                    }
                    if (null != inputStreamReader) {
                        inputStreamReader.close();
                    }
                }
                catch (IOException iOException) {
                    logger.trace("Error in closing the stream " + iOException);
                }
            }
            if (FileUtil.readStream(process, fileArray, stringArray[i], window)) {
                process.destroy();
                fileArray[i].delete();
                continue;
            }
            process.destroy();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readStream(Process process, File[] fileArray, String string, Window window) {
        boolean bl = true;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(process.getErrorStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            File file = new File(string);
            int n = 0;
            try {
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                logger.trace(interruptedException);
            }
            if (null != string2) {
                logger.trace("Error stream read : " + string2);
                if (0 != n) {
                    bl = false;
                    if (!file.exists()) {
                        FileUtil.showOpenError(fileArray, 1, window, 0);
                    } else {
                        FileUtil.showOpenError(fileArray, 1, window, 1);
                    }
                }
            }
        }
        catch (IOException iOException) {
            logger.trace("Fail to read the Error stream :" + iOException);
            bl = false;
        }
        finally {
            try {
                if (null != inputStreamReader) {
                    inputStreamReader.close();
                    inputStreamReader = null;
                }
                if (null != bufferedReader) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
            }
            catch (IOException iOException) {
                logger.trace("Exception while closing the stream :" + iOException);
            }
        }
        return bl;
    }

    private static File[] writeToTemp(String[] stringArray, boolean bl, Window window, boolean bl2) {
        if (bl) {
            return FileUtil.windows(stringArray, window, bl2);
        }
        return FileUtil.solaris(stringArray, window, bl2);
    }

    private static void showOpenError(File[] fileArray, int n, Window window, int n2) {
        for (int i = 0; i < fileArray.length; ++i) {
            if (null == fileArray[i] || !fileArray[i].exists()) continue;
            fileArray[i].delete();
        }
        Window window2 = window != null ? window : FrameworkUtilities.getMainFrame();
        String string = PrintSupportor.res.getString("file");
        if (n > 1) {
            string = PrintSupportor.res.getString("files");
        }
        String string2 = "";
        switch (n2) {
            case 0: {
                string2 = PrintSupportor.res.getString("OpenFail") + ' ' + string + PrintSupportor.res.getString("OpenFailReason");
                break;
            }
            case 1: {
                string2 = PrintSupportor.res.getString("OpenFail") + ' ' + string + PrintSupportor.res.getString("Filebeingused");
                break;
            }
            case 2: {
                string2 = PrintSupportor.res.getString("OpenFail") + ' ' + string + PrintSupportor.res.getString("writeFailReason");
                break;
            }
            case 3: {
                string2 = MessageFormat.format(PrintSupportor.res.getString("OpenDirFail"), fileArray[0]);
                break;
            }
            default: {
                logger.trace("fail to open the saved file ");
            }
        }
        OptionPane.showErrorDialog(window2, string2);
    }

    private static File[] windows(String[] stringArray, Window window, boolean bl) {
        int n = stringArray.length;
        File[] fileArray = new File[n];
        long l = System.currentTimeMillis();
        String string = "temp_view" + l + ".bat";
        for (int i = 0; i < n; ++i) {
            if (null == stringArray[i]) continue;
            FileUtil.windowFileWrite(fileArray, i, stringArray, string, window, bl);
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void windowFileWrite(File[] fileArray, int n, String[] stringArray, String string, Window window, boolean bl) {
        Writer writer = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileArray[n] = new File(System.getProperty("java.io.tmpdir") + n + string);
            fileOutputStream = new FileOutputStream(fileArray[n]);
            writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            String string2 = stringArray[n];
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer(string2);
                while (stringBuffer.indexOf("/") != -1) {
                    int n2 = stringBuffer.lastIndexOf("/");
                    stringBuffer = stringBuffer.replace(n2, n2 + 1, "\\");
                }
                string2 = stringBuffer.toString();
            }
            if (string2.indexOf(47) != -1) {
                string2 = string2.replaceAll("/", "\\");
            }
            if (bl) {
                writer.write(lineSeparator + "start \"iview\" " + "explorer  \"" + string2 + "\"");
            } else {
                writer.write(lineSeparator + "start \"iview\" \"" + string2 + "\"");
            }
        }
        catch (IOException iOException) {
            logger.trace("Failed to write to the file :" + iOException);
            fileArray[n] = null;
        }
        finally {
            try {
                if (null != writer) {
                    writer.close();
                    writer = null;
                }
                if (null != fileOutputStream) {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
            }
            catch (IOException iOException) {
                logger.trace("Failed to close the writer :" + iOException);
                fileArray[n] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File[] solaris(String[] stringArray, Window window, boolean bl) {
        int n = 0;
        String string = null;
        String string2 = "";
        String string3 = null;
        BufferedWriter bufferedWriter = null;
        long l = System.currentTimeMillis();
        string = "temp_view" + l + ".sh";
        String string4 = "/usr/dt/bin/dtpad -missingFileWarning ";
        File[] fileArray = new File[]{new File(System.getProperty("java.io.tmpdir") + string)};
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(fileArray[0]));
            int n2 = stringArray.length;
            String string5 = null;
            if (bl) {
                String string6 = "/usr/sfw/bin/mozilla ";
                bufferedWriter.write(lineSeparator + string6 + " " + stringArray[0]);
            } else {
                for (int i = 0; i < n2; ++i) {
                    if (null == stringArray[i]) continue;
                    string5 = stringArray[i];
                    n = string5.lastIndexOf("/");
                    string3 = string5.substring(n + 1);
                    if (i == 0 && n != -1) {
                        String string7 = string5.substring(0, n);
                        if (string7.equals("")) {
                            string7 = "/";
                        }
                        bufferedWriter.write("cd " + string2 + "\"" + string7 + "\"");
                    }
                    bufferedWriter.write(lineSeparator + string4 + "\"" + string3 + "\"");
                }
            }
        }
        catch (IOException iOException) {
            logger.trace("Failed to write to the file :" + iOException.toString());
            fileArray = null;
        }
        finally {
            try {
                bufferedWriter.close();
                bufferedWriter = null;
            }
            catch (IOException iOException) {
                logger.trace("Failed to close the writer :" + iOException.toString());
                fileArray = null;
            }
        }
        return fileArray;
    }
}

