/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DynamicButtonPane
extends JPanel
implements LayoutManager2 {
    private static final int HEIGHT = 21;
    private static final int WIDTH_30 = 30;
    private static final int WIDTH_60 = 60;
    private static final int WIDTH_80 = 80;
    private static final int WIDTH_100 = 100;
    private static final int WIDTH_120 = 120;
    private static final int GAP_SAME = 4;
    private static final int GAP_DIFF = 10;
    private static final int CAPACITY = 5;
    private final List<List<Component>> leftList = new ArrayList<List<Component>>(5);
    private final List<List<Component>> rightList = new ArrayList<List<Component>>(5);
    private boolean horizontal = true;
    private int buttonHeight = 21;

    public DynamicButtonPane() {
        super.setLayout(this);
        this.newLeftGroup();
        this.newRightGroup();
    }

    public void addLeft(Component component) {
        if (null != component && component instanceof JButton) {
            this.addImpl(component, null, -1);
            this.leftList.get(this.leftList.size() - 1).add(component);
        }
    }

    public void newLeftGroup() {
        this.leftList.add(new ArrayList(5));
    }

    public void addRight(Component component) {
        if (null != component && component instanceof JButton) {
            this.addImpl(component, null, -1);
            this.rightList.get(this.rightList.size() - 1).add(component);
        }
    }

    public void newRightGroup() {
        this.rightList.add(new ArrayList(5));
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
    }

    @Override
    public void invalidateLayout(Container container) {
        this.checkContainer(container);
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        return 0.0f;
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.layoutSize(container, 1);
    }

    public Dimension layoutSize(Container container, int n) {
        this.checkContainer(container);
        Dimension dimension = null;
        dimension = this.horizontal ? this.horizontalLayoutSize(n) : this.verticalLayoutSize(n);
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    private Dimension horizontalLayoutSize(int n) {
        Dimension dimension = new Dimension(0, this.buttonHeight);
        List[] listArray = new List[]{this.leftList, this.rightList};
        int n2 = 0;
        for (List list : listArray) {
            for (List list2 : list) {
                for (Component component : list2) {
                    n2 = this.modifiedWidth(component, n);
                    dimension.width += n2 + 4;
                }
                if (!list2.isEmpty()) {
                    dimension.width -= 4;
                }
                dimension.width += 10;
            }
        }
        return dimension;
    }

    private Dimension verticalLayoutSize(int n) {
        Dimension dimension = new Dimension(0, 0);
        List[] listArray = new List[]{this.leftList, this.rightList};
        int n2 = 0;
        for (List list : listArray) {
            for (List list2 : list) {
                for (Component component : list2) {
                    n2 = this.modifiedWidth(component, n);
                    dimension.width = Math.max(n2, dimension.width);
                    dimension.height += this.buttonHeight + 4;
                }
                if (!list2.isEmpty()) {
                    dimension.height -= 4;
                }
                dimension.height += 10;
            }
        }
        return dimension;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void layoutContainer(Container container) {
        this.checkContainer(container);
        if (this.horizontal) {
            this.horizontalLayoutContainer();
        } else {
            this.verticalLayoutContainer();
        }
    }

    private void horizontalLayoutContainer() {
        JButton jButton;
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int[][] nArrayArray = new int[this.leftList.size()][];
        int[][] nArrayArray2 = new int[this.rightList.size()][];
        int n7 = this.leftList.size();
        List<Component> list = null;
        Component component = null;
        int n8 = 0;
        for (n4 = 0; n4 < n7; ++n4) {
            list = this.leftList.get(n4);
            n8 = list.size();
            nArrayArray[n4] = new int[n8];
            for (n3 = 0; n3 < n8; ++n3) {
                component = list.get(n3);
                nArrayArray[n4][n3] = this.modifiedWidth(component, 0);
                n6 += nArrayArray[n4][n3];
                n5 += nArrayArray[n4][n3] + 4;
            }
            if (!list.isEmpty()) {
                n5 -= 4;
            }
            n5 += 10;
        }
        n7 = this.rightList.size();
        for (n4 = 0; n4 < n7; ++n4) {
            list = this.rightList.get(n4);
            n8 = list.size();
            nArrayArray2[n4] = new int[n8];
            for (n3 = 0; n3 < n8; ++n3) {
                component = list.get(n3);
                nArrayArray2[n4][n3] = this.modifiedWidth(component, 0);
                n6 += nArrayArray2[n4][n3];
                n5 += nArrayArray2[n4][n3] + 4;
            }
            if (!list.isEmpty()) {
                n5 -= 4;
            }
            n5 += 10;
        }
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        boolean bl = insets.left + n5 + insets.right > dimension.width;
        int n9 = 0;
        if (bl) {
            n9 = dimension.width - insets.left - insets.right - (n5 - n6);
        }
        int n10 = insets.top;
        int n11 = 0;
        int n12 = this.buttonHeight;
        int n13 = insets.left;
        n7 = this.leftList.size();
        for (n2 = 0; n2 < n7; ++n2) {
            list = this.leftList.get(n2);
            n8 = list.size();
            for (n = 0; n < n8; ++n) {
                component = list.get(n);
                int n14 = n11 = bl ? nArrayArray[n2][n] * n9 / n6 : nArrayArray[n2][n];
                if (component instanceof JButton) {
                    jButton = (JButton)component;
                    jButton.setToolTipText(this.originalWidth(component, 0) > n11 ? jButton.getText() : null);
                }
                component.setBounds(n13, n10, n11, n12);
                n13 += n11;
                n13 += 4;
            }
            if (!list.isEmpty()) {
                n13 -= 4;
            }
            n13 += 10;
        }
        n13 = dimension.width - insets.right;
        for (n2 = this.rightList.size() - 1; n2 >= 0; --n2) {
            list = this.rightList.get(n2);
            for (n = list.size() - 1; n >= 0; --n) {
                component = list.get(n);
                int n15 = n11 = bl ? nArrayArray2[n2][n] * n9 / n6 : nArrayArray2[n2][n];
                if (component instanceof JButton) {
                    jButton = (JButton)component;
                    jButton.setToolTipText(this.originalWidth(component, 0) > n11 ? jButton.getText() : null);
                }
                component.setBounds(n13 -= n11, n10, n11, n12);
                n13 -= 4;
            }
            if (!list.isEmpty()) {
                n13 += 4;
            }
            n13 -= 10;
        }
    }

    private void verticalLayoutContainer() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int[][] nArrayArray = new int[this.leftList.size()][];
        int[][] nArrayArray2 = new int[this.rightList.size()][];
        int n5 = this.leftList.size();
        int n6 = 0;
        List<Component> list = null;
        Component component = null;
        for (n3 = 0; n3 < n5; ++n3) {
            list = this.leftList.get(n3);
            nArrayArray[n3] = new int[list.size()];
            n6 = list.size();
            for (n2 = 0; n2 < n6; ++n2) {
                component = list.get(n2);
                nArrayArray[n3][n2] = this.modifiedWidth(component, 0);
                n4 = Math.max(n4, nArrayArray[n3][n2]);
            }
        }
        n5 = this.rightList.size();
        for (n3 = 0; n3 < n5; ++n3) {
            list = this.rightList.get(n3);
            nArrayArray2[n3] = new int[list.size()];
            n6 = list.size();
            for (n2 = 0; n2 < n6; ++n2) {
                component = list.get(n2);
                nArrayArray2[n3][n2] = this.modifiedWidth(component, 0);
                n4 = Math.max(n4, nArrayArray2[n3][n2]);
            }
        }
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        int n7 = insets.left;
        int n8 = 0;
        int n9 = this.buttonHeight;
        int n10 = insets.top;
        n5 = this.leftList.size();
        for (int i = 0; i < n5; ++i) {
            list = this.leftList.get(i);
            n6 = list.size();
            for (n = 0; n < n6; ++n) {
                component = list.get(n);
                n8 = nArrayArray[i][n];
                if (component instanceof JButton) {
                    JButton jButton = (JButton)component;
                    jButton.setToolTipText(this.originalWidth(component, 0) > n8 ? jButton.getText() : null);
                }
                component.setBounds(n7, n10, n8, n9);
                n10 += n9;
                n10 += 4;
            }
            if (!list.isEmpty()) {
                n10 -= 4;
            }
            n10 += 10;
        }
        n10 = dimension.height - insets.bottom;
        JButton jButton = null;
        for (n = this.rightList.size() - 1; n >= 0; --n) {
            list = this.rightList.get(n);
            for (int i = list.size() - 1; i >= 0; --i) {
                component = list.get(i);
                n8 = nArrayArray2[n][i];
                if (component instanceof JButton) {
                    jButton = (JButton)component;
                    jButton.setToolTipText(this.originalWidth(component, 0) > n8 ? jButton.getText() : null);
                }
                component.setBounds(n7, n10 -= n9, n8, n9);
                n10 -= 4;
            }
            if (!list.isEmpty()) {
                n10 += 4;
            }
            n10 -= 10;
        }
    }

    private int modifiedWidth(Component component, int n) {
        int n2 = 120;
        if (n == 0 && component instanceof JButton) {
            int[] nArray;
            JButton jButton = (JButton)component;
            Dimension dimension = jButton.getPreferredSize();
            for (int n3 : nArray = new int[]{30, 60, 80, 100, 120}) {
                if (dimension.width > n3) continue;
                n2 = n3;
                break;
            }
        } else {
            n2 = this.originalWidth(component, n);
        }
        return n2;
    }

    private int originalWidth(Component component, int n) {
        int n2 = 0;
        n2 = n < 0 ? component.getMinimumSize().width : (n > 0 ? component.getMaximumSize().width : component.getPreferredSize().width);
        return n2;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.layoutSize(container, -1);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.layoutSize(container, 0);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        List[] listArray;
        for (List list : listArray = new List[]{this.leftList, this.rightList}) {
            for (List list2 : list) {
                if (!list2.contains(component)) continue;
                list2.remove(component);
                if (list2.isEmpty()) {
                    list.remove(list2);
                }
                return;
            }
        }
    }

    private void checkContainer(Container container) {
        if (this != container) {
            throw new AWTError("This object can't be shared as a LayoutManager");
        }
    }

    public void setHorizontalLayout(boolean bl) {
        this.horizontal = bl;
    }
}

