/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.utils;

import java.awt.Color;
import java.awt.image.RGBImageFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ColorFilter
extends RGBImageFilter {
    private static final int DEFAULT_PERCENT = 50;
    private static Map rendererMap = Collections.synchronizedMap(new HashMap(4));
    private boolean brighter = true;
    private int percent = 50;
    private double degree = 2.0;
    private Color color = Color.red;
    private Renderer currentRenderer = null;
    private int width = 0;
    private int height = 0;
    private int rendererLength = 0;
    private Color rendedColor = null;
    private int rendedColorOffset = 0;

    public ColorFilter(boolean bl, int n, double d, Color color, int n2, int n3, int n4, int n5) {
        this.brighter = bl;
        this.percent = n;
        this.degree = d;
        this.color = color;
        this.canFilterIndexColorModel = true;
        if (n5 != 0) {
            this.currentRenderer = (Renderer)rendererMap.get(n4);
            this.width = n2;
            this.height = n3;
            this.rendererLength = n5;
        }
    }

    public ColorFilter(boolean bl, int n, double d, Color color, int n2, int n3, int n4, int n5, Color color2, int n6) {
        this(bl, n, d, color, n2, n3, n4, n5);
        this.rendedColor = color2;
        this.rendedColorOffset = n6;
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        if (this.currentRenderer != null) {
            int n4 = this.currentRenderer.getRenderValue(this.width, this.height, this.rendererLength, n, n2);
            if (n4 == 0) {
                return Color.black.getRGB();
            }
            if (n4 == -1) {
                return n3;
            }
        }
        Color color = new Color(n3);
        if (this.rendedColor == null || this.rendedColor != null && Math.abs(this.rendedColor.getRed() - color.getRed()) <= this.rendedColorOffset && Math.abs(this.rendedColor.getGreen() - color.getGreen()) <= this.rendedColorOffset && Math.abs(this.rendedColor.getBlue() - color.getBlue()) <= this.rendedColorOffset) {
            return this.filterPixel(n3);
        }
        return n3;
    }

    public void setrendedColor(Color color) {
        this.rendedColor = color;
    }

    private int filterPixel(int n) {
        int n2 = (int)((0.3 * (double)(n >> 16 & 0xFF) + 0.59 * (double)(n >> 8 & 0xFF) + 0.11 * (double)(n & 0xFF)) / 3.0);
        n2 = this.brighter ? 255 - (255 - n2) * (100 - this.percent) / 100 : n2 * (100 - this.percent) / 100;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        n2 = this.sharpen(n2);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.color.getRGB();
        n3 = (n6 >> 16 & 0xFF) * n2 / 255;
        n4 = (n6 >> 8 & 0xFF) * n2 / 255;
        n5 = (n6 & 0xFF) * n2 / 255;
        return n & 0xFF000000 | n3 << 16 | n4 << 8 | n5 << 0;
    }

    private int sharpen(int n) {
        int n2 = 0;
        double d = 127.5;
        double d2 = (double)n / d;
        double d3 = 0.0;
        if (n < 128) {
            d3 = n == 0 ? 0.0 : Math.pow(d2, this.degree);
            n2 = (int)((d + 0.001) * d3);
        } else {
            d3 = n == 255 ? 2.0 : 2.0 - Math.pow(2.0 - d2, this.degree);
            n2 = (int)((d + 0.001) * d3);
        }
        return n2;
    }

    static {
        rendererMap.put(1, new DownRenderer());
        rendererMap.put(2, new UpRenderer());
        rendererMap.put(3, new RightRenderer());
        rendererMap.put(4, new LeftRenderer());
    }

    private static class LeftRenderer
    extends Renderer {
        private LeftRenderer() {
        }

        @Override
        int getRenderValue(int n, int n2, int n3, int n4, int n5) {
            if (n4 == n3) {
                return 0;
            }
            if (n4 < n3) {
                return 1;
            }
            return -1;
        }
    }

    private static class RightRenderer
    extends Renderer {
        private RightRenderer() {
        }

        @Override
        int getRenderValue(int n, int n2, int n3, int n4, int n5) {
            int n6 = n - n3;
            if (n4 == n6) {
                return 0;
            }
            if (n4 > n6) {
                return 1;
            }
            return -1;
        }
    }

    private static class UpRenderer
    extends Renderer {
        private UpRenderer() {
        }

        @Override
        int getRenderValue(int n, int n2, int n3, int n4, int n5) {
            if (n5 == n3) {
                return 0;
            }
            if (n5 < n3) {
                return 1;
            }
            return -1;
        }
    }

    private static class DownRenderer
    extends Renderer {
        private DownRenderer() {
        }

        @Override
        int getRenderValue(int n, int n2, int n3, int n4, int n5) {
            int n6 = n2 - n3;
            if (n5 == n6) {
                return 0;
            }
            if (n5 > n6) {
                return 1;
            }
            return -1;
        }
    }

    private static abstract class Renderer {
        private Renderer() {
        }

        abstract int getRenderValue(int var1, int var2, int var3, int var4, int var5);
    }
}

