/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.treepropertyform;

import com.swimap.iview.templates.filtertreetable.TreeIconRenderer;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import com.swimap.iview.templates.filtertreetable.TreeTableView;
import com.swimap.iview.templates.treepropertyform.DefaultTreePropertyFormModel;
import com.swimap.iview.templates.treepropertyform.ITreePropertyFormListener;
import com.swimap.iview.templates.treepropertyform.NewTreeColumnRenderer;
import com.swimap.iview.templates.treepropertyform.TreePropertyFormModel;
import com.swimap.iview.util.Parameter;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreePropertyForm
extends TreeTableView {
    private static IviewLogger logger = IviewLogger.getLogger(TreePropertyForm.class, "IVIEW");
    private Hashtable cellEditors = new Hashtable(10);
    private Hashtable cellRenderers = new Hashtable(10);
    private static DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
    private static DefaultCellEditor defaultEditor = new DefaultCellEditor(new JTextField());
    private TreePropertyFormModel treePropertyFormModel = null;
    private boolean isShowToolTip = false;
    private Vector notEditableProperty = new Vector(10);
    private Hashtable necessaryPropertyName = new Hashtable(10);
    private Hashtable listeners = new Hashtable(5);
    private boolean isNewRender = false;
    private NewTreeColumnRenderer treeRenderer = null;
    private DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof TreePath) {
                object = ((TreePath)object).getLastPathComponent();
            }
            if (TreePropertyForm.this.necessaryPropertyName.containsKey(object.toString().trim())) {
                this.setForeground((Color)TreePropertyForm.this.necessaryPropertyName.get(object.toString().trim()));
            } else if (TreePropertyForm.this.notEditableProperty.contains(object.toString().trim()) || !TreePropertyForm.this.isPropertyEnabled(TreePropertyForm.this.getPathForRow(n))) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(TreePropertyForm.this.getForeground());
            }
            if (bl) {
                this.setForeground(TreePropertyForm.this.getForeground());
                this.setBackground(TreePropertyForm.this.getSelectionBackground());
            } else {
                this.setBackground(TreePropertyForm.this.getBackground());
            }
            this.setFont(TreePropertyForm.this.getFont());
            this.setText(object.toString());
            if (TreePropertyForm.this.isShowToolTip) {
                this.setToolTipText(this.getText().trim());
            }
            return this;
        }
    };

    public TreePropertyForm() {
        this(new DefaultTreePropertyFormModel());
    }

    public TreePropertyForm(TreePropertyFormModel treePropertyFormModel) {
        this.setSortable(false);
        this.setTreePropertyFormModel(treePropertyFormModel);
        this.setView(0);
        this.setTreeIconRenderer(new TreeIconRenderer(){

            @Override
            public Icon getNodeIcon(TreeModel treeModel, Object object, Object object2, Class clazz, boolean bl, boolean bl2, Icon icon) {
                return null;
            }
        });
        defaultEditor.setClickCountToStart(1);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.expandRoot();
    }

    public TreePropertyForm(Object[][] objectArray) {
        this(TreePropertyForm.createTreeModel(objectArray));
    }

    public TreePropertyForm(Object[][] objectArray, String[] stringArray) {
        this(TreePropertyForm.createTreeModel(objectArray, stringArray));
    }

    private void expandRoot() {
        TreeModel treeModel = this.getTreeTableModel();
        if (treeModel != null && treeModel.getRoot() != null) {
            this.expandPath(new TreePath(treeModel.getRoot()));
        }
    }

    public TreePropertyFormModel getTreePropertyFormModel() {
        return this.treePropertyFormModel;
    }

    public void setTreePropertyFormModel(TreePropertyFormModel treePropertyFormModel) {
        this.treePropertyFormModel = treePropertyFormModel;
        this.setTreeTableModel(treePropertyFormModel);
    }

    public void enableProperty(Object object, boolean bl) {
        this.treePropertyFormModel.enableProperty(object, bl);
    }

    public Object getValue(Object object) {
        return this.treePropertyFormModel.getValue(object);
    }

    public Object getPropertyAt(int n) {
        TreePath treePath = this.getPathForRow(n);
        return this.treePropertyFormModel.getValueAt(treePath.getLastPathComponent(), 0);
    }

    public void setPropertyAt(Object object, Object object2, int n) {
        TreePath treePath = this.getPathForRow(n);
        this.treePropertyFormModel.setProperty(object, object2, treePath.getLastPathComponent());
    }

    public boolean isPropertyEnabled(Object object) {
        return this.treePropertyFormModel.isPropertyEnabled(object);
    }

    private boolean isPropertyEnabled(TreePath treePath) {
        try {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return this.isPropertyEnabled(((Parameter)defaultMutableTreeNode.getUserObject()).getName());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return true;
        }
    }

    protected static TreePropertyFormModel createTreeModel(Object[][] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return new DefaultTreePropertyFormModel();
        }
        return new DefaultTreePropertyFormModel(objectArray);
    }

    protected static TreePropertyFormModel createTreeModel(Object[][] objectArray, String[] stringArray) {
        if (stringArray == null) {
            return TreePropertyForm.createTreeModel(objectArray);
        }
        if (objectArray == null || objectArray.length == 0) {
            return new DefaultTreePropertyFormModel(stringArray);
        }
        return new DefaultTreePropertyFormModel(objectArray, stringArray);
    }

    public void addProperty(Object object, Object object2) {
        this.treePropertyFormModel.addProperty(object, object2);
        this.validate();
    }

    public boolean addProperty(Object object, Object object2, Object object3) {
        boolean bl = this.treePropertyFormModel.addProperty(object, object2, object3);
        this.validate();
        return bl;
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        if (n2 != 1) {
            return super.getCellEditor();
        }
        TreePath treePath = this.getPathForRow(n);
        Object object = this.treePropertyFormModel.getValueAt(treePath.getLastPathComponent(), 0);
        if (object == null) {
            return defaultEditor;
        }
        TableCellEditor tableCellEditor = (TableCellEditor)this.cellEditors.get(object);
        return tableCellEditor == null ? defaultEditor : tableCellEditor;
    }

    public void setValue(Object object, Object object2) {
        this.treePropertyFormModel.setValue(object, object2);
    }

    public void setCellEditor(Object object, TableCellEditor tableCellEditor) {
        this.cellEditors.put(object, tableCellEditor);
    }

    public void removeCellEditor(Object object) {
        this.cellEditors.remove(object);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TreePath treePath = this.getPathForRow(n);
        Object object = this.treePropertyFormModel.getValueAt(treePath.getLastPathComponent(), 0);
        if (n2 != 1) {
            if (this.isNewRender) {
                JComponent jComponent = null;
                if (this.getView() == 0) {
                    jComponent = this.treeRenderer;
                    return jComponent;
                }
                jComponent = this.tableRenderer;
                return jComponent;
            }
            this.setNewRender(true);
            return this.treeRenderer;
        }
        if (object == null) {
            return defaultRenderer;
        }
        TableCellRenderer tableCellRenderer = (TableCellRenderer)this.cellRenderers.get(object);
        if (tableCellRenderer == null) {
            tableCellRenderer = new DefaultTableCellRenderer();
        }
        if (this.necessaryPropertyName.containsKey(object.toString().trim())) {
            if (tableCellRenderer instanceof JComponent) {
                ((JComponent)((Object)tableCellRenderer)).setForeground((Color)this.necessaryPropertyName.get(object.toString().trim()));
            }
        } else if (this.notEditableProperty.contains(object.toString().trim()) || !this.isPropertyEnabled(this.getPathForRow(n))) {
            if (tableCellRenderer instanceof JComponent) {
                ((JComponent)((Object)tableCellRenderer)).setForeground(Color.GRAY);
            }
        } else if (tableCellRenderer instanceof JComponent) {
            ((JComponent)((Object)tableCellRenderer)).setForeground(this.getForeground());
        }
        return tableCellRenderer;
    }

    public void setShowPropertyToolTip(boolean bl) {
        this.isShowToolTip = bl;
        if (this.treeRenderer != null) {
            this.treeRenderer.setShowToolTip(bl);
        }
    }

    public void setCellRenderer(Object object, TableCellRenderer tableCellRenderer) {
        this.cellRenderers.put(object, tableCellRenderer);
    }

    public void removeCellRenderer(Object object) {
        this.cellRenderers.remove(object);
    }

    public static void setDefaultCellEditor(DefaultCellEditor defaultCellEditor) {
        defaultEditor = defaultCellEditor;
    }

    public void setPropertyStatus(String string, boolean bl) {
        if (bl && this.notEditableProperty.contains(string)) {
            this.notEditableProperty.remove(string);
            if (this.treeRenderer != null) {
                this.treeRenderer.removeNotEditablePropertyName(string);
            }
        }
        if (!bl && !this.notEditableProperty.contains(string)) {
            this.notEditableProperty.addElement(string);
            if (this.treeRenderer != null) {
                this.treeRenderer.addNotEditablePropertyName(string);
            }
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        TreePath treePath = this.getPathForRow(n);
        Object object = this.treePropertyFormModel.getValueAt(treePath.getLastPathComponent(), 0);
        if (treePath.getLastPathComponent() != null && !((TreeNode)treePath.getLastPathComponent()).isLeaf()) {
            return false;
        }
        if (object == null) {
            return false;
        }
        boolean bl = !this.notEditableProperty.contains(object.toString()) && this.isPropertyEnabled(object);
        return bl;
    }

    public void addNecessaryPropertyName(String string, Color color) {
        this.necessaryPropertyName.put(string, color);
        if (this.treeRenderer != null) {
            this.treeRenderer.addNecessaryPropertyName(string, color);
        }
    }

    public void addNecessaryPropertyName(String[] stringArray, Color[] colorArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addNecessaryPropertyName(stringArray[i], colorArray[i]);
        }
    }

    public void removeNecessaryPropertyName(String string) {
        if (this.necessaryPropertyName.containsKey(string)) {
            this.necessaryPropertyName.remove(string);
            if (this.treeRenderer != null) {
                this.treeRenderer.removeNecessaryPropertyName(string);
            }
        }
    }

    public void removeNecessaryPropertyName() {
        this.necessaryPropertyName.clear();
        if (this.treeRenderer != null) {
            this.treeRenderer.removeNecessaryPropertyName();
        }
    }

    public void addListener(String string, ITreePropertyFormListener iTreePropertyFormListener) {
        if (this.listeners.containsKey(string)) {
            ((ArrayList)this.listeners.get(string)).add(string);
        } else {
            ArrayList<ITreePropertyFormListener> arrayList = new ArrayList<ITreePropertyFormListener>(5);
            arrayList.add(iTreePropertyFormListener);
            this.listeners.put(string, arrayList);
        }
    }

    public void removeListener(String string, ITreePropertyFormListener iTreePropertyFormListener) {
        if (this.listeners.containsKey(string)) {
            this.listeners.remove(string);
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object object2 = this.getValueAt(n, n2);
        if (!(object == object2 || object != null && object.equals(object2))) {
            this.getModel().setValueAt(object, n, n2);
            if (n2 != 0) {
                this.firePropertyChanged(n, object);
            }
        }
    }

    protected void firePropertyChanged(int n, Object object) {
        TreePath treePath = this.getPathForRow(n);
        Object object2 = this.treePropertyFormModel.getValueAt(treePath.getLastPathComponent(), 0);
        if (object2 == null) {
            return;
        }
        if (this.listeners.containsKey(object2.toString())) {
            ArrayList arrayList = (ArrayList)this.listeners.get(object2.toString());
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                ((ITreePropertyFormListener)arrayList.get(i)).valueChanged(this, object2.toString(), object);
            }
        }
    }

    public void setNewRender(boolean bl) {
        this.isNewRender = bl;
        this.treeRenderer = new NewTreeColumnRenderer(this, (TreeTableModel)super.getTreeTableModel());
        this.treeRenderer.setNecessaryAndNotEditableProperty(this.necessaryPropertyName, this.notEditableProperty);
    }
}

