/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.treepropertyform;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.filtertreetable.AbstractTreeTableModel;
import com.swimap.iview.templates.filtertreetable.Sorter;
import com.swimap.iview.templates.treepropertyform.TreePropertyFormModel;
import com.swimap.iview.util.Parameter;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DefaultTreePropertyFormModel
extends AbstractTreeTableModel
implements TreePropertyFormModel {
    private static IviewLogger logger = IviewLogger.getLogger(DefaultTreePropertyFormModel.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/treepropertyform/Res");
    private static DefaultMutableTreeNode root = new DefaultMutableTreeNode(new Parameter("Root", null));
    protected EventListenerList listenerList = new EventListenerList();
    private String[] columnNames = new String[]{res.getString("Name"), res.getString("Value")};
    private Vector disabledProperties = new Vector();
    private HashMap indexMap = new HashMap();
    private Sorter sorter = new Sorter();

    public DefaultTreePropertyFormModel() {
        super(root);
        root.removeAllChildren();
    }

    public DefaultTreePropertyFormModel(String[] stringArray) {
        super(root);
        root.removeAllChildren();
        if (stringArray != null) {
            this.columnNames = stringArray;
        }
    }

    public DefaultTreePropertyFormModel(Object[][] objectArray) {
        super(root);
        root.removeAllChildren();
        root.setAllowsChildren(true);
        this.createChildren(root, objectArray);
    }

    public DefaultTreePropertyFormModel(Object[][] objectArray, String[] stringArray) {
        super(root);
        if (stringArray != null) {
            this.columnNames = stringArray;
        }
        root.removeAllChildren();
        root.setAllowsChildren(true);
        this.createChildren(root, objectArray);
    }

    private void createChildren(DefaultMutableTreeNode defaultMutableTreeNode, Object[][] objectArray) {
        Parameter parameter = null;
        Object object = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            parameter = new Parameter(objectArray[i][0], null);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(parameter);
            object = objectArray[i][1];
            if (object instanceof Object[][]) {
                this.createChildren(defaultMutableTreeNode2, (Object[][])object);
            } else {
                parameter.setValue(object);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    @Override
    public Object getValueAt(Object object, int n) {
        Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
        if (n == 0) {
            if (!(object2 instanceof Parameter)) {
                logger.warn("userObj is not a Parameter " + object2.toString());
            }
            return ((Parameter)object2).getName();
        }
        if (n == 1) {
            return ((Parameter)object2).getValue();
        }
        return null;
    }

    @Override
    public Object getProperty(Object object) {
        return this.getValueAt(object, 0);
    }

    @Override
    public void setProperty(Object object, Object object2, Object object3) {
        this.setValueAt(object, object3, 0);
        this.setValueAt(object2, object3, 1);
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        if (n == 0 || !this.isLeaf(object)) {
            return false;
        }
        return !this.disabledProperties.contains(((DefaultMutableTreeNode)object).getUserObject());
    }

    @Override
    public final void setValueAt(Object object, Object object2, int n) {
        Parameter parameter = (Parameter)((DefaultMutableTreeNode)object2).getUserObject();
        if (n == 1) {
            parameter.setValue(object);
        } else if (n == 0) {
            parameter.setName(object);
        } else {
            throw new IndexOutOfBoundsException("column = " + n + ", it should be VALUE_COLUMN or PROPERTY_COLUMN");
        }
        TreePath treePath = new TreePath(this.getPathToRoot((TreeNode)object2));
        this.valueForPathChanged(treePath, parameter);
    }

    @Override
    public Class getColumnClass(int n) {
        if (n == 0) {
            return Parameter.class;
        }
        return Object.class;
    }

    @Override
    public final int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        int[] nArray = (int[])this.indexMap.get(object);
        if (nArray != null) {
            return ((TreeNode)object).getChildAt(nArray[n]);
        }
        return ((TreeNode)object).getChildAt(n);
    }

    @Override
    public int getChildCount(Object object) {
        return ((TreeNode)object).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((TreeNode)object).getIndex((TreeNode)object2);
    }

    @Override
    public Object getRoot() {
        return root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((TreeNode)object).isLeaf();
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treePath.getLastPathComponent();
        mutableTreeNode.setUserObject(object);
        this.nodeChanged(mutableTreeNode);
    }

    public void nodeChanged(TreeNode treeNode) {
        if (null == this.listenerList || null == treeNode) {
            return;
        }
        TreeNode treeNode2 = treeNode.getParent();
        if (treeNode2 != null) {
            int n = treeNode2.getIndex(treeNode);
            if (n != -1) {
                this.nodesChanged(treeNode2, new int[]{n});
            }
        } else if (treeNode == this.getRoot()) {
            this.nodesChanged(treeNode, null);
        }
    }

    public void nodesChanged(TreeNode treeNode, int[] nArray) {
        if (null == treeNode) {
            return;
        }
        if (nArray != null) {
            int n = nArray.length;
            if (n > 0) {
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = treeNode.getChildAt(nArray[i]);
                }
                this.fireTreeNodesChanged(this, this.getPathToRoot(treeNode), nArray, objectArray);
            }
        } else if (treeNode == this.getRoot()) {
            this.fireTreeNodesChanged(this, this.getPathToRoot(treeNode), null, null);
        }
    }

    @Override
    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (TreeModelListener.class != objectArray3[i]) continue;
            if (null == treeModelEvent) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    public void nodeStructureChanged(TreeNode treeNode) {
        if (null == treeNode) {
            return;
        }
        this.fireTreeStructureChanged(this, this.getPathToRoot(treeNode), null, null);
    }

    @Override
    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public TreeNode[] getPathToRoot(TreeNode treeNode) {
        return this.getPathToRoot(treeNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode treeNode, int n) {
        TreeNode[] treeNodeArray = null;
        if (treeNode == null) {
            return n == 0 ? null : new TreeNode[n];
        }
        treeNodeArray = treeNode == root ? new TreeNode[n] : this.getPathToRoot(treeNode.getParent(), ++n);
        treeNodeArray[treeNodeArray.length - n] = treeNode;
        return treeNodeArray;
    }

    @Override
    public boolean addProperty(Object object, Object object2, Object object3) {
        return this.addChild(root, object, object2, object3);
    }

    private boolean addChild(DefaultMutableTreeNode defaultMutableTreeNode, Object object, Object object2, Object object3) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (((Parameter)defaultMutableTreeNode2.getUserObject()).getName().equals(object)) {
                defaultMutableTreeNode2.setAllowsChildren(true);
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new Parameter(object2, object3)));
                this.nodeStructureChanged(defaultMutableTreeNode2);
                return true;
            }
            if (!this.addChild(defaultMutableTreeNode2, object, object2, object3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPropertyEnabled(Object object) {
        return !this.disabledProperties.contains(object);
    }

    @Override
    public void enableProperty(Object object, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNodeForProperty(root, object);
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (bl) {
            this.disabledProperties.remove(object);
        } else if (!this.disabledProperties.contains(object)) {
            this.disabledProperties.add(object);
        }
    }

    @Override
    public boolean addProperty(Object object, Object object2) {
        root.setAllowsChildren(true);
        root.add(new DefaultMutableTreeNode(new Parameter(object, object2)));
        this.nodeStructureChanged(root);
        return true;
    }

    @Override
    public boolean removeProperty(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNodeForProperty(root, object);
        if (defaultMutableTreeNode != null) {
            defaultMutableTreeNode.removeFromParent();
            this.nodeStructureChanged(root);
            return true;
        }
        return false;
    }

    @Override
    public void setValue(Object object, Object object2) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNodeForProperty(root, object);
        if (defaultMutableTreeNode == null) {
            throw new IllegalArgumentException("Can not find the property in this TreePropertyForm");
        }
        this.setValueAt(object2, defaultMutableTreeNode, 1);
    }

    @Override
    public Object getValue(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNodeForProperty(root, object);
        if (defaultMutableTreeNode == null) {
            throw new IllegalArgumentException("The property not found in " + this.toString());
        }
        return this.getValueAt(defaultMutableTreeNode, 1);
    }

    private DefaultMutableTreeNode findNodeForProperty(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Object object2 = this.getProperty(defaultMutableTreeNode);
        if (object2 != null && object2.equals(object)) {
            return defaultMutableTreeNode;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            defaultMutableTreeNode2 = this.findNodeForProperty(defaultMutableTreeNode3, object);
            if (defaultMutableTreeNode2 == null) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    @Override
    public boolean isPropertyEditable(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNodeForProperty(root, object);
        if (defaultMutableTreeNode == null) {
            throw new RuntimeException("The property not found in " + this.toString());
        }
        return this.isCellEditable(defaultMutableTreeNode, 1);
    }

    public String toString() {
        return "com.swimap.iview.templates.treepropertyform.DefaultTreePropertyFormModel" + this.hashCode();
    }

    @Override
    public boolean isColumnSortable(int n) {
        return true;
    }

    @Override
    public void setColumnSorted(int n, boolean bl) {
        int n2 = bl ? 1 : -1;
        this.orderChildren(this.getRoot(), n, n2);
        this.fireTreeStructureChanged(this, new Object[]{this.getRoot()}, null, null);
    }

    private void orderChildren(Object object, int n, int n2) {
        if (object == null) {
            return;
        }
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            int n3 = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n3; ++i) {
                this.orderChildren(defaultMutableTreeNode.getChildAt(i), n, n2);
            }
            int[] nArray = new int[((DefaultMutableTreeNode)object).getChildCount()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            ArrayList<TreeNode> arrayList = Collections.list(defaultMutableTreeNode.children());
            if (arrayList.isEmpty()) {
                return;
            }
            this.sorter.setParams(this, arrayList.toArray(), nArray, n, n2);
            this.sorter.sort();
            this.indexMap.put(object, nArray);
        }
    }
}

