/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.treecombobox;

import com.swimap.iview.templates.treecombobox.TreeComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

final class TreePopup
extends JPopupMenu
implements ComboPopup {
    protected TreeComboBox comboBox = null;
    protected JScrollPane scrollPane;
    private TreePath lastTreePath = null;
    private Rectangle lastSelectionRowRec = null;
    private Rectangle selectionRowRec = null;
    private MouseListener mouseListener = null;
    private final transient MouseMotionListener mouseMotionListener = new MouseMotionAdapter(){};
    private final JList list = new JList();
    private static final int EXPANDEDICON_SIDE = 20;

    TreePopup(JComboBox jComboBox) {
        this.comboBox = (TreeComboBox)jComboBox;
        this.comboBox.addKeyListener(new TreeComboBoxKeyListener());
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BorderLayout());
        this.setLightWeightPopupEnabled(jComboBox.isLightWeightPopupEnabled());
        JTree jTree = this.comboBox.getTree();
        if (jTree != null) {
            this.scrollPane = new JScrollPane(jTree);
            this.scrollPane.setBorder(null);
            this.add((Component)this.scrollPane, "Center");
            jTree.setUI(new ComboBoxTreeUI());
            if (jTree.getCellRenderer() instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)jTree.getCellRenderer()).setBorderSelectionColor((Color)UIManager.get("ComboBox.selectionBackground"));
            }
        } else {
            JList jList = new JList();
            jList.setName("TreePopup_list");
            jList.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    TreePopup.this.togglePopup();
                }
            });
            this.scrollPane = new JScrollPane(jList);
            this.add((Component)this.scrollPane, "Center");
        }
        super.setName("TreePopup");
        this.scrollPane.setName("TreePopup_scrollPane");
    }

    @Override
    public void show() {
        this.setPreferredSize(new Dimension(this.comboBox.getSize().width, this.comboBox.getPopupMenuHeight()));
        Object object = this.comboBox.getSelectedItem();
        JTree jTree = this.comboBox.getTree();
        if (jTree != null) {
            if (object != null) {
                TreePath treePath = (TreePath)object;
                jTree.scrollPathToVisible(treePath);
                this.comboBox.getTree().setSelectionPath(treePath);
                this.repaintSelectionAreas();
            }
            this.show(this.comboBox, 0, this.comboBox.getHeight());
            jTree.requestFocus();
        } else {
            this.show(this.comboBox, 0, this.comboBox.getHeight());
        }
    }

    @Override
    public void hide() {
        this.setVisible(false);
        this.comboBox.firePropertyChange("popupVisible", true, false);
    }

    public JList getList() {
        return this.list;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    @Override
    public KeyListener getKeyListener() {
        return null;
    }

    @Override
    public void uninstallingUI() {
    }

    @Override
    public MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new InvocationMouseHandler();
        }
        return this.mouseListener;
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        super.firePopupMenuWillBecomeVisible();
        this.comboBox.firePopupMenuWillBecomeVisible();
    }

    @Override
    protected void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
        this.comboBox.firePopupMenuWillBecomeInvisible();
    }

    @Override
    protected void firePopupMenuCanceled() {
        super.firePopupMenuCanceled();
        this.comboBox.firePopupMenuCanceled();
    }

    private void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    private Rectangle rowSelectionArea(TreePath treePath) {
        Rectangle rectangle = this.comboBox.getTree().getPathBounds(treePath);
        if (rectangle != null && this.comboBox.getRootPane() != null) {
            return new Rectangle(0, rectangle.y, this.comboBox.getRootPane().getWidth(), rectangle.height);
        }
        return null;
    }

    private void repaintSelectionAreas() {
        JTree jTree = this.comboBox.getTree();
        if (this.selectionRowRec != null) {
            jTree.repaint(this.selectionRowRec);
        }
        if (this.lastSelectionRowRec != null) {
            jTree.repaint(this.lastSelectionRowRec);
        }
    }

    private class TreeComboBoxKeyListener
    extends KeyAdapter {
        private TreeComboBoxKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            JTree jTree = TreePopup.this.comboBox.getTree();
            if (jTree != null && jTree.getRowCount() > 0 && TreePopup.this.comboBox.hasFocus()) {
                TreePath treePath;
                if (keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                    return;
                }
                boolean bl = true;
                char[] cArray = new char[]{keyEvent.getKeyChar()};
                String string = new String(cArray);
                int n = jTree.getMinSelectionRow() + 1;
                if (n < 0 || n >= jTree.getRowCount()) {
                    bl = false;
                    n = 0;
                }
                if ((treePath = jTree.getNextMatch(string, n, Position.Bias.Forward)) != null) {
                    jTree.setSelectionPath(treePath);
                } else if (bl && (treePath = jTree.getNextMatch(string, 0, Position.Bias.Forward)) != null) {
                    jTree.setSelectionPath(treePath);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            JTree jTree = TreePopup.this.comboBox.getTree();
            if (jTree != null && jTree.getRowCount() > 0 && TreePopup.this.comboBox.hasFocus()) {
                switch (keyEvent.getKeyCode()) {
                    case 36: {
                        TreePopup.this.comboBox.setSelectedItem(jTree.getPathForRow(0));
                        break;
                    }
                    case 35: {
                        TreePopup.this.comboBox.setSelectedItem(jTree.getPathForRow(jTree.getRowCount() - 1));
                        break;
                    }
                }
            }
        }
    }

    private class ComboBoxTreeUI
    extends MetalTreeUI {
        private boolean confirmSelection = true;
        private MouseMotionListener treeMouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ComboBoxTreeUI.this.confirmSelection = false;
                TreePath treePath = ComboBoxTreeUI.this.tree.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                if (treePath != TreePopup.this.lastTreePath && treePath != null) {
                    ComboBoxTreeUI.this.tree.setSelectionPath(treePath);
                }
                ComboBoxTreeUI.this.confirmSelection = true;
            }
        };
        private MouseListener treeSelectListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == TreePopup.this.comboBox.getSeletClickCount()) {
                    TreePath treePath = ComboBoxTreeUI.this.tree.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    if (ComboBoxTreeUI.this.overExpandedIcon(treePath, mouseEvent.getPoint().x, mouseEvent.getPoint().y) || treePath == null) {
                        return;
                    }
                    TreePopup.this.comboBox.setSelectedItem(treePath);
                    TreePopup.this.togglePopup();
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            }
        };
        private TreeSelectionListener treeComboBoxSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (ComboBoxTreeUI.this.tree.getSelectionPath() != null) {
                    TreePopup.this.lastTreePath = ComboBoxTreeUI.this.tree.getSelectionPath();
                    if (TreePopup.this.comboBox.isFillSelectionRow()) {
                        TreePopup.this.selectionRowRec = TreePopup.this.rowSelectionArea(TreePopup.this.lastTreePath);
                        TreePopup.this.repaintSelectionAreas();
                    }
                    if (ComboBoxTreeUI.this.confirmSelection) {
                        TreePopup.this.comboBox.setSelectedItem(TreePopup.this.lastTreePath);
                        if (ComboBoxTreeUI.this.tree.isVisible()) {
                            ComboBoxTreeUI.this.tree.scrollPathToVisible(TreePopup.this.lastTreePath);
                        }
                    }
                }
            }
        };
        private KeyListener treeKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 32: {
                        TreePopup.this.togglePopup();
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                        break;
                    }
                    case 10: {
                        TreePopup.this.comboBox.setSelectedItem(ComboBoxTreeUI.this.tree.getSelectionPath());
                        TreePopup.this.togglePopup();
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                        break;
                    }
                    case 36: {
                        TreePopup.this.comboBox.setSelectedItem(ComboBoxTreeUI.this.tree.getPathForRow(0));
                        break;
                    }
                    case 35: {
                        TreePopup.this.comboBox.setSelectedItem(ComboBoxTreeUI.this.tree.getPathForRow(ComboBoxTreeUI.this.tree.getRowCount() - 1));
                        break;
                    }
                }
            }
        };

        private ComboBoxTreeUI() {
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            if (TreePopup.this.comboBox.isFillSelectionRow()) {
                graphics.setColor((Color)UIManager.get("ComboBox.selectionBackground"));
                if (TreePopup.this.selectionRowRec != null) {
                    graphics.fillRect(((TreePopup)TreePopup.this).selectionRowRec.x, ((TreePopup)TreePopup.this).selectionRowRec.y, ((TreePopup)TreePopup.this).selectionRowRec.width, ((TreePopup)TreePopup.this).selectionRowRec.height);
                    TreePopup.this.lastSelectionRowRec = TreePopup.this.selectionRowRec;
                }
            }
            super.paint(graphics, jComponent);
        }

        @Override
        protected void installListeners() {
            super.installListeners();
            this.tree.addMouseListener(this.treeSelectListener);
            this.tree.addMouseMotionListener(this.treeMouseMotionListener);
            this.tree.addKeyListener(this.treeKeyListener);
            this.tree.getSelectionModel().addTreeSelectionListener(this.treeComboBoxSelectionListener);
        }

        @Override
        protected void uninstallListeners() {
            super.uninstallListeners();
            this.tree.removeMouseListener(this.treeSelectListener);
            this.tree.removeMouseMotionListener(this.treeMouseMotionListener);
            this.tree.removeKeyListener(this.treeKeyListener);
            this.tree.getSelectionModel().removeTreeSelectionListener(this.treeComboBoxSelectionListener);
        }

        private boolean overExpandedIcon(TreePath treePath, int n, int n2) {
            boolean bl = false;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (!defaultMutableTreeNode.isLeaf()) {
                Rectangle rectangle = this.tree.getPathBounds(treePath);
                Rectangle rectangle2 = new Rectangle(rectangle.x - 20, rectangle.y, 20, rectangle.height);
                if (rectangle2.contains(n, n2)) {
                    bl = true;
                }
            }
            return bl;
        }
    }

    private class InvocationMouseHandler
    extends MouseAdapter {
        private InvocationMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || !TreePopup.this.comboBox.isEnabled()) {
                return;
            }
            if (TreePopup.this.comboBox.isEditable()) {
                Component component = TreePopup.this.comboBox.getEditor().getEditorComponent();
                if (!(component instanceof JComponent) || ((JComponent)component).isRequestFocusEnabled()) {
                    component.requestFocus();
                }
            } else if (TreePopup.this.comboBox.isRequestFocusEnabled()) {
                TreePopup.this.comboBox.requestFocus();
            }
            TreePopup.this.togglePopup();
        }
    }
}

