/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.treecombobox;

import com.swimap.iview.templates.treecombobox.TreePopup;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeComboBox
extends JComboBox {
    private JTree tree = null;
    private int selectClickCount = 1;
    private boolean showWholePath = false;
    private boolean fillSelectionRow = false;
    private int popupMenuHeight = 200;
    private static final int DEFAULT_MENU_HEIGHT = 200;
    private static final String DEFAULT_WHOLEPATH_SEP = " / ";

    public TreeComboBox(JTree jTree) {
        this.setTree(jTree);
    }

    public TreeComboBox(TreeModel treeModel) {
        this(new JTree(treeModel));
    }

    public void setPopupMenuHeight(int n) {
        this.popupMenuHeight = n;
    }

    public void setShowWholePath(boolean bl) {
        this.showWholePath = bl;
    }

    public void setFillSelectionRow(boolean bl) {
        this.fillSelectionRow = bl;
    }

    @Override
    public void setSelectedItem(Object object) {
        this.getModel().setSelectedItem(object);
    }

    @Override
    public void updateUI() {
        this.setUI(new MetalJTreeComboBoxUI());
    }

    public void setSelectClickCount(int n) {
        this.selectClickCount = n;
    }

    public JTree getTree() {
        return this.tree;
    }

    protected String getWholePath(TreePath treePath) {
        StringBuffer stringBuffer = new StringBuffer(50);
        int n = treePath.getPathCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(DEFAULT_WHOLEPATH_SEP);
            }
            stringBuffer.append(treePath.getPathComponent(i));
        }
        return stringBuffer.toString();
    }

    final int getSeletClickCount() {
        return this.selectClickCount;
    }

    final int getPopupMenuHeight() {
        return this.popupMenuHeight;
    }

    final boolean isFillSelectionRow() {
        return this.fillSelectionRow;
    }

    private void setTree(JTree jTree) {
        this.tree = jTree;
        if (jTree != null) {
            jTree.setFocusable(true);
            jTree.getSelectionModel().setSelectionMode(1);
            if (jTree.getSelectionPath() != null) {
                this.setSelectedItem(jTree.getSelectionPath());
            } else {
                this.setSelectedItem(jTree.getPathForRow(0));
            }
            this.setRenderer(new JTreeComboBoxRenderer());
        } else {
            this.setSelectedItem(null);
        }
        this.updateUI();
        this.setName("TreeComboBox");
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        if (this.tree != null) {
            this.tree.setName(string + "_tree");
        }
    }

    private class JTreeComboBoxRenderer
    extends DefaultListCellRenderer {
        private JTreeComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                TreePath treePath = (TreePath)object;
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                if (TreeComboBox.this.showWholePath) {
                    ((DefaultListCellRenderer)component).setText(TreeComboBox.this.getWholePath(treePath));
                } else {
                    object = treeNode;
                    Component component2 = TreeComboBox.this.tree.getCellRenderer().getTreeCellRendererComponent(TreeComboBox.this.tree, object, bl, false, treeNode.isLeaf(), n, bl2);
                    if (component2 instanceof JLabel) {
                        ((DefaultListCellRenderer)component).setText(((JLabel)component2).getText());
                        ((DefaultListCellRenderer)component).setIcon(((JLabel)component2).getIcon());
                    } else {
                        component = component2;
                    }
                }
            }
            return component;
        }
    }

    private static class MetalJTreeComboBoxUI
    extends MetalComboBoxUI {
        private MetalJTreeComboBoxUI() {
        }

        public static ComponentUI createUI(JComponent jComponent) {
            return new MetalJTreeComboBoxUI();
        }

        @Override
        protected ComboPopup createPopup() {
            return new TreePopup(this.comboBox);
        }
    }
}

