/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.tree;

import com.swimap.iview.templates.tree.TreeStyleInformation;
import com.swimap.iview.templates.tree.TreeStyleInformationManager;
import com.swimap.iview.templates.tree.xml.Background;
import com.swimap.iview.templates.tree.xml.BackgroundNonSelectionColor;
import com.swimap.iview.templates.tree.xml.BackgroundSelectionColor;
import com.swimap.iview.templates.tree.xml.BorderSelectionColor;
import com.swimap.iview.templates.tree.xml.CellEditorStyle;
import com.swimap.iview.templates.tree.xml.CellRendererStyle;
import com.swimap.iview.templates.tree.xml.SelectionModelStyle;
import com.swimap.iview.templates.tree.xml.TextNonSelectionColor;
import com.swimap.iview.templates.tree.xml.TextSelectionColor;
import com.swimap.iview.templates.tree.xml.TreeInfo;
import com.swimap.iview.templates.tree.xml.TreeStyle;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.net.URL;

public class TreeXMLFileReader {
    private static IviewLogger logger = IviewLogger.getLogger(TreeXMLFileReader.class, "IVIEW");
    private boolean validity = false;
    private TreeStyleInformation styleInfo = null;
    private TreeStyleInformationManager styleInfoManager = null;

    public boolean readXMLFile(String string) throws Exception {
        try {
            string = CommonUtil.getAbsolutePath(string);
            File file = new File(string);
            URL uRL = file.toURL();
            TreeInfo treeInfo = TreeInfo.unmarshal(uRL);
            this.validity = treeInfo.isValid();
            if (this.validity) {
                this.styleInfo = new TreeStyleInformation();
                this.readTreeStyle(treeInfo);
                this.readRendererStyle(treeInfo);
                this.readEditorStyle(treeInfo);
                this.readSelectionModelStyle(treeInfo);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.validity = false;
            logger.error("Error while reading XML file : " + numberFormatException);
            throw numberFormatException;
        }
        catch (Exception exception) {
            this.validity = false;
            logger.error("Error while reading XML file : " + exception);
            throw exception;
        }
        return this.validity;
    }

    public TreeStyleInformation getTreeInfoFromXML(String string) {
        boolean bl = false;
        try {
            bl = this.readXMLFile(string);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            bl = false;
        }
        if (bl) {
            return this.styleInfo;
        }
        return null;
    }

    private Color getColor(String string, String string2, String string3) throws NumberFormatException {
        Color color = null;
        if (string != null && string2 != null && string3 != null) {
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            int n3 = Integer.parseInt(string3);
            color = new Color(n, n2, n3);
        }
        return color;
    }

    private Font getFont(String string, String string2, String string3) throws NumberFormatException {
        Font font = null;
        if (string != null && string2 != null && string3 != null) {
            int n = 0;
            n = "BOLD".equalsIgnoreCase(string2.trim()) ? 1 : ("ITALIC".equalsIgnoreCase(string2.trim()) ? 2 : ("BOLD+ITALIC".equalsIgnoreCase(string2.trim()) ? 3 : 0));
            int n2 = Integer.parseInt(string3);
            font = new Font(string.trim(), n, n2);
        }
        return font;
    }

    private void readTreeStyle(TreeInfo treeInfo) throws NumberFormatException {
        TreeStyle treeStyle = treeInfo.getTreeStyle();
        String string = null;
        if (treeStyle != null) {
            Background background;
            string = treeStyle.getEditable();
            if (string != null) {
                this.styleInfo.setEditable("true".equalsIgnoreCase(string.trim()));
            }
            if (string != null) {
                this.styleInfo.setRootVisible("true".equalsIgnoreCase(string.trim()));
            }
            if ((string = treeStyle.getShowsRootHandles()) != null) {
                this.styleInfo.setShowsRootHandles("true".equalsIgnoreCase(string.trim()));
            }
            if ((string = treeStyle.getRowHeight()) != null) {
                this.styleInfo.setRowHeight(Integer.parseInt(string));
            }
            if ((string = treeStyle.getVisibleRowCount()) != null) {
                this.styleInfo.setVisibleRowCount(Integer.parseInt(string));
            }
            if ((background = treeStyle.getBackground()) != null) {
                this.styleInfo.setBackground(this.getColor(background.getR(), background.getG(), background.getB()));
            }
        }
    }

    private void readRendererStyle(TreeInfo treeInfo) throws NumberFormatException {
        CellRendererStyle cellRendererStyle = treeInfo.getCellRendererStyle();
        String string = null;
        if (cellRendererStyle != null) {
            Background background;
            BorderSelectionColor borderSelectionColor;
            BackgroundNonSelectionColor backgroundNonSelectionColor;
            BackgroundSelectionColor backgroundSelectionColor;
            TextNonSelectionColor textNonSelectionColor;
            TreeStyleInformation.DefaultTreeCellRendererStyle defaultTreeCellRendererStyle = new TreeStyleInformation.DefaultTreeCellRendererStyle();
            string = cellRendererStyle.getLeafIcon();
            if (string != null) {
                defaultTreeCellRendererStyle.setLeafIcon(string.trim());
            }
            if ((string = cellRendererStyle.getClosedIcon()) != null) {
                defaultTreeCellRendererStyle.setClosedIcon(string.trim());
            }
            if ((string = cellRendererStyle.getOpenIcon()) != null) {
                defaultTreeCellRendererStyle.setOpenIcon(string.trim());
            }
            defaultTreeCellRendererStyle.setFont(this.getFont(cellRendererStyle.getFontName(), cellRendererStyle.getFontStyle(), cellRendererStyle.getFontSize()));
            TextSelectionColor textSelectionColor = cellRendererStyle.getTextSelectionColor();
            if (textSelectionColor != null) {
                defaultTreeCellRendererStyle.setTextSelectionColor(this.getColor(textSelectionColor.getR(), textSelectionColor.getG(), textSelectionColor.getB()));
            }
            if ((textNonSelectionColor = cellRendererStyle.getTextNonSelectionColor()) != null) {
                defaultTreeCellRendererStyle.setTextNonSelectionColor(this.getColor(textNonSelectionColor.getR(), textNonSelectionColor.getG(), textNonSelectionColor.getB()));
            }
            if ((backgroundSelectionColor = cellRendererStyle.getBackgroundSelectionColor()) != null) {
                defaultTreeCellRendererStyle.setBackgroundSelectionColor(this.getColor(backgroundSelectionColor.getR(), backgroundSelectionColor.getG(), backgroundSelectionColor.getB()));
            }
            if ((backgroundNonSelectionColor = cellRendererStyle.getBackgroundNonSelectionColor()) != null) {
                defaultTreeCellRendererStyle.setBackgroundNonSelectionColor(this.getColor(backgroundNonSelectionColor.getR(), backgroundNonSelectionColor.getG(), backgroundNonSelectionColor.getB()));
            }
            if ((borderSelectionColor = cellRendererStyle.getBorderSelectionColor()) != null) {
                defaultTreeCellRendererStyle.setBorderSelectionColor(this.getColor(borderSelectionColor.getR(), borderSelectionColor.getG(), borderSelectionColor.getB()));
            }
            if ((background = cellRendererStyle.getBackground()) != null) {
                defaultTreeCellRendererStyle.setBackground(this.getColor(background.getR(), background.getG(), background.getB()));
            }
            this.styleInfo.setDefaultTreeCellRendererStyle(defaultTreeCellRendererStyle);
        }
    }

    private void readEditorStyle(TreeInfo treeInfo) throws NumberFormatException {
        CellEditorStyle cellEditorStyle = treeInfo.getCellEditorStyle();
        if (cellEditorStyle != null) {
            TreeStyleInformation.DefaultTreeCellEditorStyle defaultTreeCellEditorStyle = new TreeStyleInformation.DefaultTreeCellEditorStyle();
            defaultTreeCellEditorStyle.setFont(this.getFont(cellEditorStyle.getFontName(), cellEditorStyle.getFontStyle(), cellEditorStyle.getFontSize()));
            BorderSelectionColor borderSelectionColor = cellEditorStyle.getBorderSelectionColor();
            if (borderSelectionColor != null) {
                defaultTreeCellEditorStyle.setBorderSelectionColor(this.getColor(borderSelectionColor.getR(), borderSelectionColor.getG(), borderSelectionColor.getB()));
            }
            this.styleInfo.setDefaultTreeCellEditorStyle(defaultTreeCellEditorStyle);
        }
    }

    private void readSelectionModelStyle(TreeInfo treeInfo) {
        SelectionModelStyle selectionModelStyle = treeInfo.getSelectionModelStyle();
        if (selectionModelStyle != null) {
            TreeStyleInformation.TreeSelectionModelStyle treeSelectionModelStyle = new TreeStyleInformation.TreeSelectionModelStyle();
            String string = selectionModelStyle.getSelectionMode();
            if (string != null) {
                int n = 0;
                n = "SINGLE".equalsIgnoreCase(string.trim()) ? 1 : ("CONTIGUOUS".equalsIgnoreCase(string.trim()) ? 2 : 4);
                treeSelectionModelStyle.setSelectionMode(n);
            }
            this.styleInfo.setTreeSelectionModelStyle(treeSelectionModelStyle);
        }
    }

    public boolean saveInformation(String string) throws Exception {
        this.styleInfoManager = new TreeStyleInformationManager(string);
        boolean bl = this.styleInfoManager != null & this.styleInfo != null;
        if (bl) {
            try {
                this.styleInfoManager.saveInformation(this.styleInfo);
            }
            catch (NullPointerException nullPointerException) {
                bl = false;
                logger.error("Error while saving the information" + nullPointerException);
                throw nullPointerException;
            }
            catch (Exception exception) {
                bl = false;
                logger.error("Error while saving the information" + exception);
                throw exception;
            }
        }
        return bl;
    }

    public boolean isInformationValid() {
        return this.validity;
    }
}

