/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.tree;

import com.swimap.iview.templates.tree.ISearchHelper;
import com.swimap.iview.templates.tree.ITreeEventHandler;
import com.swimap.iview.templates.tree.ITreeStyleInterface;
import com.swimap.iview.templates.tree.TemplateDefaultTreeCellRenderer;
import com.swimap.iview.templates.tree.TreeStyleInformation;
import com.swimap.iview.templates.utils.GenericListener;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeTemplate
extends JTree {
    private static IviewLogger logger = IviewLogger.getLogger(TreeTemplate.class, "IVIEW");
    protected ITreeEventHandler treeEventHandler = null;
    protected TreeStyleInformation treeStyleInfo = null;
    protected ITreeStyleInterface manager = null;
    protected DefaultMutableTreeNode[] treeNodeClipBoard = null;
    protected int treeNodeClipBoardTag = 0;
    protected static final int CLIP_BOARD_EMPTY = 0;
    protected static final int CLIP_BOARD_WITH_A_CUT_NODES = 1;
    protected static final int CLIP_BOARD_WITH_A_COPIED_NODES = 2;

    public TreeTemplate() {
        super(new DefaultMutableTreeNode());
    }

    public TreeTemplate(ITreeStyleInterface iTreeStyleInterface) throws Exception {
        try {
            this.treeStyleInfo = iTreeStyleInterface.loadInformation();
            this.manager = iTreeStyleInterface;
            this.loadTreeStyleInformation();
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error(classNotFoundException.toString());
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            logger.error(iOException.toString());
            throw iOException;
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
        catch (SecurityException securityException) {
            logger.error(securityException.toString());
            throw securityException;
        }
        catch (Exception exception) {
            logger.error(exception.toString());
            throw exception;
        }
    }

    public void loadTreeStyleInformation() throws NullPointerException {
        try {
            this.setEditable(this.treeStyleInfo.isEditable());
            this.setInvokesStopCellEditing(this.isEditable());
            this.setBackground(this.treeStyleInfo.getBackground());
            this.setRootVisible(this.treeStyleInfo.isRootVisible());
            this.setShowsRootHandles(this.treeStyleInfo.isShowsRootHandles());
            this.setRowHeight(this.treeStyleInfo.getRowHeight());
            this.setVisibleRowCount(this.treeStyleInfo.getVisibleRowCount());
            TreeStyleInformation.DefaultTreeCellRendererStyle defaultTreeCellRendererStyle = this.treeStyleInfo.getDefaultTreeCellRendererStyle();
            TemplateDefaultTreeCellRenderer templateDefaultTreeCellRenderer = new TemplateDefaultTreeCellRenderer(defaultTreeCellRendererStyle);
            this.setCellRenderer(templateDefaultTreeCellRenderer);
            TreeStyleInformation.DefaultTreeCellEditorStyle defaultTreeCellEditorStyle = this.treeStyleInfo.getDefaultTreeCellEditorStyle();
            DefaultTreeCellEditor defaultTreeCellEditor = new DefaultTreeCellEditor(this, (DefaultTreeCellRenderer)this.getCellRenderer());
            defaultTreeCellEditor.setFont(defaultTreeCellEditorStyle.getFont());
            defaultTreeCellEditor.setBorderSelectionColor(defaultTreeCellEditorStyle.getBorderSelectionColor());
            this.setCellEditor(defaultTreeCellEditor);
            TreeStyleInformation.TreeSelectionModelStyle treeSelectionModelStyle = this.treeStyleInfo.getTreeSelectionModelStyle();
            DefaultTreeSelectionModel defaultTreeSelectionModel = (DefaultTreeSelectionModel)this.getSelectionModel();
            defaultTreeSelectionModel.setSelectionMode(treeSelectionModelStyle.getSelectionMode());
            this.setSelectionModel(defaultTreeSelectionModel);
            this.updateUI();
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
    }

    public void setTreeEventHandler(ITreeEventHandler iTreeEventHandler) {
        this.treeEventHandler = iTreeEventHandler;
        this.setupCustomizableListeners();
    }

    public TreeStyleInformation getTreeStyleInformation() {
        return this.treeStyleInfo;
    }

    public void setTreeStyleInformation(TreeStyleInformation treeStyleInformation) throws NullPointerException {
        this.treeStyleInfo = treeStyleInformation;
        try {
            this.loadTreeStyleInformation();
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
    }

    public boolean addObject(Object object) throws NullPointerException {
        return this.addObject(object, true);
    }

    public boolean addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        return this.addObject(defaultMutableTreeNode, object, true, true);
    }

    private DefaultMutableTreeNode getParentNode() throws NullPointerException {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        TreePath treePath = this.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        defaultMutableTreeNode = defaultMutableTreeNode2.getAllowsChildren() ? defaultMutableTreeNode2 : (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
        return defaultMutableTreeNode;
    }

    public boolean addObject(Object object, boolean bl) throws NullPointerException {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        try {
            defaultMutableTreeNode = this.getParentNode();
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
        return this.addObject(defaultMutableTreeNode, object, bl, true);
    }

    public boolean addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object, boolean bl) throws NullPointerException {
        return this.addObject(defaultMutableTreeNode, object, bl, true);
    }

    public boolean addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object, boolean bl, boolean bl2) throws NullPointerException {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object, bl);
        return this.addNode(defaultMutableTreeNode, defaultMutableTreeNode2, bl2);
    }

    public boolean addNode(DefaultMutableTreeNode defaultMutableTreeNode) throws NullPointerException {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        try {
            defaultMutableTreeNode2 = this.getParentNode();
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
        return this.addNode(defaultMutableTreeNode2, defaultMutableTreeNode, true);
    }

    public boolean addNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) throws NullPointerException {
        return this.addNode(defaultMutableTreeNode, defaultMutableTreeNode2, true);
    }

    public boolean addNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, boolean bl) throws NullPointerException {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        int n = 0;
        boolean bl2 = false;
        try {
            n = defaultMutableTreeNode.getChildCount();
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
            if (bl) {
                this.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
            }
            bl2 = true;
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
        return bl2;
    }

    public void removeCurrentNode() throws NullPointerException, IllegalArgumentException {
        TreePath[] treePathArray = this.getSelectionPaths();
        try {
            for (int i = 0; i < treePathArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                this.removeTreeNode(defaultMutableTreeNode);
                this.updateUI();
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error(illegalArgumentException.toString());
            throw illegalArgumentException;
        }
    }

    public void removeTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) throws NullPointerException, IllegalArgumentException {
        try {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            this.updateUI();
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error(illegalArgumentException.toString());
            throw illegalArgumentException;
        }
    }

    public void copyTreeNode() throws NullPointerException {
        TreePath[] treePathArray = this.getSelectionPaths();
        try {
            this.treeNodeClipBoard = new DefaultMutableTreeNode[treePathArray.length];
            for (int i = 0; i < treePathArray.length; ++i) {
                this.treeNodeClipBoard[i] = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                this.treeNodeClipBoardTag = 2;
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
    }

    public void cutTreeNode() throws NullPointerException {
        TreePath[] treePathArray = this.getSelectionPaths();
        try {
            this.treeNodeClipBoard = new DefaultMutableTreeNode[treePathArray.length];
            for (int i = 0; i < treePathArray.length; ++i) {
                this.treeNodeClipBoard[i] = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                this.treeNodeClipBoardTag = 1;
                this.removeTreeNode(this.treeNodeClipBoard[i]);
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error(illegalArgumentException.toString());
            throw illegalArgumentException;
        }
    }

    public void pasteTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl, boolean bl2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            if (this.treeNodeClipBoard != null && this.treeNodeClipBoardTag != 0 && defaultMutableTreeNode != null) {
                int n = defaultMutableTreeNode.getChildCount();
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
                if (this.treeNodeClipBoardTag == 1 && bl) {
                    for (int i = 0; i < this.treeNodeClipBoard.length; ++i) {
                        defaultTreeModel.insertNodeInto(this.treeNodeClipBoard[i], defaultMutableTreeNode, n + i);
                        if (!bl2) continue;
                        this.scrollPathToVisible(new TreePath(this.treeNodeClipBoard[i].getPath()));
                    }
                    this.treeNodeClipBoardTag = 0;
                } else {
                    for (int i = 0; i < this.treeNodeClipBoard.length; ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = this.cloneTreeNode(this.treeNodeClipBoard[i]);
                        defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n + i);
                        if (!bl2) continue;
                        this.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
                    }
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.error(noSuchMethodException.toString());
            throw noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error(illegalAccessException.toString());
            throw illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.error(invocationTargetException.toString());
            throw invocationTargetException;
        }
    }

    public void pasteTreeNode() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NullPointerException {
        this.pasteTreeNode(true);
    }

    public void pasteTreeNode(boolean bl) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NullPointerException {
        TreePath treePath = this.getSelectionPath();
        try {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            this.pasteTreeNode(defaultMutableTreeNode, bl, false);
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
    }

    private DefaultMutableTreeNode cloneTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NullPointerException {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.clone();
        Object object = null;
        try {
            object = this.cloneObject(defaultMutableTreeNode.getUserObject());
            defaultMutableTreeNode2.setUserObject(object);
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            object = null;
            defaultMutableTreeNode2 = null;
            throw nullPointerException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.error(noSuchMethodException.toString());
            object = null;
            defaultMutableTreeNode2 = null;
            throw noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error(illegalAccessException.toString());
            object = null;
            defaultMutableTreeNode2 = null;
            throw illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.error(invocationTargetException.toString());
            object = null;
            defaultMutableTreeNode2 = null;
            throw invocationTargetException;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            defaultMutableTreeNode2.add(this.cloneTreeNode(defaultMutableTreeNode3));
        }
        return defaultMutableTreeNode2;
    }

    private Object cloneObject(Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NullPointerException {
        Method method = null;
        Object[] objectArray = new Class[]{};
        try {
            method = object.getClass().getMethod("clone", (Class<?>[])objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.error(noSuchMethodException.toString());
            method = null;
            throw noSuchMethodException;
        }
        try {
            return method.invoke(object, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
            throw nullPointerException;
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error(illegalAccessException.toString());
            throw illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.error(invocationTargetException.toString());
            throw invocationTargetException;
        }
    }

    private void setupCustomizableListeners() {
        TreeSelectionListener treeSelectionListener = (TreeSelectionListener)GenericListener.create(TreeSelectionListener.class, "valueChanged", this.treeEventHandler, "treeSelectionAction");
        this.addTreeSelectionListener(treeSelectionListener);
        TreeWillExpandListener treeWillExpandListener = (TreeWillExpandListener)GenericListener.create(TreeWillExpandListener.class, "treeWillExpand", this.treeEventHandler, "treeWillExpandAction");
        this.addTreeWillExpandListener(treeWillExpandListener);
        KeyListener keyListener = (KeyListener)GenericListener.create(KeyListener.class, "keyPressed", this.treeEventHandler, "keyAction");
        this.addKeyListener(keyListener);
        MouseListener mouseListener = (MouseListener)GenericListener.create(MouseListener.class, "mouseEntered", this.treeEventHandler, "mouseEnteredAction");
        this.addMouseListener(mouseListener);
        MouseListener mouseListener2 = (MouseListener)GenericListener.create(MouseListener.class, "mousePressed", this.treeEventHandler, "mousePressedAction");
        this.addMouseListener(mouseListener2);
        MouseListener mouseListener3 = (MouseListener)GenericListener.create(MouseListener.class, "mouseClicked", this.treeEventHandler, "mouseClickedAction");
        this.addMouseListener(mouseListener3);
        MouseListener mouseListener4 = (MouseListener)GenericListener.create(MouseListener.class, "mouseReleased", this.treeEventHandler, "mouseReleasedAction");
        this.addMouseListener(mouseListener4);
    }

    public TreePath searchTreeNode(Object object, boolean bl, ISearchHelper iSearchHelper) {
        TreePath treePath = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            for (int i = 0; i < treePathArray.length && ((defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent()) == null || (treePath = iSearchHelper.searchNode(defaultMutableTreeNode = defaultMutableTreeNode2.isLeaf() ? (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent() : defaultMutableTreeNode2, object)) == null); ++i) {
            }
        } else {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
            treePath = iSearchHelper.searchNode(defaultMutableTreeNode, object);
        }
        if (treePath != null && bl) {
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
        }
        return treePath;
    }

    public void expandAllNodes() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void collapseAllNodes() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.collapseRow(i);
        }
    }
}

