/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.tree;

import com.swimap.iview.templates.tree.ITreeStyleInterface;
import com.swimap.iview.templates.tree.TreeStyleInformation;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ObjectManager;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.IOException;

public class TreeStyleInformationManager
implements ITreeStyleInterface {
    private static IviewLogger logger = IviewLogger.getLogger(TreeStyleInformationManager.class, "IVIEW");
    private File styleInformationFile = null;

    public TreeStyleInformationManager(String string) {
        this.setStyleInformationFile(string);
    }

    @Override
    public TreeStyleInformation loadInformation() throws NullPointerException, ClassNotFoundException, SecurityException, IOException {
        if (this.styleInformationFile == null) {
            logger.error("Error while loading information:Null pointer exception");
            throw new NullPointerException("TreeStyleInformationManager.styleInformationFile is null");
        }
        Object object = ObjectManager.loadObject(this.styleInformationFile);
        return (TreeStyleInformation)object;
    }

    @Override
    public void saveInformation(TreeStyleInformation treeStyleInformation) throws IOException, NullPointerException {
        if (this.styleInformationFile == null) {
            logger.error("Error while saving information:Null pointer exception");
            throw new NullPointerException("TreeStyleInformationManager.styleInformationFile is null");
        }
        ObjectManager.saveObject(this.styleInformationFile, (Object)treeStyleInformation);
    }

    public void setStyleInformationFile(String string) {
        try {
            string = CommonUtil.getAbsolutePath(string);
            this.styleInformationFile = new File(string);
        }
        catch (NullPointerException nullPointerException) {
            this.styleInformationFile = null;
            logger.error("Error while settinf the styleInformationFile : " + nullPointerException);
            throw nullPointerException;
        }
    }
}

