/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.tree;

import com.swimap.iview.templates.tree.DefaultSortHelper;
import com.swimap.iview.templates.tree.ISortHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class SortableDefaultTreeModel
extends DefaultTreeModel {
    protected transient ISortHelper sortHelper = new DefaultSortHelper();
    protected boolean ascendingOrder = false;
    protected ArrayList sortOrder = new ArrayList(10);
    protected Hashtable sortedOrder = new Hashtable(10);

    public SortableDefaultTreeModel() {
        super(new DefaultMutableTreeNode());
    }

    public SortableDefaultTreeModel(TreeNode treeNode) {
        super(treeNode);
    }

    public SortableDefaultTreeModel(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
    }

    public void setSortHelper(ISortHelper iSortHelper) {
        this.sortHelper = iSortHelper;
    }

    public ISortHelper getSortHelper() {
        return this.sortHelper;
    }

    public void setOrder(boolean bl) {
        this.ascendingOrder = bl;
    }

    public boolean getOrder() {
        return this.ascendingOrder;
    }

    public void sort(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = this.getChildCount(defaultMutableTreeNode);
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = super.getChild(defaultMutableTreeNode, i);
            if (((DefaultMutableTreeNode)objectArray[i]).isLeaf()) continue;
            this.sort((DefaultMutableTreeNode)objectArray[i]);
        }
        if (this.sortHelper != null) {
            this.sortOrder = this.sortHelper.getSortedNodes(objectArray, this.ascendingOrder);
            this.sortedOrder.put(defaultMutableTreeNode, this.sortOrder);
        }
    }

    public void unsort(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = this.getChildCount(defaultMutableTreeNode);
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = super.getChild(defaultMutableTreeNode, i);
            if (((DefaultMutableTreeNode)objectArray[i]).isLeaf()) continue;
            this.unsort((DefaultMutableTreeNode)objectArray[i]);
        }
        if (!this.sortedOrder.isEmpty()) {
            this.sortedOrder.remove(defaultMutableTreeNode);
        }
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        Object var3_3 = null;
        int n = -1;
        if (!this.sortedOrder.isEmpty()) {
            int n2 = super.getIndexOfChild(object, object2);
            var3_3 = this.sortedOrder.get(object);
            if (var3_3 != null) {
                this.sortOrder = var3_3;
                int n3 = this.sortOrder.size();
                for (int i = 0; i < n3; ++i) {
                    if ((Integer)this.sortOrder.get(i) != n2) continue;
                    n = i;
                    break;
                }
            } else {
                n = super.getIndexOfChild(object, object2);
            }
        } else {
            n = super.getIndexOfChild(object, object2);
        }
        return n;
    }

    @Override
    public Object getChild(Object object, int n) {
        Object object2 = null;
        Object var4_4 = null;
        if (!this.sortedOrder.isEmpty()) {
            var4_4 = this.sortedOrder.get(object);
            if (var4_4 != null) {
                this.sortOrder = var4_4;
                object2 = super.getChild(object, (Integer)this.sortOrder.get(n));
            } else {
                object2 = super.getChild(object, n);
            }
        } else {
            object2 = super.getChild(object, n);
        }
        return object2;
    }

    @Override
    public void insertNodeInto(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2, int n) {
        Object var4_4 = null;
        if (!this.sortedOrder.isEmpty() && (var4_4 = this.sortedOrder.get(mutableTreeNode2)) != null) {
            this.sortOrder = var4_4;
            this.sortOrder.add(n, n);
            if (n < mutableTreeNode2.getChildCount()) {
                int n2 = 0;
                int n3 = this.sortOrder.size();
                for (int i = n + 1; i < n3; ++i) {
                    n2 = (Integer)this.sortOrder.get(i);
                    this.sortOrder.set(i, n2 + 1);
                }
            }
        }
        super.insertNodeInto(mutableTreeNode, mutableTreeNode2, n);
    }

    @Override
    public void removeNodeFromParent(MutableTreeNode mutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object var2_2 = null;
        if (!this.sortedOrder.isEmpty() && (var2_2 = this.sortedOrder.get(defaultMutableTreeNode = (DefaultMutableTreeNode)mutableTreeNode.getParent())) != null) {
            int n = this.getIndexOfChild(defaultMutableTreeNode, mutableTreeNode);
            this.sortOrder = var2_2;
            int n2 = (Integer)this.sortOrder.remove(n);
            int n3 = 0;
            int n4 = this.sortOrder.size();
            for (int i = 0; i < n4; ++i) {
                n3 = (Integer)this.sortOrder.get(i);
                if (n3 <= n2) continue;
                this.sortOrder.set(i, n3 - 1);
            }
        }
        super.removeNodeFromParent(mutableTreeNode);
    }
}

