/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.tree;

import com.swimap.iview.templates.tree.DefaultSearchHelper;
import com.swimap.iview.templates.tree.DefaultSortHelper;
import com.swimap.iview.templates.tree.ITreeEventHandler;
import com.swimap.iview.templates.tree.SortableDefaultTreeModel;
import com.swimap.iview.templates.tree.TreeTemplate;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeEventHandler
implements ITreeEventHandler {
    private static IviewLogger logger = IviewLogger.getLogger(DefaultTreeEventHandler.class, "IVIEW");
    private static ResourceBundle res = ResourceBundle.getBundle("com.swimap.iview.templates.tree.TreeResource");
    protected JPopupMenu popupMenu = null;
    protected Timer timer = null;
    protected static final int TIMER_DELAY = 100;
    protected String keyPressed = null;
    protected TreeTemplate tree = null;
    protected JMenuItem sort = null;
    protected JMenuItem unsort = null;

    public DefaultTreeEventHandler(TreeTemplate treeTemplate) {
        this.setHandlerOwner(treeTemplate);
        this.installPopupMenu();
    }

    private void setHandlerOwner(TreeTemplate treeTemplate) {
        this.tree = treeTemplate;
    }

    @Override
    public void treeSelectionAction(TreeSelectionEvent treeSelectionEvent) {
    }

    @Override
    public void treeWillExpandAction(TreeExpansionEvent treeExpansionEvent) {
    }

    @Override
    public void mouseEnteredAction(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressedAction(MouseEvent mouseEvent) {
    }

    public void timerActionPerformed() {
        this.setKeySelectedRow();
        this.keyPressed = "";
        this.timer.cancel();
    }

    @Override
    public void keyAction(KeyEvent keyEvent) {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                DefaultTreeEventHandler.this.timerActionPerformed();
            }
        };
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule(timerTask, 100L);
        } else {
            this.timer.schedule(timerTask, 100L);
            this.keyPressed = this.keyPressed + String.valueOf(keyEvent.getKeyChar());
        }
    }

    private void setKeySelectedRow() {
        if (this.tree != null) {
            int n = this.tree.getRowCount();
            for (int i = 1; i < n; ++i) {
                int n2 = this.tree.getMaxSelectionRow();
                int n3 = (i + n2) % n;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getPathForRow(n3).getLastPathComponent();
                if (!defaultMutableTreeNode.toString().toLowerCase().startsWith(this.keyPressed.toLowerCase())) continue;
                this.tree.setSelectionRow(n3);
                break;
            }
        }
    }

    @Override
    public void mouseReleasedAction(MouseEvent mouseEvent) {
        boolean bl = false;
        int[] nArray = this.tree.getSelectionRows();
        int n = this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                bl = true;
                break;
            }
        }
        if (!bl || nArray == null) {
            this.tree.setSelectionRow(n);
        }
        if (mouseEvent.isPopupTrigger()) {
            this.displayPopupMenu(mouseEvent);
        }
    }

    @Override
    public void mouseClickedAction(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.doubleClickAction(mouseEvent);
        }
    }

    public void doubleClickAction(MouseEvent mouseEvent) {
    }

    public void displayPopupMenu(MouseEvent mouseEvent) {
        TreeModel treeModel = this.tree.getModel();
        if (treeModel instanceof SortableDefaultTreeModel) {
            this.sort.setEnabled(true);
            this.unsort.setEnabled(true);
        } else {
            this.sort.setEnabled(false);
            this.unsort.setEnabled(false);
        }
        this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void installPopupMenu() {
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(res.getString("EXPAND_ALL"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTreeEventHandler.this.expandAllActionPerformed();
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(res.getString("COLLAPSE_ALL"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTreeEventHandler.this.collapseAllActionPerformed();
            }
        });
        this.popupMenu.add(jMenuItem);
        this.sort = new JMenuItem(res.getString("SORT"));
        this.sort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTreeEventHandler.this.sortActionPerformed();
            }
        });
        this.popupMenu.add(this.sort);
        this.unsort = new JMenuItem(res.getString("UNSORT"));
        this.unsort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTreeEventHandler.this.unsortActionPerformed();
            }
        });
        this.popupMenu.add(this.unsort);
        jMenuItem = new JMenuItem(res.getString("ADD_NODE"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTreeEventHandler.this.addActionPerformed();
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(res.getString("REMOVE_NODE"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTreeEventHandler.this.removeActionPerformed();
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(res.getString("SEARCH"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTreeEventHandler.this.searchActionPerformed();
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(res.getString("COPY"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTreeEventHandler.this.copyActionPerformed();
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(res.getString("CUT"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTreeEventHandler.this.cutActionPerformed();
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(res.getString("PASTE"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTreeEventHandler.this.pasteActionPerformed();
            }
        });
        this.popupMenu.add(jMenuItem);
    }

    public void expandAllActionPerformed() {
        if (this.tree != null) {
            this.tree.expandAllNodes();
        }
    }

    public void collapseAllActionPerformed() {
        if (this.tree != null) {
            this.tree.collapseAllNodes();
        }
    }

    public void sortActionPerformed() {
        try {
            SortableDefaultTreeModel sortableDefaultTreeModel = (SortableDefaultTreeModel)this.tree.getModel();
            sortableDefaultTreeModel.setSortHelper(new DefaultSortHelper());
            sortableDefaultTreeModel.setOrder(true);
            TreePath[] treePathArray = this.tree.getSelectionPaths();
            for (int i = 0; i < treePathArray.length; ++i) {
                sortableDefaultTreeModel.sort((DefaultMutableTreeNode)treePathArray[i].getLastPathComponent());
            }
            this.tree.updateUI();
        }
        catch (NullPointerException nullPointerException) {
            logger.warn("TreePaths are not selected" + nullPointerException);
        }
        catch (ClassCastException classCastException) {
            logger.warn("This model doesn't support sort action!!" + classCastException);
        }
    }

    public void unsortActionPerformed() {
        try {
            SortableDefaultTreeModel sortableDefaultTreeModel = (SortableDefaultTreeModel)this.tree.getModel();
            TreePath[] treePathArray = this.tree.getSelectionPaths();
            for (int i = 0; i < treePathArray.length; ++i) {
                sortableDefaultTreeModel.unsort((DefaultMutableTreeNode)treePathArray[i].getLastPathComponent());
            }
            this.tree.updateUI();
        }
        catch (NullPointerException nullPointerException) {
            logger.warn("TreePaths are not selected" + nullPointerException);
        }
        catch (ClassCastException classCastException) {
            logger.warn("This model doesn't support sort action!!");
        }
    }

    public void addActionPerformed() {
        try {
            String string = OptionPane.showInputDialog(res.getString("Node_Name"));
            this.tree.addObject(string);
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Node is not selected" + nullPointerException);
        }
    }

    public void removeActionPerformed() {
        try {
            this.tree.removeCurrentNode();
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error(illegalArgumentException.toString());
        }
    }

    public void searchActionPerformed() {
        String string = OptionPane.showInputDialog(res.getString("SEARCH_FOR"));
        DefaultSearchHelper defaultSearchHelper = new DefaultSearchHelper();
        this.tree.searchTreeNode(string, true, defaultSearchHelper);
    }

    public void copyActionPerformed() {
        try {
            this.tree.copyTreeNode();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Nodes are not selected for copy" + nullPointerException);
        }
    }

    public void cutActionPerformed() {
        try {
            this.tree.cutTreeNode();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Nodes are not selected for cut/copy" + nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Node not present in the model" + illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public void pasteActionPerformed() {
        try {
            TreePath treePath = this.tree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.getAllowsChildren()) {
                this.tree.pasteTreeNode();
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.error(nullPointerException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.error(noSuchMethodException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error(illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.error(invocationTargetException.toString());
        }
    }
}

