/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.toolbar;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.templates.toolbar.Toolbar;

public final class ToolbarLockInfo {
    private static ToolbarLockInfo lockInstance = null;
    private CommStyleInfo lockInfo = null;
    private static final String TRUE = "true";
    private static final String LOCKED = "locked";
    private static final String TOOLBAR_LOCK_INFO_FILE = "conf/mainfrm/toolbarlockinfo";

    private ToolbarLockInfo() {
    }

    private void readSettings() {
        this.lockInfo = CommStyleManager.getInstance().getUserCommonStyleFile(TOOLBAR_LOCK_INFO_FILE);
    }

    public static ToolbarLockInfo getInstance() {
        if (null == lockInstance) {
            lockInstance = new ToolbarLockInfo();
        }
        lockInstance.readSettings();
        return lockInstance;
    }

    public boolean isToolbarLocked(Toolbar toolbar) {
        DescContainer descContainer;
        if (null == this.lockInfo || null == toolbar.getLockSaveName()) {
            return false;
        }
        AreaDescContainer areaDescContainer = this.lockInfo.getAreaDescContainer(0);
        return null != areaDescContainer && null != (descContainer = areaDescContainer.getDescContainer(toolbar.getLockSaveName())) && null != descContainer.getParasItemValue(LOCKED) && TRUE.equalsIgnoreCase(descContainer.getParasItemValue(LOCKED).trim());
    }

    public boolean setToolbarLocked(Toolbar toolbar, boolean bl) {
        if (null == toolbar.getLockSaveName() || bl == this.isToolbarLocked(toolbar)) {
            return false;
        }
        return this.setLockInfo(toolbar.getLockSaveName(), bl);
    }

    private boolean setLockInfo(String string, boolean bl) {
        AreaDescContainer areaDescContainer;
        if (null == this.lockInfo) {
            this.lockInfo = new CommStyleInfo();
            areaDescContainer = new AreaDescContainer();
            this.lockInfo.addAreaDescContainer(areaDescContainer);
        }
        if (null != (areaDescContainer = this.lockInfo.getAreaDescContainer()[0])) {
            DescContainer descContainer = areaDescContainer.getDescContainer(string);
            String string2 = "false";
            if (bl) {
                string2 = TRUE;
            }
            if (null == descContainer) {
                descContainer = new DescContainer(string);
                areaDescContainer.addDescContainer(descContainer);
            }
            this.setPara(descContainer, LOCKED, string2);
            CommStyleManager.getInstance().writeToUser(this.lockInfo, TOOLBAR_LOCK_INFO_FILE);
            return true;
        }
        return false;
    }

    private void setPara(DescContainer descContainer, String string, String string2) {
        String string3 = descContainer.getParasItemValue(string);
        if (null == string3) {
            PARA pARA = new PARA();
            pARA.setName(string);
            pARA.setValue(string2);
            descContainer.addParasItem(pARA);
        } else {
            descContainer.setParasItem(string, string2);
        }
    }
}

