/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.toolbar;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.util.log.IviewLogger;
import java.io.IOException;

public class ToolbarItemSettings {
    private static final long serialVersionUID = -4297980246111375123L;
    private static final String XY_PARA_NAME = "xyindex";
    private static final String IS_WRAPPED_PARA_NAME = "iswrapped";
    private static final String X_SPACE_PARA_NAME = "xspace";
    private static final String SAVED_ORDER_NAME = "ordernumber";
    private static final String TRUE = "true";
    private int x;
    private int y;
    private int xSpace;
    private int savedOrder;
    private boolean wrapped;
    private boolean valid = false;
    private DescContainer desc = null;
    private String toolGroupSetName = null;
    private String toolGroupName = null;
    private static IviewLogger logger = IviewLogger.getLogger(ToolbarItemSettings.class, "IVIEW");

    public ToolbarItemSettings(DescContainer descContainer) {
        try {
            if (null == descContainer || null == descContainer.getParasItem("name") || null == descContainer.getDescName()) {
                this.valid = false;
                return;
            }
            this.desc = descContainer;
            this.toolGroupSetName = descContainer.getDescName();
            this.toolGroupName = descContainer.getParasItem("name").getValue();
            PARA pARA = descContainer.getParasItem(XY_PARA_NAME);
            PARA pARA2 = descContainer.getParasItem(IS_WRAPPED_PARA_NAME);
            PARA pARA3 = descContainer.getParasItem(X_SPACE_PARA_NAME);
            PARA pARA4 = descContainer.getParasItem(SAVED_ORDER_NAME);
            if (null != pARA && null != pARA2 && null != pARA3 && null != pARA4) {
                String[] stringArray = pARA.getValue().trim().split(",");
                this.x = Integer.parseInt(stringArray[0].trim());
                this.y = Integer.parseInt(stringArray[1].trim());
                this.xSpace = Integer.parseInt(pARA3.getValue().trim());
                this.savedOrder = Integer.parseInt(pARA4.getValue().trim());
                String string = pARA2.getValue().trim();
                this.wrapped = TRUE.equals(string);
                this.valid = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.valid = false;
        }
        catch (NumberFormatException numberFormatException) {
            this.valid = false;
        }
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getXSpace() {
        return this.xSpace;
    }

    public final boolean isWrapped() {
        return this.wrapped;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final boolean isValidDesc() {
        return null != this.desc && null != this.desc.getParasItem("name") && null != this.desc.getDescName();
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public boolean savePositions(int n) {
        if (!this.isValidDesc() || !(this.desc._getRootParent() instanceof CommStyleInfo)) {
            logger.trace("Failed to save the toolbar item position as it is not a valid desc");
            return false;
        }
        CommStyleInfo commStyleInfo = (CommStyleInfo)this.desc._getRootParent();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.x).append(",").append(this.y);
        this.setPara(XY_PARA_NAME, stringBuffer.toString());
        if (this.xSpace < 0) {
            this.xSpace = 0;
        }
        this.setPara(X_SPACE_PARA_NAME, this.xSpace + "");
        this.setPara(SAVED_ORDER_NAME, n + "");
        String string = "false";
        if (this.wrapped) {
            string = TRUE;
        }
        this.setPara(IS_WRAPPED_PARA_NAME, string);
        String string2 = this.desc.getParasItem("name").getValue();
        if (null == string2) {
            string2 = "";
        }
        try {
            this.writeToUser(commStyleInfo);
            logger.trace("Saved the toolbar item '" + string2 + "' postion as " + n + " successfully.");
            this.valid = true;
        }
        catch (IOException iOException) {
            logger.trace("Failed to save the toolbar item '" + string2 + "' postion as " + n + " due to " + iOException.getMessage());
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace("Failed to save the toolbar item '" + string2 + "' postion as " + n + " due to " + illegalArgumentException.getMessage());
            bl = false;
        }
        return bl;
    }

    public boolean savePositions(int n, int n2, int n3, boolean bl, int n4) {
        if (!this.isValidDesc() || !(this.desc._getRootParent() instanceof CommStyleInfo)) {
            logger.trace("Failed to save the toolbar item position as it is not a valid desc");
            return false;
        }
        this.x = n;
        this.y = n2;
        this.xSpace = n3;
        this.wrapped = bl;
        return this.savePositions(n4);
    }

    private void writeToUser(CommStyleInfo commStyleInfo) throws IOException {
        if (null != commStyleInfo.getPluginName()) {
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(commStyleInfo.getPluginName());
            if (null != plugin) {
                plugin.getIntegrateCommStyleReader().writeToUser(commStyleInfo);
            }
        } else {
            String string = commStyleInfo.getFileName();
            CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getUserCommonStyleFile(string);
            DescContainer descContainer = null;
            if (null != commStyleInfo2) {
                for (DescContainer descContainer2 : commStyleInfo.getAreaDescContainer(0).getDescContainer()) {
                    descContainer = null;
                    for (DescContainer descContainer3 : commStyleInfo2.getAreaDescContainer(0).getDescContainer()) {
                        if (!ResourceUtil.areEquals(descContainer3.getDescName(), descContainer2.getDescName())) continue;
                        descContainer = descContainer3;
                        break;
                    }
                    if (null == descContainer) {
                        commStyleInfo2.getAreaDescContainer(0).addDescContainer(descContainer2);
                        continue;
                    }
                    descContainer.mergeDescContainer(descContainer2);
                }
                CommStyleManager.getInstance().writeToUser(commStyleInfo2);
            } else {
                CommStyleManager.getInstance().writeToUser(commStyleInfo);
            }
        }
    }

    private void setPara(String string, String string2) {
        String string3 = this.desc.getParasItemValue(string);
        if (null == string3) {
            PARA pARA = new PARA();
            pARA.setName(string);
            pARA.setValue(string2);
            this.desc.addParasItem(pARA);
        } else {
            this.desc.setParasItem(string, string2);
        }
    }

    public final String getToolGroupSetName() {
        return this.toolGroupSetName;
    }

    public final String getToolGroupName() {
        return this.toolGroupName;
    }

    public final int getSavedOrder() {
        return this.savedOrder;
    }

    public void setPositions(int n, int n2, int n3, boolean bl) {
        this.x = n;
        this.y = n2;
        this.xSpace = n3;
        this.wrapped = bl;
    }

    public void logInfo() {
        String string;
        String string2;
        String string3;
        if (!this.isValidDesc() || !(this.desc._getRootParent() instanceof CommStyleInfo)) {
            logger.trace("Loaded one toolgroup , but the toolgroup desc loaded is not valid.");
        }
        if (null == (string3 = this.toolGroupName)) {
            string3 = "";
        }
        if (null == (string2 = this.toolGroupSetName)) {
            string2 = "";
        }
        if (null != (string = "Loaded a toolgroup in toolbar : Name = '" + string3 + "' , SetName = '" + string2 + "' , Saved order = '" + this.savedOrder + "' , XY = '" + this.x + ',' + this.y + "' , XSpace = '" + this.xSpace + "' , Wrapped = '" + this.wrapped)) {
            logger.trace(string);
        }
    }
}

