/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.toolbar;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.ToggleButton;
import com.swimap.iview.commstyle.commini.ToolBarButton;
import com.swimap.iview.commstyle.commini.ToolBarHandle;
import com.swimap.iview.commstyle.commini.ToolGroup;
import com.swimap.iview.commstyle.commini.ToolGroupSet;
import com.swimap.iview.commstyle.commini.UIObjMng;
import com.swimap.iview.commstyle.commini.gui.IVSeparator;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.customizedialog.CustomizeDialog;
import com.swimap.iview.framework.customizedialog.SelectObjectVector;
import com.swimap.iview.framework.modulemanagement.ModuleList;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.toolbarmanagement.ToolGroupSelectObject;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.toolbar.DefaultToolGroupRelocator;
import com.swimap.iview.templates.toolbar.IToolItemRelocator;
import com.swimap.iview.templates.toolbar.ToolBarLayout;
import com.swimap.iview.templates.toolbar.ToolbarItemSettings;
import com.swimap.iview.templates.toolbar.ToolbarLockInfo;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public class Toolbar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static IviewLogger logger = IviewLogger.getLogger(Toolbar.class, "IVIEW");
    private static final int INITIAL_CAPACITY = 10;
    private JMenuItem customizeMenuItem = null;
    private ActionListener customMenuActionListener = null;
    private JMenuItem resetMenuItem = null;
    private ActionListener resetMenuActionListener = null;
    private JMenuItem lockMenuItem = null;
    private ActionListener lockActionListener = null;
    private ComponentAdapter componentAdapter = null;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/toolbar/Res");
    private static final int MIN_WIDTH = 1;
    public static final int PREFER_HEIGHT = 28;
    private static final int MAX_WIDTH = 2048;
    private static final int MAX_HEIGHT = 768;
    private static final int NO_SERIAL_NUMBER = -1;
    private boolean showPopupMenuEnable = true;
    private Vector<ToolGroupSet> toolGroupSetVct = new Vector(10);
    private Vector<ToolGroupSet> uncustimizedToolbar = new Vector(10);
    private Vector<ToolGroupSet> dynamicToolbarGoups = new Vector(10);
    private JPanel rightPanel = new JPanel(new FlowLayout(2, 0, 0));
    private static final int DEF_VECTOR_SIZE = 10;
    private static final String EMPTY_STRING = "";
    private static final int HGAP = 2;
    private transient IToolItemRelocator relocator = new DefaultToolGroupRelocator();
    private boolean containsPanel = false;
    private Map<Integer, Component> originalComponents = Collections.synchronizedMap(new TreeMap());
    private Map<Integer, Component> currentComponents = Collections.synchronizedMap(new TreeMap());
    private Map<Integer, Component> draggedComponents = Collections.synchronizedMap(new TreeMap());
    private String lockSaveName = null;
    private boolean currentSettingsEnabled = false;
    private int oldToolbarWidth = -1;
    private int newToolbarWidth = -1;
    private int increasedWidth = -1;
    private static final boolean TRUE = true;
    private static final boolean FALSE = false;
    private boolean oldFullScreenState = false;
    private int customWidth = -1;
    private transient MouseAdapter showPopupMenuMouseAdapter = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            if ((mouseEvent.getModifiers() & 4) != 0 && Toolbar.this.showPopupMenuEnable && null != (jPopupMenu = Toolbar.this.getPopupMenu())) {
                ScreenToolKit.showPopupMenu(jPopupMenu, mouseEvent);
            }
            Toolbar.this.revalidate();
            Toolbar.this.repaint();
        }
    };
    private transient ComponentListener btnVisibleListener = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            Toolbar.this.updateToolbarSafely();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            Toolbar.this.updateToolbarSafely();
        }
    };

    public Toolbar(CommStyleInfo[] commStyleInfoArray) {
        this.jbInit(commStyleInfoArray);
        this.setVisible(true);
        if (null != commStyleInfoArray) {
            this.updateToolbarSafely();
            this.resetPositions(true, this.originalComponents);
            this.updateUISafely();
            this.currentSettingsEnabled = true;
        }
    }

    public void setOriginalComponentsPositions() {
        int n = 0;
        this.originalComponents.clear();
        for (Component component : this.getComponents()) {
            this.originalComponents.put(n++, component);
        }
    }

    public void setCurrentComponentsPositions() {
        if (!this.currentSettingsEnabled) {
            return;
        }
        int n = 0;
        this.currentComponents.clear();
        for (Component component : this.getComponents()) {
            this.currentComponents.put(n++, component);
            if (!(component instanceof ToolGroup)) continue;
            ((ToolGroup)component).savePositions(n, true);
            ((ToolGroup)component).setCurrentSetings();
        }
    }

    public void synchCurrentComponents() {
        if (!this.currentSettingsEnabled) {
            return;
        }
        List<Component> list = Arrays.asList(this.getComponents());
        HashSet<Integer> hashSet = new HashSet<Integer>(this.currentComponents.keySet());
        Iterator iterator = hashSet.iterator();
        Integer n = null;
        Component component = null;
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            component = this.currentComponents.get(n);
            if (list.contains(component)) continue;
            this.currentComponents.remove(n);
            this.synchCurrentComponents();
            break;
        }
        hashSet.clear();
    }

    private void jbInit(CommStyleInfo[] commStyleInfoArray) {
        this.init();
        ArrayList<String> arrayList = null;
        Iterator<String> iterator = null;
        CommStyleInfo commStyleInfo = null;
        String string2 = null;
        if (null != commStyleInfoArray) {
            for (CommStyleInfo commStyleInfo2 : commStyleInfoArray) {
                if (null == commStyleInfo2) continue;
                arrayList = this.getToolGroupSetDesc(commStyleInfo2);
                for (String string2 : arrayList) {
                    commStyleInfo = this.getSavedToolbarGroupConfigFile(commStyleInfo2, string2);
                    if (null == commStyleInfo) {
                        commStyleInfo = commStyleInfo2;
                        logger.trace("Saved common style not found,loading the new file for : " + string2);
                    } else {
                        logger.trace("Loading the saved common style file for : " + string2);
                    }
                    this.loadDynamicToolbarGroup(commStyleInfo, string2);
                }
            }
        }
        this.addToolbarResizeListener();
        this.setBorder(new EtchedBorder(){

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(0, 1, 0, 1);
            }
        });
    }

    private void addToolbarResizeListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Toolbar.this.revalidate();
            }
        });
        this.componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                boolean bl = ScreenToolKit.getFullScreenFlg();
                if (Toolbar.this.oldFullScreenState && !bl) {
                    Toolbar.this.resetPositions();
                    Toolbar.this.updateUISafely();
                }
                Toolbar.this.oldFullScreenState = bl;
                logger.trace("Update the toolbar layout screen width size");
                ToolBarLayout.updateScreenWidth();
            }
        };
        if (null != FrameworkUtilities.getMainFrame()) {
            FrameworkUtilities.getMainFrame().addComponentListener(this.componentAdapter);
        }
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                Toolbar.this.revalidate();
            }

            @Override
            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                Container container = hierarchyEvent.getChangedParent();
                if (container instanceof Window || container instanceof JInternalFrame) {
                    Toolbar.this.oldToolbarWidth = Toolbar.this.newToolbarWidth;
                    Toolbar.this.newToolbarWidth = (int)Toolbar.this.getPreferredSize().getWidth();
                    Toolbar.this.increasedWidth = Toolbar.this.newToolbarWidth - Toolbar.this.oldToolbarWidth;
                    if (Toolbar.this.increasedWidth > 2) {
                        Toolbar.this.resetPositions();
                        Toolbar.this.updateUISafely();
                    } else if (Toolbar.this.increasedWidth < 0) {
                        if (Toolbar.this.getRightPanel().getComponentCount() > 0) {
                            Toolbar.this.resetPositions();
                        }
                        Toolbar.this.revalidate();
                        Toolbar.this.updateUISafely();
                    }
                }
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                Toolbar.this.revalidate();
                Toolbar.this.updateUISafely();
            }
        });
    }

    public void resetPositions() {
        logger.trace("Begin resetPositions()");
        if (null != this.currentComponents && this.currentComponents.size() > 0) {
            this.resetPositions(false, this.currentComponents);
        } else {
            this.resetPositions(true, this.originalComponents);
        }
        logger.trace("End resetPositions()");
    }

    @Override
    public void revalidate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Toolbar.super.revalidate();
                if (null != Toolbar.this.getParent()) {
                    Toolbar.this.getParent().validate();
                }
            }
        });
    }

    private void init() {
        this.setLayout(new ToolBarLayout());
        this.customizeMenuItem = new JMenuItem(res.getString("Toolbar_Customize_"));
        this.customizeMenuItem.setMnemonic('C');
        this.customizeMenuItem.setName("customizeMenuItem_toolbar");
        this.setCustomActionListener();
        this.customizeMenuItem.addActionListener(this.customMenuActionListener);
        this.resetMenuItem = new JMenuItem(res.getString("Toolbar_Reset_"));
        this.resetMenuItem.setMnemonic('R');
        this.resetMenuItem.setName("resetMenuItem_toolbar");
        this.resetMenuItem.setEnabled(false);
        this.setResetActionListener();
        this.resetMenuItem.addActionListener(this.resetMenuActionListener);
        this.lockMenuItem = new JCheckBoxMenuItem(res.getString("Toolbar_Lock_"));
        this.lockMenuItem.setMnemonic('L');
        this.lockMenuItem.setName("lockMenuItem_toolbar");
        this.setLockActionListener();
        this.lockMenuItem.addActionListener(this.lockActionListener);
        this.resetLockInfo();
        this.setMinimumSize(new Dimension(1, 28));
        this.setMaximumSize(new Dimension(2048, 768));
        this.addMouseListener(this.showPopupMenuMouseAdapter);
    }

    private void setCustomActionListener() {
        this.customMenuActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.launchCustomizeDialog();
            }
        };
    }

    private void setResetActionListener() {
        this.resetMenuActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Toolbar.this.rearrangeSavedOrder()) {
                    Toolbar.this.rearrangeOriginalOrder();
                }
                Toolbar.this.resetPositions(true, Toolbar.this.originalComponents);
                Toolbar.this.setCurrentComponentsPositions();
                Toolbar.this.resetMenuItem.setEnabled(false);
                Toolbar.this.draggedComponents.clear();
            }
        };
    }

    private void setLockActionListener() {
        this.lockActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.togglePositionsChangeLock();
            }
        };
    }

    private void togglePositionsChangeLock() {
        boolean bl = false;
        if (this.lockMenuItem.isSelected()) {
            bl = true;
        }
        this.applyLockInfo(bl);
        this.updateAllSeprators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPositions(boolean bl, Map<Integer, Component> map) {
        if (!this.currentSettingsEnabled) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Object object2;
            Component[] componentArray = this.getComponents();
            for (Component serializable : componentArray) {
                if (!(serializable instanceof ToolGroup)) continue;
                ((ToolGroup)serializable).setPositions(bl);
            }
            if (map.size() > 0) {
                object2 = map;
                synchronized (object2) {
                    Iterator<Integer> iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        this.remove(map.get(iterator.next()));
                    }
                }
            }
            object2 = null;
            if (this.getRightPanel().getComponentCount() > 0) {
                object2 = this.getRightPanel();
                this.remove((Component)object2);
            }
            if (map.size() > 0) {
                Map<Integer, Component> map2 = map;
                synchronized (map2) {
                    Set<Map.Entry<Integer, Component>> set = map.entrySet();
                    Object var8_12 = null;
                    Component component = null;
                    int n = 0;
                    for (Map.Entry<Integer, Component> entry : set) {
                        Integer n2 = entry.getKey();
                        component = entry.getValue();
                        this.add(component, n++);
                        if (n2 != 0 || !(component instanceof ToolGroup)) continue;
                        ((ToolGroup)component).setWrapped(false);
                    }
                }
            }
            if (null != object2) {
                this.add((Component)object2);
                logger.debug("add ToolbarPanel....." + ((Component)object2).getBounds());
            }
        }
        this.updateAllSeprators();
        if (0 == this.draggedComponents.size()) {
            this.resetMenuItem.setEnabled(false);
        }
        this.revalidate();
    }

    @Override
    public Component add(Component component) {
        Component component2 = super.add(component);
        if (component2 instanceof ToolGroup) {
            if (this.lockMenuItem.isSelected()) {
                ((ToolGroup)component2).removeHandler();
            } else {
                ((ToolGroup)component2).addHandler();
            }
        }
        return component2;
    }

    public void savePositions() {
        this.setCurrentComponentsPositions();
        this.rearrangeCurrentOrder();
        Collection<Component> collection = this.draggedComponents.values();
        int n = 1;
        for (Component component : collection) {
            if (!(component instanceof ToolGroup)) continue;
            ((ToolGroup)component).savePositions(n++, true);
        }
        this.setOriginalComponentsPositions();
        this.revalidate();
        ToolbarLockInfo.getInstance().setToolbarLocked(this, this.lockMenuItem.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeOldPositions() {
        Map<Integer, Component> map = this.getOriginalComponents();
        Component component = null;
        Map<Integer, Component> map2 = map;
        synchronized (map2) {
            Iterator<Integer> iterator = map.keySet().iterator();
            int n = 1;
            while (iterator.hasNext()) {
                component = map.get(iterator.next());
                if (!(component instanceof ToolGroup)) continue;
                ((ToolGroup)component).savePositions(n++, false);
            }
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.toolGroupSetVct.size() <= 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        Enumeration<ToolGroupSet> enumeration = this.toolGroupSetVct.elements();
        ToolGroupSet toolGroupSet = null;
        ToolGroup toolGroup = null;
        ToolGroupMenuItem toolGroupMenuItem = null;
        int n = 0;
        while (enumeration.hasMoreElements()) {
            toolGroupSet = enumeration.nextElement();
            this.updateToolGroupSet(toolGroupSet);
            n = toolGroupSet.getToolGroupCount();
            for (int i = 0; i < n; ++i) {
                toolGroup = toolGroupSet.getToolGroup(i);
                toolGroupMenuItem = new ToolGroupMenuItem(toolGroup);
                toolGroupMenuItem.setName(toolGroup.getID());
                jPopupMenu.add(toolGroupMenuItem);
            }
        }
        if (null != this.customizeMenuItem) {
            jPopupMenu.add(new JSeparator());
            jPopupMenu.add(this.customizeMenuItem);
        }
        jPopupMenu.add(new JSeparator());
        jPopupMenu.add(this.resetMenuItem);
        jPopupMenu.add(this.lockMenuItem);
        return jPopupMenu;
    }

    public void updateToolbarSafely() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateToolbars();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Toolbar.this.updateToolbars();
                }
            });
        }
    }

    public boolean updateToolbars() {
        int n;
        int n2;
        ToolGroup toolGroup;
        ToolGroupSet toolGroupSet;
        Enumeration<ToolGroupSet> enumeration;
        logger.trace("Updating the toolbar, toolgroup set size: " + this.toolGroupSetVct.size());
        Component component = null;
        this.removeAll();
        if (this.toolGroupSetVct.size() > 0) {
            enumeration = this.toolGroupSetVct.elements();
            toolGroupSet = null;
            toolGroup = null;
            n2 = 0;
            while (enumeration.hasMoreElements()) {
                toolGroupSet = enumeration.nextElement();
                n2 = toolGroupSet.getToolGroupCount();
                for (n = 0; n < n2; ++n) {
                    toolGroup = toolGroupSet.getToolGroup(n);
                    toolGroup.addMouseListener(this.showPopupMenuMouseAdapter);
                    this.add(toolGroup);
                    logger.trace("Tool group is added to toolbar: " + toolGroup.getName());
                    if (!toolGroup.isVisible()) continue;
                    component = this.separatorUpdate(toolGroup, component);
                }
            }
        }
        if (this.uncustimizedToolbar.size() > 0) {
            enumeration = this.uncustimizedToolbar.elements();
            toolGroupSet = null;
            toolGroup = null;
            n2 = 0;
            while (enumeration.hasMoreElements()) {
                toolGroupSet = enumeration.nextElement();
                n2 = toolGroupSet.getToolGroupCount();
                for (n = 0; n < n2; ++n) {
                    toolGroup = toolGroupSet.getToolGroup(n);
                    if (null == toolGroup) continue;
                    this.add(toolGroup);
                    if (!toolGroup.isVisible()) continue;
                    component = this.separatorUpdate(toolGroup, component);
                }
            }
        }
        if (component != null && component instanceof IVSeparator) {
            component.setVisible(false);
            component = null;
        }
        if (this.rightPanel.getComponentCount() > 0) {
            this.add(this.rightPanel);
            logger.debug("add ToolbarPanel....." + this.rightPanel.getBounds());
            this.containsPanel = true;
        }
        this.rearrangeSavedOrder();
        this.setOriginalComponentsPositions();
        this.updateAllSeprators();
        try {
            this.validate();
            this.repaint();
            if (null != this.getParent()) {
                this.getParent().doLayout();
                this.getParent().validate();
            }
            logger.trace("Completed Updating the toolbar, toolgroup set size: " + this.toolGroupSetVct.size());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    private Component separatorUpdate(ToolGroup toolGroup, Component component) {
        Component component2 = component;
        if (toolGroup == null) {
            return null;
        }
        Component[] componentArray = toolGroup.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i].isVisible()) {
                if (component2 == null) {
                    component2 = componentArray[i];
                    if (!(component2 instanceof IVSeparator)) continue;
                    component2.setVisible(false);
                    component2 = null;
                    continue;
                }
                if ((component2 instanceof IVSeparator || component2 instanceof ToolBarHandle) && componentArray[i] instanceof IVSeparator) {
                    componentArray[i].setVisible(false);
                    continue;
                }
                if (i > 0 && componentArray[i] instanceof ToolBarHandle) {
                    componentArray[i].setVisible(false);
                    continue;
                }
                component2 = componentArray[i];
                continue;
            }
            if (component2 == null || !(componentArray[i] instanceof IVSeparator) || component2 instanceof IVSeparator || component2 instanceof ToolBarHandle) continue;
            componentArray[i].setVisible(true);
            component2 = componentArray[i];
        }
        this.hideLastVisibleSeperator(toolGroup, toolGroup.getComponentCount() - 1);
        return component2;
    }

    private void hideLastVisibleSeperator(ToolGroup toolGroup, int n) {
        if (this.lockMenuItem.isSelected() || n >= toolGroup.getComponentCount() || n < 0) {
            return;
        }
        Component component = toolGroup.getComponent(n);
        if (!component.isVisible()) {
            this.hideLastVisibleSeperator(toolGroup, n - 1);
        } else if (component instanceof IVSeparator) {
            component.setVisible(false);
        }
    }

    public boolean loadDynamicToolbarGroup(CommStyleInfo commStyleInfo, String string) {
        boolean bl = false;
        if (null == commStyleInfo || null == string) {
            logger.debug("styleInfo and toolGroupSetID should not be null.");
            return bl;
        }
        ToolGroupSet toolGroupSet = UIObjMng.getInstance().getToolGroupSet(commStyleInfo, string);
        bl = this.loadToolbarButtonGroup(toolGroupSet, string);
        return bl;
    }

    private boolean loadToolbarButtonGroup(ToolGroupSet toolGroupSet, String string) {
        if (null == toolGroupSet || null == string) {
            return false;
        }
        CommandManager.getInstance().addToolGroupSet(toolGroupSet, FrameworkCommandProcessor.getInstance());
        ToolGroupSet toolGroupSet2 = this.getToolGroupSet(string);
        this.updateToolGroupSet(toolGroupSet);
        if (null != toolGroupSet2) {
            int n = toolGroupSet.getToolGroupCount();
            for (int i = 0; i < n; ++i) {
                toolGroupSet2.addToolGroup(toolGroupSet.getToolGroup(i));
            }
            this.dynamicToolbarGoups.add(toolGroupSet);
        } else {
            this.addToolGroupSet(toolGroupSet);
        }
        this.addBtnVisibleListener(toolGroupSet);
        if (this.currentSettingsEnabled) {
            this.filterModuleToolbar(ModuleList.getNotLicensedModule());
            this.setCurrentComponentsPositions();
            this.updateToolbarSafely();
            this.refreshCurrent();
        }
        this.updateUISafely();
        return true;
    }

    protected void updateToolGroupSet(ToolGroupSet toolGroupSet) {
    }

    public void filterModuleToolbar(ArrayList arrayList) {
        logger.trace("Begin filterModuleToolbar()");
        if (null == arrayList || arrayList.size() == 0) {
            return;
        }
        HashMap hashMap = CommandManager.getInstance().getModuleToCommandIDMap();
        String string = null;
        ArrayList arrayList2 = null;
        int n = 0;
        String string2 = null;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            string = (String)arrayList.get(i);
            arrayList2 = (ArrayList)hashMap.get(string);
            if (arrayList2 == null) continue;
            n = arrayList2.size();
            for (int j = 0; j < n; ++j) {
                string2 = (String)arrayList2.get(j);
                logger.trace("Remove toolbars by commandID = '" + string2 + "' in module:" + string);
                this.removeToolbarByCommandID(string2);
            }
        }
        this.validateToolbar();
        this.updateToolbarSafely();
        logger.trace("End filterModuleToolbar()");
    }

    public boolean loadDynamicToolbarGroup(String string, String string2) {
        return this.loadDynamicToolbarGroupOfExtPath(string, string2, null);
    }

    public boolean loadDynamicToolbarGroupOfExtPath(String string, String string2, String string3) {
        ToolGroupSet toolGroupSet = null;
        toolGroupSet = null == string3 ? UIObjMng.getInstance().getToolGroupSet(string, string2) : UIObjMng.getInstance().getToolGroupSetOfExtPath(string, string2, string3);
        if (null == toolGroupSet) {
            logger.debug("Can't get toolGroupSet: " + string2);
            return false;
        }
        CommandManager.getInstance().addToolGroupSet(toolGroupSet, FrameworkCommandProcessor.getInstance());
        ToolGroupSet toolGroupSet2 = this.getToolGroupSet(string2);
        this.updateToolGroupSet(toolGroupSet);
        if (null != toolGroupSet2) {
            int n = toolGroupSet.getToolGroupCount();
            for (int i = 0; i < n; ++i) {
                toolGroupSet2.addToolGroup(toolGroupSet.getToolGroup(i));
            }
            this.dynamicToolbarGoups.add(toolGroupSet);
        } else {
            this.addToolGroupSet(toolGroupSet);
        }
        this.addBtnVisibleListener(toolGroupSet);
        this.filterModuleToolbar(ModuleList.getNotLicensedModule());
        this.setCurrentComponentsPositions();
        this.updateToolbarSafely();
        this.refreshCurrent();
        this.updateUISafely();
        return true;
    }

    public void updateUISafely() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Toolbar.super.updateUI();
            }
        });
    }

    public boolean loadToolbarGroupsExt(String string, String string2) {
        if (null != this.getToolGroupSet(string2)) {
            logger.error(string2 + " had been loaded.");
            return false;
        }
        ToolGroupSet toolGroupSet = UIObjMng.getInstance().getToolGroupSet(string, string2);
        if (null == toolGroupSet) {
            return false;
        }
        CommandManager.getInstance().addToolGroupSet(toolGroupSet, FrameworkCommandProcessor.getInstance());
        this.uncustimizedToolbar.add(toolGroupSet);
        this.toolGroupSetVct.trimToSize();
        this.addBtnVisibleListener(toolGroupSet);
        this.setCurrentComponentsPositions();
        this.updateToolbarSafely();
        toolGroupSet.updateToolGroupSet();
        this.refreshCurrent();
        this.updateUISafely();
        return true;
    }

    public boolean loadToolbarButtonGroups(String string, String string2) {
        if (null != this.getToolGroupSet(string2)) {
            logger.error("the tool bar group set have been loaded, group set id : " + string2);
            return false;
        }
        ToolGroupSet toolGroupSet = UIObjMng.getInstance().getToolGroupSet(string, string2);
        if (null == toolGroupSet) {
            return false;
        }
        CommandManager.getInstance().addToolGroupSet(toolGroupSet, FrameworkCommandProcessor.getInstance());
        this.addToolGroupSet(toolGroupSet);
        this.addBtnVisibleListener(toolGroupSet);
        this.setCurrentComponentsPositions();
        this.updateToolbarSafely();
        toolGroupSet.updateToolGroupSet();
        this.refreshCurrent();
        this.updateUISafely();
        return true;
    }

    public boolean unloadToolbarButtonGroups(String string) {
        ToolGroupSet toolGroupSet = this.getToolGroupSet(string);
        if (null == toolGroupSet) {
            logger.debug("Can't get toolGroupSet: " + string);
            return false;
        }
        this.toolGroupSetVct.remove(toolGroupSet);
        this.toolGroupSetVct.trimToSize();
        this.updateToolbars();
        this.synchCurrentComponents();
        this.resetPositions();
        this.updateUISafely();
        return true;
    }

    public boolean unLoadToolbarGroupsExt(String string) {
        int n = this.uncustimizedToolbar.size();
        ToolGroupSet toolGroupSet = null;
        for (int i = 0; i < n; ++i) {
            toolGroupSet = this.uncustimizedToolbar.elementAt(i);
            if (!ResourceUtil.areStringEquals(toolGroupSet.getID(), string)) continue;
            this.uncustimizedToolbar.removeElementAt(i);
            int n2 = toolGroupSet.getToolGroupCount();
            for (int j = 0; j < n2; ++j) {
                this.remove(toolGroupSet.getToolGroup(j));
            }
            this.updateToolbars();
            this.synchCurrentComponents();
            this.resetPositions();
            this.updateUISafely();
            return true;
        }
        return false;
    }

    public boolean unloadDynamicToolbarGroup(String string, String string2) {
        if (null == string || null == string2) {
            return false;
        }
        ToolGroupSet toolGroupSet = UIObjMng.getInstance().getToolGroupSet(string, string2);
        ToolGroupSet toolGroupSet2 = this.getToolGroupSet(string2);
        if (null != toolGroupSet2) {
            int n = toolGroupSet.getToolGroupCount();
            for (int i = 0; i < n; ++i) {
                this.clearToolGroup(toolGroupSet.getToolGroup(i), toolGroupSet2);
            }
            this.dynamicToolbarGoups.remove(toolGroupSet);
            if (null != toolGroupSet2 && toolGroupSet2.getToolGroupCount() == 0) {
                logger.trace("Removing toolgroup:" + toolGroupSet2);
                this.toolGroupSetVct.remove(toolGroupSet2);
            }
            this.toolGroupSetVct.trimToSize();
        }
        this.updateToolbarSafely();
        this.synchCurrentComponents();
        this.resetPositions();
        this.updateUISafely();
        return true;
    }

    public boolean unloadDynamicToolbarGroup(CommStyleInfo commStyleInfo, String string) {
        boolean bl = false;
        if (null == commStyleInfo || null == string) {
            logger.debug("styleInfo and toolGroupSetID should not be null.");
            return bl;
        }
        bl = this.unloadDynamicToolbarGroup(commStyleInfo.getFileName(), string);
        return bl;
    }

    private boolean clearToolGroup(ToolGroup toolGroup, ToolGroupSet toolGroupSet) {
        if (toolGroup == null || toolGroupSet == null) {
            return false;
        }
        int n = toolGroupSet.getToolGroupCount();
        for (int i = 0; i < n; ++i) {
            if (!ResourceUtil.areStringEquals(toolGroupSet.getToolGroup(i).getID(), toolGroup.getID())) continue;
            this.clearToolGroupButton(toolGroup, toolGroupSet.getToolGroup(i));
            if (toolGroupSet.getToolGroup(i).getButtonCount() != 0) break;
            toolGroupSet.removeToolGroup(toolGroupSet.getToolGroup(i));
            break;
        }
        return true;
    }

    public boolean clearToolGroupButton(ToolGroup toolGroup, ToolGroup toolGroup2) {
        int n = toolGroup.getButtonCount();
        Component component = null;
        String string = null;
        for (int i = 0; i < n; ++i) {
            component = toolGroup.getButton(i);
            String string2 = string = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
            if (null == string) {
                string = (String)((JComponent)component).getClientProperty("iview.component.id");
            }
            toolGroup2.removeButton(string);
        }
        return true;
    }

    public void validateToolbar() {
        ToolGroupSet toolGroupSet = null;
        for (int i = 0; i < this.toolGroupSetVct.size(); ++i) {
            toolGroupSet = this.toolGroupSetVct.elementAt(i);
            this.validateEmptyToolGroup(toolGroupSet);
        }
    }

    private void validateEmptyToolGroup(ToolGroupSet toolGroupSet) {
        ToolGroup toolGroup = null;
        boolean bl = false;
        for (int i = 0; i < toolGroupSet.getToolGroupCount(); ++i) {
            toolGroup = toolGroupSet.getToolGroup(i);
            bl = this.isEmptyToolGroup(toolGroup);
            if (!bl) continue;
            toolGroupSet.removeToolGroup(toolGroup);
        }
    }

    private boolean isEmptyToolGroup(ToolGroup toolGroup) {
        Component component = null;
        int n = toolGroup.getComponentCount();
        for (int i = 0; i < n; ++i) {
            component = toolGroup.getComponent(i);
            if (!(component instanceof ToolBarButton)) continue;
            return false;
        }
        return true;
    }

    public void removeToolbarByCommandID(String string) {
        ArrayList arrayList = CommandManager.getInstance().getAbstractButton(string);
        AbstractButton abstractButton = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            abstractButton = (AbstractButton)arrayList.get(i);
            if (!(abstractButton instanceof JButton)) continue;
            Container container = abstractButton.getParent();
            if (container != null) {
                container.remove(abstractButton);
            }
            arrayList.remove(i);
            --i;
            --n;
        }
    }

    public void addBtnVisibleListener(ToolGroupSet toolGroupSet) {
        int n = toolGroupSet.getToolGroupCount();
        ToolGroup toolGroup = null;
        int n2 = 0;
        Component component = null;
        for (int i = 0; i < n; ++i) {
            toolGroup = toolGroupSet.getToolGroup(i);
            n2 = toolGroup.getButtonCount();
            for (int j = 0; j < n2; ++j) {
                component = toolGroup.getButton(j);
                if (!(component instanceof AbstractButton)) continue;
                AbstractButton abstractButton = (AbstractButton)component;
                DescContainer descContainer = null;
                try {
                    descContainer = CommandManager.getInstance().getCommandDescContainer(abstractButton.getActionCommand());
                }
                catch (Exception exception) {
                    return;
                }
                if (descContainer == null) {
                    return;
                }
                String string = descContainer.getParasItemValue("actionType");
                if (!"aic".equals(string)) continue;
                abstractButton.addComponentListener(this.btnVisibleListener);
            }
        }
    }

    private void removeBtnVisibleListener(ToolGroupSet toolGroupSet) {
        int n = toolGroupSet.getToolGroupCount();
        ToolGroup toolGroup = null;
        int n2 = 0;
        Component component = null;
        for (int i = 0; i < n; ++i) {
            toolGroup = toolGroupSet.getToolGroup(i);
            n2 = toolGroup.getButtonCount();
            for (int j = 0; j < n2; ++j) {
                component = toolGroup.getButton(j);
                if (!(component instanceof AbstractButton)) continue;
                AbstractButton abstractButton = (AbstractButton)component;
                DescContainer descContainer = null;
                try {
                    descContainer = CommandManager.getInstance().getCommandDescContainer(abstractButton.getActionCommand());
                }
                catch (Exception exception) {
                    return;
                }
                if (descContainer == null) {
                    return;
                }
                String string = descContainer.getParasItemValue("actionType");
                if (!"aic".equals(string)) continue;
                abstractButton.removeComponentListener(this.btnVisibleListener);
            }
        }
    }

    public void addToolGroupSet(ToolGroupSet toolGroupSet) {
        int n = toolGroupSet.getSerialNumber();
        if (n == -1) {
            this.toolGroupSetVct.add(toolGroupSet);
        } else {
            int n2 = this.getToolGroupSetPos(n);
            if (n2 < this.toolGroupSetVct.size()) {
                this.toolGroupSetVct.insertElementAt(toolGroupSet, n2);
            } else {
                this.toolGroupSetVct.add(toolGroupSet);
            }
        }
        this.toolGroupSetVct.trimToSize();
    }

    private int getToolGroupSetPos(int n) {
        int n2 = this.toolGroupSetVct.size();
        int n3 = 0;
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            n4 = this.toolGroupSetVct.elementAt(n3).getSerialNumber();
            if (n4 == -1 || n4 <= n) continue;
            return n3;
        }
        return n3;
    }

    public void launchCustomizeDialog() {
        Container container = this;
        while (container.getParent() != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        CustomizeDialog customizeDialog = null;
        try {
            customizeDialog = new CustomizeDialog((Frame)container, res.getString("Toolbar_KEY"), res.getString("Toolbar_KEY1"), res.getString("Toolbar_KEY2"), this.getToolGroupSelectObjects(), this);
        }
        catch (Exception exception) {
            customizeDialog = new CustomizeDialog(FrameworkUtilities.getMainFrame(), res.getString("Toolbar_KEY"), res.getString("Toolbar_KEY1"), res.getString("Toolbar_KEY2"), this.getToolGroupSelectObjects(), this);
        }
        customizeDialog.show();
    }

    private SelectObjectVector getToolGroupSelectObjects() {
        SelectObjectVector selectObjectVector = new SelectObjectVector();
        if (this.toolGroupSetVct.size() <= 0) {
            return selectObjectVector;
        }
        Enumeration<ToolGroupSet> enumeration = this.toolGroupSetVct.elements();
        ToolGroupSet toolGroupSet = null;
        ToolGroup toolGroup = null;
        int n = 0;
        while (enumeration.hasMoreElements()) {
            toolGroupSet = enumeration.nextElement();
            n = toolGroupSet.getToolGroupCount();
            for (int i = 0; i < n; ++i) {
                toolGroup = toolGroupSet.getToolGroup(i);
                if (null == toolGroup) {
                    logger.error("The toolGroup which get from ToolGroupSet is null! ");
                    continue;
                }
                selectObjectVector.add(new ToolGroupSelectObject(toolGroup));
            }
        }
        return selectObjectVector;
    }

    public void setPopupMenuEnable(boolean bl) {
        this.showPopupMenuEnable = bl;
    }

    private ArrayList<String> getToolGroupSetDesc(CommStyleInfo commStyleInfo) {
        if (null == commStyleInfo) {
            return null;
        }
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (DescContainer descContainer : commStyleInfo.getAreaDescContainer(0).getDescContainer()) {
            string = descContainer.getParasItemValue("type");
            if (null == string || !"ToolGroupSet".equals(descContainer.getParasItem("type").getValue())) continue;
            arrayList.add(descContainer.getDescName());
        }
        return arrayList;
    }

    private CommStyleInfo getSavedToolbarGroupConfigFile(CommStyleInfo commStyleInfo, String string) {
        if (null == commStyleInfo || null == string) {
            return null;
        }
        if (null != commStyleInfo.getPluginName()) {
            String string2 = null;
            try {
                string2 = commStyleInfo.getRelatFileName();
                if (null == string2) {
                    return null;
                }
                string2 = string2.substring(0, string2.lastIndexOf(46));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(commStyleInfo.getPluginName());
            if (null != plugin && ResourceUtil.areEquals(plugin.getPluginName(), commStyleInfo.getPluginName())) {
                return plugin.getIntegrateCommStyleReader().getUserCommStyleInfo(string2);
            }
        } else {
            String string3 = commStyleInfo.getFileName();
            String string4 = CommStyleManager.getInstance().checkPersonalStyleFile(string3);
            return CommStyleManager.getInstance().getAbsCommStyleFile(string4);
        }
        return null;
    }

    public boolean storeToolbarSetting() {
        ToolGroupSet toolGroupSet;
        Enumeration<ToolGroupSet> enumeration;
        if (this.toolGroupSetVct.size() > 0) {
            enumeration = this.toolGroupSetVct.elements();
            toolGroupSet = null;
            while (enumeration.hasMoreElements()) {
                toolGroupSet = enumeration.nextElement();
                toolGroupSet.saveToolGroupSetSetting();
            }
        }
        if (this.dynamicToolbarGoups.size() > 0) {
            enumeration = this.dynamicToolbarGoups.elements();
            toolGroupSet = null;
            while (enumeration.hasMoreElements()) {
                toolGroupSet = enumeration.nextElement();
                toolGroupSet.saveToolGroupSetSetting();
            }
        }
        return true;
    }

    public boolean storeToolbarSettingToServer() throws Exception {
        ToolGroupSet toolGroupSet;
        Enumeration<ToolGroupSet> enumeration;
        if (this.toolGroupSetVct.size() > 0) {
            enumeration = this.toolGroupSetVct.elements();
            toolGroupSet = null;
            while (enumeration.hasMoreElements()) {
                toolGroupSet = enumeration.nextElement();
                toolGroupSet.saveToolGroupSetSettingToServer();
            }
        }
        if (this.dynamicToolbarGoups.size() > 0) {
            enumeration = this.dynamicToolbarGoups.elements();
            toolGroupSet = null;
            while (enumeration.hasMoreElements()) {
                toolGroupSet = enumeration.nextElement();
                toolGroupSet.saveToolGroupSetSettingToServer();
            }
        }
        return true;
    }

    public ToolGroupSet getToolGroupSet(String string) {
        if (this.toolGroupSetVct.size() <= 0) {
            return null;
        }
        if (null == string) {
            return null;
        }
        Enumeration<ToolGroupSet> enumeration = this.toolGroupSetVct.elements();
        ToolGroupSet toolGroupSet = null;
        while (enumeration.hasMoreElements()) {
            toolGroupSet = enumeration.nextElement();
            if (!ResourceUtil.areStringEquals(string, toolGroupSet.getID())) continue;
            return toolGroupSet;
        }
        enumeration = this.uncustimizedToolbar.elements();
        toolGroupSet = null;
        while (enumeration.hasMoreElements()) {
            toolGroupSet = enumeration.nextElement();
            if (!ResourceUtil.areStringEquals(string, toolGroupSet.getID())) continue;
            return toolGroupSet;
        }
        return null;
    }

    public MouseAdapter getPopupMenuListener() {
        return this.showPopupMenuMouseAdapter;
    }

    public JComponent getToolBarComponent(String string, String string2, String string3) {
        if (null == string || null == string2 || null == string3) {
            logger.debug("argument value is null. pls check.");
            return null;
        }
        ToolGroup toolGroup = this.getToolGroup(string, string2);
        if (null == toolGroup) {
            logger.debug("Can't get toolGroup: " + string2);
            return null;
        }
        Component component = toolGroup.getButton(string3);
        if (component instanceof JComponent) {
            return (JComponent)component;
        }
        return null;
    }

    public ToolGroup getToolGroup(String string, String string2) {
        ToolGroupSet toolGroupSet = this.getToolGroupSet(string);
        if (null == toolGroupSet) {
            return null;
        }
        return toolGroupSet.getToolGroup(string2);
    }

    public boolean setToolbarButtonState(String string, String string2, String string3, String string4, String string5) {
        ToolBarButton toolBarButton = this.getToolBarButton(string, string2, string3);
        if (null != toolBarButton) {
            return toolBarButton.setState(string4, string5);
        }
        return false;
    }

    public ToolBarButton getToolBarButton(String string, String string2, String string3) {
        ToolGroup toolGroup = this.getToolGroup(string, string2);
        if (null == toolGroup) {
            logger.debug("Can't get toolGroup: " + string2);
            return null;
        }
        Component component = toolGroup.getButton(string3);
        if (component instanceof ToolBarButton) {
            return (ToolBarButton)component;
        }
        return null;
    }

    public Vector<ToolGroupSet> getToolGroupSetVector() {
        return this.toolGroupSetVct;
    }

    public void setToolbarAction() {
        logger.trace("Begin setToolbarAction");
        int n = this.toolGroupSetVct.size();
        ToolGroupSet toolGroupSet = null;
        for (int i = 0; i < n; ++i) {
            toolGroupSet = this.toolGroupSetVct.elementAt(i);
            CommandManager.getInstance().setAction(toolGroupSet);
        }
        logger.trace("End setToolbarAction");
    }

    public boolean showToolbarButton(boolean bl, String string, String string2, String string3) {
        ToolBarButton toolBarButton = this.getToolBarButton(string3, string, string2);
        if (null == toolBarButton) {
            return false;
        }
        toolBarButton.setUserSelected(bl);
        this.updateToolbars();
        return true;
    }

    public boolean showToolbarButtonGroup(boolean bl, String string, String string2) {
        ToolGroup toolGroup = this.getToolGroup(string2, string);
        if (null == toolGroup) {
            logger.debug("Can't get toolGroup: " + string);
            return false;
        }
        toolGroup.setUserSelected(bl);
        this.updateToolbars();
        return true;
    }

    public void addToRightPanel(JPanel jPanel) {
        this.rightPanel.add(jPanel);
        this.add(this.rightPanel);
        this.revalidateRightPanel();
        logger.debug("addRightPanel  after :" + this.rightPanel.getBounds());
    }

    private void revalidateRightPanel() {
        this.containsPanel = true;
        this.validate();
        this.repaint();
        if (null != this.getParent()) {
            this.getParent().doLayout();
            this.getParent().validate();
        }
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rearrangeCurrentOrder() {
        this.removeAll();
        Map<Integer, Component> map = this.currentComponents;
        synchronized (map) {
            Iterator<Integer> iterator = this.currentComponents.keySet().iterator();
            while (iterator.hasNext()) {
                this.add(this.currentComponents.get(iterator.next()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rearrangeOriginalOrder() {
        Map<Integer, Component> map = this.originalComponents;
        synchronized (map) {
            Iterator<Integer> iterator = this.originalComponents.keySet().iterator();
            while (iterator.hasNext()) {
                this.remove(this.originalComponents.get(iterator.next()));
            }
            iterator = this.originalComponents.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.add(this.originalComponents.get(iterator.next()), n++);
            }
        }
    }

    public boolean rearrangeSavedOrder() {
        int n;
        boolean bl = false;
        TreeMap<Integer, ToolGroup> treeMap = new TreeMap<Integer, ToolGroup>();
        ArrayList<ToolGroup> arrayList = new ArrayList<ToolGroup>(10);
        Component component = null;
        for (n = 0; n < this.getComponentCount(); ++n) {
            DescContainer object3;
            Object object;
            component = this.getComponent(n);
            if (!(component instanceof ToolGroup) || !((ToolbarItemSettings)(object = new ToolbarItemSettings(object3 = ((ToolGroup)component).getM_desc()))).isValid() || !ResourceUtil.areEquals(object3.getDescName(), ((ToolbarItemSettings)object).getToolGroupSetName()) || !ResourceUtil.areEquals(object3.getParasItem("name").getValue(), ((ToolbarItemSettings)object).getToolGroupName()) || ((ToolbarItemSettings)object).getSavedOrder() <= 0) continue;
            if (null == treeMap.get(((ToolbarItemSettings)object).getSavedOrder())) {
                treeMap.put(((ToolbarItemSettings)object).getSavedOrder(), (ToolGroup)component);
            } else {
                arrayList.add((ToolGroup)component);
            }
            this.remove(n);
            --n;
        }
        n = 0;
        if (treeMap.size() > 0) {
            Set set = treeMap.entrySet();
            for (Map.Entry entry : set) {
                this.add((Component)entry.getValue(), n++);
            }
            bl = true;
        }
        Object var6_9 = null;
        if (arrayList.size() > 0) {
            for (ToolGroup toolGroup : arrayList) {
                this.add((Component)toolGroup, n++);
            }
            bl = true;
        }
        return bl;
    }

    public void removeFromRightPanel(JPanel jPanel) {
        this.rightPanel.remove(jPanel);
        this.remove(this.rightPanel);
        this.revalidateRightPanel();
    }

    public Vector<ToolGroupSet> getToolGroupSetVct() {
        return this.toolGroupSetVct;
    }

    public void clear() {
        this.clearToolGroupSet(this.uncustimizedToolbar);
        this.uncustimizedToolbar.removeAllElements();
        this.clearToolGroupSet(this.dynamicToolbarGoups);
        this.dynamicToolbarGoups.removeAllElements();
        this.clearToolGroupSet(this.toolGroupSetVct);
        this.toolGroupSetVct.removeAllElements();
        this.removeAll();
        if (null != this.rightPanel) {
            this.rightPanel.removeAll();
        }
        this.updateToolbarSafely();
    }

    private void clearToolGroupSet(Vector<ToolGroupSet> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            ToolGroupSet toolGroupSet = vector.elementAt(i);
            int n = toolGroupSet.getToolGroupCount();
            for (int j = 0; j < n; ++j) {
                toolGroupSet.removeToolGroup();
            }
            this.removeBtnVisibleListener(toolGroupSet);
        }
    }

    public void updateToolGroup(ToolGroup toolGroup) {
        toolGroup.updateToolGroup();
    }

    public Enumeration<Vector<ToolGroupSet>> getAllToolGroup() {
        Vector<Vector<ToolGroupSet>> vector = new Vector<Vector<ToolGroupSet>>(10);
        vector.add(this.toolGroupSetVct);
        vector.add(this.uncustimizedToolbar);
        vector.add(this.dynamicToolbarGoups);
        return vector.elements();
    }

    public Vector<ToolGroupSet> getAllToolGroupSets() {
        Vector<ToolGroupSet> vector = new Vector<ToolGroupSet>(10);
        if (null != this.toolGroupSetVct) {
            vector.addAll(this.toolGroupSetVct);
        }
        if (null != this.uncustimizedToolbar) {
            vector.addAll(this.uncustimizedToolbar);
        }
        if (null != this.dynamicToolbarGoups) {
            vector.addAll(this.dynamicToolbarGoups);
        }
        return vector;
    }

    public void updateToolBarItem(JComponent jComponent) {
        if (jComponent instanceof ToolBarButton) {
            ((ToolBarButton)jComponent).updateToolBarButton();
        } else if (jComponent instanceof ToggleButton) {
            ((ToggleButton)jComponent).updateToggleButton();
        }
    }

    public boolean relocateToolGroup(ToolGroup toolGroup, Point point, Point point2) {
        return this.relocator.reLocate(toolGroup, point, point2, this);
    }

    protected int getVisibleCount() {
        int n = 0;
        int n2 = this.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.getComponent(i).isVisible()) continue;
            ++n;
        }
        return n;
    }

    protected int getVisibleToolGroupCount() {
        int n = this.getVisibleCount();
        if (this.getRightPanel().isVisible()) {
            --n;
        }
        return n;
    }

    protected boolean isContainsPanel() {
        return this.containsPanel;
    }

    public JPanel getRightPanel() {
        return this.rightPanel;
    }

    public void refreshOriginal() {
        this.resetPositions(true, this.originalComponents);
    }

    public void refreshCurrent() {
        if (!this.currentSettingsEnabled) {
            return;
        }
        this.resetPositions(false, this.currentComponents);
    }

    public void clearSettings() {
        this.originalComponents = Collections.synchronizedMap(new TreeMap());
        this.currentComponents = Collections.synchronizedMap(new TreeMap());
        this.draggedComponents = Collections.synchronizedMap(new TreeMap());
    }

    private void applyLockInfo(boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = this.getComponents()) {
            if (!(component instanceof ToolGroup)) continue;
            if (bl) {
                ((ToolGroup)component).removeHandler();
                continue;
            }
            ((ToolGroup)component).addHandler();
        }
        this.revalidate();
    }

    public void resetLockInfo() {
        boolean bl = false;
        this.lockMenuItem.setSelected(false);
        if (ToolbarLockInfo.getInstance().isToolbarLocked(this)) {
            this.lockMenuItem.setSelected(true);
            bl = true;
        }
        this.applyLockInfo(bl);
        this.updateAllSeprators();
    }

    public final String getLockSaveName() {
        return this.lockSaveName;
    }

    public void setSaveLock(String string) {
        if (null != string && !string.trim().equals(EMPTY_STRING)) {
            this.lockSaveName = string;
            this.resetLockInfo();
        }
    }

    private void updateAllSeprators() {
        Component component = null;
        for (Component component2 : this.getComponents()) {
            if (!(component2 instanceof ToolGroup) || !component2.isVisible()) continue;
            ToolGroup toolGroup = (ToolGroup)component2;
            int n = toolGroup.getVisibleButtonCount();
            for (Component component3 : toolGroup.getComponents()) {
                if (n == 0) {
                    component3.setVisible(false);
                    continue;
                }
                if (!(component3 instanceof ToolBarHandle) && !(component3 instanceof IVSeparator)) continue;
                component3.setVisible(true);
            }
            component = this.separatorUpdate(toolGroup, component);
        }
    }

    public void enableCurrentSettings(boolean bl) {
        this.currentSettingsEnabled = bl;
    }

    public int getVisibleIndex(ToolGroup toolGroup) {
        Component[] componentArray;
        int n = 0;
        for (Component component : componentArray = this.getComponents()) {
            if (!(component instanceof ToolGroup) || !component.isVisible()) continue;
            if (toolGroup.equals((ToolGroup)component)) break;
            ++n;
        }
        return n;
    }

    private final Map<Integer, Component> getOriginalComponents() {
        return this.originalComponents;
    }

    public boolean setToolbarButtonVisible(boolean bl, String string, String string2, String string3) {
        boolean bl2 = false;
        if (null == string || null == string2 || null == string3) {
            return bl2;
        }
        Enumeration<ToolGroupSet> enumeration = this.toolGroupSetVct.elements();
        ToolGroupSet toolGroupSet = null;
        ToolGroup toolGroup = null;
        while (enumeration.hasMoreElements()) {
            toolGroupSet = enumeration.nextElement();
            if (!ResourceUtil.areStringEquals(toolGroupSet.getID(), string) || null == (toolGroup = toolGroupSet.getToolGroup(string2)) || null == toolGroup.getButton(string3)) continue;
            this.setCurrentComponentsPositions();
            bl2 = toolGroup.setButtonVisible(bl, string3);
            toolGroup.updateToolGroup();
            this.updateToolbarSafely();
            this.resetPositions();
            this.updateAllSeprators();
            this.revalidate();
            break;
        }
        return bl2;
    }

    public final int getIncreasedWidth() {
        return this.increasedWidth;
    }

    public void resetToolbarWidth() {
        this.increasedWidth = -1;
        this.oldToolbarWidth = 0;
        this.newToolbarWidth = 0;
    }

    protected final int getCustomWidth() {
        return this.customWidth;
    }

    public void setCustomWidth(int n) {
        this.customWidth = n;
        this.revalidate();
    }

    public void setDraggableComponentsPositions() {
        int n = 0;
        this.draggedComponents.clear();
        for (Component component : this.getComponents()) {
            this.draggedComponents.put(n++, component);
            if (!(component instanceof ToolGroup)) continue;
            ((ToolGroup)component).setDraggedSetings();
        }
        this.resetMenuItem.setEnabled(true);
    }

    public void cleanupWhileOSGIExit() {
        this.uncustimizedToolbar.removeAllElements();
        this.dynamicToolbarGoups.removeAllElements();
        this.toolGroupSetVct.removeAllElements();
        this.removeAll();
        if (null != this.rightPanel) {
            this.rightPanel.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component[] getComponents() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return super.getComponents();
        }
    }

    protected void uninstallListeners() {
        ComponentListener[] componentListenerArray;
        this.customizeMenuItem.removeActionListener(this.customMenuActionListener);
        this.resetMenuItem.removeActionListener(this.resetMenuActionListener);
        this.lockMenuItem.removeActionListener(this.lockActionListener);
        this.removeMouseListener(this.showPopupMenuMouseAdapter);
        for (ComponentListener componentListener : componentListenerArray = this.getComponentListeners()) {
            this.removeComponentListener(componentListener);
        }
        if (null != FrameworkUtilities.getMainFrame()) {
            FrameworkUtilities.getMainFrame().removeComponentListener(this.componentAdapter);
        }
    }

    private class ToolGroupMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 2426987116032729909L;
        private ToolGroup toolGroup = null;

        ToolGroupMenuItem(ToolGroup toolGroup) {
            this.toolGroup = toolGroup;
            String string = toolGroup.getName();
            String string2 = toolGroup.getMenuText();
            if (null == string2) {
                string2 = string;
            }
            this.setText(string2);
            this.setName(string);
            this.setState(toolGroup.isUserSelected());
        }

        @Override
        public void doClick(int n) {
            super.doClick(n);
            this.toolGroup.setUserSelected(this.isSelected());
            if (!this.isSelected()) {
                this.refactorToolGroupWrap();
            }
            int n2 = this.toolGroup.getVisibleButtonCount();
            Toolbar.this.setCurrentComponentsPositions();
            Toolbar.this.updateToolbars();
            if (n2 > 0) {
                Toolbar.this.synchCurrentComponents();
            }
            Toolbar.this.rearrangeCurrentOrder();
            Toolbar.this.resetPositions();
            Toolbar.this.storeToolbarSetting();
            Toolbar.this.storeOldPositions();
            Toolbar.this.revalidate();
            Toolbar.this.updateUISafely();
        }

        private void refactorToolGroupWrap() {
            DefaultToolGroupRelocator defaultToolGroupRelocator = new DefaultToolGroupRelocator(Toolbar.this);
            int n = defaultToolGroupRelocator.getItemIndex(this.toolGroup);
            ToolGroup toolGroup = defaultToolGroupRelocator.getNextVisibleToolGroup(n);
            if (this.toolGroup.isWrapped() && null != toolGroup) {
                boolean bl = true;
                if (this.isSelected()) {
                    bl = false;
                }
                toolGroup.setWrapped(bl);
            }
        }
    }
}

