/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.toolbar;

import com.swimap.iview.commstyle.commini.ToolGroup;
import com.swimap.iview.templates.toolbar.IToolItemRelocator;
import com.swimap.iview.templates.toolbar.Toolbar;
import java.awt.Component;
import java.awt.Point;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DefaultToolGroupRelocator
implements IToolItemRelocator {
    private Toolbar toolbar = null;
    private static final int VECTOR_SIZE = 10;

    public DefaultToolGroupRelocator() {
    }

    public DefaultToolGroupRelocator(Toolbar toolbar) {
        this.toolbar = toolbar;
    }

    @Override
    public boolean reLocate(JComponent jComponent, Point point, Point point2, Toolbar toolbar) {
        this.toolbar = toolbar;
        int n = this.getItemIndex(jComponent);
        if (this.outOfRange(point, point2, jComponent, n)) {
            return false;
        }
        int n2 = point2.x - point.x;
        if (point2.y < jComponent.getY()) {
            if (this.getLineItems(n).length > 1) {
                this.moveUp(n);
            } else {
                this.mergeUp(n);
            }
        } else if (point2.y > jComponent.getY() + jComponent.getHeight()) {
            if (this.getLineItems(n).length > 1) {
                this.moveDown(n);
            } else {
                this.mergeDown(n);
            }
        }
        n = this.getItemIndex(jComponent);
        if (n2 < 0) {
            this.moveLeading(n, -n2);
        } else if (n2 > 0) {
            this.moveTrailing(n, n2);
        }
        return true;
    }

    public boolean outOfRange(Point point, Point point2, JComponent jComponent, int n) {
        boolean bl;
        if (!(jComponent instanceof ToolGroup)) {
            return false;
        }
        ToolGroup toolGroup = (ToolGroup)jComponent;
        ToolGroup[] toolGroupArray = this.getLineItems(n);
        int n2 = 2;
        int n3 = point2.x;
        int n4 = this.toolbar.getPreferredSize().width;
        boolean bl2 = point2.x > point.x;
        boolean bl3 = bl = point2.y < point.y;
        if (bl && this.isMovedToRightPanel(toolGroup)) {
            return true;
        }
        if (bl2 && toolGroup.getX() + toolGroup.getPreferredSize().width + (point2.x - point.x) >= this.toolbar.getWidth() - n2) {
            return true;
        }
        if (null != toolGroupArray && toolGroupArray.length > 0 && bl2) {
            if (this.isMovedToRightPanel(toolGroup) && this.getItemLine(toolGroup) == 0) {
                return true;
            }
            ToolGroup toolGroup2 = toolGroupArray[toolGroupArray.length - 1];
            boolean bl4 = this.getItemLine(toolGroup2) == 0;
            int n5 = 10;
            if (bl4 && null != this.toolbar.getRightPanel()) {
                n5 += this.toolbar.getRightPanel().getPreferredSize().width;
            }
            if (!toolGroup2.equals(toolGroup) && this.isSpaceAvailable(toolGroupArray, jComponent)) {
                return false;
            }
            for (ToolGroup toolGroup3 : toolGroupArray) {
                n3 += toolGroup3.getPreferredSize().width + n2;
            }
            if (toolGroup2.getX() + toolGroup2.getPreferredSize().width > n4 - n5) {
                ToolGroup[] toolGroupArray2 = this.getLineItems(this.getItemIndex(toolGroup2));
                if (toolGroupArray2.length > 1) {
                    toolGroup2.setWrapped(true);
                    ToolGroup[] toolGroupArray3 = this.getLineItems(this.getItemIndex(toolGroup2) + 1);
                    if (toolGroupArray3.length > 0) {
                        toolGroupArray3[0].setWrapped(false);
                    }
                }
                this.toolbar.revalidate();
                this.toolbar.repaint();
                return true;
            }
        }
        return !bl2 && point2.x <= 0;
    }

    public boolean isMovedToRightPanel(ToolGroup toolGroup) {
        if (null == this.toolbar) {
            return false;
        }
        JPanel jPanel = this.toolbar.getRightPanel();
        int n = jPanel.getPreferredSize().width;
        int n2 = jPanel.getPreferredSize().height;
        int n3 = toolGroup.getX();
        int n4 = toolGroup.getY();
        int n5 = n3 + toolGroup.getPreferredSize().width;
        int n6 = this.toolbar.getPreferredSize().width - n;
        int n7 = jPanel.getY() + n2;
        return (n3 >= n6 && n4 <= n7 || n5 >= n6 && n4 <= n7) && n != 0 && n2 != 0 && n6 != 0 && n7 != 0;
    }

    private boolean isSpaceAvailable(ToolGroup[] toolGroupArray, JComponent jComponent) {
        boolean bl = false;
        int n = this.getItemIndex(jComponent);
        for (int i = n + 1; i < toolGroupArray.length; ++i) {
            if (!toolGroupArray[i].isVisible() || toolGroupArray[i].getXSpacing() <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int getItemLine(ToolGroup toolGroup) {
        int n = -1;
        if (null != this.toolbar && toolGroup.isVisible()) {
            Component[] componentArray = this.toolbar.getComponents();
            int n2 = this.toolbar.getComponentCount();
            Component component = null;
            block0: for (int i = 0; i < n2; ++i) {
                ToolGroup[] toolGroupArray;
                component = componentArray[i];
                if (!(component instanceof ToolGroup) || !component.isVisible() || null == (toolGroupArray = this.getLineItems(i)) || toolGroupArray.length <= 0) continue;
                ++n;
                for (ToolGroup toolGroup2 : toolGroupArray) {
                    if (toolGroup2.equals(toolGroup)) break block0;
                }
                i += toolGroupArray.length - 1;
            }
        }
        return n;
    }

    public int getItemIndex(JComponent jComponent) {
        int n = this.toolbar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (jComponent != this.toolbar.getComponent(i)) continue;
            return i;
        }
        return -1;
    }

    public ToolGroup[] getLineItems(int n) {
        if (n < 0) {
            return new ToolGroup[0];
        }
        int n2 = this.toolbar.getComponentCount();
        if (n >= n2) {
            return new ToolGroup[0];
        }
        Component component = this.getItem(n);
        if (n != 0 && component instanceof ToolGroup && !((ToolGroup)component).isWrapped()) {
            return this.getLineItems(n - 1);
        }
        Vector<ToolGroup> vector = new Vector<ToolGroup>(10);
        for (int i = n; i < n2; ++i) {
            component = this.getItem(i);
            if (!component.isVisible() || component instanceof ToolGroup && ((ToolGroup)component).getVisibleButtonCount() < 1) continue;
            if (i != n && component instanceof ToolGroup && ((ToolGroup)component).isWrapped()) break;
            if (!(component instanceof ToolGroup)) continue;
            vector.add((ToolGroup)component);
        }
        return vector.toArray(new ToolGroup[0]);
    }

    public Component getItem(int n) {
        return this.toolbar.getComponent(n);
    }

    private void moveUp(int n) {
        ToolGroup toolGroup;
        ToolGroup toolGroup2 = (ToolGroup)this.getItem(n);
        ToolGroup[] toolGroupArray = this.getLineItems(n);
        ToolGroup toolGroup3 = toolGroupArray[0];
        if (!this.checkIsValidMove(this.getLineItems(n - 1), toolGroup2)) {
            return;
        }
        if (toolGroup3.equals(toolGroup2)) {
            toolGroupArray[1].setWrapped(true);
        } else {
            int n2 = this.getItemIndex(toolGroup3);
            this.toolbar.remove(toolGroup2);
            this.toolbar.add((Component)toolGroup2, n2);
            toolGroup2.setWrapped(true);
            toolGroup3.setWrapped(true);
        }
        ToolGroup toolGroup4 = toolGroupArray[toolGroupArray.length - 1];
        if (toolGroup4 != toolGroup2 && null != (toolGroup = this.getNextVisibleToolGroup(n)) && !toolGroup.isWrapped()) {
            toolGroup.setXSpacing(Math.max(0, toolGroup2.getXSpacing()));
        }
        int n3 = toolGroup2.getXSpacing();
        int n4 = toolGroup2.getX();
        if (n3 < 0) {
            n4 += n3;
        }
        toolGroup2.setXSpacing(Math.max(0, n4));
        this.toolbar.revalidate();
        this.toolbar.repaint();
    }

    public ToolGroup getNextVisibleToolGroup(int n) {
        ToolGroup toolGroup = null;
        int n2 = 1;
        int n3 = this.toolbar.getComponentCount();
        Component component = null;
        while (n + n2 < n3) {
            component = this.toolbar.getComponent(n + n2);
            if (component instanceof ToolGroup && ((ToolGroup)component).isVisible() && ((ToolGroup)component).getVisibleButtonCount() > 0) {
                toolGroup = (ToolGroup)component;
                break;
            }
            ++n2;
        }
        return toolGroup;
    }

    private void mergeUp(int n) {
        int n2;
        ToolGroup toolGroup;
        ToolGroup[] toolGroupArray = this.getAboveVisibleLineItems(n);
        if (!this.checkIsValidMove(toolGroupArray, toolGroup = (ToolGroup)this.getItem(n))) {
            return;
        }
        ToolGroup toolGroup2 = null;
        int n3 = 0;
        for (n2 = 0; n2 < toolGroupArray.length && (toolGroup2 = toolGroupArray[n2]).getX() < toolGroup.getX(); ++n2) {
            ++n3;
            toolGroup2 = null;
        }
        if (n3 == toolGroupArray.length) {
            toolGroup.setWrapped(false);
        } else {
            this.toolbar.remove(toolGroup);
            this.toolbar.add((Component)toolGroup, n - toolGroupArray.length + n3);
            if (n3 == 0) {
                toolGroup.setWrapped(true);
                toolGroupArray[0].setWrapped(false);
            } else {
                toolGroup.setWrapped(false);
            }
        }
        if (n3 > 0) {
            ToolGroup toolGroup3 = toolGroupArray[n3 - 1];
            toolGroup.setXSpacing(Math.max(0, toolGroup.getX() - toolGroup3.getX() - toolGroup3.getPreferredSize().width));
        } else {
            n2 = toolGroup.getXSpacing();
            int n4 = toolGroup.getX();
            if (n2 < 0) {
                n4 += n2;
            }
            toolGroup.setXSpacing(Math.max(0, n4));
        }
        if (n3 < toolGroupArray.length) {
            ToolGroup toolGroup4 = toolGroupArray[n3];
            toolGroup2.setXSpacing(Math.max(0, toolGroup4.getX() - toolGroup.getX() - toolGroup.getPreferredSize().width));
        }
        this.toolbar.revalidate();
        this.toolbar.repaint();
    }

    private ToolGroup[] getAboveVisibleLineItems(int n) {
        ToolGroup[] toolGroupArray = null;
        int n2 = n - 1;
        while ((toolGroupArray = this.getLineItems(n2)).length <= 0 && --n2 >= 0) {
        }
        return toolGroupArray;
    }

    private ToolGroup[] getBelowVisibleLineItems(int n) {
        ToolGroup[] toolGroupArray = null;
        int n2 = n + 1;
        int n3 = this.toolbar.getComponentCount();
        while ((toolGroupArray = this.getLineItems(n2)).length <= 0 && ++n2 < n3 - 1) {
        }
        return toolGroupArray;
    }

    private boolean checkIsValidMove(ToolGroup[] toolGroupArray, ToolGroup toolGroup) {
        return toolGroupArray.length != 0;
    }

    void mergeDown(int n) {
        ToolGroup[] toolGroupArray = this.getBelowVisibleLineItems(n);
        ToolGroup toolGroup = (ToolGroup)this.getItem(n);
        if (toolGroupArray.length == 0 || this.toolbar.getVisibleIndex(toolGroup) > this.toolbar.getVisibleToolGroupCount() - 1) {
            return;
        }
        ToolGroup toolGroup2 = null;
        int n2 = 0;
        for (int i = 0; i < toolGroupArray.length && (toolGroup2 = toolGroupArray[i]).getX() < toolGroup.getX(); ++i) {
            ++n2;
            toolGroup2 = null;
        }
        if (n2 == 0) {
            toolGroup.setWrapped(true);
            toolGroupArray[0].setWrapped(false);
        } else {
            this.toolbar.remove(toolGroup);
            this.toolbar.add((Component)toolGroup, n + n2);
            toolGroup.setWrapped(false);
            ToolGroup toolGroup3 = toolGroupArray[n2 - 1];
            toolGroup.setXSpacing(Math.max(0, toolGroup.getX() - toolGroup3.getX() - toolGroup3.getPreferredSize().width));
        }
        if (n2 < toolGroupArray.length) {
            ToolGroup toolGroup4 = toolGroupArray[n2];
            toolGroup2.setXSpacing(Math.max(0, toolGroup4.getX() - toolGroup.getX() - toolGroup.getPreferredSize().width));
        }
        this.toolbar.revalidate();
        this.toolbar.repaint();
    }

    public void moveDown(int n) {
        ToolGroup toolGroup;
        ToolGroup toolGroup2 = (ToolGroup)this.getItem(n);
        ToolGroup[] toolGroupArray = this.getLineItems(n);
        ToolGroup toolGroup3 = toolGroupArray[0];
        if (toolGroup3.equals(toolGroup2)) {
            toolGroupArray[1].setWrapped(true);
        }
        toolGroup2.setWrapped(true);
        ToolGroup toolGroup4 = toolGroupArray[toolGroupArray.length - 1];
        if (toolGroup4 != toolGroup2 && null != (toolGroup = this.getNextVisibleToolGroup(n)) && !toolGroup.isWrapped()) {
            toolGroup.setXSpacing(Math.max(0, toolGroup2.getXSpacing()));
        }
        int n2 = this.getItemIndex(toolGroup4);
        this.toolbar.remove(toolGroup2);
        this.toolbar.add((Component)toolGroup2, n2);
        int n3 = toolGroup2.getXSpacing();
        int n4 = toolGroup2.getX();
        if (n3 < 0) {
            n4 += n3;
        }
        toolGroup2.setXSpacing(Math.max(0, n4));
        this.toolbar.revalidate();
        this.toolbar.repaint();
    }

    private void moveLeading(int n, int n2) {
        int n3;
        Component component;
        int n4 = -n2;
        ToolGroup toolGroup = (ToolGroup)this.getItem(n);
        int n5 = toolGroup.getXSpacing();
        int n6 = n5 + n4;
        n4 += Math.max(0, n5);
        int n7 = 0;
        if (!toolGroup.isWrapped()) {
            component = null;
            Component component2 = null;
            int n8 = 0;
            int n9 = 0;
            for (n3 = n - 1; n4 < 0 && n3 >= 0; --n3) {
                component = this.toolbar.getComponent(n3);
                if (!this.toolbar.getComponent(n3).isVisible() || !(component instanceof ToolGroup)) continue;
                component2 = component;
                n8 = ((ToolGroup)component2).getXSpacing();
                n9 = Math.min(-n4, n8);
                n4 += n9;
                n7 += n9;
                ((ToolGroup)component2).setXSpacing(n8 - n9);
                n6 += n9;
                if (!((ToolGroup)component2).isWrapped()) continue;
                --n3;
                break;
            }
        }
        ++n3;
        component = this.getNextVisibleToolGroup(n);
        if (null != component && !((ToolGroup)component).isWrapped()) {
            ((ToolGroup)component).setXSpacing(((ToolGroup)component).getXSpacing() - n6 + n5 + n7 + Math.min(0, n4));
        }
        if (n6 < 0) {
            toolGroup.setXSpacing(n6);
            this.toolbar.revalidate();
            int n10 = toolGroup.getX();
            Component component3 = null;
            ToolGroup toolGroup2 = null;
            int n11 = 0;
            for (int i = n3; i < n; ++i) {
                component3 = this.toolbar.getComponent(i);
                if (!(component3 instanceof ToolGroup) || !component3.isVisible() || (n11 = (toolGroup2 = (ToolGroup)component3).getX()) < n10 + n6) continue;
                this.toolbar.remove(toolGroup);
                this.toolbar.add((Component)toolGroup, i);
                n6 += n10 - n11;
                if (i != n3) break;
                toolGroup.setWrapped(true);
                toolGroup2.setWrapped(false);
                break;
            }
        }
        toolGroup.setXSpacing(n6);
        this.toolbar.revalidate();
        this.toolbar.repaint();
    }

    private void moveTrailing(int n, int n2) {
        int n3 = n2;
        if (this.isMovedFasterToRight(n, n2)) {
            return;
        }
        ToolGroup toolGroup = (ToolGroup)this.getItem(n);
        int n4 = toolGroup.getXSpacing();
        int n5 = n4 + n3;
        int n6 = this.toolbar.getComponentCount();
        if (n5 >= 0) {
            ToolGroup toolGroup2 = null;
            int n7 = 0;
            int n8 = 0;
            for (int i = n + 1; n3 > 0 && i < n6; ++i) {
                if (!this.toolbar.getComponent(i).isVisible() || !(this.toolbar.getComponent(i) instanceof ToolGroup)) continue;
                toolGroup2 = (ToolGroup)this.toolbar.getComponent(i);
                if (toolGroup2.isWrapped()) break;
                n7 = toolGroup2.getXSpacing();
                n8 = Math.min(n3, n7);
                n3 -= n8;
                if (n4 < 0) {
                    n8 -= -n4;
                }
                toolGroup2.setXSpacing(n7 - n8);
            }
        }
        toolGroup.setXSpacing(n5);
        this.toolbar.revalidate();
        this.toolbar.repaint();
    }

    private boolean isMovedFasterToRight(int n, int n2) {
        ToolGroup toolGroup = (ToolGroup)this.getItem(n);
        ToolGroup[] toolGroupArray = this.getLineItems(n);
        int n3 = 1;
        for (ToolGroup toolGroup2 : toolGroupArray) {
            if (toolGroup2.equals(toolGroup)) break;
            ++n3;
        }
        int n4 = this.toolbar.getX() + this.toolbar.getWidth() - 4;
        int n5 = 1;
        if (toolGroupArray.length > 1 && toolGroupArray.length > n3 && !this.isSpaceAvailable(toolGroupArray, toolGroup)) {
            boolean bl;
            ToolGroup toolGroup2;
            n5 = 0;
            toolGroup2 = toolGroupArray[toolGroupArray.length - 1];
            boolean bl2 = bl = toolGroup2.getX() + toolGroup2.getWidth() + 2 < n4;
            if (toolGroup.getX() + toolGroup.getPreferredSize().width + n2 >= toolGroupArray[n3].getX() - 2 && !bl) {
                return true;
            }
            n5 = 1;
        }
        return toolGroup.getX() + toolGroup.getPreferredSize().width + n2 >= n4 && n5 != 0;
    }
}

