/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textmenu;

import com.swimap.iview.templates.textmenu.ClearMenuItem;
import com.swimap.iview.templates.textmenu.CopyMenuItem;
import com.swimap.iview.templates.textmenu.FindMenuItem;
import com.swimap.iview.templates.textmenu.SaveMenuItem;
import com.swimap.iview.templates.textmenu.SelectAllMenuItem;
import com.swimap.iview.util.IFileStateChecker;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class TextMenuHandler {
    private JTextComponent textComponent = null;
    private JPopupMenu popupMenu = null;
    private ConcurrentHashMap menuItemConditionMap = new ConcurrentHashMap(10);
    private SaveMenuItem saveItem = null;
    private FindMenuItem findItem = null;
    public static final int POS_HEAD = 0;
    public static final int POS_TAIL = Integer.MAX_VALUE;

    public TextMenuHandler() {
        this(null, null);
    }

    public TextMenuHandler(JTextComponent jTextComponent) {
        this(jTextComponent, null);
    }

    public TextMenuHandler(Frame frame) {
        this(null, frame);
    }

    public TextMenuHandler(JTextComponent jTextComponent, Frame frame) {
        this(jTextComponent, frame, true);
    }

    public TextMenuHandler(JTextComponent jTextComponent, Frame frame, boolean bl) {
        this.textComponent = jTextComponent == null ? new JTextArea() : jTextComponent;
        this.popupMenu = this.createPopupMenu(this.textComponent, frame, bl);
        this.addTxtListener();
    }

    public TextMenuHandler(Dialog dialog, boolean bl, JTextComponent jTextComponent) {
        this.textComponent = jTextComponent == null ? new JTextArea() : jTextComponent;
        this.popupMenu = this.createPopupMenu(this.textComponent, dialog, bl);
        this.addTxtListener();
    }

    private void addTxtListener() {
        this.textComponent.addMouseListener(new TextComponentListener(this.popupMenu, this.textComponent));
        this.textComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!TextMenuHandler.this.popupMenu.isVisible()) {
                    TextMenuHandler.this.textComponent.setSelectionEnd(0);
                }
            }
        });
    }

    private JPopupMenu createPopupMenu(JTextComponent jTextComponent, Frame frame, boolean bl) {
        return this.createPoupMenu(frame, jTextComponent, bl);
    }

    private JPopupMenu createPopupMenu(JTextComponent jTextComponent, Dialog dialog, boolean bl) {
        return this.createPoupMenu(dialog, jTextComponent, bl);
    }

    private JPopupMenu createPoupMenu(Window window, JTextComponent jTextComponent, boolean bl) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        CopyMenuItem copyMenuItem = new CopyMenuItem(jTextComponent);
        this.setEnabledCondition(copyMenuItem, true);
        jPopupMenu.add(copyMenuItem);
        SelectAllMenuItem selectAllMenuItem = new SelectAllMenuItem(jTextComponent);
        this.setEnabledCondition(selectAllMenuItem, false);
        jPopupMenu.add(selectAllMenuItem);
        ClearMenuItem clearMenuItem = new ClearMenuItem(jTextComponent);
        this.setEnabledCondition(clearMenuItem, false);
        jPopupMenu.add(clearMenuItem);
        if (bl) {
            this.findItem = window instanceof Dialog ? new FindMenuItem(jTextComponent, (Dialog)window) : new FindMenuItem((Frame)window, jTextComponent);
            jPopupMenu.add(this.findItem);
        }
        this.saveItem = new SaveMenuItem(jTextComponent);
        this.setEnabledCondition(this.saveItem, false);
        jPopupMenu.add(this.saveItem);
        return jPopupMenu;
    }

    public void addMenuComponent(Component component, int n) {
        if (component == null) {
            throw new IllegalArgumentException("TextMenuHandler addMenuComponent failed: component is null.");
        }
        if (n <= 0) {
            this.popupMenu.add(component, 0);
        } else if (n < this.popupMenu.getComponentCount()) {
            this.popupMenu.add(component, n);
        } else {
            this.popupMenu.add(component);
        }
    }

    public void addMenuComponent(Component component) {
        this.addMenuComponent(component, Integer.MAX_VALUE);
    }

    public void removeMenuComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("TextMenuHandler removeMenuComponent failed: component is null.");
        }
        this.popupMenu.remove(component);
    }

    private void setEnabledCondition(JMenuItem jMenuItem, boolean bl) {
        if (null != jMenuItem) {
            this.menuItemConditionMap.put(jMenuItem, bl);
        }
    }

    private void checkMenuItemEnabled(JTextComponent jTextComponent) {
        for (Map.Entry entry : this.menuItemConditionMap.entrySet()) {
            JMenuItem jMenuItem = (JMenuItem)entry.getKey();
            boolean bl = (Boolean)entry.getValue();
            this.setMenuItemEnable(jTextComponent, jMenuItem, bl);
        }
    }

    private void setMenuItemEnable(JTextComponent jTextComponent, JMenuItem jMenuItem, boolean bl) {
        String string = null;
        string = bl ? jTextComponent.getSelectedText() : jTextComponent.getText();
        jMenuItem.setEnabled(null != string && 0 < string.length());
    }

    public void setFileStateChecker(IFileStateChecker iFileStateChecker) {
        this.saveItem.setFileStateChecker(iFileStateChecker);
    }

    public void setScrollPane(JScrollPane jScrollPane) {
        if (this.findItem != null) {
            this.findItem.setScrollPane(jScrollPane);
        }
    }

    public void setDefaultSaveFileName(String string) {
        this.saveItem.setDefaultFileName(string);
    }

    public void cleanupWhileOSGIExit() {
        int n = this.popupMenu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            Object object;
            Component component = this.popupMenu.getComponent(i);
            if (component instanceof FindMenuItem) {
                object = component.getKeyListeners();
                for (int j = 0; j < ((KeyListener[])object).length; ++j) {
                    component.removeKeyListener((KeyListener)object[j]);
                    object[j] = null;
                }
            } else if (component instanceof CopyMenuItem) {
                object = (CopyMenuItem)component;
                ActionListener[] actionListenerArray = ((AbstractButton)object).getActionListeners();
                for (n2 = 0; n2 < actionListenerArray.length; ++n2) {
                    ((AbstractButton)object).removeActionListener(actionListenerArray[n2]);
                    actionListenerArray[n2] = null;
                }
            } else if (component instanceof ClearMenuItem) {
                object = (ClearMenuItem)component;
                ActionListener[] actionListenerArray = ((AbstractButton)object).getActionListeners();
                for (n2 = 0; n2 < actionListenerArray.length; ++n2) {
                    ((AbstractButton)object).removeActionListener(actionListenerArray[n2]);
                    actionListenerArray[n2] = null;
                }
            } else if (component instanceof SelectAllMenuItem) {
                object = (SelectAllMenuItem)component;
                ActionListener[] actionListenerArray = ((AbstractButton)object).getActionListeners();
                for (n2 = 0; n2 < actionListenerArray.length; ++n2) {
                    ((AbstractButton)object).removeActionListener(actionListenerArray[n2]);
                    actionListenerArray[n2] = null;
                }
            }
            component = null;
        }
        this.popupMenu.removeAll();
        this.popupMenu = null;
    }

    private final class TextComponentListener
    extends MouseAdapter {
        private JPopupMenu popupMenu = null;
        private JTextComponent textComponent = null;

        public TextComponentListener(JPopupMenu jPopupMenu, JTextComponent jTextComponent) {
            this.popupMenu = jPopupMenu;
            this.textComponent = jTextComponent;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.textComponent.requestFocus();
                TextMenuHandler.this.checkMenuItemEnabled(this.textComponent);
                ScreenToolKit.showPopupMenu(this.popupMenu, mouseEvent);
            }
        }
    }
}

