/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textmenu;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.textmenu.ResUtil;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.FileLockTool;
import com.swimap.iview.util.IFileStateChecker;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.SaveFileChooser;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;

public class SaveMenuItem
extends JMenuItem {
    private static IviewLogger logger = IviewLogger.getLogger(SaveMenuItem.class, "IVIEW");
    private transient IFileStateChecker checker = FileLockTool.getInstance();
    private String defaultFileName = "";

    public SaveMenuItem(JTextComponent jTextComponent) {
        this(ResUtil.getString("TextMenuHandler_Save"), 'V', jTextComponent);
    }

    public SaveMenuItem(String string, char c, JTextComponent jTextComponent) {
        super(string);
        if (jTextComponent == null) {
            throw new IllegalArgumentException("init SaveMenuItem failed: textComponent is null.");
        }
        this.setMnemonic(c);
        this.addActionListener(new SaveActionListener(jTextComponent));
        this.setName("TextMenuHandler_Save");
    }

    public void setFileStateChecker(IFileStateChecker iFileStateChecker) {
        this.checker = iFileStateChecker;
    }

    void setDefaultFileName(String string) {
        this.defaultFileName = string;
    }

    private final class SaveActionListener
    implements ActionListener {
        private JTextComponent textComponent = null;
        private String fileName = null;

        public SaveActionListener(JTextComponent jTextComponent) {
            this.textComponent = jTextComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            Object object;
            SaveFileChooser saveFileChooser = new SaveFileChooser(System.getProperty("user.dir"));
            saveFileChooser.setFileStateChecker(SaveMenuItem.this.checker);
            saveFileChooser.setAcceptAllFileFilterUsed(false);
            saveFileChooser.addChoosableFileFilter(FileChooser.TXT_FILECHOOSERFILTER);
            saveFileChooser.setEncodingEnabled(true);
            saveFileChooser.getTextField(saveFileChooser).setText(SaveMenuItem.this.defaultFileName);
            if (saveFileChooser.showSaveDialog(FrameworkUtilities.getMainFrame()) != 0) {
                return;
            }
            this.fileName = saveFileChooser.getSelectedFile().getPath();
            if (null != this.fileName && 0 != this.fileName.length()) {
                object = (FileChooserFilter)saveFileChooser.getFileFilter();
                string = '.' + (String)((FileChooserFilter)object).getAllFilters().get(0);
                if (!this.fileName.toLowerCase().endsWith(string)) {
                    this.fileName = this.fileName.concat(string);
                }
            }
            object = this.textComponent.getText();
            object = ((String)object).replaceAll("\r", "");
            object = ((String)object).replaceAll("\n", System.getProperty("line.separator"));
            string = saveFileChooser.getUserEncoding();
            if (null == string) {
                string = "UTF-8";
            }
            this.saveFile(this.fileName, (String)object, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveFile(String string, String string2) {
            BufferedWriter bufferedWriter = null;
            try {
                string = CommonUtil.getAbsolutePath(string);
                bufferedWriter = new BufferedWriter(new FileWriter(string));
                bufferedWriter.write(string2);
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                this.showSaveErrorMessage(string, iOException);
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                        bufferedWriter = null;
                    }
                }
                catch (IOException iOException) {
                    logger.trace(iOException.getMessage(), iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveFile(String string, String string2, String string3) {
            BufferedWriter bufferedWriter = null;
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            boolean bl = false;
            try {
                string = CommonUtil.getAbsolutePath(string);
                fileOutputStream = new FileOutputStream(string);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string3);
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                bufferedWriter.write(string2);
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                bl = true;
                this.showSaveErrorMessage(string, iOException);
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                        bufferedWriter = null;
                    }
                    if (null != fileOutputStream) {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    if (null != outputStreamWriter) {
                        outputStreamWriter.close();
                        outputStreamWriter = null;
                    }
                    File file = new File(this.fileName);
                    if (bl && file.exists()) {
                        file.delete();
                    }
                }
                catch (IOException iOException) {
                    logger.trace(iOException.getMessage(), iOException);
                }
            }
        }

        private void showSaveErrorMessage(String string, Exception exception) {
            String string2 = ResUtil.getString("ErrorHalt");
            MessageFormat messageFormat = new MessageFormat(string2);
            string2 = messageFormat.format(new String[]{string});
            StringBuffer stringBuffer = OptionPane.separateStringWith(string2, "\n");
            OptionPane.showErrorDialog(FrameworkUtilities.getMainFrame(), stringBuffer);
            logger.trace(exception.getMessage(), exception);
        }
    }
}

