/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textmenu;

import com.swimap.iview.templates.textmenu.FindDialog;
import com.swimap.iview.templates.textmenu.ResUtil;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class FindMenuItem
extends JMenuItem {
    private FindDialog dialog = null;
    private JScrollPane scrollPane = null;

    public FindMenuItem(JTextComponent jTextComponent) {
        this(ResUtil.getString("TextMenuHandler_Find"), 'F', null, jTextComponent);
    }

    public FindMenuItem(Frame frame, JTextComponent jTextComponent) {
        this(ResUtil.getString("TextMenuHandler_Find"), 'F', frame, jTextComponent);
    }

    public FindMenuItem(JTextComponent jTextComponent, Dialog dialog) {
        this(dialog, jTextComponent, 'F', ResUtil.getString("TextMenuHandler_Find"));
    }

    public FindMenuItem(String string, char c, Frame frame, JTextComponent jTextComponent) {
        this(string, jTextComponent, c, frame);
    }

    private FindMenuItem(Dialog dialog, JTextComponent jTextComponent, char c, String string) {
        this(string, jTextComponent, c, dialog);
    }

    private FindMenuItem(String string, final JTextComponent jTextComponent, char c, final Window window) {
        super(string);
        if (jTextComponent == null) {
            throw new IllegalArgumentException("init FindMenuItem failed: textComponent is null.");
        }
        this.setMnemonic(c);
        this.addActionListener(new FindActionListener(window, jTextComponent));
        this.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
        this.setName("TextMenuHandler_Find");
        jTextComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 70) {
                    FindMenuItem.this.showFindDialog(window, jTextComponent);
                    keyEvent.consume();
                } else if (keyEvent.getKeyCode() == 114) {
                    FindMenuItem.this.findNext(window, jTextComponent);
                    keyEvent.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 114) {
                    keyEvent.consume();
                }
            }
        });
    }

    private void showFindDialog(Window window, JTextComponent jTextComponent) {
        if (this.dialog == null) {
            this.initFindDialog(window, jTextComponent);
        }
        this.dialog.setVisible(true);
    }

    private void findNext(Window window, JTextComponent jTextComponent) {
        if (null == this.dialog) {
            this.initFindDialog(window, jTextComponent);
        }
        this.dialog.getFindCommand().findNext();
    }

    private void initFindDialog(Window window, JTextComponent jTextComponent) {
        this.dialog = window instanceof Dialog ? new FindDialog(ResUtil.getString("FindDialogTitle"), (Dialog)window, true, jTextComponent) : new FindDialog((Frame)window, ResUtil.getString("FindDialogTitle"), true, jTextComponent);
        this.dialog.setScrollPane(this.scrollPane);
    }

    final void setScrollPane(JScrollPane jScrollPane) {
        this.scrollPane = jScrollPane;
    }

    private final class FindActionListener
    implements ActionListener {
        private Window parentWindow = null;
        private JTextComponent textComponent = null;

        public FindActionListener(Window window, JTextComponent jTextComponent) {
            this.parentWindow = window;
            this.textComponent = jTextComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindMenuItem.this.showFindDialog(this.parentWindow, this.textComponent);
        }
    }
}

