/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textmenu;

import com.swimap.iview.templates.textfield.ValidCharDocument;
import com.swimap.iview.templates.textmenu.FindCommand;
import com.swimap.iview.templates.textmenu.IFindNextListener;
import com.swimap.iview.templates.textmenu.ResUtil;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class FindDialog
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(FindDialog.class, "IVIEW");
    private JTextField textField = new JTextField();
    private JButton findNextButton = new JButton();
    private JButton cancelButton = new JButton();
    private JCheckBox matchWholeCheckBox = new JCheckBox();
    private JCheckBox matchCaseCheckBox = new JCheckBox();
    private JRadioButton downRadioButton = new JRadioButton();
    private JRadioButton upRadioButton = new JRadioButton();
    private FindCommand findCommand = null;
    private Window parentWindow = null;
    private JTextComponent textComponent = null;
    private JScrollPane scrollPane = null;
    private static final int BUTTON_PREFERRED_WIDTH = 100;
    private static final int BUTTON_PREFERRED_HEIGHT = 21;
    private List findListeners = null;

    public FindDialog(Frame frame, String string, boolean bl, JTextComponent jTextComponent) {
        super(frame, string, bl);
        this.textComponent = jTextComponent;
        this.initFindWindow(frame);
    }

    public FindDialog(String string, Dialog dialog, boolean bl, JTextComponent jTextComponent) {
        super(dialog, string, bl);
        this.textComponent = jTextComponent;
        this.initFindWindow(dialog);
    }

    public FindDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.initFindWindow(frame);
    }

    public FindDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.initFindWindow(dialog);
    }

    private void initFindWindow(Window window) {
        this.parentWindow = window;
        this.initialize();
    }

    private void initialize() {
        try {
            this.jbInit();
            this.initTextFieldListener();
            this.initActionListener();
            this.pack();
        }
        catch (Exception exception) {
            logger.error("init FindDialog failed!");
            logger.trace(exception.getMessage());
        }
    }

    private void jbInit() throws Exception {
        JLabel jLabel = new JLabel();
        jLabel.setText(ResUtil.getString("FindLabel"));
        jLabel.setBounds(new Rectangle(10, 10, 75, 27));
        jLabel.setDisplayedMnemonic('t');
        jLabel.setLabelFor(this.textField);
        this.textField.setAlignmentX(0.0f);
        this.textField.setMinimumSize(new Dimension(4, 21));
        this.textField.setPreferredSize(new Dimension(63, 21));
        this.textField.setText("");
        this.textField.setBounds(new Rectangle(91, 13, 242, 21));
        this.textField.setDocument(new ValidCharDocument(255, null));
        this.textField.setName("FindDialog_textField");
        this.matchWholeCheckBox.setText(ResUtil.getString("Match_Whole"));
        this.matchWholeCheckBox.setBounds(new Rectangle(10, 79, 157, 25));
        this.matchWholeCheckBox.setMnemonic('m');
        this.matchWholeCheckBox.setName("FindDialog_matchWholeCheckBox");
        this.matchCaseCheckBox.setText(ResUtil.getString("Match_Case"));
        this.matchCaseCheckBox.setBounds(new Rectangle(10, 50, 145, 24));
        this.matchCaseCheckBox.setMnemonic('c');
        this.matchCaseCheckBox.setName("FindDialog_matchCaseCheckBox");
        this.upRadioButton.setText(ResUtil.getString("Up"));
        this.upRadioButton.setBounds(new Rectangle(17, 25, 75, 26));
        this.upRadioButton.setMnemonic('u');
        this.upRadioButton.setName("FindDialog_upRadioButton");
        this.downRadioButton.setText(ResUtil.getString("Down"));
        this.downRadioButton.setBounds(new Rectangle(90, 25, 75, 26));
        this.downRadioButton.setSelected(true);
        this.downRadioButton.setMnemonic('d');
        this.downRadioButton.setName("FindDialog_downRadioButton");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.upRadioButton);
        buttonGroup.add(this.downRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setBounds(new Rectangle(165, 38, 170, 65));
        jPanel.add((Component)this.upRadioButton, null);
        jPanel.add((Component)this.downRadioButton, null);
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(), ResUtil.getString("Direction"));
        jPanel.setBorder(titledBorder);
        this.findNextButton.setMaximumSize(new Dimension(100, 21));
        this.findNextButton.setMinimumSize(new Dimension(100, 21));
        this.findNextButton.setPreferredSize(new Dimension(100, 21));
        this.findNextButton.setActionCommand("findNext");
        this.findNextButton.setMargin(new Insets(2, 1, 2, 1));
        this.findNextButton.setText(ResUtil.getString("FindNext"));
        this.findNextButton.setBounds(new Rectangle(350, 13, 100, 21));
        this.findNextButton.setEnabled(false);
        this.findNextButton.setMnemonic('f');
        this.findNextButton.setName("FindDialog_findNextButton");
        this.cancelButton.setBounds(new Rectangle(350, 46, 100, 21));
        this.cancelButton.setMaximumSize(new Dimension(100, 21));
        this.cancelButton.setMinimumSize(new Dimension(100, 21));
        this.cancelButton.setPreferredSize(new Dimension(100, 21));
        this.cancelButton.setMnemonic('0');
        this.cancelButton.setText(ResUtil.getString("Cancel"));
        this.cancelButton.setName("FindDialog_cancelButton");
        this.setFocusTraversalPolicy(new FindDialogFocusTraversalPolicy());
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)this.textField, null);
        this.getContentPane().add((Component)this.findNextButton, null);
        this.getContentPane().add((Component)this.matchCaseCheckBox, null);
        this.getContentPane().add((Component)jLabel, null);
        this.getContentPane().add((Component)this.matchWholeCheckBox, null);
        this.getContentPane().add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)jPanel, null);
        this.setSize(new Dimension(468, 150));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        ScreenToolKit.setDefaultButtons(this.findNextButton, this.cancelButton);
        ScreenToolKit.setPreferredSizeofButtons(new JButton[]{this.findNextButton, this.cancelButton}, 21);
        ScreenToolKit.centerLocateToScreen(this);
    }

    private void initTextFieldListener() {
        this.textField.getDocument().addDocumentListener(new TextFieldDocumentListener());
    }

    private void initActionListener() {
        ActionListener actionListener = null;
        if (this.textComponent == null) {
            actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FindDialog.this.fireFindNextAction();
                }
            };
        } else {
            this.findCommand = new FindCommand(this.textComponent, this);
            actionListener = new FindNextActionListener(this.findCommand);
        }
        this.findNextButton.addActionListener(actionListener);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindDialog.this.dispose();
            }
        });
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.setSize(new Dimension(468, 150));
            this.textField.requestFocus();
            this.textField.selectAll();
        }
        super.setVisible(bl);
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    private void stateChanged() {
        String string = this.textField.getText();
        if (null == string || string.length() == 0) {
            this.findNextButton.setEnabled(false);
        } else {
            this.findNextButton.setEnabled(true);
        }
    }

    public JTextField getFindTextField() {
        return this.textField;
    }

    public void setTextField(String string) {
        this.textField.setText(string);
    }

    public boolean isMatchWholeSelected() {
        return this.matchWholeCheckBox.isSelected();
    }

    public boolean isMatchCaseSelected() {
        return this.matchCaseCheckBox.isSelected();
    }

    public int getFindDirection() {
        if (this.upRadioButton.isSelected()) {
            return 1;
        }
        return 2;
    }

    final int getCaretPosition() {
        int n = 0;
        n = null == this.textComponent.getSelectedText() ? this.textComponent.getCaretPosition() : (this.getFindDirection() == 1 ? this.textComponent.getSelectionStart() : this.textComponent.getSelectionEnd());
        return n;
    }

    public FindCommand getFindCommand() {
        return this.findCommand;
    }

    final void setScrollPane(JScrollPane jScrollPane) {
        this.scrollPane = jScrollPane;
    }

    final void backwardScrollBar(JTextArea jTextArea, int n) {
        if (this.scrollPane != null) {
            JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
            int n2 = this.getCaretPositionPixel(jTextArea, n);
            if (jScrollBar != null && jScrollBar.isVisible() && n2 < jScrollBar.getValue()) {
                jScrollBar.setValue(n2);
            }
        }
    }

    private int getCaretPositionPixel(JTextArea jTextArea, int n) {
        int n2 = 0;
        try {
            int n3 = jTextArea.getLineStartOffset(jTextArea.getLineOfOffset(n));
            FontMetrics fontMetrics = jTextArea.getFontMetrics(jTextArea.getFont());
            jTextArea.select(n3, n);
            String string = jTextArea.getSelectedText();
            if (string != null) {
                n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
            }
        }
        catch (BadLocationException badLocationException) {
            logger.trace(badLocationException.getMessage(), badLocationException);
        }
        return n2;
    }

    public void addFindNextListener(IFindNextListener iFindNextListener) {
        if (null == iFindNextListener) {
            return;
        }
        if (null == this.findListeners) {
            this.findListeners = new ArrayList(1);
        }
        this.findListeners.add(iFindNextListener);
    }

    private void fireFindNextAction() {
        if (null == this.findListeners) {
            return;
        }
        int n = this.findListeners.size();
        IFindNextListener iFindNextListener = null;
        for (int i = 0; i < n; ++i) {
            iFindNextListener = (IFindNextListener)this.findListeners.get(i);
            iFindNextListener.fireFindNextAction();
        }
    }

    private class FindDialogFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private FindDialogFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            if (component.equals(FindDialog.this.textField)) {
                return FindDialog.this.matchCaseCheckBox;
            }
            if (component.equals(FindDialog.this.matchCaseCheckBox)) {
                return FindDialog.this.matchWholeCheckBox;
            }
            if (component.equals(FindDialog.this.matchWholeCheckBox)) {
                return FindDialog.this.upRadioButton;
            }
            if (component.equals(FindDialog.this.upRadioButton)) {
                return FindDialog.this.downRadioButton;
            }
            if (component.equals(FindDialog.this.downRadioButton)) {
                if (FindDialog.this.findNextButton.isEnabled()) {
                    return FindDialog.this.findNextButton;
                }
                return FindDialog.this.cancelButton;
            }
            if (component.equals(FindDialog.this.findNextButton)) {
                return FindDialog.this.cancelButton;
            }
            return FindDialog.this.textField;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (component.equals(FindDialog.this.textField)) {
                return FindDialog.this.cancelButton;
            }
            if (component.equals(FindDialog.this.matchWholeCheckBox)) {
                return FindDialog.this.textField;
            }
            if (component.equals(FindDialog.this.matchCaseCheckBox)) {
                return FindDialog.this.matchWholeCheckBox;
            }
            if (component.equals(FindDialog.this.upRadioButton)) {
                return FindDialog.this.matchCaseCheckBox;
            }
            if (component.equals(FindDialog.this.downRadioButton)) {
                return FindDialog.this.upRadioButton;
            }
            if (component.equals(FindDialog.this.findNextButton)) {
                return FindDialog.this.downRadioButton;
            }
            if (FindDialog.this.findNextButton.isEnabled()) {
                return FindDialog.this.findNextButton;
            }
            return FindDialog.this.downRadioButton;
        }

        @Override
        public Component getFirstComponent(Container container) {
            return FindDialog.this.textField;
        }

        @Override
        public Component getLastComponent(Container container) {
            return FindDialog.this.cancelButton;
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return FindDialog.this.textField;
        }
    }

    private final class TextFieldDocumentListener
    implements DocumentListener {
        private TextFieldDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            FindDialog.this.stateChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            FindDialog.this.stateChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            FindDialog.this.stateChanged();
        }
    }

    private static final class FindNextActionListener
    implements ActionListener {
        private FindCommand findCommand = null;

        FindNextActionListener(FindCommand findCommand) {
            this.findCommand = findCommand;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.findCommand.findNextActionPerformed();
        }
    }
}

