/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textmenu;

import com.swimap.iview.templates.textmenu.FindDialog;
import com.swimap.iview.templates.textmenu.ResUtil;
import com.swimap.iview.templates.textmenu.Searcher;
import com.swimap.iview.util.OptionPane;
import java.text.MessageFormat;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class FindCommand {
    private JTextComponent textComponent = null;
    private FindDialog findDialog = null;
    private String searchFor = null;
    private static final int MAX_SEARCHFOR_LEN = 128;

    public FindCommand(JTextComponent jTextComponent, FindDialog findDialog) {
        if (jTextComponent == null || findDialog == null) {
            throw new IllegalArgumentException("init FindCommand failed: parameter is null.");
        }
        this.textComponent = jTextComponent;
        this.findDialog = findDialog;
    }

    final void findNextActionPerformed() {
        this.searchFor = this.findDialog.getFindTextField().getText();
        this.findMatchingString(this.searchFor, this.textComponent.getText(), this.findDialog.isMatchCaseSelected(), this.findDialog.isMatchWholeSelected(), this.findDialog.getFindDirection(), this.findDialog.getCaretPosition());
    }

    final void findNext() {
        if (this.searchFor == null) {
            this.findDialog.setVisible(true);
            return;
        }
        this.findMatchingString(this.searchFor, this.textComponent.getText(), this.findDialog.isMatchCaseSelected(), this.findDialog.isMatchWholeSelected(), this.findDialog.getFindDirection(), this.findDialog.getCaretPosition());
    }

    private void findMatchingString(String string, String string2, boolean bl, boolean bl2, int n, int n2) {
        int n3 = -1;
        n3 = Searcher.searchMatchingString(string, string2, bl, bl2, n, n2);
        if (n3 == -1 && null == this.textComponent.getSelectedText()) {
            this.promptNotFound(string, false);
        } else if (n3 == -1) {
            n2 = n == 1 ? this.textComponent.getSelectionEnd() : this.textComponent.getSelectionStart();
            n3 = Searcher.searchMatchingString(string, string2, bl, bl2, n, n2);
            if (n3 == -1) {
                this.promptNotFound(string, false);
            } else {
                this.promptNotFound(string, true);
            }
        } else {
            if (this.textComponent instanceof JTextArea) {
                this.findDialog.backwardScrollBar((JTextArea)this.textComponent, n3);
            }
            this.textComponent.setSelectionStart(n3);
            this.textComponent.setSelectionEnd(n3 + string.length());
            this.textComponent.revalidate();
        }
    }

    private void promptNotFound(String string, boolean bl) {
        String string2 = null;
        string2 = string.length() > 128 ? string.substring(0, 128) + "..." : string;
        String string3 = ResUtil.getString("Search_NotFound");
        if (bl) {
            string3 = ResUtil.getString("Search_finished");
        }
        MessageFormat messageFormat = new MessageFormat(string3);
        string3 = messageFormat.format(new String[]{string2});
        if (this.findDialog.isVisible()) {
            OptionPane.showLineWrapOptionDialog(this.findDialog, string3, 1, false);
        } else {
            OptionPane.showLineWrapOptionDialog(this.findDialog.getParentWindow(), string3, 1, false);
        }
        this.findDialog.getFindTextField().requestFocus();
        this.findDialog.getFindTextField().selectAll();
    }
}

