/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield.ipaddress;

import com.swimap.iview.templates.textfield.ipaddress.IPv6TextField;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

final class InnerPrefixTextField
extends JTextField {
    private IPv6TextField textField = null;

    public InnerPrefixTextField(final IPv6TextField iPv6TextField) {
        this.textField = iPv6TextField;
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                iPv6TextField.clearSelectionAll(caretEvent.getDot());
            }
        });
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getID() == 401) {
            if (!this.isEditable() || !this.isEnabled()) {
                return true;
            }
            if (keyEvent.getKeyCode() == 38) {
                if (this.getCaretPosition() > 0) {
                    this.setCaretPosition(this.getCaretPosition() - 1);
                } else {
                    this.textField.IPv6Fields[7].requestFocus();
                    this.textField.IPv6Fields[7].setCaretPosition(this.textField.IPv6Fields[7].getText().length());
                }
                return true;
            }
            if (keyEvent.getKeyCode() == 37) {
                if (this.getCaretPosition() == 0) {
                    this.textField.IPv6Fields[7].requestFocus();
                    this.textField.IPv6Fields[7].setCaretPosition(this.textField.IPv6Fields[7].getText().length());
                    return true;
                }
            } else if (keyEvent.getKeyCode() == 40) {
                if (this.getCaretPosition() < this.getText().length()) {
                    this.setCaretPosition(this.getCaretPosition() + 1);
                    return true;
                }
            } else if (keyEvent.getKeyCode() == 36) {
                this.textField.IPv6Fields[0].requestFocus();
                this.textField.IPv6Fields[0].setCaretPosition(0);
            } else if (keyEvent.getKeyCode() == 35) {
                this.textField.prefixTextField.setCaretPosition(this.textField.prefixTextField.getText().length());
            } else if (keyEvent.getKeyCode() == 8) {
                if (this.textField.hasSelectionAll) {
                    this.textField.clear();
                    this.textField.requestFocus();
                    return true;
                }
                this.textField.setCanRemove(true);
                if (this.textField.prefixTextField.getCaretPosition() == 0) {
                    this.textField.IPv6Fields[7].requestFocus();
                    String string = this.textField.IPv6Fields[7].getText();
                    if (string.length() > 0) {
                        this.textField.IPv6Fields[7].setText(string.substring(0, string.length() - 1));
                    }
                    return true;
                }
            } else if (keyEvent.getKeyCode() == 127) {
                if (this.textField.hasSelectionAll) {
                    this.textField.clear();
                    this.textField.requestFocus();
                    return true;
                }
                this.textField.setCanRemove(true);
            } else {
                if (keyEvent.getKeyCode() == 65 && keyEvent.isControlDown()) {
                    this.textField.selectionAll();
                    return true;
                }
                if (keyEvent.getKeyCode() == 67 && keyEvent.isControlDown()) {
                    if (this.textField.hasSelectionAll) {
                        this.textField.copyToClipboard();
                        return true;
                    }
                } else if (keyEvent.getKeyCode() == 88 && keyEvent.isControlDown()) {
                    if (this.textField.hasSelectionAll) {
                        this.textField.cutAll();
                        return true;
                    }
                    this.textField.setCanRemove(true);
                } else {
                    this.textField.setCanRemove(false);
                }
            }
        }
        if (this.textField.hasSelectionAll && keyEvent.getKeyChar() == '\b') {
            return true;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    @Override
    public void setText(String string) {
        if (this.getText().length() != 0) {
            this.textField.setCanRemove(true);
        }
        super.setText(string);
    }
}

