/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield.ipaddress;

import com.swimap.iview.templates.textfield.ipaddress.IPv6TextField;
import com.swimap.iview.util.log.IviewLogger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

final class InnerPrefixDocument
extends PlainDocument {
    private static IviewLogger logger = IviewLogger.getLogger(InnerPrefixDocument.class, "IVIEW");
    private String regex = "[0-9]{0,3}";
    private Pattern pattern = Pattern.compile(this.regex);
    private StringBuffer input = new StringBuffer(3);
    private static final int PREFIX_MAX_VALUE = 128;
    private IPv6TextField textField = null;

    public InnerPrefixDocument(IPv6TextField iPv6TextField) {
        this.textField = iPv6TextField;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.textField.directFill) {
            this.textField.directFill = false;
            super.insertString(n, string, attributeSet);
            return;
        }
        int n2 = this.getLength();
        String string2 = this.getText(0, n2);
        this.input.setLength(0);
        int n3 = 0;
        String string3 = this.textField.prefixTextField.getSelectedText();
        if (string3 == null) {
            if (n + string.length() < n2) {
                this.input.append(string2.substring(0, n)).append(string).append(string2.substring(n + string.length()));
                n3 = string.length();
            } else {
                this.input.append(string2.substring(0, n)).append(string);
                n3 = n2 - n;
            }
        } else {
            this.input.append(string2.substring(0, this.textField.prefixTextField.getSelectionStart())).append(string).append(string2.substring(this.textField.prefixTextField.getSelectionEnd()));
        }
        Matcher matcher = this.pattern.matcher(this.input.toString().toLowerCase());
        if (matcher.matches()) {
            int n4 = 0;
            try {
                n4 = new Integer(this.input.toString());
            }
            catch (NumberFormatException numberFormatException) {
                logger.trace(numberFormatException.getMessage(), numberFormatException);
                return;
            }
            if (n4 > 128) {
                return;
            }
            if (string3 == null) {
                super.remove(n, n3);
            } else {
                super.remove(this.textField.prefixTextField.getSelectionStart(), string3.length());
            }
            super.insertString(n, string, attributeSet);
        }
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (this.textField.canRemove()) {
            super.remove(n, n2);
            this.textField.setCanRemove(false);
        }
    }
}

