/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield.ipaddress;

import com.swimap.iview.templates.textfield.ipaddress.IPv6TextField;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

final class InnerIPv6Document
extends PlainDocument {
    private int index = 0;
    private StringBuffer input = new StringBuffer(4);
    private String regex = "[0-9a-f]{0,4}";
    private Pattern pattern = Pattern.compile(this.regex);
    private static final int IPv6_4_LAST_INDEX = 5;
    private static final int PREFIX_LAST_INDEX = 7;
    private static final int IPv6_LAST_CARET_POSITION = 4;
    private static final int IPv4_AND_PREFIX_LAST_CARET_POSITION = 3;
    private IPv6TextField textField = null;

    public InnerIPv6Document(IPv6TextField iPv6TextField, int n) {
        this.index = n;
        this.textField = iPv6TextField;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.textField.directFill) {
            this.remove(0, this.getLength());
            this.textField.directFill = false;
            super.insertString(n, string.toLowerCase(), attributeSet);
            return;
        }
        int n2 = this.getLength();
        String string2 = this.getText(0, n2);
        this.input.setLength(0);
        int n3 = 0;
        String string3 = this.textField.IPv6Fields[this.index].getSelectedText();
        if (string3 == null) {
            if (n + string.length() < n2) {
                this.input.append(string2.substring(0, n)).append(string).append(string2.substring(n + string.length()));
                n3 = string.length();
            } else {
                this.input.append(string2.substring(0, n)).append(string);
                n3 = n2 - n;
            }
        } else {
            this.input.append(string2.substring(0, this.textField.IPv6Fields[this.index].getSelectionStart())).append(string).append(string2.substring(this.textField.IPv6Fields[this.index].getSelectionEnd()));
        }
        Matcher matcher = this.pattern.matcher(this.input.toString().toLowerCase());
        if (matcher.matches()) {
            if (string3 == null) {
                super.remove(n, n3);
            } else {
                super.remove(this.textField.IPv6Fields[this.index].getSelectionStart(), string3.length());
            }
            super.insertString(n, string.toLowerCase(), attributeSet);
            this.textField.clearSelectionAll(-1);
        } else if (string3 != null) {
            return;
        }
        this.removeFocusToNext();
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (this.textField.canRemove()) {
            super.remove(n, n2);
            this.textField.setCanRemove(false);
        }
    }

    private void removeFocusToNext() {
        int n;
        if (!this.textField.IPv6Fields[this.index].isRemoveFocus) {
            this.textField.IPv6Fields[this.index].isRemoveFocus = true;
            return;
        }
        int n2 = n = this.textField.mode == 2 ? 5 : 7;
        if (this.getLength() == 4 && this.textField.IPv6Fields[this.index].getCaretPosition() == 4 && this.textField.moveFocusToNext) {
            if (this.index < n) {
                this.textField.IPv6Fields[this.index + 1].requestFocus();
                this.textField.IPv6Fields[this.index + 1].setSelectionStart(0);
                this.textField.IPv6Fields[this.index + 1].setSelectionEnd(4);
            } else if (this.textField.mode == 2) {
                this.textField.IPv4Fields[0].requestFocus();
                this.textField.IPv4Fields[0].setSelectionStart(0);
                this.textField.IPv4Fields[0].setSelectionEnd(3);
            } else if (this.textField.mode == 1) {
                this.textField.prefixTextField.requestFocus();
                this.textField.prefixTextField.setSelectionStart(0);
                this.textField.prefixTextField.setSelectionEnd(3);
            }
        }
    }
}

