/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield.ipaddress;

import com.swimap.iview.templates.textfield.ipaddress.IPv6TextField;
import com.swimap.iview.util.log.IviewLogger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

final class InnerIPv4Document
extends PlainDocument {
    private static IviewLogger logger = IviewLogger.getLogger(InnerIPv4Document.class, "IVIEW");
    private static final int IPv4_LAST_CARET_POSITION = 3;
    private static final int IPv4_MAX_LENGTH = 3;
    private int index = 0;
    private StringBuffer input = new StringBuffer(3);
    private String regex = "[0-9]{0,3}";
    private Pattern pattern = Pattern.compile(this.regex);
    private IPv6TextField textField = null;

    public InnerIPv4Document(IPv6TextField iPv6TextField, int n) {
        this.index = n;
        this.textField = iPv6TextField;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.textField.directFill) {
            this.textField.directFill = false;
            super.insertString(n, string, attributeSet);
            return;
        }
        int n2 = this.getLength();
        String string2 = this.getText(0, n2);
        this.input.setLength(0);
        int n3 = 0;
        String string3 = this.textField.IPv4Fields[this.index].getSelectedText();
        if (string3 == null) {
            if (n + string.length() < n2) {
                this.input.append(string2.substring(0, n)).append(string).append(string2.substring(n + string.length()));
                n3 = string.length();
            } else {
                this.input.append(string2.substring(0, n)).append(string);
                n3 = n2 - n;
            }
        } else {
            this.input.append(string2.substring(0, this.textField.IPv4Fields[this.index].getSelectionStart())).append(string).append(string2.substring(this.textField.IPv4Fields[this.index].getSelectionEnd()));
        }
        Matcher matcher = this.pattern.matcher(this.input.toString().toLowerCase());
        if (matcher.matches()) {
            int n4 = 0;
            try {
                n4 = new Integer(this.input.toString());
            }
            catch (NumberFormatException numberFormatException) {
                logger.trace(numberFormatException.getMessage(), numberFormatException);
                return;
            }
            if (n4 > 255) {
                if (this.index < 3 && this.textField.IPv4Fields[this.index].getCaretPosition() == 2 && this.textField.moveFocusToNext && string3 == null) {
                    this.textField.IPv4Fields[this.index + 1].requestFocus();
                    this.textField.IPv4Fields[this.index + 1].setSelectionStart(0);
                    this.textField.IPv4Fields[this.index + 1].setSelectionEnd(3);
                }
                return;
            }
            if (string3 == null) {
                super.remove(n, n3);
            } else {
                super.remove(this.textField.IPv4Fields[this.index].getSelectionStart(), string3.length());
            }
            super.insertString(n, string, attributeSet);
            this.textField.clearSelectionAll(-1);
        } else if (string3 != null) {
            return;
        }
        this.removeFocusToNext();
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (this.textField.canRemove()) {
            super.remove(n, n2);
            this.textField.setCanRemove(false);
        }
    }

    private void removeFocusToNext() {
        if (!this.textField.IPv4Fields[this.index].isRemoveFocus) {
            this.textField.IPv4Fields[this.index].isRemoveFocus = true;
            return;
        }
        if (this.getLength() == 3 && this.index < 3 && this.textField.IPv4Fields[this.index].getCaretPosition() == 3 && this.textField.moveFocusToNext) {
            this.textField.IPv4Fields[this.index + 1].requestFocus();
            this.textField.IPv4Fields[this.index + 1].setSelectionStart(0);
            this.textField.IPv4Fields[this.index + 1].setSelectionEnd(3);
        }
    }
}

