/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield.ipaddress;

import com.swimap.iview.templates.textfield.ipaddress.IPv6Address;
import com.swimap.iview.templates.textfield.ipaddress.IPv6SizeManager;
import com.swimap.iview.templates.textfield.ipaddress.InnerIPv4Document;
import com.swimap.iview.templates.textfield.ipaddress.InnerIPv4TextField;
import com.swimap.iview.templates.textfield.ipaddress.InnerIPv6BtnIcon;
import com.swimap.iview.templates.textfield.ipaddress.InnerIPv6Document;
import com.swimap.iview.templates.textfield.ipaddress.InnerIPv6TextField;
import com.swimap.iview.templates.textfield.ipaddress.InnerPrefixDocument;
import com.swimap.iview.templates.textfield.ipaddress.InnerPrefixTextField;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;

public class IPv6TextField
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(IPv6TextField.class, "IVIEW");
    public static final int MODE_BASIC = 0;
    public static final int MODE_PREFIX = 1;
    public static final int MODE_IPv6_4 = 2;
    public static final int MODE_IPv4 = 3;
    private static final GridBagConstraints fieldConsts = new GridBagConstraints();
    static final GridBagConstraints areaConsts = new GridBagConstraints();
    private static final GridBagConstraints labelConsts = new GridBagConstraints();
    static final int IPv6_FIELD_SIZE = 29;
    static final int IPv4_FIELD_SIZE = 22;
    private static final int PREFIX_FIELD_SIZE = 20;
    private static final int EDIT_FIELD_SIZE = 253;
    private static final int BTN_SIZE = 24;
    private static final int HEX = 16;
    private static final int BEGIN_INDEX = 12;
    private static final int INADDRSZ = 16;
    private static final int IPv6_FIELDS_SIZE = 8;
    private static final int IPv4_FIELDS_SIZE = 4;
    JTextField IPv6_4Area = this.getIPv6_4Area();
    JTextField prefixArea = this.getPrefixArea();
    JTextField basicArea = this.getbasicArea();
    JTextField IPv4Area = this.getIPv4Area();
    private InnerIPv6BtnIcon changeModeIcon = new InnerIPv6BtnIcon(Color.black, 1, 12, 8, 8, 10);
    JButton changeModeBtn = new JButton(this.changeModeIcon);
    private InnerIPv6Document[] ipV6Doc = new InnerIPv6Document[8];
    private InnerIPv4Document[] IPv4Doc = new InnerIPv4Document[4];
    InnerIPv6TextField[] IPv6Fields = new InnerIPv6TextField[8];
    InnerIPv4TextField[] IPv4Fields = new InnerIPv4TextField[4];
    JTextField prefixTextField = null;
    JLabel[] IPv6Labels = new JLabel[7];
    JLabel[] IPv4Labels = new JLabel[3];
    JLabel prefixLengthLabel = null;
    JPanel inputPane = new JPanel();
    int mode = 0;
    private final InnerPrefixDocument prefixDoc = new InnerPrefixDocument(this);
    private JPopupMenu popupMenu = null;
    boolean containChangeModeBtn = true;
    private byte[] address = new byte[16];
    JTextField editTextField = new JTextField();
    private boolean trimZero = true;
    private boolean useDoubleColon = false;
    boolean hasSelectionAll = false;
    private boolean notifyClearSelection = true;
    boolean directFill = false;
    boolean moveFocusToNext = true;
    private transient FocusListener listener = new IPv6FocusListener();
    private IPv6KeyListener keyListener = new IPv6KeyListener();
    private boolean editable = true;
    private boolean enabled = true;
    private boolean canRemove = false;
    private boolean editFieldShow = false;
    private JRadioButtonMenuItem basicMenuItem = new JRadioButtonMenuItem("X:X:X:X:X:X:X:X");
    private JRadioButtonMenuItem perfixMenuItem = new JRadioButtonMenuItem("X:X:X:X:X:X:X:X/d");
    private JRadioButtonMenuItem IPv6_4MenuItem = new JRadioButtonMenuItem("X:X:X:X:X:X:d.d.d.d");
    private JRadioButtonMenuItem IPv4MenuItem = new JRadioButtonMenuItem("d.d.d.d");
    private int[] supportedMode = new int[]{0, 1, 2, 3};
    private IPv6SizeManager sizeManager = null;
    private Dimension preferredSize = null;

    public IPv6TextField() {
        this(0, true, new int[]{0, 1, 2, 3});
    }

    public IPv6TextField(String string) {
        this(string, true, new int[]{0, 1, 2, 3});
    }

    public IPv6TextField(IPv6Address iPv6Address) {
        this(iPv6Address.toString());
    }

    public IPv6TextField(String string, boolean bl, int[] nArray) {
        this.initSupportedMode(nArray);
        this.mode = IPv6Address.getIPAddressMode(string, true, true);
        boolean bl2 = false;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] != this.mode) continue;
            bl2 = true;
            break;
        }
        if (!bl2 && n > 0) {
            this.mode = nArray[0];
        }
        this.containChangeModeBtn = bl;
        try {
            this.jbinit();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        if (bl2) {
            if (this.mode != 3) {
                string = IPv6Address.doubleColon2basic(string);
            }
            this.ctrlVAll(string, this.mode);
        } else {
            logger.trace("address is not legal IPaddress.");
        }
    }

    public IPv6TextField(int n, boolean bl, int[] nArray) {
        this.initSupportedMode(nArray);
        boolean bl2 = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            n = nArray[0];
        }
        this.mode = n;
        this.containChangeModeBtn = bl;
        try {
            this.jbinit();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void initSupportedMode(int[] nArray) {
        int n;
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("supportedMode can not be null.");
        }
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>(4);
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < 0 || nArray[n] > 3) {
                throw new IllegalArgumentException("The mode must be one of the 'MODE_BASIC','MODE_PERFIX','MODE_IPv6_4' or 'MODE_IPv4'.");
            }
            hashtable.put(nArray[n], "");
        }
        nArray = new int[hashtable.size()];
        n = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            nArray[n] = (Integer)enumeration.nextElement();
            ++n;
        }
        this.supportedMode = nArray;
        Arrays.sort(nArray);
    }

    private void jbinit() throws Exception {
        int n;
        Dimension dimension;
        Dimension dimension2;
        int n2;
        for (n2 = 0; n2 < this.ipV6Doc.length; ++n2) {
            this.ipV6Doc[n2] = new InnerIPv6Document(this, n2);
        }
        for (n2 = 0; n2 < this.IPv4Doc.length; ++n2) {
            this.IPv4Doc[n2] = new InnerIPv4Document(this, n2);
        }
        for (n2 = 0; n2 < this.IPv6Fields.length; ++n2) {
            this.IPv6Fields[n2] = new InnerIPv6TextField(this, n2);
            this.IPv6Fields[n2].setDocument(this.ipV6Doc[n2]);
            this.IPv6Fields[n2].setBorder(null);
            this.IPv6Fields[n2].setHorizontalAlignment(0);
            dimension2 = this.IPv6Fields[n2].getPreferredSize();
            dimension = new Dimension(dimension2.width + 29, dimension2.height + 2);
            this.IPv6Fields[n2].setPreferredSize(dimension);
            this.IPv6Fields[n2].setMinimumSize(dimension);
            this.IPv6Fields[n2].setMaximumSize(dimension);
            this.IPv6Fields[n2].addFocusListener(this.listener);
            this.IPv6Fields[n2].addKeyListener(this.keyListener);
        }
        for (n2 = 0; n2 < this.IPv4Fields.length; ++n2) {
            this.IPv4Fields[n2] = new InnerIPv4TextField(this, n2);
            this.IPv4Fields[n2].setDocument(this.IPv4Doc[n2]);
            this.IPv4Fields[n2].setBorder(null);
            this.IPv4Fields[n2].setHorizontalAlignment(0);
            dimension2 = this.IPv4Fields[n2].getPreferredSize();
            dimension = new Dimension(dimension2.width + 22, dimension2.height + 2);
            this.IPv4Fields[n2].setPreferredSize(dimension);
            this.IPv4Fields[n2].setMinimumSize(dimension);
            this.IPv4Fields[n2].setMaximumSize(dimension);
            this.IPv4Fields[n2].addFocusListener(this.listener);
            this.IPv4Fields[n2].addKeyListener(this.keyListener);
        }
        this.prefixTextField = new InnerPrefixTextField(this);
        this.prefixTextField.setDocument(this.prefixDoc);
        this.prefixTextField.setBorder(null);
        this.prefixTextField.setHorizontalAlignment(0);
        Dimension dimension3 = this.prefixTextField.getPreferredSize();
        dimension2 = new Dimension(dimension3.width + 20, dimension3.height + 2);
        this.prefixTextField.setPreferredSize(dimension2);
        this.prefixTextField.setMinimumSize(dimension2);
        this.prefixTextField.setMaximumSize(dimension2);
        this.prefixTextField.addFocusListener(this.listener);
        this.prefixTextField.addKeyListener(this.keyListener);
        this.editTextField.setBorder(null);
        dimension3 = this.editTextField.getPreferredSize();
        dimension2 = new Dimension(253, dimension3.height + 2);
        this.editTextField.setPreferredSize(dimension2);
        this.editTextField.setMinimumSize(dimension2);
        this.editTextField.setMaximumSize(dimension2);
        int n3 = this.IPv6Labels.length;
        for (n = 0; n < n3; ++n) {
            this.IPv6Labels[n] = new JLabel(":", 0);
            this.IPv6Labels[n].setPreferredSize(new Dimension((int)this.IPv6Labels[n].getPreferredSize().getWidth(), (int)this.IPv6Labels[n].getPreferredSize().getHeight() + 2));
            this.IPv6Labels[n].setForeground(UIManager.getColor("TextField.foreground"));
            this.IPv6Labels[n].setBackground(UIManager.getColor("TextField.background"));
            this.IPv6Labels[n].setOpaque(true);
        }
        n3 = this.IPv4Labels.length;
        for (n = 0; n < n3; ++n) {
            this.IPv4Labels[n] = new JLabel(".", 0);
            this.IPv4Labels[n].setPreferredSize(new Dimension((int)this.IPv4Labels[n].getPreferredSize().getWidth(), (int)this.IPv4Labels[n].getPreferredSize().getHeight() + 2));
            this.IPv4Labels[n].setForeground(UIManager.getColor("TextField.foreground"));
            this.IPv4Labels[n].setBackground(UIManager.getColor("TextField.background"));
            this.IPv4Labels[n].setOpaque(true);
        }
        this.prefixLengthLabel = new JLabel("/", 0);
        this.prefixLengthLabel.setPreferredSize(new Dimension((int)this.prefixLengthLabel.getPreferredSize().getWidth(), (int)this.prefixLengthLabel.getPreferredSize().getHeight() + 2));
        this.prefixLengthLabel.setForeground(UIManager.getColor("TextField.foreground"));
        this.prefixLengthLabel.setBackground(UIManager.getColor("TextField.background"));
        this.prefixLengthLabel.setOpaque(true);
        this.changeModeBtn.setMaximumSize(new Dimension(24, 24));
        this.changeModeBtn.setMinimumSize(new Dimension(24, 24));
        this.changeModeBtn.setPreferredSize(new Dimension(24, 24));
        this.initChangeModeBtnAction();
        this.initArea();
        this.setName("IPv6TextField");
        this.sizeManager = new IPv6SizeManager(this);
        IPv6TextField.fieldConsts.anchor = 10;
        IPv6TextField.fieldConsts.fill = 1;
        IPv6TextField.fieldConsts.gridheight = 1;
        IPv6TextField.fieldConsts.gridwidth = 1;
        IPv6TextField.fieldConsts.gridy = 0;
        IPv6TextField.fieldConsts.insets = new Insets(0, 0, 0, 0);
        IPv6TextField.fieldConsts.ipadx = 0;
        IPv6TextField.fieldConsts.ipady = 0;
        IPv6TextField.fieldConsts.weightx = 0.0;
        IPv6TextField.fieldConsts.weighty = 0.0;
        IPv6TextField.areaConsts.anchor = 10;
        IPv6TextField.areaConsts.fill = 1;
        IPv6TextField.areaConsts.gridheight = 1;
        IPv6TextField.areaConsts.gridwidth = 1;
        IPv6TextField.areaConsts.gridy = 0;
        IPv6TextField.areaConsts.insets = new Insets(0, 0, 0, 0);
        IPv6TextField.areaConsts.ipadx = 0;
        IPv6TextField.areaConsts.ipady = 0;
        IPv6TextField.areaConsts.weightx = 1.0;
        IPv6TextField.areaConsts.weighty = 0.0;
        IPv6TextField.labelConsts.anchor = 10;
        IPv6TextField.labelConsts.fill = 0;
        IPv6TextField.labelConsts.gridheight = 1;
        IPv6TextField.labelConsts.gridwidth = 1;
        IPv6TextField.labelConsts.gridy = 0;
        IPv6TextField.labelConsts.insets = new Insets(0, 0, 0, 0);
        IPv6TextField.labelConsts.ipadx = 0;
        IPv6TextField.labelConsts.ipady = 0;
        IPv6TextField.labelConsts.weightx = 0.0;
        IPv6TextField.labelConsts.weighty = 0.0;
        this.createIPv6UI();
        this.setMinimumSize(new Dimension(this.sizeManager.getMinimalWidth(), (int)this.getPreferredSize().getHeight()));
    }

    @Override
    public void setName(String string) {
        int n;
        super.setName(string);
        StringBuffer stringBuffer = new StringBuffer(11);
        stringBuffer.append(string).append("_IPv6Field_");
        for (n = 0; n < this.IPv6Fields.length; ++n) {
            this.IPv6Fields[n].setName(stringBuffer.toString() + n);
        }
        stringBuffer = new StringBuffer(11);
        stringBuffer.append(string).append("_IPv4Field_");
        for (n = 0; n < this.IPv4Fields.length; ++n) {
            this.IPv4Fields[n].setName(stringBuffer.toString() + n);
        }
        this.prefixTextField.setName(string + "_prefixLengthField");
        this.editTextField.setName(string + "_editTextField");
        stringBuffer = new StringBuffer(12);
        stringBuffer.append(string).append("_IPv6Labels_");
        int n2 = this.IPv6Labels.length;
        for (n = 0; n < n2; ++n) {
            this.IPv6Labels[n].setName(stringBuffer.toString() + n);
        }
        stringBuffer = new StringBuffer(12);
        stringBuffer.append(string).append("_IPv4Labels_");
        n2 = this.IPv4Labels.length;
        for (n = 0; n < n2; ++n) {
            this.IPv4Labels[n].setName(stringBuffer.toString() + n);
        }
        this.prefixLengthLabel.setName(string + "_prefixLengthLabel");
        this.changeModeBtn.setName(string + "_changeModeBtn");
        this.IPv4Area.setName(string + "_IPv4Area");
        this.basicArea.setName(string + "_basicArea");
        this.prefixArea.setName(string + "_prefixArea");
        this.IPv6_4Area.setName(string + "_IPv6_4Area");
    }

    private void initArea() {
        this.IPv4Area.setBorder(null);
        this.IPv4Area.setFocusable(false);
        this.IPv4Area.setPreferredSize(new Dimension(168, 20));
        this.basicArea.setBorder(null);
        this.basicArea.setFocusable(false);
        this.basicArea.setPreferredSize(new Dimension(32, 20));
        this.prefixArea.setBorder(null);
        this.prefixArea.setFocusable(false);
        this.prefixArea.setPreferredSize(new Dimension(9, 20));
        this.IPv6_4Area.setBorder(null);
        this.IPv6_4Area.setFocusable(false);
        this.IPv6_4Area.setPreferredSize(new Dimension(0, 20));
    }

    private void initChangeModeBtnAction() {
        this.changeModeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IPv6TextField.this.popupMenu == null) {
                    IPv6TextField.this.popupMenu = new JPopupMenu();
                    IPv6TextField.this.basicMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            IPv6TextField.this.basicMenuItem.setSelected(true);
                            IPv6TextField.this.perfixMenuItem.setSelected(false);
                            IPv6TextField.this.IPv6_4MenuItem.setSelected(false);
                            IPv6TextField.this.IPv4MenuItem.setSelected(false);
                            IPv6TextField.this.setAddressMode(0);
                        }
                    });
                    IPv6TextField.this.perfixMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            IPv6TextField.this.basicMenuItem.setSelected(false);
                            IPv6TextField.this.perfixMenuItem.setSelected(true);
                            IPv6TextField.this.IPv6_4MenuItem.setSelected(false);
                            IPv6TextField.this.IPv4MenuItem.setSelected(false);
                            IPv6TextField.this.setAddressMode(1);
                        }
                    });
                    IPv6TextField.this.IPv6_4MenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            IPv6TextField.this.basicMenuItem.setSelected(false);
                            IPv6TextField.this.perfixMenuItem.setSelected(false);
                            IPv6TextField.this.IPv6_4MenuItem.setSelected(true);
                            IPv6TextField.this.IPv4MenuItem.setSelected(false);
                            IPv6TextField.this.setAddressMode(2);
                        }
                    });
                    IPv6TextField.this.IPv4MenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            IPv6TextField.this.basicMenuItem.setSelected(false);
                            IPv6TextField.this.perfixMenuItem.setSelected(false);
                            IPv6TextField.this.IPv6_4MenuItem.setSelected(false);
                            IPv6TextField.this.IPv4MenuItem.setSelected(true);
                            IPv6TextField.this.setAddressMode(3);
                        }
                    });
                    block10: for (int i = 0; i < IPv6TextField.this.supportedMode.length; ++i) {
                        switch (IPv6TextField.this.supportedMode[i]) {
                            case 0: {
                                IPv6TextField.this.popupMenu.add(IPv6TextField.this.basicMenuItem);
                                continue block10;
                            }
                            case 1: {
                                IPv6TextField.this.popupMenu.add(IPv6TextField.this.perfixMenuItem);
                                continue block10;
                            }
                            case 2: {
                                IPv6TextField.this.popupMenu.add(IPv6TextField.this.IPv6_4MenuItem);
                                continue block10;
                            }
                            default: {
                                IPv6TextField.this.popupMenu.add(IPv6TextField.this.IPv4MenuItem);
                            }
                        }
                    }
                }
                IPv6TextField.this.basicMenuItem.setSelected(false);
                IPv6TextField.this.perfixMenuItem.setSelected(false);
                IPv6TextField.this.IPv6_4MenuItem.setSelected(false);
                IPv6TextField.this.IPv4MenuItem.setSelected(false);
                switch (IPv6TextField.this.mode) {
                    case 0: {
                        IPv6TextField.this.basicMenuItem.setSelected(true);
                        break;
                    }
                    case 1: {
                        IPv6TextField.this.perfixMenuItem.setSelected(true);
                        break;
                    }
                    case 2: {
                        IPv6TextField.this.IPv6_4MenuItem.setSelected(true);
                        break;
                    }
                    default: {
                        IPv6TextField.this.IPv4MenuItem.setSelected(true);
                    }
                }
                IPv6TextField.this.popupMenu.show(IPv6TextField.this.changeModeBtn, 0, 24);
            }
        });
    }

    private void createIPv6UI() {
        this.inputPane.setLayout(new GridBagLayout());
        if (this.mode == 0 || this.mode == 1) {
            for (int i = 0; i < 7; ++i) {
                this.inputPane.add((Component)this.IPv6Fields[i], fieldConsts);
                this.inputPane.add((Component)this.IPv6Labels[i], labelConsts);
            }
            this.inputPane.add((Component)this.IPv6Fields[7], fieldConsts);
            if (this.mode == 1) {
                this.inputPane.add((Component)this.prefixLengthLabel, labelConsts);
                this.inputPane.add((Component)this.prefixTextField, fieldConsts);
                this.inputPane.add((Component)this.prefixArea, areaConsts);
            } else {
                this.inputPane.add((Component)this.basicArea, areaConsts);
            }
        } else if (this.mode == 2) {
            int n;
            for (n = 0; n < 6; ++n) {
                this.inputPane.add((Component)this.IPv6Fields[n], fieldConsts);
                this.inputPane.add((Component)this.IPv6Labels[n], labelConsts);
            }
            for (n = 0; n < 3; ++n) {
                this.inputPane.add((Component)this.IPv4Fields[n], fieldConsts);
                this.inputPane.add((Component)this.IPv4Labels[n], labelConsts);
            }
            this.inputPane.add((Component)this.IPv4Fields[3], fieldConsts);
            this.inputPane.add((Component)this.IPv6_4Area, areaConsts);
        } else {
            for (int i = 0; i < 3; ++i) {
                this.inputPane.add((Component)this.IPv4Fields[i], fieldConsts);
                this.inputPane.add((Component)this.IPv4Labels[i], labelConsts);
            }
            this.inputPane.add((Component)this.IPv4Fields[3], fieldConsts);
            this.inputPane.add((Component)this.IPv4Area, areaConsts);
        }
        this.inputPane.setForeground(UIManager.getColor("TextField.foreground"));
        this.inputPane.setBackground(UIManager.getColor("TextField.background"));
        this.inputPane.setBorder(UIManager.getBorder("TextField.border"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.inputPane, new GridBagConstraints(0, 0, 1, 2, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.containChangeModeBtn) {
            this.add((Component)this.changeModeBtn, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.1, 17, 0, new Insets(0, 1, 0, 0), 0, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyText() {
        this.moveFocusToNext = false;
        try {
            String string = null;
            if (this.mode == 0 || this.mode == 1) {
                String string2;
                for (int i = 0; i < this.IPv6Fields.length; ++i) {
                    String string3 = this.IPv6Fields[i].getText().trim();
                    if (string3.length() <= 0) continue;
                    String string4 = string = this.trimZero ? IPv6Address.trimZeroString(string3) : IPv6Address.fillZeroString(string3, 4);
                    if (string3.equals(string)) continue;
                    this.IPv6Fields[i].setText(string);
                }
                if (this.mode == 1 && (string2 = this.prefixTextField.getText().trim()).length() > 0) {
                    String string5 = string = this.trimZero ? IPv6Address.trimZeroString(string2) : IPv6Address.fillZeroString(string2, 3);
                    if (!string2.equals(string)) {
                        this.prefixTextField.setText(string);
                    }
                }
            } else {
                String string6;
                int n;
                for (n = 0; n < this.IPv4Fields.length; ++n) {
                    string6 = this.IPv4Fields[n].getText().trim();
                    if (string6.length() <= 0) continue;
                    String string7 = string = this.trimZero ? IPv6Address.trimZeroString(string6) : IPv6Address.fillZeroString(string6, 3);
                    if (string6.equals(string)) continue;
                    this.IPv4Fields[n].setText(string);
                }
                if (this.mode == 2) {
                    for (n = 0; n < 6; ++n) {
                        string6 = this.IPv6Fields[n].getText().trim();
                        if (string6.length() <= 0) continue;
                        String string8 = string = this.trimZero ? IPv6Address.trimZeroString(string6) : IPv6Address.fillZeroString(string6, 4);
                        if (string6.equals(string)) continue;
                        this.IPv6Fields[n].setText(string);
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        finally {
            this.moveFocusToNext = true;
        }
    }

    public void setAddressMode(int n) {
        int n2;
        boolean bl = false;
        for (n2 = 0; n2 < this.supportedMode.length; ++n2) {
            if (this.supportedMode[n2] != n) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("The mode can not be " + n + ".");
        }
        if (this.mode == n || !this.enabled || !this.editable) {
            return;
        }
        if (this.sizeManager.hasHideComp()) {
            this.sizeManager.resumeAllComp();
        }
        n2 = this.mode;
        this.clearSelectionAll(-1);
        if (this.mode == 0 && n == 1) {
            this.inputPane.remove(this.basicArea);
            this.inputPane.add((Component)this.prefixLengthLabel, labelConsts);
            this.inputPane.add((Component)this.prefixTextField, fieldConsts);
            this.inputPane.add((Component)this.prefixArea, areaConsts);
            this.mode = 1;
        } else if (this.mode == 0 && n == 2) {
            this.inputPane.remove(this.basicArea);
            this.inputPane.remove(this.IPv6Fields[7]);
            this.inputPane.remove(this.IPv6Labels[6]);
            this.inputPane.remove(this.IPv6Fields[6]);
            for (int i = 0; i < 3; ++i) {
                this.inputPane.add((Component)this.IPv4Fields[i], fieldConsts);
                this.inputPane.add((Component)this.IPv4Labels[i], labelConsts);
            }
            this.inputPane.add((Component)this.IPv4Fields[3], fieldConsts);
            this.inputPane.add((Component)this.IPv6_4Area, areaConsts);
            this.ipv6_2_ipv4();
            this.mode = 2;
        } else if (this.mode == 0 && n == 3) {
            int n3;
            this.inputPane.remove(this.basicArea);
            for (n3 = 0; n3 < 7; ++n3) {
                this.inputPane.remove(this.IPv6Fields[n3]);
                this.inputPane.remove(this.IPv6Labels[n3]);
            }
            this.inputPane.remove(this.IPv6Fields[7]);
            for (n3 = 0; n3 < 3; ++n3) {
                this.inputPane.add((Component)this.IPv4Fields[n3], fieldConsts);
                this.inputPane.add((Component)this.IPv4Labels[n3], labelConsts);
            }
            this.inputPane.add((Component)this.IPv4Fields[3], fieldConsts);
            this.inputPane.add((Component)this.IPv4Area, areaConsts);
            this.ipv6_2_ipv4();
            this.mode = 3;
        } else if (this.mode == 1 && n == 0) {
            this.inputPane.remove(this.prefixArea);
            this.inputPane.remove(this.prefixTextField);
            this.inputPane.remove(this.prefixLengthLabel);
            this.inputPane.add((Component)this.basicArea, areaConsts);
            this.mode = 0;
        } else if (this.mode == 1 && n == 2) {
            this.inputPane.remove(this.prefixArea);
            this.inputPane.remove(this.prefixTextField);
            this.inputPane.remove(this.prefixLengthLabel);
            this.inputPane.remove(this.IPv6Fields[7]);
            this.inputPane.remove(this.IPv6Labels[6]);
            this.inputPane.remove(this.IPv6Fields[6]);
            for (int i = 0; i < 3; ++i) {
                this.inputPane.add((Component)this.IPv4Fields[i], fieldConsts);
                this.inputPane.add((Component)this.IPv4Labels[i], labelConsts);
            }
            this.inputPane.add((Component)this.IPv4Fields[3], fieldConsts);
            this.inputPane.add((Component)this.IPv6_4Area, areaConsts);
            this.ipv6_2_ipv4();
            this.mode = 2;
        } else if (this.mode == 1 && n == 3) {
            int n4;
            this.inputPane.remove(this.prefixArea);
            this.inputPane.remove(this.prefixTextField);
            this.inputPane.remove(this.prefixLengthLabel);
            for (n4 = 0; n4 < 7; ++n4) {
                this.inputPane.remove(this.IPv6Fields[n4]);
                this.inputPane.remove(this.IPv6Labels[n4]);
            }
            this.inputPane.remove(this.IPv6Fields[7]);
            for (n4 = 0; n4 < 3; ++n4) {
                this.inputPane.add((Component)this.IPv4Fields[n4], fieldConsts);
                this.inputPane.add((Component)this.IPv4Labels[n4], labelConsts);
            }
            this.inputPane.add((Component)this.IPv4Fields[3], fieldConsts);
            this.inputPane.add((Component)this.IPv4Area, areaConsts);
            this.ipv6_2_ipv4();
            this.mode = 3;
        } else if (this.mode == 2 && n == 0) {
            this.inputPane.remove(this.IPv6_4Area);
            this.inputPane.remove(this.IPv4Fields[3]);
            for (int i = 2; i >= 0; --i) {
                this.inputPane.remove(this.IPv4Labels[i]);
                this.inputPane.remove(this.IPv4Fields[i]);
            }
            this.inputPane.add((Component)this.IPv6Fields[6], fieldConsts);
            this.inputPane.add((Component)this.IPv6Labels[6], labelConsts);
            this.inputPane.add((Component)this.IPv6Fields[7], fieldConsts);
            this.inputPane.add((Component)this.basicArea, areaConsts);
            this.ipv4_2_ipv6();
            this.mode = 0;
        } else if (this.mode == 2 && n == 1) {
            this.inputPane.remove(this.IPv6_4Area);
            this.inputPane.remove(this.IPv4Fields[3]);
            for (int i = 2; i >= 0; --i) {
                this.inputPane.remove(this.IPv4Labels[i]);
                this.inputPane.remove(this.IPv4Fields[i]);
            }
            this.inputPane.add((Component)this.IPv6Fields[6], fieldConsts);
            this.inputPane.add((Component)this.IPv6Labels[6], labelConsts);
            this.inputPane.add((Component)this.IPv6Fields[7], fieldConsts);
            this.inputPane.add((Component)this.prefixLengthLabel, labelConsts);
            this.inputPane.add((Component)this.prefixTextField, fieldConsts);
            this.inputPane.add((Component)this.prefixArea, areaConsts);
            this.ipv4_2_ipv6();
            this.mode = 1;
        } else if (this.mode == 2 && n == 3) {
            this.inputPane.remove(this.IPv6_4Area);
            for (int i = 0; i < 6; ++i) {
                this.inputPane.remove(this.IPv6Labels[i]);
                this.inputPane.remove(this.IPv6Fields[i]);
            }
            this.inputPane.add((Component)this.IPv4Area, areaConsts);
            this.mode = 3;
        } else if (this.mode == 3 && n == 0) {
            int n5;
            this.inputPane.remove(this.IPv4Area);
            this.inputPane.remove(this.IPv4Fields[3]);
            for (n5 = 0; n5 < 3; ++n5) {
                this.inputPane.remove(this.IPv4Fields[n5]);
                this.inputPane.remove(this.IPv4Labels[n5]);
            }
            for (n5 = 0; n5 < 7; ++n5) {
                this.inputPane.add((Component)this.IPv6Fields[n5], fieldConsts);
                this.inputPane.add((Component)this.IPv6Labels[n5], labelConsts);
            }
            this.inputPane.add((Component)this.IPv6Fields[7], fieldConsts);
            this.inputPane.add((Component)this.basicArea, areaConsts);
            this.ipv4_2_ipv6();
            this.mode = 0;
        } else if (this.mode == 3 && n == 1) {
            int n6;
            this.inputPane.remove(this.IPv4Area);
            this.inputPane.remove(this.IPv4Fields[3]);
            for (n6 = 0; n6 < 3; ++n6) {
                this.inputPane.remove(this.IPv4Fields[n6]);
                this.inputPane.remove(this.IPv4Labels[n6]);
            }
            for (n6 = 0; n6 < 7; ++n6) {
                this.inputPane.add((Component)this.IPv6Fields[n6], fieldConsts);
                this.inputPane.add((Component)this.IPv6Labels[n6], labelConsts);
            }
            this.inputPane.add((Component)this.IPv6Fields[7], fieldConsts);
            this.inputPane.add((Component)this.prefixLengthLabel, labelConsts);
            this.inputPane.add((Component)this.prefixTextField, fieldConsts);
            this.inputPane.add((Component)this.prefixArea, areaConsts);
            this.ipv4_2_ipv6();
            this.mode = 1;
        } else {
            int n7;
            this.inputPane.remove(this.IPv4Area);
            this.inputPane.remove(this.IPv4Fields[3]);
            for (n7 = 0; n7 < 3; ++n7) {
                this.inputPane.remove(this.IPv4Fields[n7]);
                this.inputPane.remove(this.IPv4Labels[n7]);
            }
            for (n7 = 0; n7 < 6; ++n7) {
                this.inputPane.add((Component)this.IPv6Fields[n7], fieldConsts);
                this.inputPane.add((Component)this.IPv6Labels[n7], labelConsts);
            }
            for (n7 = 0; n7 < 3; ++n7) {
                this.inputPane.add((Component)this.IPv4Fields[n7], fieldConsts);
                this.inputPane.add((Component)this.IPv4Labels[n7], labelConsts);
            }
            this.inputPane.add((Component)this.IPv4Fields[3], fieldConsts);
            this.inputPane.add((Component)this.IPv6_4Area, areaConsts);
            this.mode = 2;
        }
        this.setPreferredSize(this.preferredSize);
        this.firePropertyChange("mode", n2, this.mode);
        this.revalidate();
        this.repaint();
    }

    public int getAddressMode() {
        return this.mode;
    }

    private void ipv6_2_ipv4() {
        String string = null;
        for (int i = 0; i < 2; ++i) {
            if (this.IPv6Fields[i + 6].getText().trim().length() <= 0) continue;
            string = IPv6Address.fillZeroString(this.IPv6Fields[i + 6].getText().trim(), 4);
            String string2 = Integer.toString(Integer.parseInt(string.substring(0, 2), 16));
            String string3 = Integer.toString(Integer.parseInt(string.substring(2), 16));
            if (this.trimZero) {
                this.IPv4Fields[2 * i].setText(string2);
                this.IPv4Fields[2 * i + 1].setText(string3);
                continue;
            }
            string2 = IPv6Address.fillZeroString(string2, 2);
            string3 = IPv6Address.fillZeroString(string3, 2);
            this.IPv4Fields[2 * i].setText(string2);
            this.IPv4Fields[2 * i + 1].setText(string3);
        }
    }

    private void ipv4_2_ipv6() {
        for (int i = 0; i < 2; ++i) {
            String string = this.IPv4Fields[i * 2].getText().trim();
            String string2 = this.IPv4Fields[i * 2 + 1].getText().trim();
            if (string.length() > 0) {
                string = this.trimZero ? Integer.toString(Integer.parseInt(string), 16) : IPv6Address.fillZeroString(Integer.toString(Integer.parseInt(string), 16), 2);
            }
            if (this.IPv4Fields[i * 2 + 1].getText().trim().length() > 0) {
                string2 = IPv6Address.fillZeroString(Integer.toString(Integer.parseInt(string2), 16), 2);
            }
            if (string.length() == 0 && string2.length() == 0) continue;
            if (string2.length() == 0) {
                string2 = "00";
            }
            if (this.trimZero) {
                this.IPv6Fields[i + 6].setText(IPv6Address.trimZeroString(string + string2));
                continue;
            }
            this.IPv6Fields[i + 6].setText(string + string2);
        }
    }

    public void addFieldDocumentListener(DocumentListener documentListener) {
        int n;
        for (n = 0; n < this.IPv6Fields.length; ++n) {
            this.IPv6Fields[n].getDocument().addDocumentListener(documentListener);
        }
        for (n = 0; n < this.IPv4Fields.length; ++n) {
            this.IPv4Fields[n].getDocument().addDocumentListener(documentListener);
        }
        this.prefixTextField.getDocument().addDocumentListener(documentListener);
        this.editTextField.getDocument().addDocumentListener(documentListener);
    }

    public void removeFieldDocumentListener(DocumentListener documentListener) {
        int n;
        for (n = 0; n < this.IPv6Fields.length; ++n) {
            this.IPv6Fields[n].getDocument().removeDocumentListener(documentListener);
        }
        for (n = 0; n < this.IPv4Fields.length; ++n) {
            this.IPv4Fields[n].getDocument().removeDocumentListener(documentListener);
        }
        this.prefixTextField.getDocument().removeDocumentListener(documentListener);
        this.editTextField.getDocument().removeDocumentListener(documentListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        int n;
        for (n = 0; n < this.IPv6Fields.length; ++n) {
            this.IPv6Fields[n].addKeyListener(keyListener);
        }
        for (n = 0; n < this.IPv4Fields.length; ++n) {
            this.IPv4Fields[n].addKeyListener(keyListener);
        }
        this.prefixTextField.addKeyListener(keyListener);
        this.editTextField.addKeyListener(keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        int n;
        for (n = 0; n < this.IPv6Fields.length; ++n) {
            this.IPv6Fields[n].removeKeyListener(keyListener);
        }
        for (n = 0; n < this.IPv4Fields.length; ++n) {
            this.IPv4Fields[n].removeKeyListener(keyListener);
        }
        this.prefixTextField.removeKeyListener(keyListener);
        this.editTextField.removeKeyListener(keyListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        int n;
        for (n = 0; n < this.IPv6Fields.length; ++n) {
            this.IPv6Fields[n].addMouseListener(mouseListener);
        }
        for (n = 0; n < this.IPv6Labels.length; ++n) {
            this.IPv6Labels[n].addMouseListener(mouseListener);
        }
        for (n = 0; n < this.IPv4Fields.length; ++n) {
            this.IPv4Fields[n].addMouseListener(mouseListener);
        }
        for (n = 0; n < this.IPv4Labels.length; ++n) {
            this.IPv4Labels[n].addMouseListener(mouseListener);
        }
        this.prefixLengthLabel.addMouseListener(mouseListener);
        this.prefixTextField.addMouseListener(mouseListener);
        this.editTextField.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        int n;
        for (n = 0; n < this.IPv6Fields.length; ++n) {
            this.IPv6Fields[n].removeMouseListener(mouseListener);
        }
        for (n = 0; n < this.IPv6Labels.length; ++n) {
            this.IPv6Labels[n].removeMouseListener(mouseListener);
        }
        for (n = 0; n < this.IPv4Fields.length; ++n) {
            this.IPv4Fields[n].removeMouseListener(mouseListener);
        }
        for (n = 0; n < this.IPv4Labels.length; ++n) {
            this.IPv4Labels[n].removeMouseListener(mouseListener);
        }
        this.prefixLengthLabel.removeMouseListener(mouseListener);
        this.prefixTextField.removeMouseListener(mouseListener);
        this.editTextField.removeMouseListener(mouseListener);
    }

    public byte[] getNumericFormat() {
        int n;
        if (this.mode == 3) {
            throw new UnsupportedOperationException("The \"getNumericFormat\" method can not be invoked when the mode is MODE_IPv4");
        }
        String string = null;
        for (n = 0; n < 6; ++n) {
            string = IPv6Address.fillZeroString(this.IPv6Fields[n].getText().trim(), 4);
            this.address[n * 2] = (byte)Integer.parseInt(string.substring(0, 2), 16);
            this.address[n * 2 + 1] = (byte)Integer.parseInt(string.substring(2), 16);
        }
        if (this.mode != 2) {
            for (n = 6; n < 8; ++n) {
                string = IPv6Address.fillZeroString(this.IPv6Fields[n].getText().trim(), 4);
                this.address[n * 2] = (byte)Integer.parseInt(string.substring(0, 2), 16);
                this.address[n * 2 + 1] = (byte)Integer.parseInt(string.substring(2), 16);
            }
        } else {
            for (n = 0; n < 4; ++n) {
                string = IPv6Address.fillZeroString(this.IPv4Fields[n].getText().trim(), 3);
                this.address[n + 12] = (byte)Integer.parseInt(string);
            }
        }
        return this.address;
    }

    public String getTextFormat(int n, boolean bl, boolean bl2) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("The mode must be one of the 'MODE_BASIC','MODE_PERFIX' or 'MODE_IPv6_4'.");
        }
        byte[] byArray = this.getNumericFormat();
        IPv6Address iPv6Address = new IPv6Address(byArray);
        iPv6Address.setAddressMode(n);
        iPv6Address.useAbbreviatory(bl, bl2);
        String string = iPv6Address.toString();
        if (n == 1 && this.mode == 1 && this.prefixTextField.getText().trim().length() > 0) {
            string = string.substring(0, string.indexOf("/") + 1) + this.prefixTextField.getText();
        }
        return string;
    }

    public String getTextFormat(int n, boolean bl) {
        return this.getTextFormat(n, bl, false);
    }

    public void useAbbreviatory(boolean bl, boolean bl2) {
        boolean bl3 = this.trimZero;
        boolean bl4 = this.useDoubleColon;
        this.trimZero = bl;
        this.useDoubleColon = bl2;
        if (this.editable || bl3 == bl && bl4 == bl2) {
            return;
        }
        this.setEditable(true);
        this.setEditable(false);
    }

    public void useAbbreviatory(boolean bl) {
        this.useAbbreviatory(bl, false);
    }

    public void setEditable(boolean bl) {
        if (this.editable == bl || !this.enabled) {
            return;
        }
        this.editable = bl;
        if (bl) {
            if (this.editFieldShow) {
                this.editFieldShow = false;
                this.inputPane.removeAll();
                this.createIPv6UI();
                this.changeModeBtn.setEnabled(bl);
                this.revalidate();
                this.repaint();
            } else {
                for (int i = 0; i < this.inputPane.getComponentCount(); ++i) {
                    if (this.inputPane.getComponent(i) instanceof JTextField) {
                        ((JTextField)this.inputPane.getComponent(i)).setEditable(true);
                        continue;
                    }
                    if (!(this.inputPane.getComponent(i) instanceof JLabel)) continue;
                    ((JLabel)this.inputPane.getComponent(i)).setBackground(UIManager.getColor("TextField.background"));
                }
                this.inputPane.setBackground(UIManager.getColor("TextField.background"));
                this.changeModeBtn.setEnabled(bl);
                this.repaint();
            }
            this.inputPane.setEnabled(bl);
            this.changeModeIcon.setBrushColor(Color.BLACK);
            this.changeModeBtn.setIcon(this.changeModeIcon);
        } else {
            String string;
            if (this.trimZero && this.useDoubleColon && this.mode != 3 && !(string = this.getTextFormat(this.mode, this.trimZero, this.useDoubleColon)).equals(this.getTextFormat(this.mode, this.trimZero, false))) {
                this.editFieldShow = true;
                this.editTextField.setText(string);
                this.editTextField.setEditable(bl);
                this.changeModeBtn.setEnabled(bl);
                this.changeModeIcon.setBrushColor(Color.GRAY);
                this.changeModeBtn.setIcon(this.changeModeIcon);
                this.inputPane.removeAll();
                this.inputPane.add((Component)this.editTextField, areaConsts);
                this.inputPane.setEnabled(bl);
                this.revalidate();
                this.repaint();
                return;
            }
            for (int i = 0; i < this.inputPane.getComponentCount(); ++i) {
                if (this.inputPane.getComponent(i) instanceof JTextField) {
                    ((JTextField)this.inputPane.getComponent(i)).setEditable(false);
                    continue;
                }
                if (!(this.inputPane.getComponent(i) instanceof JLabel)) continue;
                ((JLabel)this.inputPane.getComponent(i)).setBackground(UIManager.getColor("TextField.inactiveBackground"));
            }
            this.inputPane.setBackground(UIManager.getColor("TextField.inactiveBackground"));
            this.inputPane.setEnabled(bl);
            this.changeModeBtn.setEnabled(bl);
            this.changeModeIcon.setBrushColor(Color.GRAY);
            this.changeModeBtn.setIcon(this.changeModeIcon);
            this.repaint();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
        this.sizeManager.setPreferredSize(dimension);
        super.setPreferredSize(dimension);
    }

    public IPv6SizeManager getSizeManager() {
        return this.sizeManager;
    }

    final void createNewArea(int n, int n2, int n3, int n4) {
        Dimension dimension = new Dimension(n >= 0 ? n : 0, 0);
        this.basicArea.setPreferredSize(dimension);
        this.basicArea.setMinimumSize(dimension);
        this.basicArea.setMaximumSize(dimension);
        dimension = new Dimension(n2 >= 0 ? n2 : 0, 0);
        this.prefixArea.setPreferredSize(dimension);
        this.prefixArea.setMinimumSize(dimension);
        this.prefixArea.setMaximumSize(dimension);
        dimension = new Dimension(n4 >= 0 ? n4 : 0, 0);
        this.IPv4Area.setPreferredSize(dimension);
        this.IPv4Area.setMaximumSize(dimension);
        this.IPv4Area.setMinimumSize(dimension);
        dimension = new Dimension(n3 >= 0 ? n3 : 0, 0);
        this.IPv6_4Area.setPreferredSize(dimension);
        this.IPv6_4Area.setMinimumSize(dimension);
        this.IPv6_4Area.setMaximumSize(dimension);
    }

    public String getIPv4Address(boolean bl, boolean bl2) {
        if (this.mode != 3) {
            throw new UnsupportedOperationException("The \"getIPv4Address(boolean,boolean)\" method only can be invoked when the mode is MODE_IPv4");
        }
        StringBuffer stringBuffer = new StringBuffer(15);
        if (bl) {
            for (int i = 0; i < 4; ++i) {
                if (this.IPv4Fields[i].getText().trim().length() == 0) {
                    if (bl2) {
                        stringBuffer.append("0");
                    } else {
                        stringBuffer.append("   ");
                    }
                } else {
                    stringBuffer.append(IPv6Address.trimZeroString(this.IPv4Fields[i].getText().trim()));
                }
                stringBuffer.append(".");
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                if (this.IPv4Fields[i].getText().trim().length() == 0) {
                    if (bl2) {
                        stringBuffer.append("000");
                    } else {
                        stringBuffer.append("   ");
                    }
                } else {
                    stringBuffer.append(IPv6Address.fillZeroString(this.IPv4Fields[i].getText().trim(), 3));
                }
                stringBuffer.append(".");
            }
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        int n = this.inputPane.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.inputPane.getComponent(i);
            component.setEnabled(bl);
            if (!(component instanceof JLabel)) continue;
            JLabel jLabel = (JLabel)component;
            if (bl) {
                jLabel.setForeground(UIManager.getColor("TextField.foreground"));
                jLabel.setBackground(UIManager.getColor("TextField.background"));
                continue;
            }
            jLabel.setForeground(UIManager.getColor("TextField.inactiveForeground"));
            jLabel.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        }
        if (bl) {
            this.inputPane.setBackground(UIManager.getColor("TextField.background"));
        } else {
            this.inputPane.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        }
        this.changeModeBtn.setEnabled(bl);
        this.changeModeIcon.setBrushColor(bl && this.editable ? Color.BLACK : Color.GRAY);
        this.changeModeBtn.setIcon(this.changeModeIcon);
        if (bl && !this.editable) {
            this.setEditable(true);
            this.setEditable(false);
        }
        this.inputPane.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String getText() {
        if (this.editFieldShow) {
            return this.editTextField.getText();
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = this.inputPane.getComponentCount();
        Component component = null;
        for (int i = 0; i < n; ++i) {
            component = this.inputPane.getComponent(i);
            if (component instanceof InnerIPv6TextField) {
                stringBuffer.append(IPv6Address.fillspaceString(((InnerIPv6TextField)component).getText(), 4));
                continue;
            }
            if (component instanceof JTextField) {
                stringBuffer.append(IPv6Address.fillspaceString(((JTextField)component).getText(), 3));
                continue;
            }
            if (!(component instanceof JLabel)) continue;
            stringBuffer.append(((JLabel)component).getText());
        }
        return stringBuffer.toString();
    }

    public boolean isEmpty() {
        String string = this.getText();
        string = string.replaceAll(":", "");
        string = string.replaceAll("/", "");
        string = string.replaceAll("\\s", "");
        return (string = string.replaceAll("\\.", "")).length() == 0;
    }

    public void setText(String string) {
        if (IPv6Address.checkIPAddress(string, this.mode, false, true)) {
            this.ctrlVAll(string, this.mode);
        } else {
            logger.debug("address is not legal IPaddress.");
        }
    }

    @Override
    public void setToolTipText(String string) {
        int n;
        for (n = 0; n < this.IPv6Fields.length; ++n) {
            this.IPv6Fields[n].setToolTipText(string);
        }
        for (n = 0; n < this.IPv6Labels.length; ++n) {
            this.IPv6Labels[n].setToolTipText(string);
        }
        for (n = 0; n < this.IPv4Fields.length; ++n) {
            this.IPv4Fields[n].setToolTipText(string);
        }
        for (n = 0; n < this.IPv4Labels.length; ++n) {
            this.IPv4Labels[n].setToolTipText(string);
        }
        this.prefixLengthLabel.setToolTipText(string);
        this.prefixTextField.setToolTipText(string);
        this.editTextField.setToolTipText(string);
        this.inputPane.setToolTipText(string);
    }

    @Override
    public void requestFocus() {
        if (!this.editable || !this.enabled) {
            return;
        }
        if (this.mode == 3) {
            this.IPv4Fields[0].requestFocus();
        } else {
            this.IPv6Fields[0].requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean bl) {
        if (!this.editable || !this.enabled) {
            return false;
        }
        if (this.mode == 3) {
            return this.IPv4Fields[0].requestFocus(bl);
        }
        return this.IPv6Fields[0].requestFocus(bl);
    }

    final void selectionAll() {
        if (!this.hasSelectionAll) {
            this.notifyClearSelection = false;
            if (this.mode == 0) {
                this.directFill = true;
                this.IPv6Fields[7].requestFocus();
                this.IPv6Fields[7].setText(IPv6Address.fillspaceString(this.IPv6Fields[7].getText(), 4));
            } else if (this.mode == 1) {
                this.directFill = true;
                this.prefixTextField.requestFocus();
                this.prefixTextField.setText(IPv6Address.fillspaceString(this.prefixTextField.getText(), 3));
            } else {
                this.directFill = true;
                this.IPv4Fields[3].requestFocus();
                this.IPv4Fields[3].setText(IPv6Address.fillspaceString(this.IPv4Fields[3].getText(), 3));
            }
            int n = this.inputPane.getComponentCount();
            Component component = null;
            for (int i = 0; i < n; ++i) {
                component = this.inputPane.getComponent(i);
                component.setBackground(UIManager.getColor("TextField.selectionBackground"));
                component.setForeground(UIManager.getColor("TextField.selectionForeground"));
            }
            this.hasSelectionAll = true;
        }
    }

    final void clearSelectionAll(int n) {
        if (this.hasSelectionAll) {
            this.inputPane.setBackground(UIManager.getColor("TextField.background"));
            int n2 = this.inputPane.getComponentCount();
            Component component = null;
            for (int i = 0; i < n2; ++i) {
                component = this.inputPane.getComponent(i);
                component.setBackground(UIManager.getColor("TextField.background"));
                component.setForeground(UIManager.getColor("TextField.foreground"));
            }
            if (this.mode == 0) {
                String string = this.IPv6Fields[7].getText();
                if (string.length() != string.trim().length()) {
                    this.IPv6Fields[7].setText(string.trim());
                    if (n != -1) {
                        this.IPv6Fields[7].setCaretPosition(n < string.trim().length() ? n : string.trim().length());
                    }
                }
            } else if (this.mode == 1) {
                String string = this.prefixTextField.getText();
                if (string.length() != string.trim().length()) {
                    this.prefixTextField.setText(string.trim());
                    if (n != -1) {
                        this.prefixTextField.setCaretPosition(n < string.trim().length() ? n : string.trim().length());
                    }
                }
            } else {
                String string = this.IPv4Fields[3].getText();
                if (string.length() != string.trim().length()) {
                    this.IPv4Fields[3].setText(string.trim());
                    if (n != -1) {
                        this.IPv4Fields[3].setCaretPosition(n < string.trim().length() ? n : string.trim().length());
                    }
                }
            }
            this.hasSelectionAll = false;
        }
    }

    final void copyToClipboard() {
        if (this.hasSelectionAll) {
            String string = this.getText();
            StringSelection stringSelection = null;
            stringSelection = this.mode == 3 ? new StringSelection(this.delSpace(string)) : new StringSelection(string);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    private String delSpace(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(15);
        int n2 = -1;
        int n3 = 0;
        while (n3 < n && (n3 = string.indexOf(32, n3)) != -1) {
            stringBuffer.append(string.substring(n2 + 1, n3));
            n2 = n3++;
        }
        return stringBuffer.append(string.substring(n2 + 1, n)).toString();
    }

    final void cutAll() {
        this.copyToClipboard();
        this.clear();
        this.requestFocus();
    }

    public void clear() {
        this.clearSelectionAll(-1);
        int n = this.inputPane.getComponentCount();
        Component component = null;
        for (int i = 0; i < n; ++i) {
            component = this.inputPane.getComponent(i);
            if (!(component instanceof JTextField)) continue;
            ((JTextField)component).setText("");
        }
    }

    private void ctrlVAll(String string, int n) {
        String string2 = string;
        string2 = IPv6Address.doubleColon2basic(string2);
        if (n == 0) {
            int n2 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            while (stringTokenizer.hasMoreElements()) {
                this.IPv6Fields[n2].setText(stringTokenizer.nextToken().trim());
                ++n2;
            }
            if (this.IPv6Fields[0].isFocusOwner()) {
                this.IPv6Fields[7].requestFocus();
            }
        } else if (n == 1) {
            int n3 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":/");
            while (stringTokenizer.hasMoreElements()) {
                if (n3 < 8) {
                    this.IPv6Fields[n3].setText(stringTokenizer.nextToken().trim());
                    ++n3;
                    continue;
                }
                this.prefixTextField.setText(stringTokenizer.nextToken().trim());
            }
            if (this.IPv6Fields[0].isFocusOwner()) {
                this.prefixTextField.requestFocus();
            }
        } else if (n == 2) {
            int n4 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":.");
            while (stringTokenizer.hasMoreElements()) {
                if (n4 < 6) {
                    this.IPv6Fields[n4].setText(stringTokenizer.nextToken().trim());
                } else {
                    this.IPv4Fields[n4 - 6].setText(stringTokenizer.nextToken().trim());
                }
                ++n4;
            }
            if (this.IPv6Fields[0].isFocusOwner()) {
                this.IPv4Fields[3].requestFocus();
            }
        } else if (n == 3) {
            int n5 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            while (stringTokenizer.hasMoreElements()) {
                this.IPv4Fields[n5].setText(stringTokenizer.nextToken().trim());
                ++n5;
            }
            if (this.IPv4Fields[0].isFocusOwner()) {
                this.IPv4Fields[3].requestFocus();
            }
        }
    }

    final boolean ctrlV() {
        String string = null;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            string = (String)clipboard.getContents(null).getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return false;
        }
        if (string == null) {
            return false;
        }
        string = this.mode == 3 ? this.IPv4Fields[0].getText().substring(0, this.IPv4Fields[0].getCaretPosition()) + string : this.IPv6Fields[0].getText().substring(0, this.IPv6Fields[0].getCaretPosition()) + string;
        if (IPv6Address.checkIPAddress(string, this.mode, true, true)) {
            this.ctrlVAll(string, this.mode);
            return true;
        }
        return false;
    }

    final boolean canRemove() {
        return this.canRemove;
    }

    final void setCanRemove(boolean bl) {
        this.canRemove = bl;
    }

    final int[] getSupportedMode() {
        return this.supportedMode;
    }

    private JTextField getIPv6_4Area() {
        return new JTextField(){

            @Override
            public void processMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.getID() == 501) {
                    IPv6TextField.this.processMouseEventForBlankareas(IPv6TextField.this.IPv4Fields[IPv6TextField.this.IPv4Fields.length - 1]);
                }
            }
        };
    }

    private JTextField getPrefixArea() {
        return new JTextField(){

            @Override
            public void processMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.getID() == 501) {
                    IPv6TextField.this.processMouseEventForBlankareas(IPv6TextField.this.prefixTextField);
                }
            }
        };
    }

    private JTextField getbasicArea() {
        return new JTextField(){

            @Override
            public void processMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.getID() == 501) {
                    IPv6TextField.this.processMouseEventForBlankareas(IPv6TextField.this.IPv6Fields[IPv6TextField.this.IPv6Fields.length - 1]);
                }
            }
        };
    }

    private JTextField getIPv4Area() {
        return new JTextField(){

            @Override
            public void processMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.getID() == 501) {
                    IPv6TextField.this.processMouseEventForBlankareas(IPv6TextField.this.IPv4Fields[IPv6TextField.this.IPv4Fields.length - 1]);
                }
            }
        };
    }

    private void processMouseEventForBlankareas(JTextField jTextField) {
        jTextField.requestFocus();
        String string = jTextField.getText().trim();
        int n = 0;
        if (null != string) {
            n = string.length();
        }
        jTextField.setCaretPosition(n);
    }

    private final class IPv6KeyListener
    extends KeyAdapter {
        private IPv6KeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                IPv6TextField.this.clearSelectionAll(-1);
                IPv6TextField.this.modifyText();
            }
        }
    }

    private final class IPv6FocusListener
    extends FocusAdapter {
        private IPv6FocusListener() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                Component component = focusEvent.getOppositeComponent();
                if (!(component instanceof InnerIPv6TextField || component instanceof InnerIPv4TextField || component instanceof InnerPrefixTextField)) {
                    IPv6TextField.this.clearSelectionAll(-1);
                    IPv6TextField.this.modifyText();
                } else {
                    boolean bl = false;
                    if (component instanceof InnerIPv6TextField) {
                        for (int i = 0; i < IPv6TextField.this.IPv6Fields.length; ++i) {
                            if (component != IPv6TextField.this.IPv6Fields[i]) continue;
                            bl = true;
                            break;
                        }
                    } else if (component instanceof InnerIPv4TextField) {
                        for (int i = 0; i < IPv6TextField.this.IPv4Fields.length; ++i) {
                            if (component != IPv6TextField.this.IPv4Fields[i]) continue;
                            bl = true;
                            break;
                        }
                    } else if (component == IPv6TextField.this.prefixTextField) {
                        bl = true;
                    }
                    if (!bl) {
                        IPv6TextField.this.clearSelectionAll(-1);
                        IPv6TextField.this.modifyText();
                    }
                }
                if (IPv6TextField.this.notifyClearSelection) {
                    IPv6TextField.this.clearSelectionAll(-1);
                } else {
                    IPv6TextField.this.notifyClearSelection = true;
                }
            }
        }
    }
}

