/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield.ipaddress;

import com.swimap.iview.templates.textfield.ipaddress.IPv6TextField;
import com.swimap.iview.templates.textfield.ipaddress.InnerIPv4TextField;
import com.swimap.iview.templates.textfield.ipaddress.InnerIPv6BtnIcon;
import com.swimap.iview.templates.textfield.ipaddress.InnerIPv6TextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class IPv6SizeManager {
    private IPv6TextField ipv6 = null;
    private int ipV6PreferredWidth = 29;
    private int ipV4PreferredWidth = 22;
    private int labelPreferredWidth = 3;
    private boolean isFixed = false;
    private static final int BASICAREAWIDTH = 32;
    private int basicAreaWidth = 32;
    private int prefixAreaWidth = 9;
    private static final int IPV4AREAWIDTH = 168;
    private int ipV4AreaWidth = 168;
    private int ipV6_4AreaWidth = 0;
    private LinkedList left = new LinkedList();
    private LinkedList middle = new LinkedList();
    private LinkedList right = new LinkedList();
    private boolean hasHideComp = true;

    public IPv6SizeManager(IPv6TextField iPv6TextField) {
        this.ipv6 = iPv6TextField;
    }

    public void setIPv6FieldPreferredWidth(int n) {
        this.isFixed = true;
        this.ipV6PreferredWidth = n;
        int n2 = this.ipv6.IPv6Fields[0].getPreferredSize().height;
        Dimension dimension = new Dimension(n, n2);
        for (int i = 0; i < this.ipv6.IPv6Fields.length; ++i) {
            this.ipv6.IPv6Fields[i].setPreferredSize(dimension);
            this.ipv6.IPv6Fields[i].setMinimumSize(dimension);
            this.ipv6.IPv6Fields[i].setMaximumSize(dimension);
        }
        this.ipv6.setMinimumSize(new Dimension(this.getMinimalWidth(), (int)this.ipv6.getPreferredSize().getHeight()));
    }

    public void setIPv4FieldPreferredWidth(int n) {
        this.isFixed = true;
        this.ipV4PreferredWidth = n;
        int n2 = this.ipv6.IPv4Fields[0].getPreferredSize().height;
        Dimension dimension = new Dimension(n, n2);
        for (int i = 0; i < this.ipv6.IPv4Fields.length; ++i) {
            this.ipv6.IPv4Fields[i].setPreferredSize(dimension);
            this.ipv6.IPv4Fields[i].setMinimumSize(dimension);
            this.ipv6.IPv4Fields[i].setMaximumSize(dimension);
        }
        this.ipv6.prefixTextField.setPreferredSize(dimension);
        this.ipv6.prefixTextField.setMinimumSize(dimension);
        this.ipv6.prefixTextField.setMaximumSize(dimension);
        this.ipv6.setMinimumSize(new Dimension(this.getMinimalWidth(), (int)this.ipv6.getPreferredSize().getHeight()));
    }

    public void setPreferredSize(Dimension dimension) {
        if (dimension == null) {
            return;
        }
        this.setPreferredHeight(dimension.height);
        this.setPreferredWidth(dimension.width);
        this.ipv6.setMinimumSize(new Dimension(this.getMinimalWidth(), (int)this.ipv6.getPreferredSize().getHeight()));
    }

    private void setPreferredHeight(int n) {
        if (this.ipv6.getPreferredSize().getHeight() != (double)n) {
            int n2;
            int n3 = this.ipv6.IPv6Fields[0].getPreferredSize().width;
            Dimension dimension = new Dimension(n3, n - 4);
            int n4 = this.ipv6.IPv6Fields.length;
            for (n2 = 0; n2 < n4; ++n2) {
                this.ipv6.IPv6Fields[n2].setPreferredSize(dimension);
                this.ipv6.IPv6Fields[n2].setMinimumSize(dimension);
                this.ipv6.IPv6Fields[n2].setMaximumSize(dimension);
            }
            n3 = this.ipv6.IPv6Labels[0].getPreferredSize().width;
            dimension = new Dimension(n3, n - 4);
            n4 = this.ipv6.IPv6Labels.length;
            for (n2 = 0; n2 < n4; ++n2) {
                this.ipv6.IPv6Labels[n2].setPreferredSize(dimension);
                this.ipv6.IPv6Labels[n2].setMinimumSize(dimension);
                this.ipv6.IPv6Labels[n2].setMaximumSize(dimension);
            }
            n3 = this.ipv6.IPv4Fields[0].getPreferredSize().width;
            dimension = new Dimension(n3, n - 4);
            n4 = this.ipv6.IPv4Fields.length;
            for (n2 = 0; n2 < n4; ++n2) {
                this.ipv6.IPv4Fields[n2].setPreferredSize(dimension);
                this.ipv6.IPv4Fields[n2].setMinimumSize(dimension);
                this.ipv6.IPv4Fields[n2].setMaximumSize(dimension);
            }
            n3 = this.ipv6.IPv4Labels[0].getPreferredSize().width;
            dimension = new Dimension(n3, n - 4);
            n4 = this.ipv6.IPv4Labels.length;
            for (n2 = 0; n2 < n4; ++n2) {
                this.ipv6.IPv4Labels[n2].setPreferredSize(dimension);
                this.ipv6.IPv4Labels[n2].setMinimumSize(dimension);
                this.ipv6.IPv4Labels[n2].setMaximumSize(dimension);
            }
            dimension = new Dimension(this.ipv6.prefixLengthLabel.getPreferredSize().width, n - 4);
            this.ipv6.prefixLengthLabel.setPreferredSize(dimension);
            this.ipv6.prefixLengthLabel.setMinimumSize(dimension);
            this.ipv6.prefixLengthLabel.setMaximumSize(dimension);
            dimension = new Dimension(this.ipv6.prefixTextField.getPreferredSize().width, n - 4);
            this.ipv6.prefixTextField.setPreferredSize(dimension);
            this.ipv6.prefixTextField.setMinimumSize(dimension);
            this.ipv6.prefixTextField.setMaximumSize(dimension);
            dimension = new Dimension(this.ipv6.editTextField.getPreferredSize().width, n - 4);
            this.ipv6.editTextField.setPreferredSize(dimension);
            this.ipv6.editTextField.setMinimumSize(dimension);
            this.ipv6.editTextField.setMaximumSize(dimension);
            dimension = new Dimension(n, n);
            this.ipv6.changeModeBtn.setMaximumSize(dimension);
            this.ipv6.changeModeBtn.setMinimumSize(dimension);
            this.ipv6.changeModeBtn.setPreferredSize(dimension);
            InnerIPv6BtnIcon innerIPv6BtnIcon = new InnerIPv6BtnIcon(Color.black, 1, 12, 8, (n + 1) / 3, (n + 1) / 3 + 2);
            this.ipv6.changeModeBtn.setIcon(innerIPv6BtnIcon);
        }
    }

    private void setPreferredWidth(int n) {
        int n2;
        int n3 = n - this.ipv6.getPreferredSize().width;
        if (n3 == 0) {
            return;
        }
        if (this.isFixed) {
            n2 = 0;
            if (this.ipv6.containChangeModeBtn) {
                n2 = this.ipv6.changeModeBtn.getPreferredSize().width + 1;
            }
            this.basicAreaWidth = n - this.ipV6PreferredWidth * 8 - this.labelPreferredWidth * 7 - 4 - n2;
            this.prefixAreaWidth = n - this.ipV6PreferredWidth * 8 - this.labelPreferredWidth * 8 - this.ipV4PreferredWidth * 1 - 4 - n2;
            this.ipV6_4AreaWidth = n - this.ipV6PreferredWidth * 6 - this.labelPreferredWidth * 9 - this.ipV4PreferredWidth * 4 - 4 - n2;
            this.ipV4AreaWidth = n - this.labelPreferredWidth * 3 - this.ipV4PreferredWidth * 4 - 4 - n2;
            this.setAreaPreferredWidth();
            this.hidePartComp(n);
        } else {
            int n4;
            n2 = n3 / 10;
            if (n3 < 0 && n3 % 10 != 0) {
                --n2;
            }
            this.ipV6PreferredWidth += n2;
            int n5 = this.ipv6.IPv6Fields[0].getPreferredSize().height;
            int n6 = this.ipv6.IPv6Fields.length;
            for (n4 = 0; n4 < n6; ++n4) {
                this.ipv6.IPv6Fields[n4].setPreferredSize(new Dimension(this.ipV6PreferredWidth, n5));
                this.ipv6.IPv6Fields[n4].setMinimumSize(new Dimension(this.ipV6PreferredWidth, n5));
                this.ipv6.IPv6Fields[n4].setMaximumSize(new Dimension(this.ipV6PreferredWidth, n5));
            }
            this.ipV4PreferredWidth += n2;
            n5 = this.ipv6.IPv4Fields[0].getPreferredSize().height;
            n6 = this.ipv6.IPv4Fields.length;
            for (n4 = 0; n4 < n6; ++n4) {
                this.ipv6.IPv4Fields[n4].setPreferredSize(new Dimension(this.ipV4PreferredWidth, n5));
                this.ipv6.IPv4Fields[n4].setMinimumSize(new Dimension(this.ipV4PreferredWidth, n5));
                this.ipv6.IPv4Fields[n4].setMaximumSize(new Dimension(this.ipV4PreferredWidth, n5));
            }
            this.ipv6.prefixTextField.setPreferredSize(new Dimension(this.ipV4PreferredWidth, this.ipv6.prefixTextField.getPreferredSize().height));
            this.basicAreaWidth += n3 - n2 * 8;
            this.prefixAreaWidth += n3 - n2 * 9 + 1;
            this.ipV6_4AreaWidth += n3 - n2 * 10;
            this.ipV4AreaWidth += n3 - n2 * 4;
            this.setAreaPreferredWidth();
        }
        n2 = n - this.ipv6.changeModeBtn.getPreferredSize().width - 5;
        Dimension dimension = new Dimension(n2, this.ipv6.editTextField.getPreferredSize().height);
        this.ipv6.editTextField.setPreferredSize(dimension);
        this.ipv6.editTextField.setMinimumSize(dimension);
        this.ipv6.editTextField.setMaximumSize(dimension);
    }

    private void setAreaPreferredWidth() {
        switch (this.ipv6.mode) {
            case 0: {
                this.ipv6.inputPane.remove(this.ipv6.basicArea);
                this.ipv6.createNewArea(this.basicAreaWidth, this.prefixAreaWidth, this.ipV6_4AreaWidth, this.ipV4AreaWidth);
                this.ipv6.inputPane.add((Component)this.ipv6.basicArea, IPv6TextField.areaConsts);
                break;
            }
            case 1: {
                this.ipv6.inputPane.remove(this.ipv6.prefixArea);
                this.ipv6.createNewArea(this.basicAreaWidth, this.prefixAreaWidth, this.ipV6_4AreaWidth, this.ipV4AreaWidth);
                this.ipv6.inputPane.add((Component)this.ipv6.prefixArea, IPv6TextField.areaConsts);
                break;
            }
            case 2: {
                this.ipv6.inputPane.remove(this.ipv6.IPv6_4Area);
                this.ipv6.createNewArea(this.basicAreaWidth, this.prefixAreaWidth, this.ipV6_4AreaWidth, this.ipV4AreaWidth);
                this.ipv6.inputPane.add((Component)this.ipv6.IPv6_4Area, IPv6TextField.areaConsts);
                break;
            }
            default: {
                this.ipv6.inputPane.remove(this.ipv6.IPv4Area);
                this.ipv6.createNewArea(this.basicAreaWidth, this.prefixAreaWidth, this.ipV6_4AreaWidth, this.ipV4AreaWidth);
                this.ipv6.inputPane.add((Component)this.ipv6.IPv4Area, IPv6TextField.areaConsts);
            }
        }
    }

    final void resumeAllComp() {
        this.hasHideComp = false;
        this.left.clear();
        this.middle.clear();
        this.right.clear();
        for (int i = 0; i < this.ipv6.inputPane.getComponentCount(); ++i) {
            Component component = this.ipv6.inputPane.getComponent(i);
            component.setVisible(true);
            if (component instanceof InnerIPv6TextField) {
                ((JTextField)component).setPreferredSize(new Dimension(this.ipV6PreferredWidth, component.getPreferredSize().height));
                this.middle.add(component);
                continue;
            }
            if (component instanceof InnerIPv4TextField) {
                ((JTextField)component).setPreferredSize(new Dimension(this.ipV4PreferredWidth, component.getPreferredSize().height));
                this.middle.add(component);
                continue;
            }
            if (!(component instanceof JLabel)) continue;
            this.middle.add(component);
        }
    }

    public boolean hasHideComp() {
        return this.hasHideComp;
    }

    final void hidePartComp(int n) {
        this.resumeAllComp();
        int n2 = 0;
        int n3 = 0;
        switch (this.ipv6.getAddressMode()) {
            case 0: {
                n2 = this.ipV6PreferredWidth * 8 + this.labelPreferredWidth * 7;
                n3 = this.ipv6.basicArea.getWidth();
                break;
            }
            case 1: {
                n2 = this.ipV6PreferredWidth * 8 + this.ipV4PreferredWidth * 1 + this.labelPreferredWidth * 8;
                n3 = this.ipv6.prefixArea.getWidth();
                break;
            }
            case 2: {
                n2 = this.ipV6PreferredWidth * 6 + this.ipV4PreferredWidth * 4 + this.labelPreferredWidth * 9;
                n3 = this.ipv6.IPv6_4Area.getWidth();
                break;
            }
            default: {
                n2 = this.ipV4PreferredWidth * 4 + this.labelPreferredWidth * 3;
                n3 = this.ipv6.IPv4Area.getWidth();
            }
        }
        int n4 = 0;
        if (this.ipv6.containChangeModeBtn) {
            n4 = this.ipv6.changeModeBtn.getPreferredSize().width + 1;
        }
        n3 = n - n4 - 4 - n3;
        Component component = null;
        for (int i = this.ipv6.inputPane.getComponentCount() - 1; i > 0; --i) {
            if (n2 <= n3) {
                if (i != this.ipv6.inputPane.getComponentCount() - 1) break;
                this.hasHideComp = false;
                break;
            }
            this.hasHideComp = true;
            component = this.ipv6.inputPane.getComponent(i - 1);
            if (component instanceof JLabel) {
                if (n2 - n3 < 3) {
                    switch (this.ipv6.getAddressMode()) {
                        case 0: {
                            this.basicAreaWidth = 3 - (n2 - n3);
                            break;
                        }
                        case 1: {
                            this.prefixAreaWidth = 3 - (n2 - n3);
                            break;
                        }
                        case 2: {
                            this.ipV6_4AreaWidth = 3 - (n2 - n3);
                            break;
                        }
                        default: {
                            this.ipV4AreaWidth = 3 - (n2 - n3);
                        }
                    }
                    this.setAreaPreferredWidth();
                }
                n2 -= component.getPreferredSize().width;
                component.setVisible(false);
                this.middle.remove(component);
                this.right.add(0, component);
                continue;
            }
            if (!(component instanceof JTextField)) continue;
            if (n2 - component.getPreferredSize().width > n3) {
                n2 -= component.getPreferredSize().width;
                component.setVisible(false);
                this.middle.remove(component);
                this.right.add(0, component);
                continue;
            }
            ((JTextField)component).setPreferredSize(new Dimension(component.getPreferredSize().width - (n2 - n3), component.getPreferredSize().height));
            n2 = n3;
            break;
        }
    }

    final int getMinimalWidth() {
        int n = 0;
        int[] nArray = this.ipv6.getSupportedMode();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = 0;
            switch (nArray[i]) {
                case 3: {
                    n2 = 4 * (int)this.ipv6.IPv4Fields[0].getPreferredSize().getWidth() + 9;
                    break;
                }
                case 2: {
                    n2 = 6 * (int)this.ipv6.IPv6Fields[0].getPreferredSize().getWidth() + 4 * (int)this.ipv6.IPv4Fields[0].getPreferredSize().getWidth() + 27;
                    break;
                }
                default: {
                    n2 = 8 * (int)this.ipv6.IPv6Fields[0].getPreferredSize().getWidth() + 21;
                    if (nArray[i] != 1) break;
                    n2 += 3 + (int)this.ipv6.prefixTextField.getPreferredSize().getWidth();
                }
            }
            n2 += 5;
            if (this.ipv6.containChangeModeBtn) {
                n2 += (int)this.ipv6.changeModeBtn.getPreferredSize().getWidth();
            }
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }
}

