/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield.ipaddress;

import com.swimap.iview.commstyle.resource.ResourceMng;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPv6Address
implements Comparable {
    public static final int MODE_BASIC = 0;
    public static final int MODE_PREFIX = 1;
    public static final int MODE_IPv6_4 = 2;
    public static final int MODE_IPv4 = 3;
    public static final int ILLEGAL_IP_ADDRESS = -1;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/textfield/ipaddress/Res");
    private static final int INADDRSZ = 16;
    private byte[] ipaddress = new byte[16];
    private int mode = 0;
    private boolean trimZero = false;
    private boolean useDoubleColon = false;
    private static final int DIVISOR = 256;
    private static final int BEGIN_INDEX = 12;
    private static final int IPv4_MAX_VALUE = 255;
    private static final int PREFIX_MAX_VALUE = 128;
    private static final int HEX = 16;

    public IPv6Address(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("address can not be null.");
        }
        System.arraycopy(byArray, 0, this.ipaddress, 0, byArray.length > 16 ? 16 : byArray.length);
    }

    private byte[] getIPAddress() {
        return this.ipaddress;
    }

    public int compareTo(Object object) {
        if (!(object instanceof IPv6Address)) {
            throw new IllegalArgumentException("o is not IPv6Address type.");
        }
        byte[] byArray = this.getIPAddress();
        byte[] byArray2 = ((IPv6Address)object).getIPAddress();
        for (int i = 0; i < 16; ++i) {
            if ((byArray[i] + 256) % 256 > (byArray2[i] + 256) % 256) {
                return 1;
            }
            if ((byArray[i] + 256) % 256 >= (byArray2[i] + 256) % 256) continue;
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (null == object || !(object instanceof IPv6Address)) {
            return false;
        }
        int n = this.compareTo(object);
        return 0 == n;
    }

    public int hashCode() {
        return this.getIPAddress().hashCode();
    }

    public void setAddressMode(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("mode must be one of the 'MODE_BASIC','MODE_PREFIX','MODE_IPv6_4'.");
        }
        this.mode = n;
    }

    public int getAddressMode() {
        return this.mode;
    }

    public boolean getTrimZero() {
        return this.trimZero;
    }

    public boolean getUseDoubleColon() {
        return this.useDoubleColon;
    }

    public void useAbbreviatory(boolean bl, boolean bl2) {
        this.trimZero = bl;
        this.useDoubleColon = bl2;
    }

    public void useAbbreviatory(boolean bl) {
        this.useAbbreviatory(bl, false);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.trimZero) {
            for (n = 0; n < 6; ++n) {
                stringBuffer.append(IPv6Address.trimZeroString(this.byteToHexString(this.ipaddress[n * 2], this.ipaddress[n * 2 + 1])));
                stringBuffer.append(":");
            }
        } else {
            for (n = 0; n < 6; ++n) {
                stringBuffer.append(this.byteToHexString(this.ipaddress[n * 2], this.ipaddress[n * 2 + 1]));
                stringBuffer.append(":");
            }
        }
        if (this.mode != 2) {
            if (this.trimZero) {
                for (n = 6; n < 8; ++n) {
                    stringBuffer.append(IPv6Address.trimZeroString(this.byteToHexString(this.ipaddress[n * 2], this.ipaddress[n * 2 + 1])));
                    stringBuffer.append(":");
                }
            } else {
                for (n = 6; n < 8; ++n) {
                    stringBuffer.append(this.byteToHexString(this.ipaddress[n * 2], this.ipaddress[n * 2 + 1]));
                    stringBuffer.append(":");
                }
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            if (this.mode == 1) {
                stringBuffer.append("/");
                stringBuffer.append("0");
            }
        } else {
            if (this.trimZero) {
                for (n = 12; n < 16; ++n) {
                    if (this.ipaddress[n] >= 0) {
                        stringBuffer.append(this.ipaddress[n]);
                    } else {
                        stringBuffer.append(this.ipaddress[n] + 256);
                    }
                    stringBuffer.append(".");
                }
            } else {
                for (n = 0; n < 4; ++n) {
                    if (this.ipaddress[n + 12] >= 0) {
                        stringBuffer.append(IPv6Address.fillZeroString(Byte.toString(this.ipaddress[n + 12]), 3));
                    } else {
                        stringBuffer.append(IPv6Address.fillZeroString(Integer.toString(this.ipaddress[n + 12] + 256), 3));
                    }
                    stringBuffer.append(".");
                }
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        if (this.trimZero && this.useDoubleColon) {
            return IPv6Address.getDoubleColonString(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static final String getDoubleColonString(String string) {
        String string2 = null;
        String string3 = null;
        if (string.indexOf(".") != -1) {
            string2 = ':' + string.substring(0, string.lastIndexOf(":") + 1);
            string3 = string.substring(string.lastIndexOf(":") + 1);
        } else if (string.indexOf("/") != -1) {
            string2 = ':' + string.substring(0, string.lastIndexOf("/")) + ':';
            string3 = string.substring(string.lastIndexOf("/"));
        } else {
            string2 = ':' + string + ':';
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer(":0:0:0:0:0:0:0:0:");
        for (int i = 8; i > 1; --i) {
            if (string2.indexOf(stringBuffer.toString()) != -1) {
                if ((string2 = string2.replaceFirst(stringBuffer.toString(), "::")).charAt(0) == ':' && !string2.startsWith("::")) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith(":") && !string2.endsWith("::") && (string3.length() == 0 || string3.charAt(0) == '/')) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                return string2 + string3;
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        return string;
    }

    private String byteToHexString(byte by, byte by2) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        string = by >= 0 ? Integer.toHexString(by) : Integer.toHexString(by + 256);
        stringBuffer.append(IPv6Address.fillZeroString(string.toLowerCase(), 2));
        string = by2 >= 0 ? Integer.toHexString(by2) : Integer.toHexString(by2 + 256);
        stringBuffer.append(IPv6Address.fillZeroString(string.toLowerCase(), 2));
        return stringBuffer.toString();
    }

    static final String trimZeroString(String string) {
        while (string.length() > 1 && string.charAt(0) == '0') {
            string = string.substring(1);
        }
        return string;
    }

    static final String fillZeroString(String string, int n) {
        if (string.length() == n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(4);
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static final String fillspaceString(String string, int n) {
        if (string.length() == n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static int getIPAddressMode(String string, boolean bl, boolean bl2) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        if (IPv6Address.checkIPAddress(string, 0, bl, bl2)) {
            return 0;
        }
        if (IPv6Address.checkIPAddress(string, 1, bl, bl2)) {
            return 1;
        }
        if (IPv6Address.checkIPAddress(string, 2, bl, bl2)) {
            return 2;
        }
        if (IPv6Address.checkIPAddress(string, 3, bl, bl2)) {
            return 3;
        }
        return -1;
    }

    public static boolean checkIPAddress(String string, int n, boolean bl, boolean bl2) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("The mode must be one of the 'MODE_BASIC','MODE_PERFIX','MODE_IPv6_4' or 'MODE_IPv4'.");
        }
        if (!bl && string != null && string.indexOf("::") != -1) {
            return false;
        }
        if (n == 0) {
            return IPv6Address.checkBasicIP(string, bl2);
        }
        if (n == 1) {
            return IPv6Address.checkPerfixIP(string, bl2);
        }
        if (n == 2) {
            return IPv6Address.checkIPv6_4(string, bl2);
        }
        return IPv6Address.checkIPv4(string, bl2);
    }

    private static boolean check(String string, int n) {
        if (string == null) {
            return false;
        }
        if (string.indexOf("//") != -1 || string.indexOf("..") != -1 || string.indexOf(":::") != -1 || string.replaceFirst("::", "").indexOf("::") != -1 || string.replaceFirst("/", "").indexOf("/") != -1 || n != 0 && string.endsWith("::")) {
            return false;
        }
        String string2 = null;
        string2 = n == 0 ? "[0-9a-f: ]*" : (n == 1 ? "[0-9a-f:/ ]*" : (n == 2 ? "[0-9a-f:/. ]*" : "[0-9. ]*"));
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string.toLowerCase());
        return matcher.matches();
    }

    private static boolean checkIPv6_4(String string, boolean bl) {
        if (string == null || string.indexOf(":") == -1) {
            return false;
        }
        String string2 = string.substring(0, string.lastIndexOf(":") + 1);
        String string3 = string.substring(string.lastIndexOf(":") + 1);
        return IPv6Address.checkBasicIP(string2 = string2 + "0:0", bl) && IPv6Address.checkIPv4(string3, bl);
    }

    private static boolean checkBasicIP(String string, boolean bl) {
        if (!IPv6Address.check(string, 0)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (string.indexOf("::") == -1 && stringTokenizer.countTokens() != 8 || string.indexOf("::") != -1 && stringTokenizer.countTokens() >= 7) {
            return false;
        }
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.trim().length() != string2.trim().replaceAll(" ", "").length() || string2.trim().length() > 4) {
                return false;
            }
            if (string2.length() != 0 && (bl || string2.trim().length() != 0)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPerfixIP(String string, boolean bl) {
        if (string == null || string.indexOf("/") == -1) {
            return false;
        }
        String string2 = string.substring(0, string.indexOf("/"));
        if (!IPv6Address.checkBasicIP(string2, bl)) {
            return false;
        }
        String string3 = string.substring(string.indexOf("/") + 1);
        if (bl && string3.trim().length() == 0 && string3.length() != 0) {
            return true;
        }
        if (string3.trim().length() != string3.trim().replaceAll(" ", "").length() || string3.trim().length() > 3) {
            return false;
        }
        if (string3.length() == 0 || !bl && string3.trim().length() == 0) {
            return false;
        }
        if (bl && string3.trim().length() == 0) {
            return true;
        }
        try {
            if (Integer.parseInt(string3.trim()) > 128) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private static boolean checkIPv4(String string, boolean bl) {
        if (string == null || string.indexOf("..") != -1) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        try {
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.trim().length() != string2.trim().replaceAll(" ", "").length() || string2.trim().length() > 3) {
                    return false;
                }
                if (string2.length() == 0 || !bl && string2.trim().length() == 0) {
                    return false;
                }
                if (bl && string2.trim().length() == 0 || Integer.parseInt(string2.trim()) <= 255) continue;
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private static byte[] checkAddress(byte[] byArray) {
        if (byArray == null || byArray.length > 16) {
            throw new IllegalArgumentException("ipaddress can not benull and ipaddress's length can not more than 16.");
        }
        if (byArray.length < 16) {
            byte[] byArray2 = new byte[16];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            for (int i = byArray.length; i < 16; ++i) {
                byArray2[i] = 0;
            }
            return byArray2;
        }
        return byArray;
    }

    public static String numericToTextFormat(byte[] byArray, int n, boolean bl, boolean bl2) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("The mode must be one of the 'MODE_BASIC','MODE_PERFIX' or 'MODE_IPv6_4'.");
        }
        IPv6Address iPv6Address = new IPv6Address(byArray);
        iPv6Address.setAddressMode(n);
        iPv6Address.useAbbreviatory(bl, bl2);
        String string = iPv6Address.toString();
        return string;
    }

    public static String numericToTextFormat(byte[] byArray, int n, boolean bl) {
        return IPv6Address.numericToTextFormat(byArray, n, bl, false);
    }

    static final String doubleColon2basic(String string) {
        int n;
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        int n2 = string.indexOf("/");
        if (string.indexOf(".") != -1) {
            n2 = string.lastIndexOf(":");
            bl = true;
        }
        if (n2 != -1) {
            string3 = string.substring(n2);
            string2 = string.substring(0, n2);
        } else {
            string2 = string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = bl ? 6 : 8;
        for (n = 0; n < n3 - stringTokenizer.countTokens(); ++n) {
            stringBuffer.append("0:");
        }
        if (string2.startsWith("::")) {
            string2 = stringBuffer.toString() + string2.substring(2);
            if (string2.endsWith(":")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        } else if (string2.endsWith("::")) {
            if ((string2 = string2.substring(0, string2.indexOf("::") + 1) + stringBuffer).endsWith(":")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        } else if (string2.indexOf("::") != -1) {
            n = string2.indexOf("::") + 1;
            stringBuffer.setLength(stringBuffer.length() - 1);
            string2 = string2.substring(0, n) + stringBuffer.toString() + string2.substring(n);
        }
        return string2 + string3;
    }

    public static byte[] textToNumericFormat(String string) {
        if (IPv6Address.checkIPAddress(string, 0, true, false) || IPv6Address.checkIPAddress(string, 1, true, false)) {
            string = IPv6Address.doubleColon2basic(string);
            byte[] byArray = new byte[16];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":/");
            String string2 = null;
            for (int i = 0; i < 8; ++i) {
                string2 = IPv6Address.fillZeroString(stringTokenizer.nextToken().trim(), 4);
                byArray[i * 2] = (byte)Integer.parseInt(string2.substring(0, 2), 16);
                byArray[i * 2 + 1] = (byte)Integer.parseInt(string2.substring(2), 16);
            }
            return byArray;
        }
        if (IPv6Address.checkIPAddress(string, 2, true, false)) {
            int n;
            string = IPv6Address.doubleColon2basic(string);
            byte[] byArray = new byte[16];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":.");
            String string3 = null;
            for (n = 0; n < 6; ++n) {
                string3 = IPv6Address.fillZeroString(stringTokenizer.nextToken().trim(), 4);
                byArray[n * 2] = (byte)Integer.parseInt(string3.substring(0, 2), 16);
                byArray[n * 2 + 1] = (byte)Integer.parseInt(string3.substring(2), 16);
            }
            for (n = 0; n < 4; ++n) {
                string3 = IPv6Address.fillZeroString(stringTokenizer.nextToken().trim(), 3);
                byArray[n + 12] = (byte)Integer.parseInt(string3);
            }
            return byArray;
        }
        return null;
    }

    public static String isAnyLocalAddress(byte[] byArray) {
        byArray = IPv6Address.checkAddress(byArray);
        byte by = 0;
        for (int i = 0; i < 16; ++i) {
            by = (byte)(by | byArray[i]);
        }
        if (by == 0) {
            return null;
        }
        return res.getString("isAnyLocalAddress");
    }

    public static String isIPv4CompatibleAddress(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = (byArray = IPv6Address.checkAddress(byArray))[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 && byArray[8] == 0 && byArray[9] == 0 && byArray[10] == 0 && byArray[11] == 0;
        if (bl) {
            return null;
        }
        return res.getString("isIPv4CompatibleAddress");
    }

    public static String isIPv4MappedAddress(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = (byArray = IPv6Address.checkAddress(byArray))[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 && byArray[8] == 0 && byArray[9] == 0 && byArray[10] == -1 && byArray[11] == -1;
        if (bl) {
            return null;
        }
        return res.getString("isIPv4MappedAddress");
    }

    public static String isLinkLocalAddress(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = ((byArray = IPv6Address.checkAddress(byArray))[0] & 0xFF) == 254 && (byArray[1] & 0xC0) == 128;
        if (bl) {
            return null;
        }
        return res.getString("isLinkLocalAddress");
    }

    public static String isLoopbackAddress(byte[] byArray) {
        int n;
        byArray = IPv6Address.checkAddress(byArray);
        byte by = 0;
        for (n = 0; n < 15; ++n) {
            by = (byte)(by | byArray[n]);
        }
        int n2 = n = by == 0 && byArray[15] == 1 ? 1 : 0;
        if (n != 0) {
            return null;
        }
        return res.getString("isLoopbackAddress");
    }

    public static String isMCGlobal(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = ((byArray = IPv6Address.checkAddress(byArray))[0] & 0xFF) == 255 && (byArray[1] & 0xF) == 14;
        if (bl) {
            return null;
        }
        return res.getString("isMCGlobal");
    }

    public static String isMCLinkLocal(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = ((byArray = IPv6Address.checkAddress(byArray))[0] & 0xFF) == 255 && (byArray[1] & 0xF) == 2;
        if (bl) {
            return null;
        }
        return res.getString("isMCLinkLocal");
    }

    public static String isMCNodeLocal(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = ((byArray = IPv6Address.checkAddress(byArray))[0] & 0xFF) == 255 && (byArray[1] & 0xF) == 1;
        if (bl) {
            return null;
        }
        return res.getString("isMCNodeLocal");
    }

    public static String isMCOrgLocal(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = ((byArray = IPv6Address.checkAddress(byArray))[0] & 0xFF) == 255 && (byArray[1] & 0xF) == 8;
        if (bl) {
            return null;
        }
        return res.getString("isMCOrgLocal");
    }

    public static String isMCSiteLocal(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = ((byArray = IPv6Address.checkAddress(byArray))[0] & 0xFF) == 255 && (byArray[1] & 0xF) == 5;
        if (bl) {
            return null;
        }
        return res.getString("isMCSiteLocal");
    }

    public static String isMulticastAddress(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = ((byArray = IPv6Address.checkAddress(byArray))[0] & 0xFF) == 255;
        if (bl) {
            return null;
        }
        return res.getString("isMulticastAddress");
    }

    public static String isSiteLocalAddress(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = ((byArray = IPv6Address.checkAddress(byArray))[0] & 0xFF) == 254 && (byArray[1] & 0xC0) == 192;
        if (bl) {
            return null;
        }
        return res.getString("isSiteLocalAddress");
    }
}

