/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield.ipaddress;

import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class IPInputDocument
extends PlainDocument {
    private static IviewLogger logger = IviewLogger.getLogger(IPInputDocument.class, "IVIEW");
    private static final int MAX_DOT_POSITION = 11;
    private static final int IP_MAX_LENGTH = 15;
    public static final String INITSTRING = "   .   .   .   ";
    private static final int IPMAXUM = 255;
    private IPAddressTextField ipTextField = null;
    private boolean isIgnoreIPMAXUM = true;

    IPInputDocument(IPAddressTextField iPAddressTextField) {
        this.ipTextField = iPAddressTextField;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        String string2 = this.ipTextField.getSelectedText();
        if (string2 != null && !this.ipTextField.isClearOrSet() && string2.indexOf(".") != -1) {
            if (!this.isValidkeyChar(string.charAt(0))) {
                return;
            }
            if (string2.length() != 1) {
                this.changeToSpace(n, string2.length());
            }
        }
        if (INITSTRING.equals(string) && this.ipTextField.getCaretPosition() == 0) {
            super.remove(0, this.ipTextField.getText().length());
            super.insertString(n, string, attributeSet);
            this.ipTextField.setCaretPosition(0);
        } else if (string.length() > 1) {
            if (string.length() == 15 && n == 0 && this.isValidStr(string)) {
                this.processFullIP(string, attributeSet);
            } else {
                this.processMultiLetters(string);
            }
        } else if (string.length() == 1) {
            if (n + 1 > INITSTRING.length()) {
                return;
            }
            char c = string.charAt(0);
            if (!this.isValidkeyChar(c)) {
                return;
            }
            int n2 = n % 4;
            switch (n2) {
                case 0: {
                    String string3;
                    if (c == '.' || c == ' ') break;
                    if (string2 == null && this.isValidRange(c, (string3 = this.ipTextField.getText(n + 1, 2)).charAt(0), string3.charAt(1))) {
                        super.remove(n, 1);
                        super.insertString(n, string, attributeSet);
                    }
                    if (string2 != null) {
                        int n3 = string2.length();
                        if (n3 > 2) {
                            super.remove(n, 3);
                            super.insertString(n, string, attributeSet);
                            super.insertString(n + 1, " ", null);
                            super.insertString(n + 2, " ", null);
                        } else if (n3 == 2) {
                            super.remove(n, n3);
                            super.insertString(n, string, attributeSet);
                            super.insertString(n + 2, " ", null);
                        } else {
                            String string4 = this.ipTextField.getText(n + 1, 2);
                            if (this.isValidRange(c, string4.charAt(0), string4.charAt(1))) {
                                super.remove(n, 1);
                                super.insertString(n, string, attributeSet);
                            }
                        }
                    }
                    this.ipTextField.setCaretPosition(n + 1);
                    break;
                }
                case 1: {
                    int n4;
                    if (c == '.' || c == ' ') {
                        if (this.ipTextField.getCaretPosition() > 11) break;
                        String string5 = this.ipTextField.getText(n - 1, 3);
                        if (string5.trim().length() > 0 && Integer.valueOf(string5.trim()) > 255) {
                            super.remove(n + 1, 1);
                            super.insertString(n + 1, " ", attributeSet);
                        }
                        this.ipTextField.setCaretPosition(n + 3);
                        if (this.ipTextField.getText(n + 3, 3).trim().length() <= 0) break;
                        this.ipTextField.selectField(n + 3, n + 6);
                        break;
                    }
                    String string6 = this.ipTextField.getText(n - 1, 1);
                    if (string6.charAt(0) == ' ') {
                        super.remove(n - 1, 1);
                        super.insertString(n - 1, string, attributeSet);
                        this.ipTextField.setCaretPosition(n);
                        break;
                    }
                    if (string2 != null && (n4 = string2.length()) > 1) {
                        super.remove(n, 2);
                        super.insertString(n, string, attributeSet);
                        super.insertString(n + 1, " ", null);
                        this.ipTextField.setCaretPosition(n + 1);
                        break;
                    }
                    String string7 = this.ipTextField.getText(n + 1, 1);
                    if (this.isValidRange(string6.charAt(0), c, string7.charAt(0))) {
                        super.remove(n, 1);
                        super.insertString(n, string, attributeSet);
                    }
                    this.ipTextField.setCaretPosition(n + 1);
                    break;
                }
                case 2: {
                    if (c == '.' || c == ' ') {
                        if (this.ipTextField.getCaretPosition() > 11) break;
                        String string8 = this.ipTextField.getText(n - 2, 3);
                        if (string8.trim().length() > 0 && Integer.valueOf(string8.trim()) > 255) {
                            super.remove(n + 1, 1);
                            super.insertString(n + 1, " ", attributeSet);
                        }
                        this.ipTextField.setCaretPosition(n + 2);
                        if (this.ipTextField.getText(n + 2, 3).trim().length() <= 0) break;
                        this.ipTextField.selectField(n + 2, n + 5);
                        break;
                    }
                    String string9 = this.ipTextField.getText(n - 2, 2);
                    if (string9.charAt(0) == ' ' && string9.charAt(1) == ' ') {
                        super.remove(n - 2, 1);
                        super.insertString(n - 2, string, attributeSet);
                        this.ipTextField.setCaretPosition(n - 1);
                        break;
                    }
                    if (string9.charAt(1) == ' ') {
                        super.remove(n - 1, 1);
                        super.insertString(n - 1, string, attributeSet);
                        this.ipTextField.setCaretPosition(n);
                        break;
                    }
                    if (!this.isValidRange(string9.charAt(0), string9.charAt(1), c)) {
                        if (this.isIgnoreIPMAXUM) {
                            if (this.ipTextField.getCaretPosition() <= 11) {
                                this.ipTextField.setCaretPosition(n + 2);
                            }
                            if (this.ipTextField.getText(n + 2, 3).trim().length() <= 0) break;
                            this.ipTextField.selectField(n + 2, n + 5);
                            break;
                        }
                        super.remove(n - 2, 3);
                        super.insertString(n - 2, new Integer(255).toString(), attributeSet);
                        break;
                    }
                    super.remove(n, 1);
                    super.insertString(n, string, attributeSet);
                    if (this.ipTextField.getCaretPosition() > 11) {
                        this.ipTextField.setCaretPosition(n + 1);
                        break;
                    }
                    this.ipTextField.setCaretPosition(n + 2);
                    if (this.ipTextField.getText(n + 2, 3).trim().length() <= 0) break;
                    this.ipTextField.selectField(n + 2, n + 5);
                    break;
                }
                case 3: {
                    if (c == '.' || c == ' ') {
                        if (this.ipTextField.getCaretPosition() > 11) break;
                        this.ipTextField.setCaretPosition(n + 1);
                        if (this.ipTextField.getText(n + 1, 3).trim().length() <= 0) break;
                        this.ipTextField.selectField(n + 1, n + 4);
                        break;
                    }
                    this.insertString(n + 1, string, attributeSet);
                    break;
                }
            }
        }
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (n + n2 > INITSTRING.length() || n2 == 0) {
            this.ipTextField.setIsBackspace(false);
            this.ipTextField.setIsDelete(false);
            return;
        }
        if (n == 0 && n2 == 15 && this.ipTextField.isCellEditor() && this.ipTextField.getSelectedText() == null) {
            this.ipTextField.setIsBackspace(true);
            return;
        }
        String string = this.ipTextField.getSelectedText();
        String string2 = this.ipTextField.getText(n, 1);
        if (string2.endsWith(".")) {
            int n3;
            if (this.ipTextField.isIsBackspace()) {
                if (n2 > 1) {
                    this.changeToSpace(n, n2);
                }
                this.ipTextField.setCaretPosition(n);
                n3 = this.ignoreFrontSpacePos(this.ipTextField.getCaretPosition());
                this.ipTextField.setCaretPosition(n3);
                this.ipTextField.setIsBackspace(false);
            }
            if (this.ipTextField.isIsDelete()) {
                if (n2 > 1) {
                    this.changeToSpace(n, n2);
                }
                this.ipTextField.setCaretPosition(n + 1);
                n3 = this.ignoreFrontSpacePos(this.ipTextField.getCaretPosition());
                this.ipTextField.setCaretPosition(n3);
                this.ipTextField.setIsDelete(false);
            }
            return;
        }
        if (this.ipTextField.isIsDelete()) {
            if (string != null && string.indexOf(".") != -1) {
                if (n2 > 1) {
                    this.changeToSpace(n, n2);
                }
                int n4 = this.ignoreFrontSpacePos(this.ipTextField.getCaretPosition());
                this.ipTextField.setCaretPosition(n4);
                this.ipTextField.setIsDelete(false);
                return;
            }
            block10: for (int i = 0; i < n2; ++i) {
                super.remove(n, 1);
                int n5 = n % 4;
                switch (n5) {
                    case 0: {
                        super.insertString(n + 2, " ", null);
                        this.ipTextField.setCaretPosition(n);
                        continue block10;
                    }
                    case 1: {
                        super.insertString(n + 1, " ", null);
                        this.ipTextField.setCaretPosition(n);
                        continue block10;
                    }
                    case 2: {
                        super.insertString(n, " ", null);
                        this.ipTextField.setCaretPosition(n);
                        continue block10;
                    }
                }
            }
            this.ipTextField.setIsDelete(false);
            return;
        }
        if (this.ipTextField.isIsBackspace()) {
            int n6;
            if (string != null && string.length() != 1 && string.indexOf(".") != -1) {
                this.changeToSpace(n, n2);
                return;
            }
            block11: for (n6 = 0; n6 < n2; ++n6) {
                if (".".equals(string2)) {
                    this.ipTextField.setCaretPosition(n);
                    this.ipTextField.setIsBackspace(false);
                    return;
                }
                super.remove(n, 1);
                int n7 = n % 4;
                switch (n7) {
                    case 0: {
                        super.insertString(n + 2, " ", null);
                        this.ipTextField.setCaretPosition(n);
                        continue block11;
                    }
                    case 1: {
                        super.insertString(n + 1, " ", null);
                        this.ipTextField.setCaretPosition(n);
                        continue block11;
                    }
                    case 2: {
                        super.insertString(n, " ", null);
                        this.ipTextField.setCaretPosition(n);
                        continue block11;
                    }
                }
            }
            n6 = this.ignoreFrontSpacePos(this.ipTextField.getCaretPosition());
            this.ipTextField.setCaretPosition(n6);
            this.ipTextField.setIsBackspace(false);
        }
    }

    private final int ignoreFrontSpacePos(int n) {
        try {
            while (n > 0 && "".equals(this.ipTextField.getText(n - 1, 1).trim())) {
                --n;
            }
        }
        catch (BadLocationException badLocationException) {
            logger.trace(badLocationException.getMessage(), badLocationException);
        }
        return n;
    }

    private final int ignoreBackSpacePos(int n) {
        if (n >= 11) {
            try {
                while (n > 0 && "".equals(this.ipTextField.getText(n, 1).trim())) {
                    --n;
                }
            }
            catch (BadLocationException badLocationException) {
                logger.trace(badLocationException.getMessage(), badLocationException);
            }
            return n;
        }
        try {
            while (n < 11 && "".equals(this.ipTextField.getText(n, 1).trim())) {
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            logger.trace(badLocationException.getMessage(), badLocationException);
        }
        return n;
    }

    private void changeToSpace(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        String string = "";
        n3 = n;
        int n5 = n3 + n2;
        String string2 = this.ipTextField.getSelectedText();
        if (string2.length() != n2) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            if (string2.charAt(i) == '.' || string2.charAt(i) == ' ') continue;
            ++n4;
        }
        try {
            while (n3 < n5 && n4 > 0) {
                string = this.ipTextField.getText(n3, 1);
                if (!".".equals(string) && !" ".equals(string)) {
                    --n4;
                    super.remove(n3, 1);
                    int n6 = n3 % 4;
                    switch (n6) {
                        case 0: {
                            super.insertString(n3 + 2, " ", null);
                            this.ipTextField.setCaretPosition(n3);
                            break;
                        }
                        case 1: {
                            super.insertString(n3 + 1, " ", null);
                            this.ipTextField.setCaretPosition(n3);
                            break;
                        }
                        case 2: {
                            super.insertString(n3, " ", null);
                            this.ipTextField.setCaretPosition(n3);
                            break;
                        }
                    }
                }
                if (!" ".equals(string) && !".".equals(string)) continue;
                ++n3;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        this.ipTextField.setCaretPosition(n);
    }

    private boolean isValidkeyChar(char c) {
        return c >= '0' && c <= '9' || c == '.' || c == ' ';
    }

    private boolean isValidStr(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (this.isValidkeyChar(cArray[i])) continue;
            return false;
        }
        if (cArray[3] != '.' && cArray[7] != '.' && cArray[11] != '.') {
            return false;
        }
        cArray[3] = 57;
        cArray[7] = 57;
        cArray[11] = 57;
        return new String(cArray).indexOf(46) == -1;
    }

    private boolean isValidRange(char c, char c2, char c3) {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(c);
        stringBuffer.append(c2);
        stringBuffer.append(c3);
        return Integer.valueOf(stringBuffer.toString().trim()) <= 255;
    }

    private void processMultiLetters(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.length() <= 1 || INITSTRING.equals(string)) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        String string2 = null;
        int n2 = this.ipTextField.getCaretPosition();
        while (stringTokenizer.hasMoreElements()) {
            try {
                String string3;
                String string4 = stringTokenizer.nextToken().trim();
                Integer.parseInt(string4);
                if (this.ipTextField.getSelectedText() != null) {
                    this.ipTextField.setIsDelete(true);
                    this.remove(this.ipTextField.getSelectionStart(), this.ipTextField.getSelectedText().length());
                }
                string2 = this.ipTextField.getText(this.ipTextField.getCaretPosition() / 4 * 4, this.ipTextField.getCaretPosition() % 4).trim();
                String string5 = string3 = n == 0 && string2 != null ? string2 + string4 : string4;
                if (string3.length() > 3) {
                    string3 = string3.substring(0, 3);
                }
                if ("".equals(string3.trim())) {
                    ++n;
                    continue;
                }
                int n3 = Integer.parseInt(string3);
                if (n3 < 0) {
                    return;
                }
                this.ipTextField.setIsDelete(true);
                this.remove(n2 / 4 * 4 + n * 4, 3);
                int n4 = n2 / 4 * 4 + n * 4;
                int n5 = n4 = n4 < 15 ? n4 : 15;
                if (this.isIgnoreIPMAXUM) {
                    if (n3 > 255) {
                        this.insertIPData(n4, string3.substring(0, 2));
                    } else {
                        this.insertIPData(n4, string3);
                    }
                } else if (n3 > 255) {
                    this.insertIPData(n4, "255");
                } else {
                    this.insertIPData(n4, string3);
                }
                int n6 = n4 + 4;
                if (n6 < 15) {
                    this.ipTextField.selectField(n6, n6 + 3);
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            ++n;
        }
    }

    private void processFullIP(String string, AttributeSet attributeSet) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            ++n;
            string2 = stringTokenizer.nextToken();
            if ("".equalsIgnoreCase(string2.trim())) {
                stringBuffer.append(string2);
            } else {
                int n2 = Integer.parseInt(string2.trim());
                if (this.isIgnoreIPMAXUM) {
                    if (n2 > 255) {
                        stringBuffer.append(string2.trim().substring(0, 2));
                        stringBuffer.append(" ");
                    } else {
                        stringBuffer.append(string2);
                    }
                } else if (n2 > 255) {
                    stringBuffer.append(255);
                } else {
                    stringBuffer.append(string2);
                }
            }
            if (n >= 4) continue;
            stringBuffer.append('.');
        }
        try {
            super.remove(0, this.ipTextField.getText().length());
            super.insertString(0, stringBuffer.toString(), attributeSet);
        }
        catch (BadLocationException badLocationException) {
            logger.trace(badLocationException.getMessage(), badLocationException);
        }
    }

    private void insertIPData(int n, String string) {
        if (string.length() >= 1 && string.length() <= 3) {
            int n2 = n % 4 * 4 + 2;
            for (int i = 0; i < string.length() && i <= n2; ++i) {
                String string2 = string.substring(i, i + 1);
                if (!this.isValidkeyChar(string.charAt(i)) || n + i > 15) continue;
                try {
                    this.insertString(n + i, string2, null);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    logger.trace(badLocationException.getMessage(), badLocationException);
                }
            }
        }
    }

    public void processLEFTKey(KeyEvent keyEvent) {
        int n = this.ignoreFrontSpacePos(this.ipTextField.getCaretPosition());
        if (keyEvent.isShiftDown()) {
            this.ipTextField.moveCaretPosition(n);
        } else {
            this.ipTextField.setCaretPosition(n);
        }
    }

    public void processRIGHTKey(KeyEvent keyEvent) {
        int n = this.ignoreBackSpacePos(this.ipTextField.getCaretPosition());
        if (keyEvent.isShiftDown()) {
            this.ipTextField.moveCaretPosition(n);
        } else {
            this.ipTextField.setCaretPosition(n);
        }
    }

    public void setIgnoreIPMAXUM(boolean bl) {
        this.isIgnoreIPMAXUM = bl;
    }
}

